/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultsetinput;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.resultsetinput.AbstractDataStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ExceptionType;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class AsciiDataStream
extends AbstractDataStream {
    public AsciiDataStream(InputStream stream, long streamLength, int type, IWarningListener warningListener) {
        super(stream, streamLength, type, warningListener);
    }

    @Override
    public Pair<DataWrapper, Long> getNextValue() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_CLOSED, this.m_warningListener, ExceptionType.DATA, new Object[0]);
        }
        if (!this.hasMoreData()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_EMPTY, this.m_warningListener, ExceptionType.DATA, new Object[0]);
        }
        int numBytesToFetch = this.getNumToFetch();
        byte[] byteArray = new byte[numBytesToFetch];
        int numBytesRead = 0;
        try {
            numBytesRead = this.m_stream.read(byteArray, 0, numBytesToFetch);
        }
        catch (IOException e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
        this.m_numRead += numBytesRead;
        if (-1L != this.m_streamLength) {
            if (-1 == numBytesRead) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STREAM_UNEXPECTED_END, this.m_warningListener, ExceptionType.DATA, new Object[0]);
            }
            DataWrapper data = new DataWrapper();
            if (12 == this.m_type) {
                data.setVarChar(new String(byteArray));
            } else {
                data.setLongVarChar(new String(byteArray));
            }
            return new Pair<DataWrapper, Long>(data, Long.valueOf(numBytesRead));
        }
        this.m_lastChunkReadSize = numBytesRead;
        if (numBytesRead < byteArray.length && -1 != numBytesRead) {
            byte[] temp = new byte[numBytesRead];
            System.arraycopy(byteArray, 0, temp, 0, numBytesRead);
            byteArray = temp;
            this.m_lastChunkReadSize = -1L;
        }
        DataWrapper data = new DataWrapper();
        if (12 == this.m_type) {
            data.setVarChar(new String(byteArray));
        } else {
            data.setLongVarChar(new String(byteArray));
        }
        return new Pair<DataWrapper, Long>(data, Long.valueOf(numBytesRead));
    }
}

