/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ProtocolException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;

class Header {
    final EXAConnection connection;
    private int size = 0;
    private byte mode = (byte)-1;
    private Vector attributes;
    private int serialNumber = -1;
    private int numberOfResults;
    private int sizeOfAttributes;
    static final int VMU = 64;
    private DebugLog debug;

    Header(EXAConnection eXAConnection, DebugLog debugLog, int n) {
        this.connection = eXAConnection;
        this.attributes = new Vector();
        this.debug = debugLog;
        this.serialNumber = n;
    }

    Header(Header header) {
        this.connection = header.connection;
        this.attributes = new Vector();
        this.debug = header.debug;
        this.serialNumber = header.serialNumber;
    }

    private void log(Object object) {
        if (this.debug != null) {
            this.debug.log(object.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized InputStream read_from(InputStream inputStream, ExecutionStatus executionStatus, int n) throws SQLException, IOException {
        EXAInputStream eXAInputStream = new EXAInputStream(inputStream, this.connection, executionStatus);
        long l = System.currentTimeMillis();
        int n2 = -1;
        if (0 < n && this.connection != null && this.connection.csocket != null) {
            n2 = this.connection.csocket.getSoTimeout();
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            if (n2 >= 0) {
                this.connection.csocket.setSoTimeout(n);
            }
            byte[] byArray = new byte[21];
            eXAInputStream.read(byArray);
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            EXAInputStream eXAInputStream2 = new EXAInputStream(byteArrayInputStream2, this.connection, executionStatus);
            this.size = eXAInputStream2.readInt();
            if (this.size < 0) {
                throw new ProtocolException("Message size negative: " + this.size);
            }
            this.mode = eXAInputStream2.readByte();
            this.serialNumber = eXAInputStream2.readInt();
            int n3 = eXAInputStream2.readInt();
            this.sizeOfAttributes = eXAInputStream2.readInt();
            this.numberOfResults = eXAInputStream2.readInt();
            byte[] byArray2 = new byte[this.size];
            eXAInputStream.read(byArray2);
            byte[] byArray3 = new byte[this.sizeOfAttributes];
            System.arraycopy(byArray2, 0, byArray3, 0, this.sizeOfAttributes);
            ByteArrayInputStream byteArrayInputStream3 = new ByteArrayInputStream(byArray3);
            EXAInputStream eXAInputStream3 = new EXAInputStream(byteArrayInputStream3, this.connection, executionStatus);
            try {
                for (int i = 0; i < n3; ++i) {
                    ProtocolAttribute protocolAttribute = eXAInputStream3.readAttribute();
                    this.attributes.add(protocolAttribute);
                    this.log("Attribute of message #" + this.serialNumber + ": " + protocolAttribute);
                }
            }
            catch (Exception exception) {
                throw new ProtocolException(exception.getMessage());
            }
            byte[] byArray4 = new byte[this.size - this.sizeOfAttributes];
            System.arraycopy(byArray2, this.sizeOfAttributes, byArray4, 0, this.size - this.sizeOfAttributes);
            byteArrayInputStream = new ByteArrayInputStream(byArray4);
            this.size -= this.sizeOfAttributes;
            this.log("Header.read_from(InputStream, " + n + ") serialNumber: " + this.serialNumber + ", attrSize: " + this.sizeOfAttributes + ", numRes: " + this.numberOfResults + ", mode: " + this.mode + ", data_size: " + this.size);
        }
        finally {
            if (n2 >= 0) {
                this.connection.csocket.setSoTimeout(n2);
            }
        }
        return byteArrayInputStream;
    }

    private String getStacktrace() {
        String string = "";
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            string = string + stackTraceElement + "\n";
        }
        return string;
    }

    void write_to(OutputStream outputStream) throws IOException, ConnectionException {
        int n;
        if (this.mode <= 0) {
            throw new ProtocolException("ProtocolException A0001 in Header.write_to:\n" + this.getStacktrace() + "mode=" + this.mode);
        }
        if (this.serialNumber < 0) {
            throw new ProtocolException("ProtocolException B0001 in Header.write_to:\n" + this.getStacktrace() + "serialNumber=" + this.serialNumber);
        }
        EXAOutputStream eXAOutputStream = new EXAOutputStream(outputStream, this.connection);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream2 = new EXAOutputStream(byteArrayOutputStream, this.connection);
        for (n = 0; n < this.attributes.size(); ++n) {
            ProtocolAttribute protocolAttribute = (ProtocolAttribute)this.attributes.get(n);
            eXAOutputStream2.writeAttribute(protocolAttribute);
        }
        eXAOutputStream2.flush();
        n = byteArrayOutputStream.size();
        if (this.mode <= 0) {
            throw new ProtocolException("ProtocolException A0002 in Header.write_to:\n" + this.getStacktrace() + "mode=" + this.mode);
        }
        if (this.serialNumber < 0) {
            throw new ProtocolException("ProtocolException B0002 in Header.write_to:\n" + this.getStacktrace() + "serialNumber=" + this.serialNumber);
        }
        eXAOutputStream.writeInt(n + this.size);
        eXAOutputStream.writeByte(this.mode);
        eXAOutputStream.writeInt(this.serialNumber);
        eXAOutputStream.writeInt(this.attributes.size());
        eXAOutputStream.writeInt(n);
        eXAOutputStream.writeInt(this.numberOfResults);
        eXAOutputStream.setHeader();
        eXAOutputStream.write(byteArrayOutputStream.toByteArray());
        this.log("Header.write_to(OutputStream) serialNumber: " + this.serialNumber + ", numAttr: " + this.attributes.size() + ", attrSize: " + n + ", numRes: " + this.numberOfResults + ", data_size: " + this.size + ", mode: " + this.mode);
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(int n) {
        this.numberOfResults = n;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int n) {
        this.serialNumber = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public void incSize(int n) {
        this.size += n;
    }

    public void addAttribute(ProtocolAttribute protocolAttribute) {
        this.attributes.addElement(protocolAttribute);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("*** Header no. ");
        stringBuffer.append(this.serialNumber);
        stringBuffer.append(" ***\n");
        stringBuffer.append("  message mode   : " + this.mode);
        stringBuffer.append('\n');
        stringBuffer.append("  result count   : " + this.numberOfResults);
        stringBuffer.append('\n');
        stringBuffer.append("  data size      : " + this.size);
        stringBuffer.append('\n');
        stringBuffer.append("  attribute count: " + this.attributes.size());
        stringBuffer.append('\n');
        stringBuffer.append("  attribute size : " + this.attributes.size());
        stringBuffer.append("\n ****************");
        return stringBuffer.toString();
    }
}

