/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXABatchUpdateException;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NoResultException;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.Translator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public abstract class AbstractEXAStatement
extends ServerCommunication
implements Statement {
    protected Vector commands;
    protected int fetchSize;
    protected int fetchDirection;
    protected int maxFieldSize = 0;
    protected int queryTimeout = 0;
    protected int resultSetConcurrency = 10;
    protected int resultSetType;
    protected long maxRows = 0L;
    private int activeProtocolVersion = 14;
    SQLWarning warning;
    protected ExecutionStatus execStatus = null;
    protected EXAResult[] results = null;
    protected boolean IsClosed = false;
    protected int current_result;
    private int metadataSQL = 0;
    protected boolean isPoolable = false;

    @Override
    public boolean isClosed() {
        return this.IsClosed;
    }

    AbstractEXAStatement(EXAConnection eXAConnection) {
        super(eXAConnection.getDebug(), "EXAStatement", eXAConnection);
        this.log("EXAStatement() created.");
        this.commands = new Vector();
        this.fetchSize = eXAConnection.getDefaultFetchSize();
        this.activeProtocolVersion = eXAConnection.getActiveProtocolVersion();
        try {
            this.metadataSQL = Integer.parseInt(this.connection.getParameter("metadataSQL"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.metadataSQL != 0) {
            this.metadataSQL = 1;
        }
    }

    AbstractEXAStatement(EXAConnection eXAConnection, int n, int n2) {
        this(eXAConnection);
        this.resultSetConcurrency = n2;
        this.resultSetType = n;
    }

    public int getActiveProtocolVersion() {
        return this.activeProtocolVersion;
    }

    public synchronized ResultSet GetKeywords() throws SQLException {
        this.log("GetKeywords()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select KEYWORD from EXA_SQL_KEYWORDS /*Keywords from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)120, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public synchronized ResultSet GetCommands() throws SQLException {
        this.log("GetCommands()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select \"COMMAND\",\"IS_PLSQL\" from \"$ODBCJDBC\".\"SQL_COMMANDS\" order by \"COMMAND\" /*Commands from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)121, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public synchronized ResultSet GetDbMetadata(String[] stringArray, String string) throws SQLException {
        this.log("GetDbMetadata(" + stringArray + ", " + string + ")");
        if (0 != this.metadataSQL) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (stringArray != null) {
                string2 = " \"NAME\" in (";
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + "'" + stringArray[i] + "'";
                    if (i >= stringArray.length - 1) continue;
                    string2 = string2 + ", ";
                }
                string2 = string2 + ") ";
            }
            if (string != null) {
                string3 = " \"STATIC\"=" + string;
            }
            if (string2.length() > 0 || string3.length() > 0) {
                string4 = " WHERE ";
            }
            if (string2.length() > 0 && string3.length() > 0) {
                string5 = " AND ";
            }
            String string6 = "select \"NAME\",\"VALUE\",\"STATIC\" from \"$ODBCJDBC\".\"DB_METADATA\" " + string4 + string2 + string5 + string3 + " order by 1";
            return this.executeQuery(string6 + " /*DbMetadata from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        int n = -1;
        if (null != string && string.equals("true")) {
            n = 1;
        }
        if (null != string && string.equals("false")) {
            n = 0;
        }
        try {
            if (null == stringArray) {
                eXAOutputStream.writeInt(-1);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    eXAOutputStream.writeInt(stringArray[i].getBytes(this.connection.getEncoding()).length);
                    eXAOutputStream.write(stringArray[i].getBytes(this.connection.getEncoding()));
                }
                eXAOutputStream.writeInt(-1);
            }
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(n);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)122, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public synchronized ResultSet GetAllObjects() throws SQLException {
        this.log("GetAllObjects()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select \"OBJECT_NAME\", \"OBJECT_TYPE\", \"OBJECT_ID\", \"ROOT_ID\", \"LAST_COMMIT\", \"CREATED\", \"OWNER\", \"OBJECT_COMMENT\", \"OBJECT_IS_VIRTUAL\"  from \"SYS\".\"EXA_ALL_OBJECTS\" where \"ROOT_ID\" IS NULL order by \"OBJECT_ID\" /*AllObjects from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)123, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public synchronized ResultSet GetAllUsers() throws SQLException {
        this.log("GetAllUsers()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select USER_NAME, 0 as USER_ID, CREATED, USER_COMMENT from SYS.EXA_ALL_USERS order by USER_NAME /*AllUsers from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)124, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public synchronized ResultSet GetDbaRoles() throws SQLException {
        this.log("GetDbaRoles()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select ROLE_NAME as ROLE, -1 as ROLE_ID, ROLE_COMMENT, CREATED from SYS.EXA_DBA_ROLES order by ROLE_NAME /*DbaRoles from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)125, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public synchronized ResultSet GetDbaConnections() throws SQLException {
        this.log("GetDbaConnections()");
        if (0 != this.metadataSQL) {
            return this.executeQuery("select CONNECTION_NAME, CONNECTION_STRING, USER_NAME, CREATED,CONNECTION_COMMENT from SYS.EXA_DBA_CONNECTIONS /*DbaConnections from jdbc*/");
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)126, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.log("addBatch(" + string + ")");
        this.commands.add(string);
    }

    @Override
    public void cancel() throws SQLException {
        this.log("cancel()");
        if (null != this.execStatus) {
            this.execStatus.cancel();
        } else {
            this.log("nothing to cancel");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.log("clearBatch()");
        this.commands.clear();
    }

    @Override
    public void clearWarnings() {
        this.log("clearWarnings");
    }

    protected void finalize() {
        this.log("finalize()");
        try {
            this.close();
        }
        catch (Exception exception) {
            this.log("Exception caught automaticaly closing statement: " + exception.toString() + "\nYour application should call close() for statements when they are not needed anymore.");
        }
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            this.log(throwable.toString());
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        this.log("close()");
        if (this.IsClosed) {
            this.log("   Warning: statement was closed before.");
        }
        try {
            if (this.results != null) {
                this.closeResultSets(this.results);
                this.results = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.IsClosed = true;
        }
    }

    private ProtocolAttribute[] CreateMaxRowsAttribute() {
        if (this.maxRows > 0L && this.activeProtocolVersion >= 16) {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_RESULT_MAX_ROWS.id);
            protocolAttribute.value = new Long(this.maxRows);
            ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
            return protocolAttributeArray;
        }
        return null;
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        this.log("execute(" + string + ")");
        this.connection.setSchemaMayHaveChanged();
        this.execStatus = new ExecutionStatus();
        try {
            this.results = this.connection.communication_resultset(string.getBytes(this.connection.getEncoding()), (byte)12, this.execStatus, this.CreateMaxRowsAttribute());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.current_result = 0;
        if (this.results != null && this.results.length > 0) {
            if (this.results[0] instanceof EXASQLException) {
                throw ((EXASQLException)this.results[0]).getSQLExceptionIntern(this.connection);
            }
            return this.results[0] instanceof EXAResultSet;
        }
        return false;
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.log("executeBatch()");
        int[] nArray = null;
        long[] lArray = null;
        lArray = this.exaExecuteLargeBatch();
        if (lArray != null) {
            nArray = new int[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                nArray[i] = (int)lArray[i];
            }
        }
        return nArray;
    }

    public synchronized long[] exaExecuteLargeBatch() throws SQLException {
        this.log("exaExecuteLargeBatch()");
        Throwable throwable = null;
        this.connection.setSchemaMayHaveChanged();
        this.execStatus = new ExecutionStatus();
        this.results = this.connection.communication_vector(this.commands, (byte)17, this.execStatus, this.CreateMaxRowsAttribute());
        if (this.results.length > 0) {
            long[] lArray = new long[this.results.length];
            for (int i = 0; i < this.results.length; ++i) {
                if (this.results[i] instanceof EXARowCount) {
                    lArray[i] = ((EXARowCount)this.results[i]).getLongRowCount();
                    continue;
                }
                if (this.results[i] instanceof EXASQLException) {
                    long[] lArray2 = new long[this.results.length - 1];
                    System.arraycopy(lArray, 0, lArray2, 0, this.results.length - 1);
                    lArray = lArray2;
                    throwable = ((EXASQLException)this.results[i]).getSQLExceptionIntern(this.connection);
                    continue;
                }
                lArray[i] = -2L;
            }
            if (throwable != null) {
                throw new EXABatchUpdateException(throwable.getMessage(), ((SQLException)throwable).getSQLState(), ((SQLException)throwable).getErrorCode(), lArray, throwable);
            }
            return lArray;
        }
        return null;
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.log("executeQuery(" + string + ")");
        this.connection.setSchemaMayHaveChanged();
        if (this.execute(string)) {
            if (this.results.length == 0) {
                throw new SQLException(Translator.Query_did_not_return_a_result());
            }
            if (this.results.length > 1) {
                throw new SQLException(Translator.Query_returned_more_than_one_result());
            }
            ResultSet resultSet = this.getResultSet();
            resultSet.setFetchSize(this.getFetchSize());
            return resultSet;
        }
        throw new SQLException(Translator.Query_returned_update_count());
    }

    long exaExecuteLargeUpdate(String string) throws SQLException {
        this.log("exaExecuteLargeUpdate(" + string + ")");
        this.connection.setSchemaMayHaveChanged();
        if (this.execute(string)) {
            throw new SQLException(Translator.Statement_returned_resultset());
        }
        long l = this.getLongUpdateCount();
        if (l < 0L) {
            return 0L;
        }
        return l;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        if (this.debug != null) {
            this.log("EXAStatement:getFetchSize(): " + this.fetchSize);
        }
        if (this.fetchSize <= 0) {
            if (this.debug != null) {
                this.log("Ignoring invalid fetch size: " + this.fetchSize + ". Fetch size will be set to connection default: " + this.connection.getDefaultFetchSize());
            }
            this.fetchSize = this.connection.getDefaultFetchSize();
        }
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.debug != null) {
            this.debug.log("getGeneratedKys()");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() {
        return (int)this.maxRows;
    }

    @Override
    public long getLargeMaxRows() {
        return this.maxRows;
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        this.log("getMoreResults()");
        if (this.results == null || this.current_result >= this.results.length) {
            return false;
        }
        if (this.current_result > 0 && this.results[this.current_result] instanceof EXAResultSet) {
            EXAResultSet eXAResultSet = (EXAResultSet)this.results[this.current_result];
            eXAResultSet.close();
        }
        ++this.current_result;
        if (this.current_result >= this.results.length) {
            return false;
        }
        if (this.results[this.current_result] instanceof EXASQLException) {
            return false;
        }
        return this.results[this.current_result] instanceof EXAResultSet;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        this.log("getResultSet()");
        if (this.results == null || this.current_result >= this.results.length) {
            throw new NoResultException();
        }
        if (this.results[this.current_result] instanceof EXAResultSet) {
            ((EXAResultSet)this.results[this.current_result]).setMaxRows(this.maxRows);
            EXAResultSet eXAResultSet = (EXAResultSet)this.results[this.current_result];
            eXAResultSet.setStatement((EXAStatement)this);
            eXAResultSet.setFetchSize(this.getFetchSize());
            return eXAResultSet;
        }
        if (this.results[this.current_result] instanceof EXAHandle && this.current_result < this.results.length - 1 && this.results[this.current_result + 1] instanceof EXASQLException) {
            ++this.current_result;
        }
        if (this.results[this.current_result] instanceof EXASQLException) {
            throw ((EXASQLException)this.results[this.current_result]).getSQLExceptionIntern(this.connection);
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        long l = (int)this.getLongUpdateCount();
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        this.log("getUpdateCount() - " + l);
        return (int)l;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        long l = this.getLongUpdateCount();
        this.log("getLargeUpdateCount() - " + l);
        return l;
    }

    public synchronized long getLongUpdateCount() throws SQLException {
        long l = -1L;
        if (this.results != null && this.current_result < this.results.length) {
            if (this.results[this.current_result] instanceof EXASQLException) {
                throw ((EXASQLException)this.results[this.current_result]).getSQLExceptionIntern(this.connection);
            }
            if (this.results[this.current_result] instanceof EXARowCount) {
                l = ((EXARowCount)this.results[this.current_result]).getLongRowCount();
            }
        }
        return l;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warning;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String name)");
    }

    @Override
    public void setEscapeProcessing(boolean bl) {
        this.log("setEscapeProcessing(" + bl + ")");
    }

    @Override
    public void setFetchDirection(int n) {
        this.log("setFetchDirection(" + n + ")");
        this.fetchDirection = n;
    }

    @Override
    public void setFetchSize(int n) {
        this.log("setFetchSize(): " + n);
        if (n <= 0) {
            this.fetchSize = this.connection.getDefaultFetchSize();
            this.log(" Fetch size set to default: " + this.fetchSize);
        } else if (n > 65536) {
            this.fetchSize = 65536;
            this.log("Fetch size set to max: " + this.fetchSize);
        } else {
            this.fetchSize = n;
        }
    }

    @Override
    public void setMaxFieldSize(int n) {
        this.log("setMaxFieldSize(" + n + ")");
        this.maxFieldSize = n;
    }

    @Override
    public void setMaxRows(int n) {
        this.log("setMaxRows(" + n + ")");
        this.maxRows = n < 0 ? 0L : (long)n;
    }

    @Override
    public void setLargeMaxRows(long l) {
        this.log("setLargeMaxRows(" + l + ")");
        this.maxRows = l < 0L ? 0L : l;
    }

    @Override
    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.log("setQueryTimeout(" + n + ")");
        this.queryTimeout = n;
    }

    protected void closeResultSets(EXAResult[] eXAResultArray) throws SQLException {
        if (null == eXAResultArray) {
            this.log("closeResultSets(null)");
            return;
        }
        this.log("closeResultSets() - resultSets.length: " + eXAResultArray.length);
        if (null == eXAResultArray) {
            return;
        }
        this.execStatus = new ExecutionStatus();
        int n = 0;
        for (int i = 0; i < eXAResultArray.length; ++i) {
            if (!(eXAResultArray[i] instanceof EXAResultSet) || ((EXAResultSet)eXAResultArray[i]).GetHandle() < 0) continue;
            ++n;
        }
        if (n > 0) {
            byte[] byArray = new byte[4 * n];
            int n2 = 0;
            int n3 = 0;
            do {
                if (!(eXAResultArray[n3] instanceof EXAResultSet) || ((EXAResultSet)eXAResultArray[n3]).GetHandle() < 0) continue;
                byArray[4 * n2 + 0] = (byte)((EXAResultSet)eXAResultArray[n3]).GetHandle();
                byArray[4 * n2 + 1] = (byte)(((EXAResultSet)eXAResultArray[n3]).GetHandle() >> 8);
                byArray[4 * n2 + 2] = (byte)(((EXAResultSet)eXAResultArray[n3]).GetHandle() >> 16);
                byArray[4 * n2 + 3] = (byte)(((EXAResultSet)eXAResultArray[n3]).GetHandle() >> 24);
                this.log("Closing result with handle: " + ((EXAResultSet)eXAResultArray[n3]).GetHandle());
                ((EXAResultSet)eXAResultArray[n3]).setHandle(-1);
                ++n2;
            } while (n2 < n && ++n3 < eXAResultArray.length);
            if (n2 != n) {
                throw new SQLException("something is wrong");
            }
            this.connection.communication(byArray, (byte)13, this.execStatus, null);
        }
    }

    public String getSQLTypeName(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN TYPE";
    }

    public int getNumberOfResults() {
        int n = 0;
        if (this.results != null) {
            n = this.results.length;
        }
        this.log("getNumberOfResults() - " + n);
        return n;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.log("setPoolable(" + bl + ")");
        this.isPoolable = bl;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.log("isPoolable() - " + this.isPoolable);
        return this.isPoolable;
    }
}

