/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractMargin;
import com.jidesoft.margin.RowMarginPainter;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.utils.SortedList;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ToolTipManager;

public abstract class AbstractRowMargin
extends AbstractMargin
implements MouseListener,
MouseMotionListener {
    protected List<RowMarginPainter> _rowMarginPainters;
    private int \u0103 = -1;
    private int \u0102 = -1;

    public AbstractRowMargin(RowMarginSupport rowMarginSupport) {
        super(rowMarginSupport);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paintMargin(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n2 = this.getFontMetrics(this.getFont()).getHeight();
        int n3 = ((RowMarginSupport)this._marginSupport).positionToRow(0);
        int n4 = ((RowMarginSupport)this._marginSupport).getRowCount();
        if (n3 == -1 || n3 >= n4) {
            return;
        }
        int n5 = ((RowMarginSupport)this._marginSupport).positionToRow(this._marginSupport.getViewSize());
        n5 = n5 == -1 || n5 >= n4 ? n4 - 1 : ++n5;
        int n6 = this.getPreferredSize().width;
        if (!this.isEnabled()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        try {
            int n7 = 0;
            Rectangle rectangle = new Rectangle(0, n7, n6, n2);
            Insets insets = this.getInsets();
            rectangle.x += insets.left;
            rectangle.width -= insets.left + insets.right;
            List<RowMarginPainter> list = this.getRowMarginPainters();
            for (int i2 = n3; i2 <= n5; ++i2) {
                rectangle.y = ((RowMarginSupport)this._marginSupport).rowToPosition(i2);
                ++rectangle.y;
                rectangle.height = ((RowMarginSupport)this._marginSupport).getRowHeight(i2);
                if (rectangle.height <= 0 || rectangle.y + rectangle.height < 0) continue;
                rectangle.y += insets.top;
                int n8 = this.\u0101(list, graphics2D, rectangle, i2);
                this.paintRowMargin(graphics2D, rectangle, i2);
                this.\u0101(list, n8, graphics2D, rectangle, i2);
            }
        }
        catch (Exception exception) {
            System.err.println("Error repainting line range {" + n3 + "," + n5 + "}:");
        }
        graphics2D.dispose();
    }

    private int \u0101(List<RowMarginPainter> list, Graphics graphics, Rectangle rectangle, int n2) {
        int n3;
        if (list != null) {
            RowMarginPainter rowMarginPainter;
            for (n3 = 0; n3 < list.size() && (rowMarginPainter = list.get(n3)).getLayer() < 1000; ++n3) {
                rowMarginPainter.paintRowMargin(graphics, (RowMarginSupport)this._marginSupport, rectangle, n2);
            }
        }
        return n3;
    }

    private void \u0101(List<RowMarginPainter> list, int n2, Graphics graphics, Rectangle rectangle, int n3) {
        if (list != null) {
            for (int i2 = n2; i2 < list.size(); ++i2) {
                RowMarginPainter rowMarginPainter = list.get(i2);
                rowMarginPainter.paintRowMargin(graphics, (RowMarginSupport)this._marginSupport, rectangle, n3);
            }
        }
    }

    public void addRowMarginPainter(RowMarginPainter rowMarginPainter) {
        if (this._rowMarginPainters == null) {
            this._rowMarginPainters = new SortedList<RowMarginPainter>(new ArrayList(), new Comparator<RowMarginPainter>(){

                public int \u0101(RowMarginPainter rowMarginPainter, RowMarginPainter rowMarginPainter2) {
                    int n2;
                    int n3 = rowMarginPainter.getLayer();
                    if (n3 < (n2 = rowMarginPainter2.getLayer())) {
                        return -1;
                    }
                    if (n3 > n2) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this._rowMarginPainters.add(rowMarginPainter);
    }

    public void removeRowMarginPainter(RowMarginPainter rowMarginPainter) {
        if (this._rowMarginPainters == null) {
            return;
        }
        this._rowMarginPainters.remove(rowMarginPainter);
    }

    protected List<RowMarginPainter> getRowMarginPainters() {
        return this._rowMarginPainters;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        String string = this.getToolTipText(mouseEvent);
        if (string == null) {
            return null;
        }
        int n2 = this.getFontMetrics(this.getFont()).getHeight();
        int n3 = mouseEvent.getPoint().y / n2;
        return new Point(this.getPreferredSize().width + 6, n3 * n2 + n2 / 2);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText(((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getY()));
    }

    public abstract void paintRowMargin(Graphics var1, Rectangle var2, int var3);

    public abstract String getToolTipText(int var1);

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n2 = this._marginSupport.getViewPosition();
        int n3 = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
        if (n3 < 0 || n3 > ((RowMarginSupport)this._marginSupport).positionToRow(n2 + this._marginSupport.getViewSize())) {
            return;
        }
        if ((mouseEvent.getModifiers() & 2) != 0 && (mouseEvent.getModifiers() & 1) == 0) {
            this.\u0102 = n3;
        } else if (this.\u0102 >= 0 && (mouseEvent.getModifiers() & 2) == 0 && (mouseEvent.getModifiers() & 1) != 0) {
            int n4 = Math.max(Math.min(n3, this.\u0102), 0);
            int n5 = Math.max(n3, this.\u0102) + 1;
            ((RowMarginSupport)this._marginSupport).scrollTo(n4, n5, this.isClickToSelect());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.\u0103 = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
        ((RowMarginSupport)this._marginSupport).scrollTo(this.\u0103, this.\u0103, this.isClickToSelect());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.\u0103 = -1;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.\u0103 < 0) {
            return;
        }
        this.\u0102 = -1;
        int n2 = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
        int n3 = this.\u0103;
        int n4 = Math.max(0, n2);
        ((RowMarginSupport)this._marginSupport).scrollTo(n3, n4, this.isClickToSelect());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

