/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.ContainerContainerDivider;
import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.J;
import com.jidesoft.docking.SlidingOverFrameContainer;
import com.jidesoft.docking.Workspace;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DockingUtils {
    static int \u0101(Component component, int n2, int n3, int n4, boolean bl) {
        int n5 = Math.min(n4, component.getWidth() / 3);
        int n6 = Math.min(n4, component.getHeight() / 3);
        if (n2 >= 0 && n2 < n5 && n3 >= 0 && n3 < component.getHeight()) {
            return 8;
        }
        if (n2 >= component.getWidth() - n5 && n2 < component.getWidth() && n3 >= 0 && n3 <= component.getHeight()) {
            return 4;
        }
        if (n3 >= 0 && n3 < n6 + (component instanceof FrameContainer && bl ? DockingUtils.\u0102((FrameContainer)component) : 0) && n2 >= 0 && n2 < component.getWidth()) {
            return 1;
        }
        if (n3 >= component.getHeight() - n6 - (component instanceof FrameContainer && ((FrameContainer)component).isTabShown() ? 22 : 0) && n3 < component.getHeight() && n2 >= 0 && n2 <= component.getWidth()) {
            return 2;
        }
        if (n2 > n5 && n2 < component.getWidth() - n5 && n3 > n6 && n3 < component.getHeight() - n6) {
            return 16;
        }
        return 32;
    }

    static int \u0102(FrameContainer frameContainer) {
        DockableFrame dockableFrame = frameContainer.getSelectedFrame();
        if (dockableFrame != null && dockableFrame.getUI() != null && dockableFrame.getUI().getTitlePane() != null) {
            return dockableFrame.getUI().getTitlePane().getHeight();
        }
        return 0;
    }

    static int \u0101(Component component, int n2, int n3, int n4) {
        int n5 = Math.min(n4, component.getWidth() / 3);
        int n6 = Math.min(n4, component.getHeight() / 3);
        if (n2 < 0 && n2 >= -n5 && n3 >= 0 && n3 < component.getHeight()) {
            return 8;
        }
        if (n2 < component.getWidth() + n5 && n2 >= component.getWidth() && n3 >= 0 && n3 <= component.getHeight()) {
            return 4;
        }
        if (n3 < 0 && n3 >= -n6 && n2 >= 0 && n2 < component.getWidth()) {
            return 1;
        }
        if (n3 < component.getHeight() + n6 && n3 >= component.getHeight() && n2 >= 0 && n2 <= component.getWidth()) {
            return 2;
        }
        return 32;
    }

    static void \u0101(Map<Component, List<MouseEvent>> map, Component component) {
        List<MouseEvent> list = map.remove(component);
        if (list != null) {
            for (MouseEvent mouseEvent : list) {
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, mouseEvent.getComponent());
                mouseEvent.getComponent().dispatchEvent(mouseEvent2);
            }
        }
    }

    public static Window getWindowFor(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    private static boolean \u0107(Component component) {
        while (component != null) {
            if (component instanceof FloatingContainer) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static Component \u0101(Component component, DockableFrame dockableFrame, boolean bl) {
        if (component == null) {
            return null;
        }
        if (!dockableFrame.isFloatable() && DockingUtils.\u0107(component)) {
            return null;
        }
        if (component instanceof FrameContainer && ((FrameContainer)component).getTabCount() == 1 && ((FrameContainer)component).isAncestorOf(dockableFrame)) {
            return null;
        }
        if (component instanceof FrameContainer && !bl && component.equals(dockableFrame.getParent())) {
            return null;
        }
        if (DockingUtils.\u0103(component, dockableFrame, bl)) {
            return component;
        }
        do {
            if (dockableFrame.equals(component) && ((FrameContainer)component.getParent()).getTabCount() == 1) {
                return null;
            }
            if (component instanceof BasicDockableFrameTitlePane && component.getParent().equals(dockableFrame) && ((FrameContainer)component.getParent().getParent()).getTabCount() == 1) {
                return null;
            }
            if (component.getParent() == null) {
                return null;
            }
            if (!bl && component.getParent().equals(dockableFrame.getParent())) {
                return null;
            }
            if ((component = component.getParent()) == null) {
                return null;
            }
            if (!(component instanceof FrameContainer) || ((FrameContainer)component).getTabCount() != 1 || !((FrameContainer)component).isAncestorOf(dockableFrame)) continue;
            return null;
        } while (!DockingUtils.\u0103(component, dockableFrame, bl));
        return component;
    }

    static Component \u0101(DockingManager dockingManager, Class<? extends DockableHolder> clazz, Component component) {
        if (component == null) {
            return null;
        }
        if (clazz.isInstance(component) && component instanceof DockableHolder && ((DockableHolder)((Object)component)).getDockingManager() == dockingManager) {
            return component;
        }
        do {
            if ((component = component.getParent()) != null) continue;
            return null;
        } while (!clazz.isInstance(component) || !(component instanceof DockableHolder) || ((DockableHolder)((Object)component)).getDockingManager() != dockingManager);
        if (!clazz.isInstance(component)) {
            return null;
        }
        return component;
    }

    static List<DockingManager> \u0103(Component component) {
        ArrayList<DockingManager> arrayList = new ArrayList<DockingManager>();
        while (component != null) {
            DockingManager dockingManager = null;
            if (component instanceof DockableFrame) {
                dockingManager = ((DockableFrame)component).getDockingManager();
            } else if (component instanceof Workspace) {
                dockingManager = ((Workspace)component).getDockingManager();
            }
            if (dockingManager != null && !arrayList.contains(dockingManager)) {
                arrayList.add(0, dockingManager);
            }
            component = component.getParent();
        }
        return arrayList;
    }

    static boolean \u0101(Component component, DockingManager dockingManager) {
        while (component != null) {
            DockingManager dockingManager2 = null;
            if (component instanceof DockableFrame) {
                dockingManager2 = ((DockableFrame)component).getDockingManager();
            } else if (component instanceof Workspace) {
                dockingManager2 = ((Workspace)component).getDockingManager();
            }
            if (dockingManager2 == dockingManager) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static boolean \u0106(Component component) {
        while (component != null) {
            DockingManager dockingManager = null;
            if (component instanceof DockableFrame) {
                dockingManager = ((DockableFrame)component).getDockingManager();
            } else if (component instanceof Workspace) {
                dockingManager = ((Workspace)component).getDockingManager();
            }
            if (dockingManager != null) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static Component \u0102(DockingManager dockingManager, Component component) {
        return DockingUtils.\u0101(dockingManager, component, false);
    }

    static Component \u0101(DockingManager dockingManager, Component component, boolean bl) {
        if (component == null) {
            return null;
        }
        if (DockingUtils.\u0101(dockingManager, component)) {
            return component;
        }
        if (bl) {
            do {
                if ((component = component.getParent()) != null) continue;
                return null;
            } while (!DockingUtils.\u0105(component));
            if (component instanceof Workspace && ((Workspace)component).getDockingManager() != dockingManager) {
                component = null;
            } else if (component instanceof DockableFrame && ((DockableFrame)component).getDockingManager() != dockingManager) {
                component = null;
            }
        } else {
            do {
                if ((component = component.getParent()) != null) continue;
                return null;
            } while (!DockingUtils.\u0101(dockingManager, component));
        }
        return component;
    }

    private static boolean \u0101(DockingManager dockingManager, Component component) {
        return component instanceof DockableFrame && ((DockableFrame)component).getDockingManager() == dockingManager || component instanceof Workspace && component == dockingManager.getWorkspace();
    }

    private static boolean \u0105(Component component) {
        return component instanceof DockableFrame || component instanceof Workspace;
    }

    private static boolean \u0103(Component component, DockableFrame dockableFrame, boolean bl) {
        return DockingUtils.\u0102(component, dockableFrame, bl) && DockingUtils.isSameDockingManager(component, dockableFrame);
    }

    public static DockingManager getDockingManager(Component component) {
        if (component instanceof BasicDockableFrameTitlePane && component.getParent() instanceof DockableFrame) {
            return ((DockableFrame)component.getParent()).getDockingManager();
        }
        if (component instanceof ContainerContainerDivider && component.getParent() instanceof ContainerContainer) {
            return ((ContainerContainer)component.getParent()).getDockingManager();
        }
        if (component instanceof DockableFrame) {
            return ((DockableFrame)component).getDockingManager();
        }
        if (component instanceof Workspace) {
            return ((Workspace)component).getDockingManager();
        }
        if (component instanceof ContainerContainer) {
            return ((ContainerContainer)component).getDockingManager();
        }
        if (component instanceof FrameContainer) {
            return ((FrameContainer)component).getDockingManager();
        }
        if (component instanceof FloatingContainer) {
            return ((FloatingContainer)((Object)component)).getDockingManager();
        }
        return null;
    }

    public static boolean isSameDockingManager(Component component, DockableFrame dockableFrame) {
        DockingManager dockingManager = dockableFrame.getDockingManager();
        DockingManager dockingManager2 = DockingUtils.getDockingManager(component);
        if (dockingManager2 != null && dockingManager != null && dockingManager2 != dockingManager) {
            return dockingManager.isCrossDraggingAllowed() && dockingManager2.isCrossDroppingAllowed();
        }
        return dockingManager2 != null && dockingManager != null;
    }

    private static boolean \u0102(Component component, DockableFrame dockableFrame, boolean bl) {
        return component instanceof BasicDockableFrameTitlePane && component.getParent() instanceof DockableFrame && ((DockableFrame)component.getParent()).isTabDockAllowed() && !((DockableFrame)component.getParent()).isMaximized() && component.getParent().getParent() != dockableFrame.getParent() || component instanceof ContainerContainerDivider && component.getParent() instanceof ContainerContainer && (bl && dockableFrame.getParent() != null && ((FrameContainer)dockableFrame.getParent()).getTabCount() > 1 || !((ContainerContainer)component.getParent()).\u0101((ContainerContainerDivider)component, dockableFrame.getParent())) || component instanceof DockableFrame && ((DockableFrame)component).isMaximized() || component instanceof DockableFrame && ((DockableFrame)component).isAutohideShowing() || component instanceof Workspace || component instanceof ContainerContainer || component instanceof FrameContainer || component instanceof FloatingContainer;
    }

    static void \u0101(Container container, DockingManager dockingManager) throws PropertyVetoException {
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                DockingUtils.\u0101((Container)component, dockingManager);
            }
            if (!(component instanceof DockableFrame) || ((DockableFrame)component).getDockingManager() != dockingManager) continue;
            ((DockableFrame)component).setFloated(true);
        }
    }

    protected static void dockizeChildrenOf(Container container, DockingManager dockingManager) throws PropertyVetoException {
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            if (container.getComponent(i2) instanceof Container) {
                DockingUtils.\u0101((Container)container.getComponent(i2), dockingManager);
            }
            if (!(container.getComponent(i2) instanceof DockableFrame) || ((DockableFrame)container.getComponent(i2)).getDockingManager() != dockingManager) continue;
            ((DockableFrame)container.getComponent(i2)).setDocked(true);
        }
    }

    protected static Container getValidFloatableParent(DockableFrame dockableFrame) {
        Container container = dockableFrame;
        while (!DockingUtils.\u0109(container)) {
            if ((container = container.getParent()) != null) continue;
            return null;
        }
        return container;
    }

    private static boolean \u0109(Component component) {
        return component instanceof ContainerContainer || component instanceof FrameContainer;
    }

    private static void \u0101(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            System.out.print("\t");
        }
    }

    static void \u0101(DockedFrameContainer dockedFrameContainer, int n2) {
        DockingUtils.\u0101((ContainerContainer)dockedFrameContainer.getNormalContainer().getComponent(0), n2);
    }

    static void \u0101(ContainerContainer containerContainer, int n2) {
        DockingUtils.\u0101(++n2);
        Map<Component, Object> map = ((JideBoxLayout)containerContainer.getLayout()).getConstraintMap();
        System.out.println("ContainerContainer " + (containerContainer.getOrientation() == 1 ? "(Horizontal) " : "(Vertical) ") + " Count = " + containerContainer.getPaneCount());
        for (int i2 = 0; i2 < containerContainer.getComponentCount(); ++i2) {
            Component component = containerContainer.getComponent(i2);
            DockingUtils.\u0101(n2);
            System.out.println("Constraint: " + map.get(component));
            if (component instanceof ContainerContainerDivider) {
                DockingUtils.\u0101(n2);
                System.out.println("Divider Size = " + (containerContainer.getOrientation() == 1 ? component.getWidth() : component.getHeight()));
                continue;
            }
            if (component instanceof ContainerContainer) {
                DockingUtils.\u0101((ContainerContainer)component, n2);
                continue;
            }
            if (component instanceof FrameContainer) {
                DockingUtils.\u0101((FrameContainer)component, n2);
                continue;
            }
            if (component instanceof DockableFrame) {
                DockingUtils.\u0101((DockableFrame)component, n2);
                continue;
            }
            if (component instanceof Workspace) {
                DockingUtils.\u0101((Workspace)component, n2);
                continue;
            }
            DockingUtils.\u0101(component, n2);
        }
    }

    private static void \u0101(FrameContainer frameContainer, int n2) {
        DockingUtils.\u0101(++n2);
        System.out.println("FrameContainer  Count = " + frameContainer.getTabCount() + " DockedWidth = " + frameContainer.getDockedWidth() + " DockedHeight = " + frameContainer.getDockedHeight() + " AutohideWidth = " + frameContainer.getAutohideWidth() + " AutohideHeight = " + frameContainer.getAutohideWidth() + " UndockedBounds = " + frameContainer.getUndockedBounds());
        for (int i2 = 0; i2 < frameContainer.getTabCount(); ++i2) {
            Component component = frameContainer.getComponentAt(i2);
            if (component instanceof DockableFrame) {
                DockingUtils.\u0101((DockableFrame)component, n2);
                continue;
            }
            DockingUtils.\u0101(component, n2);
        }
    }

    private static void \u0101(Workspace workspace, int n2) {
        DockingUtils.\u0101(++n2);
        System.out.println("Workspace");
    }

    private static void \u0101(DockableFrame dockableFrame, int n2) {
        DockingUtils.\u0101(++n2);
        System.out.println("TitledFrame \"" + dockableFrame.getTitle() + "\" Mode = " + dockableFrame.getContext().getCurrentMode() + " Side = " + dockableFrame.getContext().getCurrentDockSide() + " DockedWidth = " + dockableFrame.getDockedWidth() + " DockedHeight = " + dockableFrame.getDockedHeight() + " AutohideWidth = " + dockableFrame.getAutohideWidth() + " AutohideHeight = " + dockableFrame.getAutohideWidth() + " UndockedBounds = " + dockableFrame.getUndockedBounds());
    }

    private static void \u0101(Component component, int n2) {
        DockingUtils.\u0101(++n2);
    }

    static Container \u0104(Component component) {
        if (component instanceof DockedFrameContainer) {
            return (DockedFrameContainer)component;
        }
        if (component instanceof FloatingContainer) {
            return (Container)component;
        }
        Container container = component.getParent();
        do {
            if (container == null) {
                return null;
            }
            if (container instanceof DockedFrameContainer) {
                return container;
            }
            if (!(container instanceof FloatingContainer)) continue;
            return container;
        } while ((container = container.getParent()) != null);
        return null;
    }

    static ContainerContainer \u0102(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        do {
            if (container != null && container instanceof ContainerContainer) {
                return (ContainerContainer)container;
            }
            if (container != null) continue;
            return null;
        } while ((container = container.getParent()) != null);
        return null;
    }

    static boolean \u0101(DockedFrameContainer dockedFrameContainer, Component component) {
        return component == dockedFrameContainer || dockedFrameContainer.isAncestorOf(component);
    }

    static int \u0101(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.x >= rectangle2.x + rectangle2.width) {
            return 8;
        }
        if (rectangle.x + rectangle.width <= rectangle2.x) {
            return 4;
        }
        if (rectangle.y >= rectangle2.y + rectangle.height) {
            return 1;
        }
        if (rectangle.y + rectangle.height <= rectangle2.y) {
            return 2;
        }
        return 32;
    }

    static Container \u0101(int n2, Container container, Workspace workspace) {
        if (container == null || !(container.getComponent(0) instanceof ContainerContainer)) {
            return null;
        }
        Rectangle rectangle = DockingUtils.\u0101((Component)workspace);
        Container container2 = (Container)container.getComponent(0);
        return DockingUtils.\u0101(container2, rectangle, n2);
    }

    private static Container \u0101(Container container, Rectangle rectangle, int n2) {
        Rectangle rectangle2 = DockingUtils.\u0101((Component)container);
        if ((container instanceof ContainerContainer || container instanceof FrameContainer) && DockingUtils.\u0101(rectangle, rectangle2) == n2) {
            return container;
        }
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Container container2;
            Component component = container.getComponent(i2);
            if (component instanceof Workspace || component instanceof JideSplitPaneDivider || !(container instanceof Container) || (container2 = DockingUtils.\u0101((Container)component, rectangle, n2)) == null) continue;
            return container2;
        }
        return null;
    }

    private static Rectangle \u0101(Component component) {
        Rectangle rectangle = component.getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, component);
        rectangle.setLocation(point);
        return rectangle;
    }

    static int \u0101(DockingManager dockingManager, Container container) {
        int n2 = 0;
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                n2 += DockingUtils.\u0101(dockingManager, (ContainerContainer)component);
                continue;
            }
            if (component instanceof FrameContainer) {
                if (((FrameContainer)component).getDockingManager() != dockingManager) continue;
                ++n2;
                continue;
            }
            if (!(component instanceof DockableFrame) || ((DockableFrame)component).getDockingManager() != dockingManager) continue;
            ++n2;
        }
        return n2;
    }

    static int \u0102(DockingManager dockingManager, Container container) {
        int n2 = 0;
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                n2 += DockingUtils.\u0102(dockingManager, (ContainerContainer)component);
                continue;
            }
            if (component instanceof FrameContainer) {
                n2 += DockingUtils.\u0102(dockingManager, (FrameContainer)component);
                continue;
            }
            if (!(component instanceof DockableFrame) || ((DockableFrame)component).getDockingManager() != dockingManager) continue;
            ++n2;
        }
        return n2;
    }

    static boolean \u0101(Container container) {
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof ContainerContainer) {
                return DockingUtils.\u0101((Container)((ContainerContainer)component));
            }
            if (!(component instanceof FrameContainer)) continue;
            return ((FrameContainer)component).getTabCount() > 1 || !((FrameContainer)component).isHideOneTab();
        }
        return false;
    }

    static void \u0102(Container container, Border border) {
        if (container instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)container;
            Border border2 = frameContainer.getBorder();
            if (border2 == null || border2 instanceof UIResource) {
                frameContainer.setBorder(border);
            }
            return;
        }
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            if (component instanceof ContainerContainer) {
                DockingUtils.\u0102((ContainerContainer)component, border);
                continue;
            }
            if (!(component instanceof FrameContainer)) continue;
            ((FrameContainer)component).setBorder(border);
        }
    }

    static void \u0101(Container container, Border border) {
        if (container instanceof DockableFrame) {
            DockableFrame dockableFrame = (DockableFrame)container;
            Border border2 = dockableFrame.getBorder();
            if (border2 == null || border2 instanceof UIResource) {
                dockableFrame.setBorder(border);
            }
            return;
        }
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            if (component instanceof ContainerContainer) {
                DockingUtils.\u0101((Container)((ContainerContainer)component), border);
                continue;
            }
            if (component instanceof FrameContainer) {
                DockingUtils.\u0101((Container)((FrameContainer)component), border);
                continue;
            }
            if (!(component instanceof DockableFrame)) continue;
            ((DockableFrame)component).setBorder(border);
        }
    }

    static List<Component> \u0102(ContainerContainer containerContainer) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i2 = 0; i2 < containerContainer.getComponentCount(); ++i2) {
            Component component = containerContainer.getComponent(i2);
            if (component instanceof ContainerContainerDivider) continue;
            if (component instanceof Workspace) {
                arrayList.add(component);
            }
            if (component instanceof ContainerContainer) {
                arrayList.addAll(DockingUtils.\u0102((ContainerContainer)component));
                continue;
            }
            if (component instanceof FrameContainer) {
                arrayList.addAll(DockingUtils.\u0104((FrameContainer)component));
                continue;
            }
            if (!(component instanceof DockableFrame)) continue;
            arrayList.add(component);
        }
        return arrayList;
    }

    static List<Component> \u0104(FrameContainer frameContainer) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i2 = 0; i2 < frameContainer.getTabCount(); ++i2) {
            arrayList.add(frameContainer.getComponentAt(i2));
        }
        return arrayList;
    }

    static ArrayList<Integer> \u0101(ContainerContainer containerContainer) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < containerContainer.getComponentCount(); ++i2) {
            Component component = containerContainer.getComponent(i2);
            if (component instanceof Workspace) {
                arrayList.add(-1);
                continue;
            }
            if (!(component instanceof Dockable)) continue;
            arrayList.add(((Dockable)((Object)component)).getDockID());
        }
        return arrayList;
    }

    static ArrayList<Integer> \u0101(FrameContainer frameContainer) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < frameContainer.getTabCount(); ++i2) {
            Component component = frameContainer.getComponentAt(i2);
            if (!(component instanceof DockableFrame)) continue;
            arrayList.add(((DockableFrame)component).getDockID());
        }
        return arrayList;
    }

    static List<DockableFrame> \u0103(FrameContainer frameContainer) {
        ArrayList<DockableFrame> arrayList = new ArrayList<DockableFrame>();
        for (int i2 = 0; i2 < frameContainer.getTabCount(); ++i2) {
            Component component = frameContainer.getComponentAt(i2);
            if (!(component instanceof DockableFrame)) continue;
            arrayList.add((DockableFrame)component);
        }
        return arrayList;
    }

    static List<DockableFrame> \u0102(Container container) {
        if (container instanceof ContainerContainer) {
            return DockingUtils.\u0103((ContainerContainer)container);
        }
        if (container instanceof FrameContainer) {
            return DockingUtils.\u0103((FrameContainer)container);
        }
        final ArrayList<DockableFrame> arrayList = new ArrayList<DockableFrame>();
        JideSwingUtilities.setRecursively(container, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                return component instanceof DockableFrame;
            }

            @Override
            public void action(Component component) {
                arrayList.add((DockableFrame)component);
            }

            @Override
            public void postAction(Component component) {
            }
        });
        return arrayList;
    }

    static List<DockableFrame> \u0103(ContainerContainer containerContainer) {
        ArrayList<DockableFrame> arrayList = new ArrayList<DockableFrame>();
        for (int i2 = 0; i2 < containerContainer.getPaneCount(); ++i2) {
            Component component = containerContainer.getPaneAt(i2);
            if (component instanceof DockableFrame) {
                arrayList.add((DockableFrame)component);
            }
            if (component instanceof FrameContainer) {
                arrayList.addAll(DockingUtils.\u0103((FrameContainer)component));
                continue;
            }
            if (!(component instanceof ContainerContainer)) continue;
            arrayList.addAll(DockingUtils.\u0103((ContainerContainer)component));
        }
        return arrayList;
    }

    static int \u0102(int n2) {
        int n3 = 32;
        switch (n2) {
            case 3: {
                n3 = 4;
                break;
            }
            case 7: {
                n3 = 8;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 5: {
                n3 = 2;
            }
        }
        return n3;
    }

    static int[] \u0101(int n2, int n3, int n4, int n5) {
        if (n5 == -1) {
            return DockingUtils.\u0101(n2, n3, n4);
        }
        if (n5 > n4) {
            return DockingUtils.\u0101(n2, n5, n4);
        }
        if (n5 < n4) {
            return DockingUtils.\u0101(n5, n3, n4);
        }
        return new int[0];
    }

    static int[] \u0101(int n2, int n3, int n4) {
        int n5;
        int n6 = n3 - n2 + 1;
        if (n6 <= 0) {
            return new int[0];
        }
        int[] nArray = new int[n6 - 1];
        int n7 = Math.max(n4 - n2, n3 - n4);
        int[] nArray2 = new int[n7 * 2];
        for (n5 = 0; n5 < n7; ++n5) {
            nArray2[2 * n5] = n4 + (n5 + 1);
            nArray2[2 * n5 + 1] = n4 - (n5 + 1);
        }
        n5 = 0;
        for (int i2 = 0; i2 < n7 * 2; ++i2) {
            if (nArray2[i2] < n2 || nArray2[i2] > n3) continue;
            nArray[n5] = nArray2[i2];
            ++n5;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        int[] nArray;
        System.out.println("[0,2] --- 0, 2");
        for (int n2 : nArray = DockingUtils.\u0101(0, 2, 0, 1)) {
            System.out.print(n2 + " ");
        }
        System.out.println();
        System.out.println("[0,1] --- 0");
        for (int n2 : nArray = DockingUtils.\u0101(0, 1, 0)) {
            System.out.print(n2 + " ");
        }
        System.out.println();
        System.out.println("[0, 3] --- 0");
        for (int n2 : nArray = DockingUtils.\u0101(0, 3, 0)) {
            System.out.print(n2 + " ");
        }
        System.out.println();
        System.out.println("[0, 7] --- 4");
        for (int n2 : nArray = DockingUtils.\u0101(0, 7, 4)) {
            System.out.print(n2 + " ");
        }
        System.out.println();
        System.out.println("[3, 8] --- 6");
        for (int n2 : nArray = DockingUtils.\u0101(3, 8, 6)) {
            System.out.print(n2 + " ");
        }
        System.out.println();
    }

    static void \u0101(DockedFrameContainer dockedFrameContainer, Workspace workspace) {
        if (dockedFrameContainer != null && dockedFrameContainer.getNormalContainer().getComponentCount() > 0) {
            DockingUtils.\u0101(workspace.getDockingManager(), (ContainerContainer)dockedFrameContainer.getNormalContainer().getComponent(0), workspace);
        }
    }

    static void \u0101(DockingManager dockingManager, Container container, Workspace workspace) {
        if (container instanceof ContainerContainer) {
            DockingUtils.\u0101(dockingManager, (ContainerContainer)container, workspace);
        } else {
            DockingUtils.\u0101(dockingManager, workspace);
        }
    }

    static void \u0101(DockingManager dockingManager, Workspace workspace) {
        for (int i2 = 0; i2 < workspace.getComponentCount(); ++i2) {
            Component component = workspace.getComponent(i2);
            if (!(component instanceof Container)) continue;
            DockingUtils.\u0101(dockingManager, (Container)component, 16);
        }
    }

    static void \u0101(DockingManager dockingManager, ContainerContainer containerContainer, Workspace workspace) {
        boolean bl = false;
        int n2 = containerContainer.getOrientation();
        for (int i2 = 0; i2 < containerContainer.getComponentCount(); ++i2) {
            Component component = containerContainer.getComponent(i2);
            if (!(component instanceof Container)) continue;
            if (!bl && (((Container)component).isAncestorOf(workspace) || component.equals(workspace))) {
                bl = true;
                DockingUtils.\u0101(dockingManager, (Container)component, workspace);
                continue;
            }
            if (bl) {
                DockingUtils.\u0101(dockingManager, (Container)component, n2 == 1 ? 4 : 2);
                continue;
            }
            DockingUtils.\u0101(dockingManager, (Container)component, n2 == 1 ? 8 : 1);
        }
    }

    static void \u0101(DockingManager dockingManager, Container container, int n2) {
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            DockableFrame dockableFrame;
            Component component = container.getComponent(i2);
            if (component instanceof Container) {
                DockingUtils.\u0101(dockingManager, (Container)component, n2);
            }
            if (!(component instanceof DockableFrame) || (dockableFrame = (DockableFrame)component).getDockingManager() != dockingManager || dockableFrame.getContext().getCurrentDockSide() == n2) continue;
            dockableFrame.getContext().setCurrentDockSide(n2);
        }
    }

    static DockingManager \u0101(AWTEvent aWTEvent, boolean bl) {
        Serializable serializable;
        Component component = null;
        if (aWTEvent instanceof MouseEvent) {
            serializable = (MouseEvent)aWTEvent;
            Component component2 = ((ComponentEvent)serializable).getComponent();
            if (component2 == null) {
                return null;
            }
            component = SwingUtilities.getDeepestComponentAt(component2, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
        } else if (aWTEvent instanceof KeyEvent && aWTEvent.getSource() instanceof Component) {
            component = PortingUtils.getCurrentFocusComponent(aWTEvent);
        } else if (aWTEvent instanceof FocusEvent) {
            component = PortingUtils.getCurrentFocusComponent(aWTEvent);
        }
        if (!bl && component instanceof JComponent && ((JComponent)component).getClientProperty("ignoreClickToActivate") instanceof Boolean && ((Boolean)((JComponent)component).getClientProperty("ignoreClickToActivate")).booleanValue()) {
            return null;
        }
        if (component instanceof AutoHideContainer && aWTEvent instanceof MouseEvent) {
            serializable = (AutoHideContainer)component;
            int n2 = ((AutoHideContainer)serializable).getSelectedItemIndex(((MouseEvent)aWTEvent).getPoint());
            SidePaneItem sidePaneItem = null;
            if (n2 != -1) {
                sidePaneItem = ((AutoHideContainer)serializable).getItemForIndex(n2);
            }
            if (sidePaneItem != null && sidePaneItem.getComponent() instanceof DockableFrame) {
                component = sidePaneItem.getComponent();
            }
        }
        if (!(component instanceof Workspace) && SwingUtilities.getAncestorOfClass(FrameContainer.class, component) != null && SwingUtilities.getAncestorOfClass(SlidingOverFrameContainer.class, component) == null || component instanceof FrameContainer) {
            if (!(component instanceof FrameContainer)) {
                component = SwingUtilities.getAncestorOfClass(FrameContainer.class, component);
            }
            component = ((FrameContainer)(serializable = (FrameContainer)component)).getSelectedFrame() != null ? ((FrameContainer)serializable).getSelectedFrame().getComponent(0) : null;
        }
        if ((serializable = DockingUtils.\u0108(component)) instanceof DockableFrame) {
            return ((DockableFrame)serializable).getDockingManager();
        }
        if (serializable instanceof Workspace) {
            return ((Workspace)serializable).getDockingManager();
        }
        return null;
    }

    static Component \u0108(Component component) {
        if (component == null) {
            return null;
        }
        if (DockingUtils.\u0105(component)) {
            return component;
        }
        do {
            if ((component = component.getParent()) != null) continue;
            return null;
        } while (!DockingUtils.\u0105(component));
        return component;
    }

    public static Container getAncestorOfClassButNot(Class<?> clazz, Component component, Class<?> clazz2) {
        Container container;
        if (component == null || clazz == null) {
            return null;
        }
        for (container = component.getParent(); container != null && !clazz.isInstance(container); container = container.getParent()) {
            if (!clazz2.isInstance(container)) continue;
            return null;
        }
        return container;
    }

    static Component \u0101(DockingManager dockingManager, AWTEvent aWTEvent, boolean bl, boolean bl2) {
        boolean bl3;
        Object object;
        Component component;
        Serializable serializable;
        Component component2 = null;
        if (aWTEvent instanceof MouseEvent) {
            serializable = (MouseEvent)aWTEvent;
            component = ((ComponentEvent)serializable).getComponent();
            if (component == null) {
                return null;
            }
            component2 = SwingUtilities.getDeepestComponentAt(component, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
        } else if (aWTEvent instanceof KeyEvent && aWTEvent.getSource() instanceof Component) {
            component2 = PortingUtils.getCurrentFocusComponent(aWTEvent);
        } else if (aWTEvent instanceof FocusEvent) {
            component2 = PortingUtils.getCurrentFocusComponent(aWTEvent);
        }
        if (!bl && component2 instanceof JComponent && ((JComponent)component2).getClientProperty("ignoreClickToActivate") instanceof Boolean && ((Boolean)((JComponent)component2).getClientProperty("ignoreClickToActivate")).booleanValue()) {
            return null;
        }
        if (component2 instanceof AutoHideContainer && aWTEvent instanceof MouseEvent) {
            serializable = (AutoHideContainer)component2;
            int n2 = ((AutoHideContainer)serializable).getSelectedItemIndex(((MouseEvent)aWTEvent).getPoint());
            object = null;
            if (n2 != -1) {
                object = ((AutoHideContainer)serializable).getItemForIndex(n2);
            }
            if (object != null && ((SidePaneItem)object).getComponent() instanceof DockableFrame) {
                component2 = ((SidePaneItem)object).getComponent();
            }
        }
        boolean bl4 = bl3 = component2 instanceof Workspace || DockingUtils.getAncestorOfClassButNot(Workspace.class, component2, FrameContainer.class) != null;
        if (!bl3 && SwingUtilities.getAncestorOfClass(FrameContainer.class, component2) != null && SwingUtilities.getAncestorOfClass(SlidingOverFrameContainer.class, component2) == null || component2 instanceof FrameContainer) {
            component = component2;
            if (!(component2 instanceof FrameContainer)) {
                component2 = SwingUtilities.getAncestorOfClass(FrameContainer.class, component2);
            }
            component2 = ((FrameContainer)(object = (FrameContainer)component2)).getSelectedFrame() != null ? ((FrameContainer)object).getSelectedFrame().getComponent(0) : null;
            if (aWTEvent instanceof MouseEvent && aWTEvent.getSource() instanceof Component && !(component instanceof JideTabbedPane.NoFocusButton)) {
                Point point = SwingUtilities.convertPoint((Component)aWTEvent.getSource(), ((MouseEvent)aWTEvent).getPoint(), (Component)object);
                int n3 = ((JideTabbedPane)object).getUI().tabForCoordinate((JTabbedPane)object, point.x, point.y);
                if (n3 >= 0 && n3 != ((JTabbedPane)object).getSelectedIndex() && n3 < ((JTabbedPane)object).getTabCount() && ((FrameContainer)object).getFrame(n3) != null) {
                    component2 = ((FrameContainer)object).getFrame(n3).getComponent(0);
                }
            }
        }
        return DockingUtils.\u0101(dockingManager, component2, bl2);
    }

    static void \u0105(DockableFrame dockableFrame) {
        if (dockableFrame.isMaximized()) {
            J.\u0101(dockableFrame.getClosePreviousState());
            dockableFrame.setClosePreviousState(dockableFrame.getMaximizedPreviousState());
        } else {
            J.\u0101(dockableFrame.getClosePreviousState());
            dockableFrame.setClosePreviousState(J.\u0101(dockableFrame));
        }
    }

    static void \u0102(DockableFrame dockableFrame) {
        if (dockableFrame.isMaximized()) {
            J.\u0101(dockableFrame.getHiddenPreviousState());
            dockableFrame.setHiddenPreviousState(dockableFrame.getMaximizedPreviousState());
        } else {
            J.\u0101(dockableFrame.getHiddenPreviousState());
            dockableFrame.setHiddenPreviousState(J.\u0101(dockableFrame));
        }
    }

    static void \u0101(DockableFrame dockableFrame) {
        J.\u0101(dockableFrame.getAvailablePreviousState());
        dockableFrame.setAvailablePreviousState(J.\u0101(dockableFrame));
    }

    static void \u0104(DockableFrame dockableFrame) {
        J.\u0101(dockableFrame.getMaximizedPreviousState());
        dockableFrame.setMaximizedPreviousState(J.\u0101(dockableFrame));
    }

    static void \u0102(DockableFrame dockableFrame, boolean bl) {
        if (bl) {
            J.\u0101(dockableFrame.getDockPreviousState());
            dockableFrame.setDockPreviousState(J.\u0101(dockableFrame));
        } else {
            FrameContainer frameContainer = (FrameContainer)dockableFrame.getParent();
            for (int i2 = frameContainer.getTabCount() - 1; i2 >= 0; --i2) {
                DockableFrame dockableFrame2 = (DockableFrame)frameContainer.getComponentAt(i2);
                J j2 = J.\u0101(dockableFrame2);
                J.\u0101(dockableFrame2.getDockPreviousState());
                dockableFrame2.setDockPreviousState(j2);
            }
        }
    }

    static void \u0101(DockableFrame dockableFrame, boolean bl) {
        if (bl) {
            J.\u0101(dockableFrame.getFloatPreviousState());
            dockableFrame.setFloatPreviousState(J.\u0101(dockableFrame));
        } else {
            FrameContainer frameContainer = (FrameContainer)dockableFrame.getParent();
            for (int i2 = frameContainer.getTabCount() - 1; i2 >= 0; --i2) {
                DockableFrame dockableFrame2 = (DockableFrame)frameContainer.getComponentAt(i2);
                J j2 = J.\u0101(dockableFrame2);
                J.\u0101(dockableFrame2.getFloatPreviousState());
                dockableFrame2.setFloatPreviousState(j2);
            }
        }
    }

    static void \u0103(DockableFrame dockableFrame) {
        J.\u0101(dockableFrame.getAutohidePreviousState());
        dockableFrame.setAutohidePreviousState(J.\u0101(dockableFrame));
    }

    static boolean \u0101(DockingManager dockingManager, Container container, J.A a2, JComponent jComponent, boolean bl) {
        int n2 = a2.\u0105.indexOf(new Integer(a2.\u0103));
        int n3 = a2.\u0105.indexOf(new Integer(-1));
        Component component = J.\u0101(dockingManager, container, a2.\u0101);
        JideSwingUtilities.removeFromParentWithFocusTransfer(jComponent);
        if (component != null && component instanceof ContainerContainer) {
            ContainerContainer containerContainer = (ContainerContainer)component;
            if (!bl) {
                int[] nArray;
                for (int n4 : nArray = DockingUtils.\u0101(0, a2.\u0105.size() - 1, n2, n3)) {
                    Component component2;
                    Component component3 = J.\u0101(dockingManager, containerContainer, a2.\u0105.get(n4));
                    if (component3 == null || (component2 = J.\u0101(dockingManager, container, a2.\u0101)) == null || !(component2 instanceof ContainerContainer)) continue;
                    ContainerContainer containerContainer2 = (ContainerContainer)component2;
                    int n5 = containerContainer.indexOfPane(component3);
                    if (n5 == -1) continue;
                    containerContainer2.insertPane(jComponent, n5 + (n4 > n2 ? 0 : 1));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                if (n2 < n3) {
                    containerContainer.insertPane(jComponent, 0);
                } else {
                    containerContainer.add(jComponent);
                }
                bl = true;
            }
        }
        return bl;
    }

    static boolean \u0101(DockingManager dockingManager, Container container, J j2, DockableFrame dockableFrame) {
        Component component = J.\u0101(dockingManager, container, j2.\u0107);
        ArrayList<Integer> arrayList = j2.\u010a;
        if (arrayList == null) {
            return false;
        }
        int n2 = arrayList.indexOf(new Integer(j2.\u0101));
        boolean bl = false;
        if (component != null && component instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)component;
            if (n2 != -1) {
                int[] nArray;
                for (int n3 : nArray = DockingUtils.\u0101(0, j2.\u010a.size() - 1, n2)) {
                    Component component2 = J.\u0101(dockingManager, frameContainer, j2.\u010a.get(n3));
                    if (component2 == null) continue;
                    int n4 = frameContainer.indexOfComponent(component2);
                    int n5 = n4 + (n3 > n2 ? 0 : 1);
                    JideSwingUtilities.removeFromParentWithFocusTransfer(dockableFrame);
                    frameContainer.insertTab(dockableFrame, n5, true);
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                frameContainer.addTab(dockableFrame, true);
                return true;
            }
        }
        return bl;
    }

    static boolean \u0102(FloatingContainer floatingContainer) {
        DockableFrame dockableFrame;
        List<DockableFrame> list;
        return floatingContainer != null && floatingContainer.getContentPane().getComponentCount() == 1 && (list = DockingUtils.\u0102((Container)floatingContainer.getContentPane().getComponent(0))) != null && list.size() == 1 && !(dockableFrame = list.get(0)).isDockable();
    }

    static int \u0101(FloatingContainer floatingContainer) {
        List<DockableFrame> list;
        if (floatingContainer != null && floatingContainer.getContentPane().getComponentCount() == 1 && (list = DockingUtils.\u0102((Container)floatingContainer.getContentPane().getComponent(0))) != null) {
            return list.size();
        }
        return 0;
    }

    public static Insets getFloatingContainerInsets(DockingManager dockingManager) {
        Insets insets;
        if (dockingManager.isUseDecoratedFloatingContainer()) {
            switch (dockingManager.getFloatingContainerType()) {
                case 1: {
                    JFrame jFrame = new JFrame();
                    insets = jFrame.getInsets();
                    break;
                }
                case 2: {
                    JWindow jWindow = new JWindow();
                    insets = jWindow.getInsets();
                    break;
                }
                default: {
                    JDialog jDialog = new JDialog();
                    insets = jDialog.getInsets();
                    break;
                }
            }
        } else {
            Border border = UIDefaultsLookup.getBorder("Resizable.resizeBorder");
            insets = border.getBorderInsets(new JPanel());
            if (!SystemInfo.isJdk14Above()) {
                insets.top = 22;
            }
        }
        return insets;
    }

    public static boolean isFloatingContainerDecorated(FloatingContainer floatingContainer) {
        return !floatingContainer.isUndecorated() || floatingContainer instanceof RootPaneContainer && ((RootPaneContainer)((Object)floatingContainer)).getRootPane().getWindowDecorationStyle() != 0;
    }

    public static boolean shouldUseDecoratedFloatingContainer(DockingManager dockingManager, Container container) {
        return dockingManager.isUseDecoratedFloatingContainer() || DockingUtils.\u0101(dockingManager, container) > 1 || DockingUtils.\u0101(dockingManager, container) == 1 && DockingUtils.\u0102(dockingManager, container) > 1 && !dockingManager.isDragAllTabs();
    }

    public static boolean isInPopup(Component component) {
        for (Component component2 = component; component2 != null && !(component2 instanceof Applet) && !(component2 instanceof Window); component2 = component2.getParent()) {
            if (!(component2 instanceof JPopupMenu)) continue;
            return true;
        }
        return false;
    }

    static void \u0101(DockingManager dockingManager, boolean bl) {
        List<FloatingContainer> list;
        if (dockingManager == null) {
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setVisible(bl);
        }
        if ((list = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer floatingContainer : list) {
                Container container;
                if (!(floatingContainer.getContentPane() instanceof JComponent) || !((container = ((JComponent)floatingContainer.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)container)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)container)).getGlassPane().setVisible(bl);
            }
        }
    }

    static void \u0101(DockingManager dockingManager, Cursor cursor) {
        List<FloatingContainer> list;
        if (dockingManager == null) {
            return;
        }
        if (cursor == Cursor.getDefaultCursor()) {
            DockingUtils.\u0101(dockingManager);
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setCursor(cursor);
        }
        if ((list = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer floatingContainer : list) {
                Container container;
                if (!(floatingContainer.getContentPane() instanceof JComponent) || !((container = ((JComponent)floatingContainer.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)container)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)container)).getGlassPane().setCursor(cursor);
            }
        }
    }

    static void \u0101(DockingManager dockingManager) {
        List<FloatingContainer> list;
        if (dockingManager == null) {
            return;
        }
        if (dockingManager.getRootPaneContainer().getGlassPane() != null) {
            dockingManager.getRootPaneContainer().getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
        if ((list = dockingManager.getFloatingFrames()) != null) {
            for (FloatingContainer floatingContainer : list) {
                Container container;
                if (!(floatingContainer.getContentPane() instanceof JComponent) || !((container = ((JComponent)floatingContainer.getContentPane()).getTopLevelAncestor()) instanceof RootPaneContainer) || ((RootPaneContainer)((Object)container)).getGlassPane() == null) continue;
                ((RootPaneContainer)((Object)container)).getGlassPane().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static void closeFloatingContainer(DockingManager dockingManager, FloatingContainer floatingContainer) {
        DockableFrame dockableFrame;
        if (dockingManager == null) {
            return;
        }
        switch (dockingManager.getFloatingContainerCloseBehavior()) {
            case 0: {
                if (dockingManager.isHidable()) break;
                return;
            }
            case 1: {
                if (dockingManager.isFloatable()) break;
                return;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DockableFrame dockableFrame2 = dockingManager.getFrame(dockingManager.getActiveFrameKey());
        if (dockableFrame2 != null && SwingUtilities.isDescendingFrom(dockableFrame2, (Component)((Object)floatingContainer)) && !dockableFrame2.isHidden() && dockableFrame2.isHidable() && !dockableFrame2.shouldVetoHiding() && !arrayList.contains(dockableFrame2.getKey())) {
            arrayList.add(dockableFrame2.getKey());
        }
        List<String> list = dockingManager.getAllFrameNames();
        for (String string : list) {
            dockableFrame = dockingManager.getFrame(string);
            if (dockableFrame == null || !SwingUtilities.isDescendingFrom(dockableFrame, (Component)((Object)floatingContainer)) || dockableFrame.isHidden() || !dockableFrame.isHidable() || dockableFrame.shouldVetoHiding() || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            switch (dockingManager.getFloatingContainerCloseBehavior()) {
                case 0: {
                    dockingManager.addUndo(dockingManager.getResourceString("Undo.hide"));
                    for (String string : arrayList) {
                        Action action;
                        dockableFrame = dockingManager.getFrame(string);
                        if (dockableFrame == null || (action = dockableFrame.getCloseAction()) == null || !action.isEnabled()) continue;
                        ActionEvent actionEvent = new ActionEvent(floatingContainer, 1001, "hiddenByParentContainer");
                        action.actionPerformed(actionEvent);
                    }
                    break;
                }
                case 1: {
                    dockingManager.addUndo(dockingManager.getResourceString("Undo.toggle"));
                    for (String string : arrayList) {
                        Action action;
                        dockableFrame = dockingManager.getFrame(string);
                        if (dockableFrame == null || (action = dockableFrame.getFloatingAction(true)) == null || !action.isEnabled()) continue;
                        ActionEvent actionEvent = new ActionEvent(floatingContainer, 1001, "hiddenByParentContainer");
                        action.actionPerformed(actionEvent);
                    }
                    break;
                }
            }
        }
    }
}

