/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.axis.TickCalculator;
import com.jidesoft.range.Range;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class LogarithmicTickCalculator
implements TickCalculator<Double> {
    public static final String PROPERTY_LABEL_FORMAT = "LabelFormatProperty";
    public static final String PROPERTY_NUMBER_FORMAT = "NumberFormat";
    private final PropertyChangeSupport \u0102 = new PropertyChangeSupport(this);
    private LogarithmicTickLabelFormat \u0103 = LogarithmicTickLabelFormat.DECIMAL_FORM;
    private NumberFormat \u0101 = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.getDefault()));

    public LogarithmicTickCalculator() {
        this.\u0101.setMaximumFractionDigits(340);
    }

    public LogarithmicTickLabelFormat getLabelFormat() {
        return this.\u0103;
    }

    public void setLabelFormat(LogarithmicTickLabelFormat logarithmicTickLabelFormat) {
        LogarithmicTickLabelFormat logarithmicTickLabelFormat2 = this.\u0103;
        this.\u0103 = logarithmicTickLabelFormat;
        this.\u0102.firePropertyChange(PROPERTY_LABEL_FORMAT, (Object)logarithmicTickLabelFormat2, (Object)logarithmicTickLabelFormat);
    }

    public NumberFormat getNumberFormat() {
        return this.\u0101;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        NumberFormat numberFormat2 = this.\u0101;
        this.\u0101 = numberFormat;
        this.\u0102.firePropertyChange(PROPERTY_NUMBER_FORMAT, numberFormat2, numberFormat);
    }

    @Override
    public Tick[] calculateTicks(Range<Double> range) {
        BigDecimal bigDecimal;
        int n2;
        double d2 = range.minimum();
        double d3 = range.maximum();
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return new Tick[0];
        }
        int n3 = (int)Math.floor(Math.log10(d2));
        if (n3 == (n2 = (int)Math.ceil(Math.log10(d3))) && n3 > 0 && Math.pow(10.0, n3) > d2) {
            --n3;
        }
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        BigDecimal bigDecimal2 = BigDecimal.ONE.scaleByPowerOfTen(n3);
        do {
            int n4 = this.\u0101(bigDecimal2);
            bigDecimal = this.\u0101(n4);
            Tick tick = new Tick(bigDecimal2.doubleValue());
            boolean bl = this.\u0102(bigDecimal2);
            tick.setMajor(bl);
            if (bl) {
                tick.setLabel(this.createLabel(bigDecimal2));
            }
            arrayList.add(tick);
        } while ((bigDecimal2 = bigDecimal2.add(bigDecimal)).doubleValue() <= d3);
        return arrayList.toArray(new Tick[0]);
    }

    int \u0101(BigDecimal bigDecimal) {
        return (int)Math.floor(Math.log10(bigDecimal.doubleValue()));
    }

    BigDecimal \u0101(int n2) {
        if (n2 == 0) {
            return BigDecimal.ONE;
        }
        if (n2 > 0) {
            return BigDecimal.ONE.movePointRight(n2);
        }
        return BigDecimal.ONE.movePointLeft(-n2);
    }

    protected String createLabel(BigDecimal bigDecimal) {
        if (this.\u0103 == LogarithmicTickLabelFormat.EXPONENTIAL_FORM) {
            int n2 = this.\u0101(bigDecimal);
            return "10" + this.\u0102(n2);
        }
        return this.\u0101.format(bigDecimal);
    }

    String \u0102(int n2) {
        if (n2 < 0) {
            return "\u207b" + this.\u0102(-n2);
        }
        if (n2 == 0) {
            return "\u2070";
        }
        if (n2 == 1) {
            return "\u00b9";
        }
        if (n2 == 2) {
            return "\u00b2";
        }
        if (n2 == 3) {
            return "\u00b3";
        }
        if (n2 <= 9) {
            int n3 = 8304 + n2;
            return Character.toString((char)n3);
        }
        int n4 = n2 % 10;
        return this.\u0102(n2 / 10) + this.\u0102(n4);
    }

    private boolean \u0102(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            return false;
        }
        if (bigDecimal.compareTo(BigDecimal.ONE) < 0) {
            return this.\u0102(bigDecimal.multiply(BigDecimal.TEN));
        }
        return this.\u0101(bigDecimal.longValue());
    }

    private boolean \u0101(long l2) {
        while (l2 > 1L) {
            if (l2 % 10L != 0L) {
                return false;
            }
            l2 /= 10L;
        }
        return l2 == 1L;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0102.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0102.removePropertyChangeListener(propertyChangeListener);
    }

    public static enum LogarithmicTickLabelFormat {
        DECIMAL_FORM,
        EXPONENTIAL_FORM;

    }
}

