/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.model;

import com.yworks.util.graph.Node;
import com.yworks.yshrink.model.AbstractDescriptor;
import com.yworks.yshrink.model.FieldDescriptor;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.Model;
import java.io.File;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassDescriptor
extends AbstractDescriptor {
    private String name;
    private String superName;
    private String[] interfaces;
    private String enclosingClass;
    private AbstractMap.SimpleEntry<Object, Object> enclosingMethod;
    private Map<AbstractMap.SimpleEntry<Object, Object>, MethodDescriptor> methods;
    private Map<String, FieldDescriptor> fields;
    private Set<String> allInterfaces;
    private Set<String> allAncestors;
    private Node newNode;
    private boolean hasExternalAncestors = false;
    private Set<String> attributesToKeep = new HashSet<String>();

    protected ClassDescriptor(String name, int access, Node newNode, File sourceJar) {
        super(access, sourceJar);
        this.name = name;
        this.newNode = newNode;
        this.methods = new HashMap<AbstractMap.SimpleEntry<Object, Object>, MethodDescriptor>();
        this.fields = new HashMap<String, FieldDescriptor>();
    }

    protected ClassDescriptor(String name, String superName, String[] interfaces, int access, Node newNode, File sourceJar) {
        this(name, access, newNode, sourceJar);
        this.superName = superName;
        this.interfaces = interfaces;
    }

    public void setEnclosingClass(String enclosingClass) {
        this.enclosingClass = enclosingClass;
    }

    public void setEnclosingMethod(String methodName, String methodDesc) {
        this.enclosingMethod = new AbstractMap.SimpleEntry<String, String>(methodName, methodDesc);
    }

    public String getEnclosingClass() {
        return this.enclosingClass;
    }

    public AbstractMap.SimpleEntry<Object, Object> getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public void addMethod(MethodDescriptor method) {
        this.methods.put(new AbstractMap.SimpleEntry<String, String>(method.getName(), method.getDesc()), method);
    }

    public void addField(FieldDescriptor field) {
        this.fields.put(field.getName(), field);
    }

    public boolean hasExternalAncestors() {
        return this.hasExternalAncestors;
    }

    public void setHasExternalAncestors(boolean hasExternalAncestors) {
        this.hasExternalAncestors = hasExternalAncestors;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        int i = this.name.lastIndexOf(47);
        if (i != -1) {
            return this.name.substring(i + 1, this.name.length());
        }
        return this.name;
    }

    public String getSuperName() {
        return this.superName;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public MethodDescriptor getMethod(String name, String desc) {
        return this.methods.get(new AbstractMap.SimpleEntry<String, String>(name, desc));
    }

    public MethodDescriptor getMethod(AbstractMap.SimpleEntry<Object, Object> method) {
        return this.methods.get(method);
    }

    public FieldDescriptor getField(String name) {
        return this.fields.get(name);
    }

    public Collection<MethodDescriptor> getMethods() {
        return this.methods.values();
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isEnum() {
        return (this.access & 0x4000) != 0;
    }

    public boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    public boolean isInnerClass() {
        return this.enclosingClass != null;
    }

    public boolean implementsMethod(String methodName, String methodDesc) {
        return this.methods.containsKey(new AbstractMap.SimpleEntry<String, String>(methodName, methodDesc));
    }

    public boolean declaresField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public Collection<FieldDescriptor> getFields() {
        return this.fields.values();
    }

    public Set<String> getAllImplementedInterfaces(Model model) {
        if (null != this.allInterfaces) {
            return this.allInterfaces;
        }
        this.allInterfaces = new HashSet<String>(3);
        model.getAllImplementedInterfaces(this.getName(), this.allInterfaces);
        return this.allInterfaces;
    }

    public Set<String> getAllAncestorClasses(Model model) {
        if (null != this.allAncestors) {
            return this.allAncestors;
        }
        this.allAncestors = new HashSet<String>(3);
        model.getAllAncestorClasses(this.getName(), this.allAncestors);
        return this.allAncestors;
    }

    public String toString() {
        return "ClassDescriptor{name='" + this.name + '\'' + ", enclosingClass='" + this.enclosingClass + '\'' + ", enclosingMethod=" + this.enclosingMethod + '}';
    }

    public Node getNewNode() {
        return this.newNode;
    }

    public Set<String> getAttributesToKeep() {
        return this.attributesToKeep;
    }

    public void setRetainAttribute(String attr) {
        this.attributesToKeep.add(attr);
    }

    public boolean getRetainAttribute(String attr) {
        return this.attributesToKeep.contains(attr);
    }
}

