/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.agent;

import com.nuodb.agent.TLSCertificate;
import com.nuodb.impl.util.Env;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class TLSUtils {
    public static final String ENABLE_TLS_PROP = "enableTLS";
    public static final boolean ENABLE_TLS_DEFAULT = false;
    public static final String KEY_STORE_PROP = "keyStore";
    public static final String KEY_STORE_TYPE_PROP = "keyStoreType";
    public static final String KEY_PASSWORD_PROP = "keyPassword";
    public static final String KEY_STORE_PASSWORD_PROP = "keyStorePassword";
    public static final String PEER_CONFIG_PROP = "peerConfig";
    public static final String defaultKeyStoreSubDir = "keys";
    public static final String defaultKeyStoreFileName = "hostkey.p12";
    public static final String defaultKeyStorePass = "changeit";
    public static final String defaultKeyStoreType = "PKCS12";
    public static final String defaultPeerConfigFileName = "peerConfig.xml";

    public static String getDefaultKeyStorePath(String configDir, String homeDir) {
        configDir = Env.configDir(configDir, homeDir);
        return Paths.get(configDir, defaultKeyStoreSubDir, defaultKeyStoreFileName).toString();
    }

    public static String getDefaultPeerConfigPath(String configDir, String homeDir) {
        configDir = Env.configDir(configDir, homeDir);
        return Paths.get(configDir, defaultPeerConfigFileName).toString();
    }

    public static KeyStore getKeyStore(File keyStoreFile, String keyType, String keyPass) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(keyType);
        keyStore.load(new FileInputStream(keyStoreFile), keyPass.toCharArray());
        return keyStore;
    }

    public static Certificate getCertFromKeyStore(KeyStore keyStore) throws IOException, KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        if (!enumeration.hasMoreElements()) {
            throw new IOException("The keyfile contains no certificates!");
        }
        String alias = enumeration.nextElement();
        Certificate cert = keyStore.getCertificate(alias);
        if (enumeration.hasMoreElements()) {
            throw new IOException("The keyfile contains more than one certificate!");
        }
        if (cert == null) {
            throw new IOException("The keyfile can not be processed");
        }
        return cert;
    }

    public static void writeCertToDisk(File keyStoreFile, String keyType, String keyPass, String storeAlias, Certificate cert, KeyPair keyPair) throws IOException {
        try {
            Certificate[] outChain = new Certificate[]{cert};
            KeyStore outStore = KeyStore.getInstance(keyType);
            outStore.load(null, keyPass.toCharArray());
            outStore.setKeyEntry(storeAlias, keyPair.getPrivate(), keyPass.toCharArray(), outChain);
            try (FileOutputStream outputStream = new FileOutputStream(keyStoreFile);){
                outStore.store(outputStream, keyPass.toCharArray());
                outputStream.flush();
            }
        }
        catch (Exception ex) {
            throw new IOException("Failure while loading the keystore " + keyStoreFile.getAbsolutePath(), ex);
        }
    }

    public static Certificate readCert(File keyStoreFile, String keyType, String keyPass) throws IOException {
        try {
            KeyStore keyStore = TLSUtils.getKeyStore(keyStoreFile, keyType, keyPass);
            return TLSUtils.getCertFromKeyStore(keyStore);
        }
        catch (Exception ex) {
            throw new IOException("Failure while loading the keystore " + keyStoreFile.getAbsolutePath(), ex);
        }
    }

    private static KeyManagerFactory readKeyManagerFactory(File keyStoreFile, String keyType, String keyPass) throws IOException {
        try {
            KeyStore keyStore = TLSUtils.getKeyStore(keyStoreFile, keyType, keyPass);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            keyManagerFactory.init(keyStore, keyPass.toCharArray());
            return keyManagerFactory;
        }
        catch (Exception ex) {
            throw new IOException("Failure while loading the keystore " + keyStoreFile.getAbsolutePath(), ex);
        }
    }

    public static void validateKeyStoreConfig(String keyStoreFileName, String keyType, String keyPass) throws IOException {
        File keyStoreFile = new File(keyStoreFileName);
        try {
            TLSUtils.readKeyManagerFactory(keyStoreFile, keyType, keyPass);
        }
        catch (Exception ex) {
            throw new IOException("Failure while loading the keystore " + keyStoreFile.getAbsolutePath(), ex);
        }
    }

    public static SSLSocket generateSSLSocket(String selfAlias, Map<String, TLSCertificate> trustedCerts, Socket proxySocket, String keyType, String keyPass, File keyStoreFile) throws Exception {
        KeyStore onDiskPrivateStore = TLSUtils.getKeyStore(keyStoreFile, keyType, keyPass);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
        keyManagerFactory.init(onDiskPrivateStore, keyPass.toCharArray());
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, null);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (Map.Entry<String, TLSCertificate> entry : trustedCerts.entrySet()) {
            String stableId = entry.getKey();
            Certificate certificate = certificateFactory.generateCertificate(entry.getValue().toInputStream());
            trustStore.setCertificateEntry(stableId, certificate);
        }
        Certificate privCert = TLSUtils.getCertFromKeyStore(onDiskPrivateStore);
        trustStore.setCertificateEntry(selfAlias, privCert);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
        trustManagerFactory.init(trustStore);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        return (SSLSocket)sslSocketFactory.createSocket(proxySocket, proxySocket.getInetAddress().getHostAddress(), proxySocket.getPort(), true);
    }
}

