/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.sql;

import com.onseven.dbvis.sql.g;
import com.onseven.dbvis.util.w;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class BinaryData
implements g {
    protected static final Set<String> LOGGED_ENCODING_EXCEPTIONS = new HashSet<String>();
    private byte[] data = new byte[0];
    private long length = 0L;
    private Blob blob;
    private String cachedStr;
    private String cachedStrEncoding;
    private int cachedStrLength;
    private String cachedHex;
    private int cachedHexLength;
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Logger LOG = Logger.getLogger(BinaryData.class.getName());

    public BinaryData() {
    }

    public BinaryData(Blob blob) {
        this.blob = blob;
        this.data = null;
        this.length = -1L;
    }

    public BinaryData(byte[] byArray) {
        this.data = byArray;
        this.length = this.data.length;
    }

    public BinaryData(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[1024];
        while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        this.data = byteArrayOutputStream.toByteArray();
        this.length = this.data.length;
    }

    public long getLength() {
        if (this.length < 0L && this.blob != null) {
            try {
                this.length = this.blob.length();
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "There was an error getting BLOB/Binary data", exception);
                this.length = 0L;
            }
        }
        return this.length;
    }

    public byte[] getBytes() {
        if (this.data == null && this.blob != null) {
            try {
                this.data = this.blob.getBytes(1L, (int)this.getLength());
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "There was an error getting BLOB/Binary data", exception);
                this.data = new byte[0];
            }
        }
        return this.data;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public String toString() {
        return this.toString(null, -1);
    }

    public String toString(String string, int n2) {
        if (this.cachedStr != null && StringUtils.equals((CharSequence)this.cachedStrEncoding, (CharSequence)string) && this.cachedStrLength == n2) {
            return this.cachedStr;
        }
        this.cachedStr = null;
        this.cachedStrEncoding = null;
        this.cachedStrLength = -1;
        byte[] byArray = this.getBytes();
        int n3 = (int)this.getLength();
        if (n3 == 0 || byArray.length == 0) {
            return "";
        }
        if (n2 <= 0) {
            n2 = n3;
        }
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        n3 = Math.min(n3, n2);
        try {
            this.cachedStr = w.j(string) ? new String(byArray, 0, n3, string) : new String(byArray, 0, n3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            BinaryData.logEncodingException(string, unsupportedEncodingException);
        }
        this.cachedStrLength = n2;
        this.cachedStrEncoding = string;
        return this.cachedStr;
    }

    private static void logEncodingException(String string, UnsupportedEncodingException unsupportedEncodingException) {
        if (!LOGGED_ENCODING_EXCEPTIONS.add(string)) {
            LOG.log(Level.WARNING, "Unexpected encoding: '" + string + "'", new IllegalArgumentException(unsupportedEncodingException));
        }
    }

    public String toHexString() {
        return this.toHexString(-1);
    }

    public String toHexString(int n2) {
        if (this.cachedHex != null && this.cachedHexLength == n2) {
            return this.cachedHex;
        }
        this.cachedHex = null;
        this.cachedHexLength = -1;
        byte[] byArray = this.getBytes();
        int n3 = (int)this.getLength();
        if (n3 == 0 || byArray.length == 0) {
            return "";
        }
        if (n2 <= 0) {
            n2 = n3;
        }
        if (n2 > byArray.length) {
            n2 = byArray.length;
        }
        n3 = Math.min(n3, n2);
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(hexChar[(byArray[i2] & 0xF0) >>> 4]);
            stringBuilder.append(hexChar[byArray[i2] & 0xF]);
        }
        this.cachedHexLength = n3;
        this.cachedHex = stringBuilder.toString();
        return this.cachedHex;
    }

    public static String byteToBase64String(byte[] byArray) {
        return new String(Base64.getEncoder().encode(byArray));
    }
}

