/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.wizard;

import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.IconMultilinePanel;
import com.jidesoft.wizard.WizardIconsFactory;
import com.jidesoft.wizard.WizardStyle;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DefaultWizardPage
extends AbstractWizardPage {
    private List<Component> _components = new ArrayList<Component>();
    private JComponent _varyComponent = null;
    private Border _contentBorder;

    public DefaultWizardPage(String string) {
        super(string);
    }

    public DefaultWizardPage(String string, String string2) {
        super(string, string2);
    }

    public DefaultWizardPage(String string, Icon icon) {
        super(string, icon);
    }

    public DefaultWizardPage(String string, String string2, Icon icon) {
        super(string, string2, icon);
    }

    protected JComponent createDefaultContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 3));
        boolean bl = true;
        for (int i = 0; i < this._components.size(); ++i) {
            Component component = this._components.get(i);
            if (component instanceof Box.Filler) {
                bl = false;
                jPanel.add(component, "vary");
            } else if (component == this._varyComponent) {
                bl = false;
                jPanel.add(component, "vary");
            } else {
                jPanel.add(component);
            }
            if (i == this._components.size() - 1 || component instanceof Box.Filler) continue;
            jPanel.add(Box.createVerticalStrut(WizardStyle.getInt("Wizard.gap")));
        }
        if (bl) {
            jPanel.add(Box.createGlue(), "vary");
        }
        jPanel.setOpaque(false);
        jPanel.setBorder(this.getContentBorder());
        return jPanel;
    }

    public void addText(String string) {
        this.addText(string, null);
    }

    public void addText(String string, Font font) {
        MultilineLabel multilineLabel = new MultilineLabel(string);
        if (font != null) {
            multilineLabel.setFont(font);
        }
        this.addComponent(multilineLabel);
    }

    public void addTitle(String string) {
        Font font = WizardStyle.getFont("Wizard.titleFont");
        MultilineLabel multilineLabel = new MultilineLabel(string);
        if (font != null) {
            multilineLabel.setFont(font);
        }
        this.addComponent(multilineLabel);
    }

    public void addWarning(String string) {
        this.addComponent(new IconMultilinePanel(WizardIconsFactory.getImageIcon("icons/warning.gif"), string));
    }

    public void addInfo(String string) {
        this.addComponent(new IconMultilinePanel(WizardIconsFactory.getImageIcon("icons/info.gif"), string));
    }

    public void addIconText(Icon icon, String string) {
        this.addComponent(new IconMultilinePanel(icon, string));
    }

    public void addComponent(JComponent jComponent) {
        this._components.add(jComponent);
    }

    @Override
    public void reset() {
        super.reset();
        if (this._components != null) {
            this._components.clear();
        }
    }

    public void addComponent(JComponent jComponent, boolean bl) {
        this.addComponent(jComponent);
        if (bl) {
            this._varyComponent = jComponent;
        }
    }

    public void addSpace() {
        this._components.add(Box.createGlue());
    }

    @Override
    public void setupWizardButtons() {
    }

    protected void initContentPane() {
    }

    @Override
    public JComponent createWizardContent() {
        this.initContentPane();
        return this.createDefaultContentPane();
    }

    public Border getContentBorder() {
        if (this._contentBorder == null) {
            return this.getContentThinBorder();
        }
        return this._contentBorder;
    }

    public void setContentBorder(Border border) {
        this._contentBorder = border;
    }
}

