/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.wizard;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageEvent;
import com.jidesoft.dialog.PageListener;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.wizard.JavaWizardHeader;
import com.jidesoft.wizard.WizardDialogPane;
import com.jidesoft.wizard.WizardStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class AbstractWizardPage
extends AbstractDialogPage {
    public static final int LEFTPANE_NONE = 0;
    public static final int LEFTPANE_EMPTY = 1;
    public static final int LEFTPANE_GRAPHIC = 2;
    public static final int LEFTPANE_STEPS = 4;
    public static final int LEFTPANE_HELP = 8;
    public static final int LEFTPANE_CUSTOM = 16;
    private int _leftPaneItems = -1;
    protected JComponent _wizardContent;
    private transient WizardDialogPane _owner;
    private PageListener _pageListener;
    private String _helpText = null;

    public AbstractWizardPage(String string) {
        this(string, "", null);
    }

    public AbstractWizardPage(String string, String string2) {
        this(string, string2, null);
    }

    public AbstractWizardPage(String string, Icon icon) {
        this(string, "", icon);
    }

    public AbstractWizardPage(String string, String string2, Icon icon) {
        super(string, string2, icon);
        this.installPageListener();
    }

    private AbstractWizardPage(String string, String string2, Icon icon, AbstractDialogPage abstractDialogPage) {
        super(string, string2, icon, abstractDialogPage);
        this.installPageListener();
    }

    private void installPageListener() {
        this._pageListener = new PageListener(){

            @Override
            public void pageEventFired(PageEvent pageEvent) {
                if (pageEvent.getID() == 3199) {
                    WizardDialogPane wizardDialogPane = AbstractWizardPage.this.getOwner();
                    if (wizardDialogPane != null) {
                        wizardDialogPane.setNextPage(null);
                    }
                    AbstractWizardPage.this.setupWizardButtons();
                }
            }
        };
        this.addPageListener(this._pageListener);
    }

    public WizardDialogPane getOwner() {
        return this._owner;
    }

    void setOwner(WizardDialogPane wizardDialogPane) {
        this._owner = wizardDialogPane;
        this.setHelpText(this._helpText);
    }

    public abstract JComponent createWizardContent();

    public abstract void setupWizardButtons();

    public JComponent getWizardContent() {
        return this._wizardContent;
    }

    public boolean showBannerPane() {
        return WizardStyle.getStyle() == 0;
    }

    @Override
    public void lazyInitialize() {
        this.setLayout(new BorderLayout());
        this._wizardContent = this.createWizardContent();
        if (this._wizardContent != null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            if (WizardStyle.getStyle() == 2) {
                final JavaWizardHeader javaWizardHeader = new JavaWizardHeader(this.getTitle(), this.getDescription());
                this.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        AbstractWizardPage.this.updateHeaderPanel(javaWizardHeader, AbstractWizardPage.this);
                    }
                });
                this.updateHeaderPanel(javaWizardHeader, this);
                javaWizardHeader.setBorder(BorderFactory.createEmptyBorder(0, 0, WizardStyle.getInt("Wizard.gap"), 0));
                jPanel.add((Component)javaWizardHeader, "First");
            } else if (WizardStyle.getStyle() == 3) {
                JLabel jLabel = new JLabel(this.getTitle());
                jLabel.setFont(WizardStyle.getFont("Wizard.titleFont"));
                jLabel.setBorder(BorderFactory.createEmptyBorder(0, 25, WizardStyle.getInt("Wizard.gap"), 0));
                jPanel.add((Component)jLabel, "First");
                this._wizardContent.setBackground(WizardStyle.getColor("Wizard.contentBackground"));
                this._wizardContent.setOpaque(true);
                this._wizardContent.setBorder(WizardStyle.getBorder("Wizard.contentBorder"));
            }
            jPanel.add((Component)this._wizardContent, "Center");
            jPanel.setBorder(WizardStyle.getBorder("Wizard.pageBorder"));
            this.add((Component)jPanel, "Center");
        }
    }

    protected void updateHeaderPanel(JComponent jComponent, AbstractDialogPage abstractDialogPage) {
        if (jComponent instanceof JavaWizardHeader) {
            JavaWizardHeader javaWizardHeader = (JavaWizardHeader)jComponent;
            javaWizardHeader.setTitle(abstractDialogPage.getTitle());
            javaWizardHeader.setSubtitle(abstractDialogPage.getDescription());
        }
    }

    public Border getContentThinBorder() {
        return WizardStyle.getBorder("Wizard.thinPageBorder");
    }

    public Border getContentThickBorder() {
        return UIDefaultsLookup.getBorder("Wizard.thickPageBorder");
    }

    public int getLeftPaneItems() {
        if (this._leftPaneItems == -1) {
            if (WizardStyle.getStyle() == 2) {
                return 4;
            }
            if (WizardStyle.getStyle() == 3) {
                return 4;
            }
            return 0;
        }
        return this._leftPaneItems;
    }

    public void setLeftPaneItems(int n) {
        this._leftPaneItems = n;
    }

    public List<String> getSteps() {
        if (this.getOwner() != null) {
            return this.getOwner().getPageList().getPageTitlesAsList();
        }
        return new ArrayList<String>();
    }

    public int getSelectedStepIndex() {
        if (this.getOwner() != null) {
            return this.getOwner().getPageList().getPageIndexByFullTitle(this.getFullTitle());
        }
        return -1;
    }

    public void setHelpText(String string) {
        this._helpText = string;
        if (this.getOwner() != null && this.getOwner().getHelpPane() != null) {
            this.getOwner().getHelpPane().setHelpText(string);
        }
    }

    public String getHelpText() {
        return this._helpText;
    }

    public Image getGraphic() {
        return null;
    }

    public JComponent getCustomLeftPane() {
        return null;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(8)) {
            Lm.showInvalidProductMessage(AbstractWizardPage.class.getName(), 8);
        }
    }
}

