/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.converter.CalendarConverter;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PopupWindow;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.ProductNames;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.Beans;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public final class Lm
implements ProductNames {
    private static Logger LOGGER = Logger.getLogger(Lm.class.getName());
    public static final boolean DEBUG = false;
    public static final boolean DOC_DEBUG = false;
    public static final boolean CM_DEBUG = false;
    public static final boolean RA_DEBUG = false;
    public static final boolean ID_DEBUG = false;
    public static final boolean PG_DEBUG = false;
    public static final boolean CB_DEBUG = false;
    public static final boolean HG_DEBUG = false;
    public static final boolean AF_DEBUG = false;
    public static final boolean BP_DEBUG = false;
    public static final boolean DOCK_DEBUG = false;
    public static final boolean DOCK_ID_DEBUG = false;
    public static final boolean ACTION_DEBUG = false;
    public static final boolean COMPONENT_DEBUG = false;
    public static final boolean PROPERTY_TABLE_DEBUG = false;
    public static final boolean COMBOBOX_DEBUG = false;
    public static final boolean BEAN_INTROSPECTOR_DEBUG = false;
    public static final boolean DEMO = false;
    private static final String COMPANY = "JIDE Software, Inc.";
    private static final int YEAR = 2021;
    private static final int MONTH = 12;
    private static final int DAY = 1;
    private static boolean _showDemo = false;
    private static int count = 0;
    private static JFrame _parent;
    private static final String PRODUCT_VERSION = "3.7.12";
    private static final Calendar expireDate;
    private static final String EVAL_ONLY = "Evaluation Purpose Only";
    private static int _showProducts;
    private static boolean _showCommon;
    private static int _productsPurchased;
    private static String _companyName;
    private static String _projectName;
    private static final String PRODUCT_DOCKING_S = "Docking";
    private static final String PRODUCT_COMPONENT_S = "Component";
    private static final String PRODUCT_GRID_S = "Grid";
    private static final String PRODUCT_DIALOG_S = "Dialog";
    private static final String PRODUCT_ACTION_S = "Action";
    private static final String PRODUCT_SHORTCUT_S = "Shortcut";
    private static final String PRODUCT_PIVOT_S = "Pivot";
    private static final String PRODUCT_CODE_EDITOR_S = "CodeEditor";
    private static final String PRODUCT_FEEDREADER_S = "FeedReader";
    private static final String PRODUCT_DASHBOARD_S = "Dashboard";
    private static final String PRODUCT_DATAGRIDS_S = "Data";
    private static final String PRODUCT_CHART_S = "Charts";
    private static final String PRODUCT_GANTT_S = "Gantt";
    private static final String PRODUCT_DIFF_S = "Diff";
    private static final String PRODUCT_TREEMAP_S = "TreeMap";
    private static final String PRODUCT_JDAF_S = "JDAF";
    private static final String[] PRODUCTS;
    private static final BigInteger e;
    private static final BigInteger n;

    public static String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public static boolean showDemoMessageBoxDocking() {
        if (++count != 0 && count % 20 == 0) {
            _showDemo = false;
            Lm.z();
        }
        return false;
    }

    public static void showAboutMessageBox() {
        _showDemo = false;
        Lm.z();
    }

    private static String getProductName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            return "";
        }
        if ((n & 1) != 0) {
            stringBuffer.append("JIDE Docking Framework, ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("JIDE Components, ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("JIDE Grids, ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("JIDE Dialogs, ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("JIDE Action Framework, ");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append("JIDE Shortcut Editor, ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("JIDE Pivot Grid, ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("JIDE Code Editor, ");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("JIDE Feed Reader, ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("JIDE Dashboard, ");
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append("JIDE Data Grids, ");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("JIDE Charts, ");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("JIDE Gantt Chart, ");
        }
        if ((n & 0x4000) != 0) {
            stringBuffer.append("JIDE Diff, ");
        }
        if ((n & 0x8000) != 0) {
            stringBuffer.append("JIDE TreeMap, ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("JIDE Desktop Application Framework, ");
        }
        String string = new String(stringBuffer);
        return string.substring(0, string.length() - 2);
    }

    protected static String getProductName(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n != 1) continue;
            stringBuffer.append(PRODUCTS[i]);
        }
        return stringBuffer.toString();
    }

    public static void showInvalidProductMessage(String string, int n) {
        if (_productsPurchased == 0) {
            if (!_showCommon) {
                if ("true".equals(SecurityUtils.getProperty("jide.verifyLicense", "false"))) {
                    System.err.println("Verifying " + string);
                    Thread.dumpStack();
                }
                if (!Beans.isDesignTime() && Beans.isGuiAvailable()) {
                    Lm.showMessageBox("<html><font size=3><b>Unauthorized usage of JIDE products</b></font><br><br><hr size='1'><br>You get this message box is because you didn't input a correct license key.<br>If you see this message box in one of our demo examples, just ignore it. If you wish to use JIDE products in <br>your application, please contact sales@jidesoft.com.</html>", COMPANY, -1, "Click to Continue");
                } else {
                    System.out.println("Unauthorized usage of JIDE products\nYou get this message is because you didn't input a correct license key.\nIf you see this message box in one of our demo examples, just ignore it.\nIf you wish to use JIDE products in your application, please contact sales@jidesoft.com.");
                }
                _showCommon = true;
            }
        } else if ((_showProducts & n) == 0) {
            if ("true".equals(SecurityUtils.getProperty("jide.verifyLicense", "false"))) {
                System.err.println("Verifying " + string + " for " + n);
                Thread.dumpStack();
            }
            String string2 = Lm.getProductName(n);
            String string3 = Lm.getProductName(_productsPurchased);
            if (!Beans.isDesignTime() && Beans.isGuiAvailable()) {
                Lm.showMessageBox("<html><font size=3><b>Unauthorized usage of JIDE products</b></font><br><br><hr size='1'><br>You get this message box is because the license key(s) are for " + string3 + " only.<br>The class " + string + " you tried to use is part of " + string2 + ".<br>If you wish to use " + string2 + " in your application, please contact sales@jidesoft.com.</html>", COMPANY, -1, "Click to Continue");
            } else {
                System.out.println("Unauthorized usage of JIDE products\nYou get this message is because the license key(s) are for " + string3 + " only.\nThe class " + string + " you tried to use is part of " + string2 + ".\nIf you wish to use " + string2 + " in your application, please contact sales@jidesoft.com.");
            }
            _showProducts |= n;
        }
    }

    private static void showDemoWelcomeMessageBox() {
        if (_productsPurchased == 0) {
            Lm.verifyLicense();
        }
        Calendar calendar = Calendar.getInstance();
        String string = "JIDE Docking Framework, JIDE Action Framework, JIDE Components, JIDE Grids, JIDE Dialogs, JIDE Pivot Grid, JIDE Shortcut Editor, JIDE Code Editor, JIDE Feed Reader, JIDE Dashboard, JIDE Data Grids, JIDE Charts, JIDE Gantt Chart, and JIDE Diff";
        int n = string.indexOf(",", string.length() / 2);
        string = string.substring(0, n + 1) + "<BR>" + string.substring(n + 1) + "<BR>" + Lm.getProductVersion();
        if (_productsPurchased == 0 && calendar.after(expireDate)) {
            Lm.showMessageBox("<html><font size=3><b>Demo for " + string + "</b></font><br><br>Copyright (c) 2002-" + new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime()) + " JIDE Software, Inc, all rights reserved.<br><br><hr size='1'><br><font color='red'><b>This demo version has expired on " + DateFormat.getDateInstance(1).format(expireDate.getTime()) + ".</b></font><br>If you want to continue evaluating, please download it again from http://www.jidesoft.com.<br><br><b>Please Note: This release package is for evaluation purpose only. Distribution of it is strictly prohibited. If you wish to use any JIDE products in your application, please contact sales@jidesoft.com.</html>", COMPANY, -1, "Click to Exit");
            System.exit(0);
        } else if (!_showDemo) {
            if (!Beans.isDesignTime() && Beans.isGuiAvailable()) {
                Lm.showMessageBox("<html><font size=3><b>Demo for " + string + "</b></font><br><br>Copyright (c) 2002-" + new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime()) + " JIDE Software, Inc, all rights reserved.<br><br><hr size='1'><br>This is an evaluation version of JIDE products " + (_productsPurchased == 0 ? ". It will expire on " + DateFormat.getDateInstance(1).format(expireDate.getTime()) : "that is temporarily licensed to <b>" + _companyName + "</b> for " + _projectName) + ".<br><br><b>Please Note: This release package is for evaluation purpose only. Distribution of it is strictly prohibited.<br> If you wish to use any JIDE products in your application, please contact sales@jidesoft.com. If you already purchased, please download the formal release package to get rid of this message box.</html>", COMPANY, -1, "Continue to Evaluate");
            } else {
                System.out.println("Demo for JIDE Docking Framework, JIDE Action Framework, JIDE Components, JIDE Grids, JIDE Dialogs, JIDE Pivot Grid, JIDE Shortcut Editor, JIDE Code Editor, JIDE Feed Reader, JIDE Dashboard, JIDE Data Grids, JIDE Charts, JIDE Gantt Chart, and JIDE Diff\n\nCopyright (c) 2002-" + new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime()) + " JIDE Software, Inc, all rights reserved.\n\n---------\nThis is an evaluation version of JIDE products " + (_productsPurchased == 0 ? ". It will expire on " + DateFormat.getDateInstance(1).format(expireDate.getTime()) : "that is temporarily licensed to <b>" + _companyName + " for " + _projectName) + ".\n\nPlease Note: This release package is for evaluation purpose only. Distribution of it is strictly prohibited.\n If you wish to use any JIDE products in your application, please contact sales@jidesoft.com. If you already purchased, please download the formal release package to get rid of this message box.");
            }
            _showDemo = true;
        }
    }

    public static void z() {
        Lm.showDemoWelcomeMessageBox();
    }

    private static String createInputString(String string, String string2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(string2);
        stringBuffer.append(":");
        stringBuffer.append(n);
        if (n2 != 0) {
            stringBuffer.append(":");
            stringBuffer.append(n2);
        }
        return new String(stringBuffer);
    }

    private static String createInputString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(string2);
        stringBuffer.append(":");
        stringBuffer.append(string3);
        return new String(stringBuffer);
    }

    private static int convertProductStringToValue(String string) {
        int n = 0;
        if (string.indexOf(PRODUCT_DOCKING_S) != -1) {
            n |= 1;
        }
        if (string.indexOf(PRODUCT_COMPONENT_S) != -1) {
            n |= 2;
        }
        if (string.indexOf(PRODUCT_GRID_S) != -1) {
            n |= 4;
        }
        if (string.indexOf(PRODUCT_DIALOG_S) != -1) {
            n |= 8;
        }
        if (string.indexOf(PRODUCT_ACTION_S) != -1) {
            n |= 0x10;
        }
        if (string.indexOf(PRODUCT_SHORTCUT_S) != -1) {
            n |= 0x40;
        }
        if (string.indexOf(PRODUCT_PIVOT_S) != -1) {
            n |= 0x20;
        }
        if (string.indexOf(PRODUCT_CODE_EDITOR_S) != -1) {
            n |= 0x80;
        }
        if (string.indexOf(PRODUCT_FEEDREADER_S) != -1) {
            n |= 0x100;
        }
        if (string.indexOf(PRODUCT_DASHBOARD_S) != -1) {
            n |= 0x400;
        }
        if (string.indexOf(PRODUCT_DATAGRIDS_S) != -1) {
            n |= 0x800;
        }
        if (string.indexOf(PRODUCT_CHART_S) != -1) {
            n |= 0x1000;
        }
        if (string.indexOf(PRODUCT_GANTT_S) != -1) {
            n |= 0x2000;
        }
        if (string.indexOf(PRODUCT_DIFF_S) != -1) {
            n |= 0x4000;
        }
        if (string.indexOf(PRODUCT_TREEMAP_S) != -1) {
            n |= 0x8000;
        }
        if (string.indexOf(PRODUCT_JDAF_S) != -1) {
            n |= 0x200;
        }
        return n;
    }

    static boolean z(int n) {
        if (_productsPurchased == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No license key is input, try to get it from resource file or system property");
            }
            Lm.verifyLicense();
        }
        return (_productsPurchased & n) != 0 && !EVAL_ONLY.equals(_projectName);
    }

    public static void verifyLicense(String string, String string2, String string3) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Verify license key: " + string + " + " + string2 + " + " + string3);
        }
        Lm.internalVerifyProductLicense(string, string2, string3);
    }

    private static void verifyLicense() {
        Object object;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.jidesoft.utils.utils");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resourceBundle == null) {
            try {
                object = Thread.currentThread().getContextClassLoader();
                if (object != null) {
                    resourceBundle = ResourceBundle.getBundle("com.jidesoft.utils.utils", Locale.getDefault(), (ClassLoader)object);
                }
            }
            catch (Exception exception) {}
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Retrieved license key from the resource file");
        }
        try {
            String string;
            String string2;
            Object object2 = object = resourceBundle != null ? resourceBundle.getString("verifyLicense.companyName") : SecurityUtils.getProperty("verifyLicense.companyName", null);
            if (object == null || ((String)object).trim().length() == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Company name is empty");
                }
                return;
            }
            String string3 = string2 = resourceBundle != null ? resourceBundle.getString("verifyLicense.projectName") : SecurityUtils.getProperty("verifyLicense.projectName", null);
            if (string2 == null || string2.trim().length() == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Product name is empty");
                }
                return;
            }
            String string4 = string = resourceBundle != null ? resourceBundle.getString("verifyLicense.licenseKey") : SecurityUtils.getProperty("verifyLicense.licenseKey", null);
            if (string == null || string.trim().length() == 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("License key is empty");
                }
                return;
            }
            Lm.internalVerifyProductLicense((String)object, string2, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void internalVerifyProductLicense(String string, String string2, String string3) {
        Object object;
        Object object2;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Verifying ...");
        }
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0 || string3 == null || string3.trim().length() == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Verify failed as one of the names are null");
            }
            return;
        }
        string = string.trim();
        if ((string2 = string2.trim()).startsWith("Trial") && ((String)(object2 = (Object)string2.substring("Trial".length()).trim())).length() > 0 && (object = new CalendarConverter().fromString((String)object2, null)) instanceof Calendar && Calendar.getInstance().after((Calendar)object)) {
            Lm.showMessageBox("<html><font size=3><b>Trial Version for JIDE Products</b></font><br><br>Copyright (c) 2002-" + new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime()) + " JIDE Software, Inc, all rights reserved.<br><br><hr size='1'><br><font color='red'><b>This trial version has expired on " + DateFormat.getDateInstance(1).format(((Calendar)object).getTime()) + ".</b></font><br>If you want to continue evaluating, please email sales@jidesoft.com to extend your trial license.<br><br><b>Please Note: This release package is for trial purpose only. Distribution of it is strictly prohibited.<br> If you wish to use any JIDE products in your application, please contact sales@jidesoft.com.</html>", COMPANY, -1, "Click to Exit");
            System.exit(0);
        }
        object2 = new int[PRODUCTS.length];
        Arrays.fill((int[])object2, 0);
        object = Lm.computeInteger(string3);
        BigInteger bigInteger = ((BigInteger)object).modPow(e, n);
        if (Lm.verifyCommonProducts(string, string2, (int[])object2, bigInteger)) {
            return;
        }
        if (Lm.verifyAllProducts(string, string2, (int[])object2, bigInteger)) {
            return;
        }
        for (int i = 15; i >= 0; --i) {
            for (int j = 7; j >= 0; --j) {
                int n = Lm.computerSum(Lm.createInputString(string, string2, i, j * 16));
                if (!bigInteger.equals(new BigInteger("" + n))) continue;
                _productsPurchased |= i + j * 16;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Verified (old way): " + _productsPurchased);
                }
                return;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Verify failed");
        }
    }

    private static boolean verifyAllProducts(String string, String string2, int[] nArray, BigInteger bigInteger) {
        nArray[0] = 1;
        while (nArray[0] >= 0) {
            nArray[1] = 1;
            while (nArray[1] >= 0) {
                nArray[2] = 1;
                while (nArray[2] >= 0) {
                    nArray[3] = 1;
                    while (nArray[3] >= 0) {
                        nArray[4] = 1;
                        while (nArray[4] >= 0) {
                            nArray[5] = 1;
                            while (nArray[5] >= 0) {
                                nArray[6] = 1;
                                while (nArray[6] >= 0) {
                                    nArray[7] = 1;
                                    while (nArray[7] >= 0) {
                                        nArray[8] = 1;
                                        while (nArray[8] >= 0) {
                                            nArray[9] = 1;
                                            while (nArray[9] >= 0) {
                                                nArray[10] = 1;
                                                while (nArray[10] >= 0) {
                                                    nArray[11] = 1;
                                                    while (nArray[11] >= 0) {
                                                        nArray[12] = 1;
                                                        while (nArray[12] >= 0) {
                                                            nArray[13] = 1;
                                                            while (nArray[13] >= 0) {
                                                                nArray[14] = 1;
                                                                while (nArray[14] >= 0) {
                                                                    nArray[15] = 1;
                                                                    while (nArray[15] >= 0) {
                                                                        if (Lm.verify(string, string2, nArray, bigInteger)) {
                                                                            return true;
                                                                        }
                                                                        nArray[15] = nArray[15] - 1;
                                                                    }
                                                                    nArray[14] = nArray[14] - 1;
                                                                }
                                                                nArray[13] = nArray[13] - 1;
                                                            }
                                                            nArray[12] = nArray[12] - 1;
                                                        }
                                                        nArray[11] = nArray[11] - 1;
                                                    }
                                                    nArray[10] = nArray[10] - 1;
                                                }
                                                nArray[9] = nArray[9] - 1;
                                            }
                                            nArray[8] = nArray[8] - 1;
                                        }
                                        nArray[7] = nArray[7] - 1;
                                    }
                                    nArray[6] = nArray[6] - 1;
                                }
                                nArray[5] = nArray[5] - 1;
                            }
                            nArray[4] = nArray[4] - 1;
                        }
                        nArray[3] = nArray[3] - 1;
                    }
                    nArray[2] = nArray[2] - 1;
                }
                nArray[1] = nArray[1] - 1;
            }
            nArray[0] = nArray[0] - 1;
        }
        return false;
    }

    private static boolean verifyCommonProducts(String string, String string2, int[] nArray, BigInteger bigInteger) {
        Arrays.fill(nArray, 1);
        if (Lm.verify(string, string2, nArray, bigInteger)) {
            return true;
        }
        Arrays.fill(nArray, 0);
        nArray[0] = 1;
        nArray[1] = 1;
        if (Lm.verify(string, string2, nArray, bigInteger)) {
            return true;
        }
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        if (Lm.verify(string, string2, nArray, bigInteger)) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            Arrays.fill(nArray, 0);
            nArray[i] = 1;
            if (!Lm.verify(string, string2, nArray, bigInteger)) continue;
            return true;
        }
        Arrays.fill(nArray, 0);
        nArray[2] = 1;
        nArray[6] = 1;
        return Lm.verify(string, string2, nArray, bigInteger);
    }

    private static boolean verify(String string, String string2, int[] nArray, BigInteger bigInteger) {
        String string3 = Lm.getProductName(nArray);
        int n = Lm.computerSum2(Lm.createInputString(string, string2, string3));
        if (bigInteger.equals(new BigInteger("" + n))) {
            _productsPurchased |= Lm.convertProductStringToValue(string3);
            _companyName = string;
            _projectName = string2;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Verified: " + _productsPurchased);
            }
            return true;
        }
        return false;
    }

    public static void clearLicense() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("License key is cleared");
        }
        _productsPurchased = 0;
    }

    private static BigInteger computeInteger(String string) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = string.length() - 1; i >= 0; --i) {
            int n;
            char c = string.charAt(i);
            if ('0' <= c && c <= '9') {
                n = c - 48;
            } else if ('A' <= c && c <= 'Z') {
                n = c - 65 + 10;
            } else if ('a' <= c && c <= 'z') {
                n = c - 97 + 36;
            } else if (c == '.') {
                n = 62;
            } else if (c == ':') {
                n = 63;
            } else {
                System.err.println("incorrect char:" + c);
                continue;
            }
            bigInteger = bigInteger.shiftLeft(6);
            bigInteger = bigInteger.add(BigInteger.valueOf(n));
        }
        return bigInteger;
    }

    private static int computerSum(String string) {
        int n = 1976;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i);
            n += 666;
            n ^= 0x7895;
        }
        return n;
    }

    private static int computerSum2(String string) {
        int n = 1979;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i);
            n += 88888;
            n ^= 0x31527B;
        }
        return n;
    }

    public static void setParent(JFrame jFrame) {
        _parent = jFrame;
    }

    private static void showMessageBox(Object object, String string, int n) {
        Lm.showMessageBox(object, string, n, null);
    }

    private static void showMessageBox(Object object, String string, int n, String string2) {
        if (_parent == null) {
            JFrame jFrame = new JFrame(COMPANY);
            jFrame.setIconImage(JideIconsFactory.getImageIcon("jide/jide32.png").getImage());
            jFrame.setLocation(0, Integer.MAX_VALUE);
            jFrame.pack();
            jFrame.setVisible(true);
            PortingUtils.notifyUser();
            jFrame.toFront();
            MessageDialog messageDialog = new MessageDialog(jFrame, string, object.toString(), n, string2);
            messageDialog.display(false);
            jFrame.setVisible(false);
            jFrame.dispose();
        } else {
            MessageDialog messageDialog = new MessageDialog(_parent, string, object.toString(), n, string2);
            messageDialog.display(false);
        }
    }

    public static void showPopupMessageBox(String string) {
        PopupWindow popupWindow = new PopupWindow(_parent);
        JLabel jLabel = new JLabel();
        jLabel.setBackground(UIDefaultsLookup.getColor("ContentContainer.background"));
        jLabel.setForeground(Color.black);
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jLabel.setText(string);
        popupWindow.add(jLabel);
        popupWindow.show(_parent, 100, 200);
    }

    private static void showVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JIDE Version: ").append(PRODUCT_VERSION);
        stringBuffer.append("<BR>");
        stringBuffer.append("JDK Version: ").append(SystemInfo.getJavaVersion());
        stringBuffer.append("<BR>");
        stringBuffer.append("JDK Vendor: ").append(SystemInfo.getJavaVendor());
        stringBuffer.append("<BR>");
        stringBuffer.append("Java Class Version: ").append(SystemInfo.getJavaClassVersion());
        stringBuffer.append("<BR>");
        stringBuffer.append("Platform: ").append(SystemInfo.getOS());
        stringBuffer.append("<BR>");
        stringBuffer.append("Platform Version: ").append(SystemInfo.getOSVersion());
        stringBuffer.append("<BR>");
        stringBuffer.append("Platform Architecture: ").append(SystemInfo.getOSArchitecture());
        stringBuffer.append("<BR>");
        String string = stringBuffer.toString();
        string = string.replaceAll("<BR>", "\n");
        System.out.println(string);
        Lm.showMessageBox("<HTML>" + stringBuffer + "</HTML>", "JIDE Products - System Information", -1);
    }

    public static void main(String[] stringArray) {
        Lm.showVersion();
    }

    public static void getUIError(String string) {
        Lm.showMessageBox("<HTML><B>Missing value in LookAndFeel's UIDefaults</B>. <BR><BR><HR><BR>Component \"<B>" + string + "</B>\" requires its own ComponentUI and additional values in LookAndFeel's UIDefaults.<BR>Please make sure you call LookAndFeelFactory.installJideExtension() whenever you switch L&F.<BR>For more details, please refer to Developer Guides or visit JIDE Developer's Forum (http://www.jidesoft.com/forum).\n", "LookAndFeel Error", -1, "  Exit  ");
        System.exit(-1);
    }

    static {
        expireDate = Calendar.getInstance();
        expireDate.set(2021, 11, 1, 0, 0, 0);
        _showProducts = 0;
        _showCommon = false;
        _productsPurchased = 0;
        _companyName = null;
        _projectName = null;
        PRODUCTS = new String[]{PRODUCT_DOCKING_S, PRODUCT_COMPONENT_S, PRODUCT_GRID_S, PRODUCT_DIALOG_S, PRODUCT_ACTION_S, PRODUCT_SHORTCUT_S, PRODUCT_PIVOT_S, PRODUCT_CODE_EDITOR_S, PRODUCT_FEEDREADER_S, PRODUCT_DASHBOARD_S, PRODUCT_DATAGRIDS_S, PRODUCT_CHART_S, PRODUCT_GANTT_S, PRODUCT_DIFF_S, PRODUCT_TREEMAP_S, PRODUCT_JDAF_S};
        e = new BigInteger("19", 10);
        n = new BigInteger("305508269643653255827856366547026610628423058227532461973", 10);
    }

    private static class CancelableDialog
    extends JDialog {
        private boolean _result = false;
        private CancelAction _cancelAction = new CancelAction(this);

        public CancelableDialog() throws HeadlessException {
            this((Frame)null, "", true);
        }

        public CancelableDialog(Frame frame) throws HeadlessException {
            this(frame, "", true);
        }

        public CancelableDialog(Frame frame, String string) throws HeadlessException {
            this(frame, string, true);
        }

        public CancelableDialog(Frame frame, boolean bl) throws HeadlessException {
            this(frame, "", bl);
        }

        public CancelableDialog(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
            this.getRootPane().registerKeyboardAction(this._cancelAction, KeyStroke.getKeyStroke(27, 0), 1);
        }

        public final boolean getResult() {
            return this._result;
        }

        public final void setResult(boolean bl) {
            this._result = bl;
        }

        public void display(boolean bl) {
            this.setDefaultEnabled(this.getRootPane());
            this.pack();
            this.setResizable(bl);
            JideSwingUtilities.globalCenterWindow(this);
            this.setVisible(true);
        }

        private void setDefaultEnabled(Component component) {
            if (component instanceof JButton) {
                component.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        this.getRootPane().setDefaultButton((JButton)focusEvent.getSource());
                    }
                });
            }
            Component[] componentArray = null;
            if (component instanceof JMenu) {
                componentArray = ((JMenu)component).getMenuComponents();
            } else if (component instanceof Container) {
                componentArray = ((Container)component).getComponents();
            }
            if (componentArray != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    this.setDefaultEnabled(componentArray[i]);
                }
            }
        }

        public void display() {
            this.display(false);
        }

        public AbstractAction getDefaultCancelAction() {
            return this._cancelAction;
        }

        private class CancelAction
        extends AbstractAction {
            private JDialog _dlg;

            protected CancelAction(JDialog jDialog) {
                super("Close");
                this._dlg = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CancelableDialog.this._result = false;
                this._dlg.setVisible(false);
            }
        }
    }

    private static class MessageDialog
    extends CancelableDialog {
        private String _message;
        private int _messageType;
        private String _buttonText;

        public MessageDialog(Frame frame, String string, String string2) throws HeadlessException {
            this(frame, string, string2, -1, null);
        }

        public MessageDialog(Frame frame, String string, String string2, int n) throws HeadlessException {
            this(frame, string, string2, n, null);
        }

        public MessageDialog(Frame frame, String string, String string2, int n, String string3) throws HeadlessException {
            super(frame, string, true);
            this._message = string2;
            this._messageType = n;
            this._buttonText = string3;
            this.initComponents();
        }

        private void initComponents() {
            JLabel jLabel;
            JPanel jPanel = new JPanel(new BorderLayout(6, 6));
            JButton jButton = new JButton(this.getDefaultCancelAction());
            this.getRootPane().setDefaultButton(jButton);
            if (this._buttonText != null) {
                jButton.setText(this._buttonText);
            }
            jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JLabel jLabel2 = new JLabel(this._message);
            JPanel jPanel2 = new JPanel(new BorderLayout(12, 12));
            switch (this._messageType) {
                case 2: {
                    jLabel = new JLabel(UIDefaultsLookup.getIcon("OptionPane.warningIcon"));
                    break;
                }
                case 0: {
                    jLabel = new JLabel(UIDefaultsLookup.getIcon("OptionPane.errorIcon"));
                    break;
                }
                case 1: {
                    jLabel = new JLabel(UIDefaultsLookup.getIcon("OptionPane.informationIcon"));
                    break;
                }
                case 3: {
                    jLabel = new JLabel(UIDefaultsLookup.getIcon("OptionPane.questionIcon"));
                    break;
                }
                default: {
                    jLabel = new JLabel(JideIconsFactory.getImageIcon("jide/jide_logo.png"));
                }
            }
            jPanel2.add((Component)JideSwingUtilities.createTopPanel(jLabel), "Before");
            jPanel2.add((Component)jLabel2, "Center");
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)JideSwingUtilities.createCenterPanel(jButton), "Last");
            this.getContentPane().add(jPanel);
        }
    }
}

