/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.swing.JideSwingUtilities;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static TreePath[] saveSelection(JTree jTree) {
        return jTree.getSelectionPaths();
    }

    public static void loadSelection(JTree jTree, TreePath[] treePathArray) {
        if (treePathArray != null && treePathArray.length > 0) {
            jTree.setSelectionPaths(treePathArray);
            jTree.scrollPathToVisible(treePathArray[0]);
        }
    }

    public static Enumeration<TreePath> saveExpansionStateByTreePath(JTree jTree) {
        return jTree.getExpandedDescendants(new TreePath(jTree.getModel().getRoot()));
    }

    public static void loadExpansionStateByTreePath(JTree jTree, Enumeration<TreePath> enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = enumeration.nextElement();
                jTree.expandPath(treePath);
            }
        }
    }

    public static boolean isDescendant(TreePath treePath, TreePath treePath2) {
        int n;
        int n2 = treePath.getPathCount();
        if (n2 <= (n = treePath2.getPathCount())) {
            return false;
        }
        while (n2 != n) {
            treePath = treePath.getParentPath();
            --n2;
        }
        return treePath.equals(treePath2);
    }

    public static String saveExpansionState(JTree jTree, int n) {
        TreePath treePath = jTree.getPathForRow(n);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = jTree.getRowCount();
        for (int i = n; i < n2; ++i) {
            TreePath treePath2 = jTree.getPathForRow(i);
            if (i != n && !TreeUtils.isDescendant(treePath2, treePath)) break;
            if (!jTree.isExpanded(treePath2)) continue;
            stringBuffer.append(",").append(String.valueOf(i - n));
        }
        return stringBuffer.toString();
    }

    public static void loadExpansionState(JTree jTree, int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = n + Integer.parseInt(stringTokenizer.nextToken());
            jTree.expandRow(n2);
        }
    }

    public static void expandAll(JTree jTree) {
        TreeModel treeModel = jTree.getModel();
        for (int i = 0; i < treeModel.getChildCount(treeModel.getRoot()); ++i) {
            jTree.expandPath(new TreePath(new Object[]{treeModel.getRoot(), treeModel.getChild(treeModel.getRoot(), i)}));
        }
    }

    public static void expandAll(JTree jTree, boolean bl) {
        Object object = jTree.getModel().getRoot();
        TreeUtils.expandAll(jTree, new TreePath(object), bl);
    }

    public static void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        Object object = treePath.getLastPathComponent();
        if (jTree.getModel().getChildCount(object) >= 0) {
            for (int i = 0; i < jTree.getModel().getChildCount(object); ++i) {
                Object object2 = jTree.getModel().getChild(object, i);
                TreePath treePath2 = treePath.pathByAddingChild(object2);
                TreeUtils.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public static Object findTreeNode(JTree jTree, Object object) {
        Object object2 = jTree.getModel().getRoot();
        return TreeUtils.findTreeNode(jTree, new TreePath(object2), object);
    }

    public static Object findTreeNode(JTree jTree, TreePath treePath, Object object) {
        Object object2 = treePath.getLastPathComponent();
        if (object2 instanceof DefaultMutableTreeNode && JideSwingUtilities.equals(object, ((DefaultMutableTreeNode)object2).getUserObject())) {
            return object2;
        }
        if (jTree.getModel().getChildCount(object2) >= 0) {
            for (int i = 0; i < jTree.getModel().getChildCount(object2); ++i) {
                Object object3 = jTree.getModel().getChild(object2, i);
                TreePath treePath2 = treePath.pathByAddingChild(object3);
                Object object4 = TreeUtils.findTreeNode(jTree, treePath2, object);
                if (object4 == null) continue;
                return object4;
            }
        }
        return null;
    }

    public static int getLeafCount(TreeModel treeModel) {
        return TreeUtils.countLeafNodes(treeModel, treeModel.getRoot());
    }

    public static int getLeafCount(TreeModel treeModel, Object object) {
        return TreeUtils.countLeafNodes(treeModel, object);
    }

    private static int countLeafNodes(TreeModel treeModel, Object object) {
        if (treeModel.isLeaf(object)) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < treeModel.getChildCount(object); ++i) {
            n += TreeUtils.countLeafNodes(treeModel, treeModel.getChild(object, i));
        }
        return n;
    }
}

