/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.RegexFilter;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.ShrinkSearchableSupport;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.TreeSearchable;
import com.jidesoft.tree.FilterableTreeModel;
import com.jidesoft.tree.TreeUtils;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeShrinkSearchableSupport
extends ShrinkSearchableSupport {
    private FilterableTreeModel _filterableTreeModel;

    public TreeShrinkSearchableSupport(Searchable searchable) {
        super(searchable);
        if (this._searchable == null || !(this._searchable instanceof TreeSearchable)) {
            throw new IllegalArgumentException("The searchable instance should be TreeSearchable for TreeShrinkSearchableSupport");
        }
    }

    @Override
    protected boolean needReinstallFilterableModel(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getSource() == this._searchable.getComponent() && this._filterableTreeModel != null && propertyChangeEvent.getNewValue() != this._filterableTreeModel;
    }

    @Override
    public void installFilterableModel() {
        if (this._searchable.getComponent() instanceof JTree) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this._filterableTreeModel = this.createFilterableTreeModel(((JTree)this._searchable.getComponent()).getModel());
            this._searchable.getComponent().removePropertyChangeListener("model", this);
            ((JTree)this._searchable.getComponent()).setModel(this._filterableTreeModel);
            this._searchable.getComponent().addPropertyChangeListener("model", this);
        }
    }

    protected FilterableTreeModel createFilterableTreeModel(TreeModel treeModel) {
        FilterableTreeModel filterableTreeModel = new FilterableTreeModel(treeModel);
        filterableTreeModel.setHideEmptyParentNode(true);
        filterableTreeModel.setMatchesLeafNodeOnly(true);
        return filterableTreeModel;
    }

    @Override
    public void uninstallFilterableModel() {
        this._searchable.getComponent().removePropertyChangeListener("model", this);
        if (this._filterableTreeModel != null) {
            this._searchable.removeSearchableListener(this);
            ((JTree)this._searchable.getComponent()).setModel(this._filterableTreeModel.getActualModel());
            this._filterableTreeModel = null;
        }
    }

    @Override
    protected void applyFilter(String string) {
        Enumeration<TreePath> enumeration = null;
        TreePath[] treePathArray = null;
        if (this._searchable.getComponent() instanceof JTree) {
            enumeration = TreeUtils.saveExpansionStateByTreePath((JTree)this._searchable.getComponent());
            treePathArray = TreeUtils.saveSelection((JTree)this._searchable.getComponent());
        }
        this._filterableTreeModel.clearFilters();
        if (string != null && string.length() > 0) {
            Object object;
            if (this._searchable.isWildcardEnabled() && (object = this._searchable.getWildcardSupport()) != null) {
                string = object.convert(string);
            }
            object = new WildcardFilter(string){
                private static final long serialVersionUID = -8657334053362079212L;

                @Override
                protected String convertElementToString(Object object) {
                    Object object2 = this.getObjectGrouper() == null ? object : this.getObjectGrouper().getValue(object);
                    String string = TreeShrinkSearchableSupport.this.convertElementToString(object2);
                    if (string == null) {
                        string = super.convertElementToString(object);
                    }
                    return string != null ? string : ObjectConverterManager.toString(object2);
                }

                @Override
                protected Pattern createRegexPattern() {
                    return Pattern.compile(this.isBeginWith() ? "^" + this.getPattern() : this.getPattern(), this.isCaseSensitive() ? 0 : 2);
                }
            };
            ((RegexFilter)object).setBeginWith(this._searchable.isFromStart());
            ((RegexFilter)object).setEndWith(false);
            this._filterableTreeModel.addFilter((Filter)object);
        }
        this._filterableTreeModel.setFiltersApplied(true);
        if (this._searchable.getComponent() instanceof JTree) {
            if (enumeration != null) {
                TreeUtils.loadExpansionStateByTreePath((JTree)this._searchable.getComponent(), enumeration);
            }
            if (treePathArray != null) {
                TreeUtils.loadSelection((JTree)this._searchable.getComponent(), treePathArray);
            }
        }
        TreeUtils.expandAll((JTree)this._searchable.getComponent(), true);
    }

    @Override
    protected int getActualIndexAt(int n) {
        return n;
    }

    @Override
    protected int getVisualIndexAt(int n) {
        return n;
    }

    @Override
    protected boolean isRestoreSelection(int n, int n2) {
        return false;
    }
}

