/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.list.SortableListModel;
import com.jidesoft.tree.DefaultTreeModelWrapper;
import javax.swing.ListModel;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SortableTreeModel
extends DefaultTreeModelWrapper {
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = -1;
    public static final int UNSORTED = 0;
    private int _sortOrder = 0;

    public SortableTreeModel() {
    }

    public SortableTreeModel(TreeModel treeModel) {
        super(treeModel);
    }

    @Override
    protected ListModelWrapper createListModelWrapper(Object object) {
        SortableListModel sortableListModel = new SortableListModel();
        sortableListModel.setOptimized(false);
        return sortableListModel;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (this.getSortOrder() == 0) {
            super.treeNodesChanged(treeModelEvent);
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            ListModelWrapper listModelWrapper = this.getListModelWrapper(treePath.getLastPathComponent());
            if (listModelWrapper != null) {
                ListModel listModel = ListModelWrapperUtils.getActualListModel(listModelWrapper.getActualModel());
                int[] nArray = treeModelEvent.getChildIndices();
                if (listModel instanceof DefaultTreeModelWrapper.TreeModelListModel && nArray != null && nArray.length >= 1) {
                    int n;
                    int[] nArray2 = new int[nArray.length];
                    for (n = 0; n < nArray.length; ++n) {
                        nArray2[n] = ListModelWrapperUtils.getIndexAt((ListModel)((Object)listModelWrapper), listModel, nArray[n]);
                    }
                    ((DefaultTreeModelWrapper.TreeModelListModel)listModel).fireContentsChanged(listModel, nArray[0], nArray[nArray.length - 1]);
                    n = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray2[i] == ListModelWrapperUtils.getIndexAt((ListModel)((Object)listModelWrapper), listModel, nArray[i])) continue;
                        n = 1;
                        break;
                    }
                    if (this.shouldOptimize(treeModelEvent) || n == 0) {
                        TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 2);
                        this.fireTreeNodesChanged(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
                    } else {
                        this.fireTreeStructureChanged(this, treePath);
                    }
                    return;
                }
            }
            super.treeNodesChanged(treeModelEvent);
        }
    }

    @Override
    protected TreeModelEvent convertTreeModelEvent(TreeModelEvent treeModelEvent, int n) {
        if (n == 2) {
            TreePath treePath = treeModelEvent.getTreePath();
            int n2 = this.getChildCount(treePath.getLastPathComponent());
            int[] nArray = new int[n2];
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = i;
                objectArray[i] = this.getChild(treePath.getLastPathComponent(), i);
            }
            return new TreeModelEvent((Object)this, treeModelEvent.getPath(), nArray, objectArray);
        }
        return super.convertTreeModelEvent(treeModelEvent, n);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (this.getSortOrder() == 0) {
            super.treeNodesInserted(treeModelEvent);
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            ListModelWrapper listModelWrapper = this.getListModelWrapper(treePath.getLastPathComponent());
            if (listModelWrapper != null) {
                ListModel listModel = ListModelWrapperUtils.getActualListModel(listModelWrapper.getActualModel());
                int[] nArray = treeModelEvent.getChildIndices();
                if (listModel instanceof DefaultTreeModelWrapper.TreeModelListModel && nArray != null && nArray.length >= 1 && this.shouldOptimize(treeModelEvent)) {
                    ((DefaultTreeModelWrapper.TreeModelListModel)listModel).fireIntervalAdded(listModel, nArray[0], nArray[nArray.length - 1]);
                    TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 0);
                    this.fireTreeNodesInserted(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
                    return;
                }
            }
            super.treeNodesInserted(treeModelEvent);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (this.getSortOrder() == 0) {
            super.treeNodesRemoved(treeModelEvent);
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 1);
            ListModelWrapper listModelWrapper = this.getListModelWrapper(treePath.getLastPathComponent());
            if (listModelWrapper != null) {
                ListModel listModel = ListModelWrapperUtils.getActualListModel(listModelWrapper.getActualModel());
                int[] nArray = treeModelEvent.getChildIndices();
                if (listModel instanceof DefaultTreeModelWrapper.TreeModelListModel && nArray != null && nArray.length >= 1 && this.shouldOptimize(treeModelEvent)) {
                    ((DefaultTreeModelWrapper.TreeModelListModel)listModel).fireIntervalRemoved(listModel, nArray[0], nArray[nArray.length - 1]);
                    this.fireTreeNodesRemoved(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
                    return;
                }
            }
            super.treeNodesRemoved(treeModelEvent);
        }
    }

    protected boolean shouldOptimize(TreeModelEvent treeModelEvent) {
        return treeModelEvent.getChildIndices().length == 1 && treeModelEvent.getChildren().length == 1 && treeModelEvent.getChildren()[0] instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)treeModelEvent.getChildren()[0]).isLeaf();
    }

    @Override
    protected void configureListModelWrapper(ListModelWrapper listModelWrapper, Object object) {
        if (listModelWrapper instanceof SortableListModel) {
            ((SortableListModel)listModelWrapper).setSortOrder(this._sortOrder);
        }
    }

    public int getSortOrder() {
        return this._sortOrder;
    }

    public void setSortOrder(int n) {
        this._sortOrder = n;
        this.clearAllListModelWrappers();
        this.fireTreeStructureChanged(this, new TreePath(this.getRoot()));
    }

    public void sort(int n) {
        this.setSortOrder(n);
    }

    public void sort() {
        this.setSortOrder(1);
    }

    public void unsort() {
        this.setSortOrder(0);
    }
}

