/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.tree.AbstractTreeModel;
import com.jidesoft.tree.TreeModelWrapper;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeModelWrapper
extends AbstractTreeModel
implements TreeModelWrapper,
TreeModelListener {
    private TreeModel _model;
    private Map<Object, ListModelWrapper> _listModelWrappers = new Hashtable<Object, ListModelWrapper>();
    public static final int EVENT_TYPE_STRUCTURE_CHANGED = -1;
    public static final int EVENT_TYPE_NODES_INSERTED = 0;
    public static final int EVENT_TYPE_NODES_REMOVED = 1;
    public static final int EVENT_TYPE_NODES_CHANGED = 2;

    public DefaultTreeModelWrapper() {
    }

    public DefaultTreeModelWrapper(TreeModel treeModel) {
        this.setActualModel(treeModel);
    }

    @Override
    public void setActualModel(TreeModel treeModel) {
        if (treeModel == null) {
            throw new IllegalArgumentException("model passed to DefaultTreeModelWrapper cannot be null");
        }
        this._model = treeModel;
        this._model.addTreeModelListener(this);
    }

    @Override
    public TreeModel getActualModel() {
        return this._model;
    }

    @Override
    public Object getRoot() {
        return this._model.getRoot();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        this.initWrapper(object);
        return this.getListModelWrapperNotNull(object).getIndexAt(this._model.getIndexOfChild(object, object2));
    }

    @Override
    public Object getChild(Object object, int n) {
        this.initWrapper(object);
        int n2 = this.getListModelWrapperNotNull(object).getActualIndexAt(n);
        if (n2 == -1) {
            return null;
        }
        return this._model.getChild(object, n2);
    }

    @Override
    public int getChildCount(Object object) {
        if (object == null) {
            return 0;
        }
        this.initWrapper(object);
        int[] nArray = this.getListModelWrapperNotNull(object).getIndexes();
        return nArray == null ? this._model.getChildCount(object) : nArray.length;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this._model.isLeaf(object);
    }

    ListModelWrapper getListModelWrapperNotNull(Object object) {
        ListModelWrapper listModelWrapper = this.getListModelWrapper(object);
        return listModelWrapper == null ? this.createListModelWrapper(object) : listModelWrapper;
    }

    protected ListModelWrapper getListModelWrapper(Object object) {
        return object != null ? this._listModelWrappers.get(object) : null;
    }

    protected void setListModelWrapper(Object object, ListModelWrapper listModelWrapper) {
        this._listModelWrappers.put(object, listModelWrapper);
    }

    protected void clearListModelWrapper(Object object) {
        this._listModelWrappers.remove(object);
    }

    protected void clearAllListModelWrappers() {
        this._listModelWrappers.clear();
    }

    private ListModelWrapper initListModelWrapper(Object object) {
        ListModelWrapper listModelWrapper = this.createListModelWrapper(object);
        TreeModelListModel treeModelListModel = new TreeModelListModel(object);
        listModelWrapper.setActualModel(treeModelListModel);
        this._listModelWrappers.put(object, listModelWrapper);
        return listModelWrapper;
    }

    protected void initWrapper(Object object) {
        if (object == null) {
            return;
        }
        ListModelWrapper listModelWrapper = this.getListModelWrapper(object);
        if (listModelWrapper == null) {
            listModelWrapper = this.initListModelWrapper(object);
            this.configureListModelWrapper(listModelWrapper, object);
        }
    }

    protected ListModelWrapper createListModelWrapper(Object object) {
        return new DefaultListModelWrapper();
    }

    protected void configureListModelWrapper(ListModelWrapper listModelWrapper, Object object) {
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        this._model.valueForPathChanged(treePath, object);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            this.clearListModelWrapper(treePath.getLastPathComponent());
            this.initWrapper(treePath.getLastPathComponent());
            TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 2);
            this.fireTreeNodesChanged(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            this.clearListModelWrapper(treePath.getLastPathComponent());
            this.initWrapper(treePath.getLastPathComponent());
            TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 0);
            this.fireTreeNodesInserted(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 1);
            this.clearListModelWrapper(treePath.getLastPathComponent());
            this.initWrapper(treePath.getLastPathComponent());
            this.fireTreeNodesRemoved(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.clearAllListModelWrappers();
        TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, -1);
        if (treeModelEvent2.getPath() == null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.fireTreeStructureChanged(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
        }
    }

    @Deprecated
    protected TreeModelEvent convertTreeModelEvent(TreeModelEvent treeModelEvent) {
        return this.convertTreeModelEvent(treeModelEvent, 2);
    }

    protected TreeModelEvent convertTreeModelEvent(TreeModelEvent treeModelEvent, int n) {
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray != null) {
                Object[] objectArray2;
                TreeMap<Integer, Object[]> treeMap = new TreeMap<Integer, Object[]>();
                for (int i = 0; i < objectArray.length; ++i) {
                    int n2;
                    objectArray2 = objectArray[i];
                    ListModelWrapper listModelWrapper = this.getListModelWrapper(treePath.getLastPathComponent());
                    if (listModelWrapper == null) {
                        listModelWrapper = this.initListModelWrapper(treePath.getLastPathComponent());
                        this.configureListModelWrapper(listModelWrapper, treePath.getLastPathComponent());
                    }
                    if ((n2 = listModelWrapper.getIndexAt(treeModelEvent.getChildIndices()[i])) == -1) continue;
                    treeMap.put(n2, objectArray2);
                }
                int[] nArray = new int[treeMap.size()];
                objectArray2 = new Object[treeMap.size()];
                int n3 = 0;
                for (Map.Entry entry : treeMap.entrySet()) {
                    nArray[n3] = (Integer)entry.getKey();
                    objectArray2[n3++] = entry.getValue();
                }
                return new TreeModelEvent((Object)this, treeModelEvent.getPath(), nArray, objectArray2);
            }
            return new TreeModelEvent((Object)this, treeModelEvent.getPath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren());
        }
        return treeModelEvent;
    }

    class TreeModelListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 7975945491961499886L;
        private Object _node;

        public TreeModelListModel(Object object) {
            this._node = object;
        }

        @Override
        public int getSize() {
            return DefaultTreeModelWrapper.this._model.getChildCount(this._node);
        }

        @Override
        public Object getElementAt(int n) {
            return DefaultTreeModelWrapper.this._model.getChild(this._node, n);
        }

        @Override
        public void fireIntervalAdded(Object object, int n, int n2) {
            super.fireIntervalAdded(object, n, n2);
        }

        @Override
        public void fireIntervalRemoved(Object object, int n, int n2) {
            super.fireIntervalRemoved(object, n, n2);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }
}

