/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shapes;

import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.tooltip.shapes.OvalBalloonShape;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

class BubbleBalloonShape
extends OvalBalloonShape {
    private Ellipse2D.Double _bubble1;
    private Ellipse2D.Double _bubble2;
    private Ellipse2D.Double _bubble3;
    private double _radium1 = 7.0;
    private double _radium2 = 12.0;
    private double _radium3 = 26.0;

    BubbleBalloonShape() {
    }

    @Override
    public Shape createOutline(Dimension dimension, Dimension dimension2) {
        if (this.outline == null) {
            if (this.ellipse == null) {
                this.ellipse = this.createEllipse2D(dimension2, dimension);
            }
            if (this._bubble1 == null || this._bubble2 == null || this._bubble3 == null) {
                this.createBubbles(dimension, dimension2);
            }
            Area area = new Area(this.ellipse);
            Area area2 = new Area(this._bubble1);
            Area area3 = new Area(this._bubble2);
            Area area4 = new Area(this._bubble3);
            area.add(area2);
            area.add(area3);
            area.add(area4);
            this.outline = area;
        }
        return this.outline;
    }

    private void createBubbles(Dimension dimension, Dimension dimension2) {
        double d = (double)dimension2.height / (double)dimension2.width;
        Point2D.Double double_ = this.getVertext(dimension, dimension2);
        Point2D.Double double_2 = this.getArmPoint(dimension, dimension2, this.angle - this.arrowAngle / 2);
        Point2D.Double double_3 = this.getArmPoint(dimension, dimension2, this.angle + this.arrowAngle / 2);
        double d2 = double_2.distance(double_3) / 2.0;
        double d3 = this._radium1 / (this._radium1 + this._radium2 + this._radium3 + d2);
        double d4 = (this._radium1 + this._radium2) / (this._radium1 + this._radium2 + this._radium3 + d2);
        double d5 = (this._radium1 + this._radium2 + this._radium3) / (this._radium1 + this._radium2 + this._radium3 + d2);
        double d6 = double_.x + d3 * (double_2.x - double_.x);
        double d7 = double_.y + d3 * (double_2.y - double_.y);
        Point2D.Double double_4 = new Point2D.Double(d6, d7);
        d6 = double_.x + d3 * (double_3.x - double_.x);
        d7 = double_.y + d3 * (double_3.y - double_.y);
        Point2D.Double double_5 = new Point2D.Double(d6, d7);
        d6 = (double_4.x + double_5.x) / 2.0;
        d7 = (double_4.y + double_5.y) / 2.0;
        Point2D.Double double_6 = new Point2D.Double(d6, d7);
        d6 = double_.x + d4 * (double_2.x - double_.x);
        d7 = double_.y + d4 * (double_2.y - double_.y);
        Point2D.Double double_7 = new Point2D.Double(d6, d7);
        d6 = double_.x + d4 * (double_3.x - double_.x);
        d7 = double_.y + d4 * (double_3.y - double_.y);
        Point2D.Double double_8 = new Point2D.Double(d6, d7);
        d6 = (double_7.x + double_8.x) / 2.0;
        d7 = (double_7.y + double_8.y) / 2.0;
        Point2D.Double double_9 = new Point2D.Double(d6, d7);
        d6 = double_.x + d5 * (double_2.x - double_.x);
        d7 = double_.y + d5 * (double_2.y - double_.y);
        Point2D.Double double_10 = new Point2D.Double(d6, d7);
        d6 = double_.x + d5 * (double_3.x - double_.x);
        d7 = double_.y + d5 * (double_3.y - double_.y);
        Point2D.Double double_11 = new Point2D.Double(d6, d7);
        d6 = (double_10.x + double_11.x) / 2.0;
        d7 = (double_10.y + double_11.y) / 2.0;
        Point2D.Double double_12 = new Point2D.Double(d6, d7);
        double d8 = this._radium1;
        double d9 = d * this._radium1;
        double d10 = this._radium2;
        double d11 = d * this._radium2;
        double d12 = this._radium3;
        double d13 = d * this._radium3;
        this._bubble1 = new Ellipse2D.Double(double_6.x - d8, double_6.y - d9, 2.0 * d8, 2.0 * d9);
        this._bubble2 = new Ellipse2D.Double(double_9.x - d10, double_9.y - d11, 2.0 * d10, 2.0 * d11);
        this._bubble3 = new Ellipse2D.Double(double_12.x - d12, double_12.y - d13, 2.0 * d12, 2.0 * d13);
    }

    @Override
    public double getEdgeDistance(Point point, BalloonTip balloonTip) {
        Dimension dimension = balloonTip.getBalloonSize();
        Dimension dimension2 = balloonTip.getContentSize();
        if (this.ellipse == null) {
            this.ellipse = this.createEllipse2D(dimension2, dimension);
        }
        if (this._bubble1 == null || this._bubble2 == null || this._bubble3 == null) {
            this.createBubbles(dimension, dimension2);
        }
        if (this.ellipse.contains(point)) {
            return this.getEllipseEdgeDistance(this.ellipse, point);
        }
        if (this._bubble3.contains(point)) {
            return this.getEllipseEdgeDistance(this._bubble3, point);
        }
        if (this._bubble2.contains(point)) {
            return this.getEllipseEdgeDistance(this._bubble2, point);
        }
        if (this._bubble1.contains(point)) {
            return this.getEllipseEdgeDistance(this._bubble1, point);
        }
        return 0.0;
    }

    private double getEllipseEdgeDistance(Ellipse2D.Double double_, Point point) {
        double d = point.x;
        double d2 = point.y;
        double d3 = double_.x + double_.width / 2.0;
        double d4 = double_.y + double_.height / 2.0;
        double d5 = Math.sqrt((d -= d3) * d + (d2 -= d4) * d2);
        double d6 = double_.width / 2.0;
        double d7 = double_.height / 2.0;
        if ((int)d == 0) {
            if ((int)d2 == 0) {
                return -Math.max(d6, d7);
            }
            return d5 - d7;
        }
        if ((int)d2 == 0) {
            return d5 - d6;
        }
        double d8 = d2 / d;
        double d9 = d6 * d7 * Math.sqrt((d8 * d8 + 1.0) / (d6 * d6 * d8 * d8 + d7 * d7));
        return d5 - d9;
    }
}

