/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.navigation.NavigationTree;
import com.jidesoft.tooltip.ExpandedTip;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeExpandedTip
extends ExpandedTip<JTree> {
    private Handler _handler = new Handler();

    public TreeExpandedTip(JTree jTree) {
        super(jTree);
        ((JTree)this._component).getSelectionModel().addTreeSelectionListener(this._handler);
        if (((JTree)this._component).getModel() != null) {
            ((JTree)this._component).getModel().addTreeModelListener(this._handler);
        }
        ((JTree)this._component).addPropertyChangeListener("selectionModel", this._handler);
        ((JTree)this._component).addPropertyChangeListener("model", this._handler);
    }

    @Override
    public void uninstall() {
        super.uninstall();
        if (this._handler != null) {
            ((JTree)this._component).removePropertyChangeListener("model", this._handler);
            ((JTree)this._component).removePropertyChangeListener("selectionModel", this._handler);
            if (((JTree)this._component).getModel() != null) {
                ((JTree)this._component).getModel().removeTreeModelListener(this._handler);
            }
            ((JTree)this._component).getSelectionModel().removeTreeSelectionListener(this._handler);
        }
    }

    private void updateSelection(JTree jTree) {
        int n = jTree.getSelectionCount() == 1 ? jTree.getSelectionModel().getLeadSelectionRow() : -1;
        this.handleSelectionChange(n);
    }

    @Override
    protected int rowAtPoint(Point point) {
        return ((JTree)this._component).getRowForLocation(point.x, point.y);
    }

    @Override
    protected Rectangle getRowBounds(int n) {
        TreePath treePath = ((JTree)this._component).getPathForRow(n);
        if (treePath == null) {
            return null;
        }
        Rectangle rectangle = ((JTree)this._component).getPathBounds(treePath);
        if (rectangle == null) {
            return null;
        }
        return rectangle;
    }

    @Override
    protected void paintTipImage(Graphics2D graphics2D, Component component, Rectangle rectangle, int n, int n2) {
        boolean bl = false;
        if (component instanceof NavigationTree) {
            bl = ((NavigationTree)component).isWideSelection();
            ((NavigationTree)component).setWideSelection(false);
        }
        super.paintTipImage(graphics2D, component, rectangle, n, n2);
        if (component instanceof NavigationTree) {
            ((NavigationTree)component).setWideSelection(bl);
        }
    }

    private class Handler
    implements TreeSelectionListener,
    PropertyChangeListener,
    TreeModelListener {
        private Handler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeExpandedTip.this.updateSelection((JTree)TreeExpandedTip.this._component);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TreeExpandedTip.this.updateSelection((JTree)TreeExpandedTip.this._component);
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getOldValue() != null) {
                    ((TreeSelectionModel)propertyChangeEvent.getOldValue()).removeTreeSelectionListener(this);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    ((TreeSelectionModel)propertyChangeEvent.getNewValue()).addTreeSelectionListener(this);
                }
            }
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getOldValue() != null) {
                    ((TreeModel)propertyChangeEvent.getOldValue()).removeTreeModelListener(this);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    ((TreeModel)propertyChangeEvent.getNewValue()).addTreeModelListener(this);
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeExpandedTip.this.updateCurrentSelection();
                }
            });
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeExpandedTip.this.updateSelection((JTree)TreeExpandedTip.this._component);
                }
            });
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeExpandedTip.this.updateSelection((JTree)TreeExpandedTip.this._component);
                }
            });
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeExpandedTip.this.updateSelection((JTree)TreeExpandedTip.this._component);
                }
            });
        }
    }
}

