/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.tooltip.ExpandedTip;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableRowExpandedTip
extends ExpandedTip<JTable> {
    private Handler _handler = new Handler();
    private Timer _hideHeaderTipTimer;
    private boolean _showHeaderTip = true;

    public TableRowExpandedTip(JTable jTable) {
        super(jTable);
        ((JTable)this._component).getSelectionModel().addListSelectionListener(this._handler);
        ((JTable)this._component).getColumnModel().getSelectionModel().addListSelectionListener(this._handler);
        ((JTable)this._component).addPropertyChangeListener("selectionModel", this._handler);
        ((JTable)this._component).addPropertyChangeListener("columnModel", this._handler);
        if (((JTable)this._component).getModel() != null) {
            ((JTable)this._component).getModel().addTableModelListener(this._handler);
        }
        ((JTable)this._component).addPropertyChangeListener("model", this._handler);
    }

    @Override
    public void uninstall() {
        super.uninstall();
        if (this._handler != null) {
            ((JTable)this._component).removePropertyChangeListener("model", this._handler);
            if (((JTable)this._component).getModel() != null) {
                ((JTable)this._component).getModel().removeTableModelListener(this._handler);
            }
            ((JTable)this._component).removePropertyChangeListener("columnModel", this._handler);
            ((JTable)this._component).removePropertyChangeListener("selectionModel", this._handler);
            ((JTable)this._component).getColumnModel().getSelectionModel().removeListSelectionListener(this._handler);
            ((JTable)this._component).getSelectionModel().removeListSelectionListener(this._handler);
        }
    }

    private void updateSelection(JTable jTable) {
        int n = jTable.getSelectedRowCount() == 1 ? jTable.getSelectedRow() : -1;
        this.handleSelectionChange(n);
    }

    private Rectangle getCellRect(int n) {
        return ((JTable)this._component).getCellRect(n, 0, false).union(((JTable)this._component).getCellRect(n, ((JTable)this._component).getColumnCount() - 1, false));
    }

    @Override
    public Component getComponent(int n) {
        return this._component;
    }

    @Override
    public Rectangle getRowBounds(int n) {
        return this.getCellRect(n);
    }

    @Override
    public Rectangle getVisibleRect(int n) {
        return ((JTable)this._component).getVisibleRect();
    }

    @Override
    public int rowAtPoint(Point point) {
        return ((JTable)this._component).rowAtPoint(point);
    }

    @Override
    public void hideTip() {
        ExpandedTip expandedTip;
        super.hideTip();
        if (this.isShowHeaderTip() && (expandedTip = ExpandedTip.getExpandedTip(((JTable)this._component).getTableHeader())) != null) {
            if (this._hideHeaderTipTimer == null) {
                this._hideHeaderTipTimer = new Timer(300, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        expandedTip.hideTip();
                    }
                });
            }
            this._hideHeaderTipTimer.setRepeats(false);
            this._hideHeaderTipTimer.start();
        }
    }

    void stopHeaderTimer() {
        if (this._hideHeaderTipTimer != null && this._hideHeaderTipTimer.isRunning()) {
            this._hideHeaderTipTimer.stop();
        }
    }

    @Override
    public void showTip() {
        ExpandedTip expandedTip;
        super.showTip();
        if (this._hideHeaderTipTimer != null && this._hideHeaderTipTimer.isRunning()) {
            this._hideHeaderTipTimer.stop();
        }
        if ((expandedTip = ExpandedTip.getExpandedTip(((JTable)this._component).getTableHeader())) != null) {
            expandedTip.setIndex(0);
            expandedTip.showTip();
        }
    }

    public boolean isShowHeaderTip() {
        return this._showHeaderTip;
    }

    public void setShowHeaderTip(boolean bl) {
        this._showHeaderTip = bl;
    }

    private class Handler
    implements ListSelectionListener,
    PropertyChangeListener,
    TableModelListener {
        private Handler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            TableRowExpandedTip.this.updateSelection((JTable)TableRowExpandedTip.this._component);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableRowExpandedTip.this.updateSelection((JTable)TableRowExpandedTip.this._component);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getOldValue() != null) {
                    ((ListSelectionModel)propertyChangeEvent.getOldValue()).removeListSelectionListener(TableRowExpandedTip.this._handler);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    ((ListSelectionModel)propertyChangeEvent.getNewValue()).addListSelectionListener(TableRowExpandedTip.this._handler);
                }
            }
            if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getOldValue() != null) {
                    ((TableColumnModel)propertyChangeEvent.getOldValue()).getSelectionModel().removeListSelectionListener(TableRowExpandedTip.this._handler);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    ((TableColumnModel)propertyChangeEvent.getNewValue()).getSelectionModel().addListSelectionListener(TableRowExpandedTip.this._handler);
                }
            }
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                TableRowExpandedTip.this.updateSelection((JTable)TableRowExpandedTip.this._component);
                if (propertyChangeEvent.getOldValue() != null) {
                    ((TableModel)propertyChangeEvent.getOldValue()).removeTableModelListener(TableRowExpandedTip.this._handler);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    ((TableModel)propertyChangeEvent.getNewValue()).addTableModelListener(TableRowExpandedTip.this._handler);
                }
            }
        }
    }
}

