/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.tooltip.Balloon;
import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.tooltip.Shadow;
import com.jidesoft.tooltip.ShadowStyle;
import com.jidesoft.tooltip.shadows.LeftBottomBackward;
import com.jidesoft.tooltip.shapes.RoundedRectangularBalloonShape;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ToolTipUI;

public class BalloonTipUI
extends ToolTipUI {
    protected BalloonTip _balloonTip;
    private JPanel _layer;
    private Balloon _balloon;
    private Shadow _shadow;

    public BalloonTipUI(BalloonTip balloonTip) {
        this._balloonTip = balloonTip;
    }

    Dimension getShadowSize() {
        return this._shadow.getSize();
    }

    public Dimension getBalloonSize() {
        return this._balloon.getSize();
    }

    public Point getHotSpot() {
        Point point = this._balloonTip.getBalloonShape().getHotSpot(this.getBalloonPreferredSize());
        ShadowStyle shadowStyle = this._balloonTip.getShadowStyle();
        if (shadowStyle != null) {
            Dimension dimension = this._balloon.getPreferredSize();
            Dimension dimension2 = shadowStyle.getShadowSize(dimension);
            Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
            Rectangle rectangle2 = new Rectangle(0, 0, dimension2.width, dimension2.height);
            shadowStyle.layout(rectangle, rectangle2);
            point.x += rectangle.x;
            point.y += rectangle.y;
        }
        return point;
    }

    public Dimension getBalloonPreferredSize() {
        return this._balloon.getPreferredSize();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._balloonTip.setOpaque(false);
        this._balloonTip.setBorder(null);
        LookAndFeel.installColors(jComponent, "ToolTip.background", "ToolTip.foreground");
        this._balloonTip.setLayout(new BorderLayout());
        this._layer = new JPanel();
        this._layer.setOpaque(false);
        this._balloonTip.add((Component)this._layer, "Center");
        this._balloonTip.setBalloonShape(new RoundedRectangularBalloonShape());
        this._balloonTip.setShadowStyle(new LeftBottomBackward());
    }

    protected void setContent(Component component) {
        this._layer.removeAll();
        this._layer.setLayout(new BalloonShadowLayout());
        this._shadow = new Shadow(this._balloonTip);
        this._balloon = new Balloon(this._balloonTip);
        this._layer.add(this._balloon);
        this._layer.add(this._shadow);
        if (SystemInfo.isJdk15Above()) {
            this._layer.setComponentZOrder(this._balloon, 0);
            this._layer.setComponentZOrder(this._shadow, 1);
        }
        this._layer.invalidate();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this._layer.getPreferredSize();
    }

    class BalloonShadowLayout
    implements LayoutManager {
        BalloonShadowLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            ShadowStyle shadowStyle = BalloonTipUI.this._balloonTip.getShadowStyle();
            if (shadowStyle != null) {
                Dimension dimension = BalloonTipUI.this._balloon.getPreferredSize();
                Dimension dimension2 = shadowStyle.getShadowSize(dimension);
                Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                Rectangle rectangle2 = new Rectangle(0, 0, dimension2.width, dimension2.height);
                shadowStyle.layout(rectangle, rectangle2);
                Rectangle rectangle3 = new Rectangle();
                Rectangle2D.union(rectangle, rectangle2, rectangle3);
                return rectangle3.getSize();
            }
            return BalloonTipUI.this._balloon.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container container) {
            ShadowStyle shadowStyle = BalloonTipUI.this._balloonTip.getShadowStyle();
            if (shadowStyle != null) {
                Dimension dimension = BalloonTipUI.this._balloon.getPreferredSize();
                Dimension dimension2 = shadowStyle.getShadowSize(dimension);
                Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                Rectangle rectangle2 = new Rectangle(0, 0, dimension2.width, dimension2.height);
                shadowStyle.layout(rectangle, rectangle2);
                BalloonTipUI.this._balloon.setBounds(rectangle);
                BalloonTipUI.this._shadow.setBounds(rectangle2);
            } else {
                Dimension dimension = BalloonTipUI.this._balloon.getPreferredSize();
                Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                BalloonTipUI.this._balloon.setBounds(rectangle);
            }
        }
    }
}

