/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tipoftheday;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.tipoftheday.TipOfTheDayDialog;
import com.jidesoft.tipoftheday.TipOfTheDaySource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class TipOfTheDayDialogPane
extends StandardDialogPane {
    private TipOfTheDaySource _tipOfTheDaySource;
    private Component _htmlBrowser;
    private JCheckBox _showTipEditor;
    private boolean _showTooltip;
    private Action _showTipAction;
    private URL _optionalStyleSheet;
    private JButton _nextButton;
    private Action previousTipAction;
    private Action nextTipAction;
    private Action closeAction;

    public TipOfTheDayDialogPane() throws HeadlessException {
    }

    public TipOfTheDayDialogPane(TipOfTheDaySource tipOfTheDaySource, Action action, URL uRL) {
        this.init(tipOfTheDaySource, action, uRL);
    }

    void init(TipOfTheDaySource tipOfTheDaySource, Action action, URL uRL) {
        if (tipOfTheDaySource == null) {
            throw new IllegalArgumentException("tipOfTheDaySource cannot be null.");
        }
        this._tipOfTheDaySource = tipOfTheDaySource;
        this._showTipAction = action;
        this._optionalStyleSheet = uRL;
    }

    @Override
    public JComponent createBannerPanel() {
        JLabel jLabel = new JLabel(this.getResourceString("Label.didYouKnow"), IconsFactory.getImageIcon(TipOfTheDayDialog.class, "icons/tip.gif"), 2);
        jLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return jLabel;
    }

    @Override
    public JComponent createContentPanel() {
        this._htmlBrowser = this.createHtmlBrowser(this._optionalStyleSheet);
        if (this._showTipAction != null) {
            this._showTipEditor = new JCheckBox(this._showTipAction);
            this._showTipEditor.setSelected(this._showTooltip);
        } else {
            this._showTipEditor = null;
        }
        JComponent jComponent = this.createScrollPaneForHtmlBrowser(this._htmlBrowser);
        JPanel jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.add((Component)jComponent, "Center");
        if (this._showTipEditor != null) {
            jPanel.add((Component)this._showTipEditor, "Last");
        }
        this.nextTip();
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return jPanel;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton(this.getPreviousTipAction());
        jButton.setMnemonic(this.getResourceString("Button.back.mnemonic").charAt(0));
        jButton.setName("Button.back");
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        JButton jButton2 = new JButton(this.getNextTipAction());
        jButton2.setMnemonic(this.getResourceString("Button.next.mnemonic").charAt(0));
        jButton2.setName("Button.next");
        this._nextButton = jButton2;
        buttonPanel.addButton((AbstractButton)jButton2, "AFFIRMATIVE");
        JButton jButton3 = new JButton(this.getCloseAction());
        jButton3.setName("Button.close");
        buttonPanel.addButton((AbstractButton)jButton3, "CANCEL");
        this.setDefaultAction(this.getNextTipAction());
        this.setDefaultCancelAction(jButton3.getAction());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return buttonPanel;
    }

    protected Component createHtmlBrowser(URL uRL) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        if (uRL != null) {
            jEditorPane.setEditorKit(new StyledHTMLEditorKit(uRL));
        } else {
            jEditorPane.setEditorKit(new HTMLEditorKit());
        }
        return jEditorPane;
    }

    protected JComponent createScrollPaneForHtmlBrowser(Component component) {
        JScrollPane jScrollPane = new JScrollPane(component);
        jScrollPane.setPreferredSize(new Dimension(320, 160));
        return jScrollPane;
    }

    protected void displayHtmlBrowser(String string, String string2) {
        if (this._htmlBrowser instanceof JTextComponent) {
            ((JTextComponent)this._htmlBrowser).setText(string);
            ((JTextComponent)this._htmlBrowser).setCaretPosition(0);
        }
    }

    protected Action getPreviousTipAction() {
        return this.previousTipAction;
    }

    void setPreviousTipAction(AbstractAction abstractAction) {
        this.previousTipAction = abstractAction;
    }

    protected Action getNextTipAction() {
        return this.nextTipAction;
    }

    void setNextTipAction(AbstractAction abstractAction) {
        this.nextTipAction = abstractAction;
    }

    protected Action getCloseAction() {
        return this.closeAction;
    }

    void setCloseAction(AbstractAction abstractAction) {
        this.closeAction = abstractAction;
    }

    public void previousTip() {
        this.setTip(this._tipOfTheDaySource.getPreviousTip());
    }

    public void nextTip() {
        this.setTip(this._tipOfTheDaySource.getNextTip());
    }

    public int getCurrentTipIndex() {
        return this._tipOfTheDaySource.getCurrentTipIndex();
    }

    public void setCurrentTipIndex(int n) {
        this._tipOfTheDaySource.setCurrentTipIndex(n);
    }

    public TipOfTheDaySource getTipOfTheDaySource() {
        return this._tipOfTheDaySource;
    }

    private void setTip(String string) {
        if (string == null) {
            return;
        }
        this.displayHtmlBrowser(string, null);
    }

    public JCheckBox getShowTipCheckBox() {
        return this._showTipEditor;
    }

    public boolean isShowTooltip() {
        return this._showTooltip;
    }

    public void setShowTooltip(boolean bl) {
        this._showTooltip = bl;
    }

    JButton getNextButton() {
        return this._nextButton;
    }

    public String getResourceString(String string) {
        if (string != null && string.startsWith("Button")) {
            return ButtonResources.getResourceBundle(this.getLocale()).getString(string);
        }
        return ResourceBundle.getBundle("com.jidesoft.tipoftheday.TipOfTheDay", this.getLocale()).getString(string);
    }

    private static class StyledHTMLEditorKit
    extends HTMLEditorKit {
        private StyleSheet styleSheet = new StyleSheet();
        private static final long serialVersionUID = 8647049658703051557L;

        public StyledHTMLEditorKit(URL uRL) {
            this.styleSheet.addStyleSheet(super.getStyleSheet());
            this.styleSheet.importStyleSheet(uRL);
        }

        @Override
        public StyleSheet getStyleSheet() {
            return this.styleSheet;
        }

        @Override
        public void setStyleSheet(StyleSheet styleSheet) {
            this.styleSheet = styleSheet;
        }
    }
}

