/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.util;

import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;

public class UniqueRowIterator
extends IntIterator {
    private IntIterator m_iter;
    private int m_next;
    private BitSet m_visited;

    public UniqueRowIterator(IntIterator intIterator) {
        this.m_iter = intIterator;
        this.m_visited = new BitSet();
        this.advance();
    }

    private void advance() {
        int n = -1;
        while (n == -1 && this.m_iter.hasNext()) {
            n = this.m_iter.nextInt();
            if (!this.visit(n)) continue;
            n = -1;
        }
        this.m_next = n;
    }

    private boolean visit(int n) {
        if (this.m_visited.get(n)) {
            return true;
        }
        this.m_visited.set(n);
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.m_next != -1;
    }

    @Override
    public int nextInt() {
        if (this.m_next == -1) {
            throw new NoSuchElementException();
        }
        int n = this.m_next;
        this.advance();
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

