/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.tuple;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import java.util.Date;

public class TableTuple
implements Tuple {
    protected Table m_table;
    protected int m_row;

    protected void init(Table table, int n) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(n) ? n : -1;
    }

    @Override
    public Schema getSchema() {
        return this.m_table.getSchema();
    }

    @Override
    public Table getTable() {
        return this.m_table;
    }

    @Override
    public int getRow() {
        return this.m_row;
    }

    @Override
    public boolean isValid() {
        return this.m_row != -1;
    }

    void invalidate() {
        this.m_row = -1;
    }

    private void validityCheck() {
        if (this.m_row == -1) {
            throw new IllegalStateException("This tuple is no longer valid. It has been deleted from its table");
        }
    }

    @Override
    public Class getColumnType(String string) {
        return this.m_table.getColumnType(string);
    }

    @Override
    public Class getColumnType(int n) {
        return this.m_table.getColumnType(n);
    }

    @Override
    public int getColumnIndex(String string) {
        return this.m_table.getColumnNumber(string);
    }

    @Override
    public int getColumnCount() {
        return this.m_table.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.m_table.getColumnName(n);
    }

    @Override
    public boolean canGet(String string, Class clazz) {
        return this.m_table.canGet(string, clazz);
    }

    @Override
    public boolean canSet(String string, Class clazz) {
        return this.m_table.canSet(string, clazz);
    }

    @Override
    public final Object get(String string) {
        this.validityCheck();
        return this.m_table.get(this.m_row, string);
    }

    @Override
    public final void set(String string, Object object) {
        this.validityCheck();
        this.m_table.set(this.m_row, string, object);
    }

    @Override
    public final Object getValueAt(int n) {
        this.validityCheck();
        return this.m_table.getValueAt(this.m_row, n);
    }

    @Override
    public final void setValueAt(int n, Object object) {
        this.validityCheck();
        this.m_table.setValueAt(this.m_row, n, object);
    }

    @Override
    public Object getDefault(String string) {
        this.validityCheck();
        return this.m_table.getDefault(string);
    }

    @Override
    public void revertToDefault(String string) {
        this.validityCheck();
        this.m_table.revertToDefault(this.m_row, string);
    }

    @Override
    public final boolean canGetInt(String string) {
        return this.m_table.canGetInt(string);
    }

    @Override
    public final boolean canSetInt(String string) {
        return this.m_table.canSetInt(string);
    }

    @Override
    public final int getInt(String string) {
        this.validityCheck();
        return this.m_table.getInt(this.m_row, string);
    }

    @Override
    public final void setInt(String string, int n) {
        this.validityCheck();
        this.m_table.setInt(this.m_row, string, n);
    }

    @Override
    public final boolean canGetLong(String string) {
        return this.m_table.canGetLong(string);
    }

    @Override
    public final boolean canSetLong(String string) {
        return this.m_table.canSetLong(string);
    }

    @Override
    public final long getLong(String string) {
        this.validityCheck();
        return this.m_table.getLong(this.m_row, string);
    }

    @Override
    public final void setLong(String string, long l) {
        this.validityCheck();
        this.m_table.setLong(this.m_row, string, l);
    }

    @Override
    public final boolean canGetFloat(String string) {
        return this.m_table.canGetFloat(string);
    }

    @Override
    public final boolean canSetFloat(String string) {
        return this.m_table.canSetFloat(string);
    }

    @Override
    public final float getFloat(String string) {
        this.validityCheck();
        return this.m_table.getFloat(this.m_row, string);
    }

    @Override
    public final void setFloat(String string, float f) {
        this.validityCheck();
        this.m_table.setFloat(this.m_row, string, f);
    }

    @Override
    public final boolean canGetDouble(String string) {
        return this.m_table.canGetDouble(string);
    }

    @Override
    public final boolean canSetDouble(String string) {
        return this.m_table.canSetDouble(string);
    }

    @Override
    public final double getDouble(String string) {
        this.validityCheck();
        return this.m_table.getDouble(this.m_row, string);
    }

    @Override
    public final void setDouble(String string, double d) {
        this.validityCheck();
        this.m_table.setDouble(this.m_row, string, d);
    }

    @Override
    public final boolean canGetBoolean(String string) {
        return this.m_table.canGetBoolean(string);
    }

    @Override
    public final boolean canSetBoolean(String string) {
        return this.m_table.canSetBoolean(string);
    }

    @Override
    public final boolean getBoolean(String string) {
        this.validityCheck();
        return this.m_table.getBoolean(this.m_row, string);
    }

    @Override
    public final void setBoolean(String string, boolean bl) {
        this.validityCheck();
        this.m_table.setBoolean(this.m_row, string, bl);
    }

    @Override
    public final boolean canGetString(String string) {
        return this.m_table.canGetString(string);
    }

    @Override
    public final boolean canSetString(String string) {
        return this.m_table.canSetString(string);
    }

    @Override
    public final String getString(String string) {
        this.validityCheck();
        return this.m_table.getString(this.m_row, string);
    }

    @Override
    public final void setString(String string, String string2) {
        this.validityCheck();
        this.m_table.setString(this.m_row, string, string2);
    }

    @Override
    public final boolean canGetDate(String string) {
        return this.m_table.canGetDate(string);
    }

    @Override
    public final boolean canSetDate(String string) {
        return this.m_table.canSetDate(string);
    }

    @Override
    public final Date getDate(String string) {
        this.validityCheck();
        return this.m_table.getDate(this.m_row, string);
    }

    @Override
    public final void setDate(String string, Date date) {
        this.validityCheck();
        this.m_table.setDate(this.m_row, string, date);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tuple[");
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            try {
                stringBuffer.append(this.getValueAt(i).toString());
                continue;
            }
            catch (Exception exception) {
                stringBuffer.append("?");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

