/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.parser;

import com.jidesoft.thirdparty.prefuse.data.parser.BooleanParser;
import com.jidesoft.thirdparty.prefuse.data.parser.DataParser;
import com.jidesoft.thirdparty.prefuse.data.parser.DateParser;
import com.jidesoft.thirdparty.prefuse.data.parser.DateTimeParser;
import com.jidesoft.thirdparty.prefuse.data.parser.DoubleParser;
import com.jidesoft.thirdparty.prefuse.data.parser.FloatParser;
import com.jidesoft.thirdparty.prefuse.data.parser.IntArrayParser;
import com.jidesoft.thirdparty.prefuse.data.parser.IntParser;
import com.jidesoft.thirdparty.prefuse.data.parser.LongParser;
import com.jidesoft.thirdparty.prefuse.data.parser.StringParser;
import com.jidesoft.thirdparty.prefuse.data.parser.TimeParser;
import java.util.Arrays;

public class ParserFactory
implements Cloneable {
    private static final DataParser[] DEFAULT_PARSERS = new DataParser[]{new IntParser(), new LongParser(), new DoubleParser(), new FloatParser(), new BooleanParser(), new DateParser(), new TimeParser(), new DateTimeParser(), new IntArrayParser(), new StringParser()};
    private static final ParserFactory DEFAULT_FACTORY = new ParserFactory(DEFAULT_PARSERS);
    private DataParser[] m_parsers;
    private boolean[] m_isCandidate;

    public static ParserFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public ParserFactory() {
        this(DEFAULT_PARSERS);
    }

    public Object clone() {
        return new ParserFactory(this.m_parsers);
    }

    public ParserFactory(DataParser[] dataParserArray) {
        for (int i = 0; i < dataParserArray.length; ++i) {
            if (dataParserArray[i] != null) continue;
            throw new IllegalArgumentException("Input parsers must be non-null");
        }
        this.m_parsers = dataParserArray;
        this.m_isCandidate = new boolean[this.m_parsers.length];
        this.reset();
    }

    protected void reset() {
        Arrays.fill(this.m_isCandidate, true);
    }

    protected void sample(String string) {
        for (int i = 0; i < this.m_parsers.length; ++i) {
            if (!this.m_isCandidate[i]) continue;
            this.m_isCandidate[i] = this.m_parsers[i].canParse(string);
        }
    }

    protected DataParser getParser() {
        for (int i = 0; i < this.m_parsers.length; ++i) {
            if (!this.m_isCandidate[i]) continue;
            return this.m_parsers[i];
        }
        return null;
    }

    public DataParser getParser(Class clazz) {
        for (int i = 0; i < this.m_parsers.length; ++i) {
            if (!this.m_parsers[i].getType().equals(clazz)) continue;
            return this.m_parsers[i];
        }
        return null;
    }

    public DataParser getParser(String[] stringArray, int n) {
        return this.getParser(new String[][]{stringArray}, 0, n);
    }

    public DataParser getParser(String[][] stringArray, int n, int n2) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n3 = stringArray.length;
        this.reset();
        for (int i = n2; i < n3; ++i) {
            this.sample(stringArray[i][n]);
        }
        DataParser dataParser = this.getParser();
        return dataParser;
    }
}

