/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.expression.AbstractExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionVisitor;
import com.jidesoft.thirdparty.prefuse.data.expression.Function;
import com.jidesoft.thirdparty.prefuse.util.collections.CopyOnWriteArrayList;

public abstract class FunctionExpression
extends AbstractExpression
implements Function {
    protected CopyOnWriteArrayList m_params;
    protected final int m_pcount;

    protected FunctionExpression(int n) {
        this.m_pcount = n;
    }

    @Override
    public abstract String getName();

    @Override
    public void addParameter(Expression expression) {
        int n = this.getParameterCount();
        if (n != -1 && this.paramCount() + 1 > n) {
            throw new IllegalStateException("This function takes only " + n + " parameters.");
        }
        if (this.m_params == null) {
            this.m_params = new CopyOnWriteArrayList();
        }
        this.m_params.add(expression);
    }

    protected int paramCount() {
        return this.m_params == null ? 0 : this.m_params.size();
    }

    protected final Expression param(int n) {
        return (Expression)this.m_params.get(n);
    }

    @Override
    public int getParameterCount() {
        return this.m_pcount;
    }

    protected void missingParams() {
        throw new IllegalStateException("Function is missing parameters: " + this.getName());
    }

    @Override
    public void visit(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visitExpression(this);
        if (this.paramCount() > 0) {
            Object[] objectArray = this.m_params.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                expressionVisitor.down();
                ((Expression)objectArray[i]).visit(expressionVisitor);
                expressionVisitor.up();
            }
        }
    }

    @Override
    protected void addChildListeners() {
        if (this.paramCount() > 0) {
            Object[] objectArray = this.m_params.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Expression)objectArray[i]).addExpressionListener(this);
            }
        }
    }

    @Override
    protected void removeChildListeners() {
        if (this.paramCount() > 0) {
            Object[] objectArray = this.m_params.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Expression)objectArray[i]).removeExpressionListener(this);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append('(');
        for (int i = 0; i < this.paramCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.param(i).toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

