/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.expression;

import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.expression.BinaryExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;
import com.jidesoft.thirdparty.prefuse.util.collections.DefaultLiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import java.util.Comparator;

public class ComparisonPredicate
extends BinaryExpression
implements Predicate {
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int EQ = 2;
    public static final int NEQ = 3;
    public static final int LTEQ = 4;
    public static final int GTEQ = 5;
    private Comparator m_cmp;

    public ComparisonPredicate(int n, Expression expression, Expression expression2) {
        this(n, expression, expression2, DefaultLiteralComparator.getInstance());
    }

    public ComparisonPredicate(int n, Expression expression, Expression expression2, Comparator comparator) {
        super(n, 0, 5, expression, expression2);
        this.m_cmp = comparator;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    @Override
    public Class getType(Schema schema) {
        return Boolean.TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getBoolean(Tuple tuple) {
        Class clazz = this.m_left.getType(tuple.getSchema());
        Class clazz2 = this.m_right.getType(tuple.getSchema());
        int n = 0;
        if (TypeLib.isNumericType(clazz) && TypeLib.isNumericType(clazz2)) {
            Class clazz3 = TypeLib.getNumericType(clazz, clazz2);
            if (clazz3 == Integer.TYPE) {
                int n2 = this.m_left.getInt(tuple);
                int n3 = this.m_right.getInt(tuple);
                n = ((LiteralComparator)this.m_cmp).compare(n2, n3);
            } else if (clazz3 == Long.TYPE) {
                long l = this.m_left.getLong(tuple);
                long l2 = this.m_right.getLong(tuple);
                n = ((LiteralComparator)this.m_cmp).compare(l, l2);
            } else if (clazz3 == Float.TYPE) {
                float f = this.m_left.getFloat(tuple);
                float f2 = this.m_right.getFloat(tuple);
                n = ((LiteralComparator)this.m_cmp).compare(f, f2);
            } else {
                if (clazz3 != Double.TYPE) throw new IllegalStateException();
                double d = this.m_left.getDouble(tuple);
                double d2 = this.m_right.getDouble(tuple);
                n = ((LiteralComparator)this.m_cmp).compare(d, d2);
            }
        } else {
            n = this.m_cmp.compare(this.m_left.get(tuple), this.m_right.get(tuple));
        }
        switch (this.m_op) {
            case 0: {
                if (n != -1) return false;
                return true;
            }
            case 1: {
                if (n != 1) return false;
                return true;
            }
            case 2: {
                if (n != 0) return false;
                return true;
            }
            case 3: {
                if (n == 0) return false;
                return true;
            }
            case 4: {
                if (n > 0) return false;
                return true;
            }
            case 5: {
                if (n < 0) return false;
                return true;
            }
        }
        throw new IllegalStateException("Unknown operation.");
    }

    @Override
    public Object get(Tuple tuple) {
        return this.getBoolean(tuple) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        String string = "?";
        switch (this.m_op) {
            case 0: {
                string = "<";
                break;
            }
            case 1: {
                string = ">";
                break;
            }
            case 2: {
                string = "=";
                break;
            }
            case 3: {
                string = "!=";
                break;
            }
            case 4: {
                string = "<=";
                break;
            }
            case 5: {
                string = ">=";
            }
        }
        return this.m_left.toString() + ' ' + string + ' ' + this.m_right.toString();
    }
}

