/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.event.ColumnListener;
import com.jidesoft.thirdparty.prefuse.data.util.Index;
import com.jidesoft.thirdparty.prefuse.util.DataLib;
import com.jidesoft.thirdparty.prefuse.util.TypeLib;
import com.jidesoft.thirdparty.prefuse.util.collections.DefaultLiteralComparator;
import java.util.Comparator;
import java.util.Map;

public class ColumnMetadata
implements ColumnListener {
    private Table m_table;
    private String m_field;
    private boolean m_dynamic;
    private boolean m_init;
    private Comparator m_cmp;
    private Object m_default;
    private int m_min;
    private int m_max;
    private int m_median;
    private int m_unique;
    private Double m_mean;
    private Double m_stdev;
    private Double m_sum;
    private Object[] m_ordinalA;
    private Map m_ordinalM;

    public ColumnMetadata(Table table, String string) {
        this(table, string, DefaultLiteralComparator.getInstance(), true);
    }

    public ColumnMetadata(Table table, String string, Comparator comparator, boolean bl) {
        this.m_table = table;
        this.m_field = string;
        this.m_cmp = comparator;
        this.m_dynamic = bl;
    }

    public void dispose() {
        this.m_table.getColumn(this.m_field).removeColumnListener(this);
    }

    private void clearCachedValues() {
        this.m_min = -1;
        this.m_max = -1;
        this.m_median = -1;
        this.m_unique = -1;
        this.m_mean = null;
        this.m_stdev = null;
        this.m_sum = null;
        this.m_ordinalA = null;
        this.m_ordinalM = null;
    }

    public void calculateValues() {
        this.clearCachedValues();
        boolean bl = this.m_dynamic;
        this.m_dynamic = true;
        this.getMinimumRow();
        this.getMaximumRow();
        this.getMedianRow();
        this.getUniqueCount();
        if (TypeLib.isNumericType(this.m_table.getColumnType(this.m_field))) {
            this.getMean();
            this.getDeviation();
            this.getSum();
        }
        this.getOrdinalArray();
        this.getOrdinalMap();
        this.m_init = true;
        this.m_dynamic = bl;
    }

    private void accessCheck() {
        if (this.m_init) {
            return;
        }
        if (this.m_dynamic) {
            this.clearCachedValues();
            this.m_table.getColumn(this.m_field).addColumnListener(this);
        } else {
            this.calculateValues();
        }
        this.m_init = true;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    public void setComparator(Comparator comparator) {
        this.m_cmp = comparator;
        this.clearCachedValues();
    }

    public Object getDefaultValue() {
        return this.m_default;
    }

    public int getMinimumRow() {
        this.accessCheck();
        if (this.m_min == -1 && this.m_dynamic) {
            Index index = this.m_table.getIndex(this.m_field);
            this.m_min = index != null ? index.minimum() : DataLib.min(this.m_table.tuples(), this.m_field, this.m_cmp).getRow();
        }
        return this.m_min;
    }

    public int getMaximumRow() {
        this.accessCheck();
        if (this.m_max == -1 && this.m_dynamic) {
            Index index = this.m_table.getIndex(this.m_field);
            this.m_max = index != null ? index.maximum() : DataLib.max(this.m_table.tuples(), this.m_field, this.m_cmp).getRow();
        }
        return this.m_max;
    }

    public int getMedianRow() {
        this.accessCheck();
        if (this.m_median == -1 && this.m_dynamic) {
            Index index = this.m_table.getIndex(this.m_field);
            if (index != null) {
                this.m_max = index.median();
            } else {
                this.m_median = DataLib.median(this.m_table.tuples(), this.m_field, this.m_cmp).getRow();
            }
        }
        return this.m_median;
    }

    public int getUniqueCount() {
        this.accessCheck();
        if (this.m_unique == -1 && this.m_dynamic) {
            Index index = this.m_table.getIndex(this.m_field);
            this.m_unique = index != null ? index.uniqueCount() : DataLib.uniqueCount(this.m_table.tuples(), this.m_field);
        }
        return this.m_unique;
    }

    public double getMean() {
        this.accessCheck();
        if (this.m_mean == null && this.m_dynamic) {
            this.m_mean = new Double(DataLib.mean(this.m_table.tuples(), this.m_field));
        }
        return this.m_mean;
    }

    public double getDeviation() {
        this.accessCheck();
        if (this.m_stdev == null && this.m_dynamic) {
            this.m_stdev = new Double(DataLib.deviation(this.m_table.tuples(), this.m_field, this.getMean()));
        }
        return this.m_stdev;
    }

    public double getSum() {
        this.accessCheck();
        if (this.m_sum == null && this.m_dynamic) {
            this.m_sum = new Double(DataLib.sum(this.m_table.tuples(), this.m_field));
        }
        return this.m_sum;
    }

    public Object[] getOrdinalArray() {
        this.accessCheck();
        if (this.m_ordinalA == null && this.m_dynamic) {
            this.m_ordinalA = DataLib.ordinalArray(this.m_table.tuples(), this.m_field, this.m_cmp);
        }
        return this.m_ordinalA;
    }

    public Map getOrdinalMap() {
        this.accessCheck();
        if (this.m_ordinalM == null && this.m_dynamic) {
            this.m_ordinalM = DataLib.ordinalMap(this.m_table.tuples(), this.m_field, this.m_cmp);
        }
        return this.m_ordinalM;
    }

    @Override
    public void columnChanged(Column column, int n, int n2, int n3) {
        this.clearCachedValues();
    }

    @Override
    public void columnChanged(Column column, int n, boolean bl) {
        this.columnChanged(column, 0, n, n);
    }

    @Override
    public void columnChanged(Column column, int n, double d) {
        this.columnChanged(column, 0, n, n);
    }

    @Override
    public void columnChanged(Column column, int n, float f) {
        this.columnChanged(column, 0, n, n);
    }

    @Override
    public void columnChanged(Column column, int n, int n2) {
        this.columnChanged(column, 0, n, n);
    }

    @Override
    public void columnChanged(Column column, int n, long l) {
        this.columnChanged(column, 0, n, n);
    }

    @Override
    public void columnChanged(Column column, int n, Object object) {
        this.columnChanged(column, 0, n, n);
    }
}

