/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.status.StatusBarItem;
import com.jidesoft.swing.NullButton;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;

public class ButtonStatusBarItem
extends StatusBarItem {
    private AbstractButton _button;
    private String _name;

    public ButtonStatusBarItem() {
        this("");
    }

    public ButtonStatusBarItem(String string) {
        this.setLayout(new BorderLayout());
        this._button = this.createButton();
        this.add((Component)this._button, "Center");
        this.customizeButton(this._button);
        this._name = string;
    }

    public ButtonStatusBarItem(Action action) {
        this.setLayout(new BorderLayout());
        this._button = this.createButton();
        this.add((Component)this._button, "Center");
        this.customizeButton(this._button);
        this._button.setAction(action);
        this._name = "" + action.getValue("Name");
    }

    protected void customizeButton(AbstractButton abstractButton) {
        PortingUtils.removeFocus(abstractButton);
        PortingUtils.removeButtonBorder(abstractButton);
        abstractButton.setOpaque(false);
    }

    @Override
    public void setToolTipText(String string) {
        if (this._button != null) {
            this.setToolTip(string);
        }
        super.setToolTipText(string);
    }

    @Override
    public String getToolTipText() {
        if (this._button != null) {
            return this._button.getToolTipText();
        }
        return super.getToolTipText();
    }

    protected AbstractButton createButton() {
        return new NullButton(){

            @Override
            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (SystemInfo.isJdk6Above()) {
                    return super.getToolTipLocation(mouseEvent);
                }
                Point point = this.getLocation();
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                point.y += this.getHeight() - fontMetrics.getHeight();
                return point;
            }
        };
    }

    public void setText(String string) {
        this._button.setText(string);
    }

    public void setToolTip(String string) {
        this._button.setToolTipText(string);
    }

    public void setIcon(Icon icon) {
        this._button.setIcon(icon);
    }

    @Override
    public void setEnabled(boolean bl) {
        this._button.setEnabled(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this._button.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._button.removeActionListener(actionListener);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == ActionListener.class) {
            return this._button.getListeners(clazz);
        }
        return super.getListeners(clazz);
    }

    public Component getComponent() {
        return this._button;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getPreferredWidth() == 0) {
            return new Dimension(this._button.getPreferredSize().width + this.getInsets().left + this.getInsets().right, super.getPreferredSize().height);
        }
        return super.getPreferredSize();
    }

    @Override
    public String getItemName() {
        return this._name;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._button != null) {
            PortingUtils.removeButtonBorder(this._button);
        }
    }

    public void doClick() {
        if (this._button != null) {
            this._button.doClick();
        }
    }

    public void doClick(int n) {
        if (this._button != null) {
            this._button.doClick(n);
        }
    }

    public void setHorizontalAlignment(int n) {
        if (this._button != null) {
            this._button.setHorizontalAlignment(n);
        }
    }

    public int getHorizontalAlignment() {
        if (this._button != null) {
            return this._button.getHorizontalAlignment();
        }
        return 10;
    }
}

