/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.shortcut.KeyboardShortcut;
import com.jidesoft.shortcut.MouseShortcut;
import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.shortcut.ShortcutIconsFactory;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

class ShortcutLabel
extends JLabel {
    private Shortcut _shortcut;

    public ShortcutLabel() {
        this.initComponent();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.initComponent();
    }

    protected void initComponent() {
        this.setBorder(BorderFactory.createCompoundBorder(UIDefaultsLookup.getBorder("TextField.border"), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
    }

    public Shortcut getShortcut() {
        return this._shortcut;
    }

    public void setShortcut(Shortcut shortcut) {
        this._shortcut = shortcut;
        ShortcutLabel.configureRenderer(shortcut, this);
    }

    private static void configureRenderer(Object object, Component component) {
        if (component instanceof JLabel) {
            if (object instanceof KeyboardShortcut) {
                if (((KeyboardShortcut)object).getIcon() != null) {
                    ((JLabel)component).setIcon(((KeyboardShortcut)object).getIcon());
                } else {
                    ((JLabel)component).setIcon(ShortcutIconsFactory.getImageIcon("icons/keyboard.png"));
                }
                ((JLabel)component).setText(object.toString());
            } else if (object instanceof MouseShortcut) {
                if (((MouseShortcut)object).getIcon() != null) {
                    ((JLabel)component).setIcon(((MouseShortcut)object).getIcon());
                } else {
                    ((JLabel)component).setIcon(ShortcutIconsFactory.getImageIcon("icons/mouse.png"));
                }
                ((JLabel)component).setText(object.toString());
            } else {
                ((JLabel)component).setIcon(null);
                ((JLabel)component).setText(null);
            }
        }
    }
}

