/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.utils.SystemInfo;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;

public class KeyboardShortcut
extends Shortcut {
    private List<KeyStroke> _keyStrokes = new Vector<KeyStroke>();

    public KeyboardShortcut() {
    }

    public KeyboardShortcut(KeyStroke keyStroke) {
        this(keyStroke, null);
    }

    public KeyboardShortcut(KeyStroke keyStroke, String string) {
        this.addKeyStroke(keyStroke);
        this.setContext(string);
    }

    public KeyboardShortcut(KeyStroke[] keyStrokeArray) {
        this(keyStrokeArray, null);
    }

    public KeyboardShortcut(KeyStroke[] keyStrokeArray, String string) {
        for (KeyStroke keyStroke : keyStrokeArray) {
            this.addKeyStroke(keyStroke);
        }
        this.setContext(string);
    }

    public KeyboardShortcut(KeyEvent keyEvent) {
        this(KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers()), null);
    }

    public KeyStroke[] getKeyStrokes() {
        return this._keyStrokes.toArray(new KeyStroke[this._keyStrokes.size()]);
    }

    public void addKeyStroke(KeyStroke keyStroke) {
        this._keyStrokes.add(keyStroke);
    }

    public void removeLastKeyStroke() {
        if (this._keyStrokes.size() > 0) {
            this._keyStrokes.remove(this._keyStrokes.size() - 1);
        }
    }

    public void clear() {
        this._keyStrokes.clear();
    }

    public int getCount() {
        return this._keyStrokes.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isEmpty()) {
            for (int i = 0; i < this._keyStrokes.size(); ++i) {
                KeyStroke keyStroke = this._keyStrokes.get(i);
                if (keyStroke == null) continue;
                int n = keyStroke.getKeyCode();
                int n2 = keyStroke.getModifiers();
                String string = KeyEvent.getKeyModifiersText(n2);
                stringBuffer.append(string);
                if ("".equals(string)) {
                    stringBuffer.append(KeyEvent.getKeyText(n));
                } else {
                    switch (n) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 65406: {
                            stringBuffer.append("+");
                        }
                    }
                    stringBuffer.append("+").append(KeyEvent.getKeyText(n));
                }
                if (i == this._keyStrokes.size() - 1) continue;
                stringBuffer.append(", ");
            }
        }
        if (this.getContext() != null) {
            stringBuffer.append(" (").append(this.getContext()).append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyboardShortcut)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        KeyboardShortcut keyboardShortcut = (KeyboardShortcut)object;
        return !(this._keyStrokes == null ? keyboardShortcut._keyStrokes != null : !this._keyStrokes.equals(keyboardShortcut._keyStrokes));
    }

    @Override
    public int hashCode() {
        return this._keyStrokes != null ? this._keyStrokes.hashCode() : 0;
    }

    @Override
    boolean isEmpty() {
        if (this._keyStrokes == null || this._keyStrokes.size() == 0) {
            return true;
        }
        for (KeyStroke keyStroke : this._keyStrokes) {
            if (keyStroke == null) continue;
            return false;
        }
        return true;
    }

    public static KeyStroke parseKeyStroke(String string) {
        return KeyStroke.getKeyStroke(string);
    }

    public static String getKeyStrokeString(KeyStroke keyStroke) {
        String string = keyStroke.toString();
        int n = string.lastIndexOf(" ");
        return KeyboardShortcut.getModifiersText(keyStroke.getModifiers()) + string.substring(++n);
    }

    static String getModifiersText(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0x40) != 0) {
            stringBuffer.append("shift ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("control ");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("meta ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("alt ");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("altGraph ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("button1 ");
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append("button2 ");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("button3 ");
        }
        return stringBuffer.toString();
    }

    public Shortcut convertToMacOSX() {
        boolean bl = false;
        KeyboardShortcut keyboardShortcut = new KeyboardShortcut();
        for (KeyStroke keyStroke : this._keyStrokes) {
            String string = KeyboardShortcut.getKeyStrokeString(keyStroke);
            String string2 = KeyboardShortcut.convertToMacOSX(string);
            if (!string2.equals(string)) {
                bl = true;
            }
            keyboardShortcut.addKeyStroke(KeyStroke.getKeyStroke(string2));
        }
        if (!bl) {
            return null;
        }
        keyboardShortcut.setName(this.getName());
        keyboardShortcut.setIcon(this.getIcon());
        keyboardShortcut.setContext(this.getContext());
        return keyboardShortcut;
    }

    public static String convertToMacOSX(String string) {
        if (string.indexOf("control ") != -1) {
            if (SystemInfo.isJdk15Above()) {
                return string.replace("control ", "meta ");
            }
            return Pattern.compile("control ", 16).matcher(string).replaceAll("meta ");
        }
        return string;
    }

    public static String convertFromMacOSX(String string) {
        if (string.indexOf("meta ") != -1) {
            if (SystemInfo.isJdk15Above()) {
                return string.replace("meta ", "control ");
            }
            return Pattern.compile("meta ", 16).matcher(string).replaceAll("control ");
        }
        return string;
    }
}

