/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.shortcut.ShortcutEditor;
import com.jidesoft.shortcut.ShortcutSchema;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CommandListCellRenderer
extends JPanel
implements ListCellRenderer {
    protected static Color COLOR_MODIFIED = new Color(0, 0, 255);
    protected static Color COLOR_MODIFIED_SELECTED = UIDefaultsLookup.getColor("List.selectionForeground");
    protected static Color COLOR_DEFAULT = UIDefaultsLookup.getColor("List.foreground");
    protected static Color COLOR_DEFAULT_SELECTED = UIDefaultsLookup.getColor("List.selectionForeground");
    protected static Color COLOR_DISABLE = UIDefaultsLookup.getColor("Label.disabledForeground");
    protected StyledLabel _commandLabel;
    protected StyledLabel _shortcutLabel;
    private static Border noFocusBorder;
    protected ShortcutEditor _shortcutEditor;

    public CommandListCellRenderer(ShortcutEditor shortcutEditor) {
        if (noFocusBorder == null) {
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }
        this.setLayout(new JideBoxLayout(this, 0, 3));
        this._shortcutEditor = shortcutEditor;
        this._commandLabel = new StyledLabel();
        this._shortcutLabel = new StyledLabel();
        this.add((Component)this._commandLabel, "fix");
        this.add(Box.createGlue(), "vary");
        this.add((Component)this._shortcutLabel, "fix");
        Component component = Box.createGlue();
        component.setPreferredSize(new Dimension(3, 3));
        this.add(component, "fix");
        this.setOpaque(false);
    }

    private void customizeStyledLabel(StyledLabel styledLabel, JList jList, Object object, int n, boolean bl, boolean bl2) {
        styledLabel.clearStyleRanges();
        if (object instanceof Icon) {
            styledLabel.setIcon((Icon)object);
            styledLabel.setText("");
        } else {
            styledLabel.setIcon(null);
            styledLabel.setText(object == null ? "" : object.toString());
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        CharSequence charSequence;
        Object object2;
        Object object3;
        this._commandLabel.applyComponentOrientation(jList.getComponentOrientation());
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setOpaque(true);
            this._commandLabel.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setOpaque(false);
            this._commandLabel.setForeground(jList.getForeground());
        }
        this._commandLabel.setIgnoreColorSettings(bl);
        this.customizeStyledLabel(this._commandLabel, jList, object, n, bl, bl2);
        this._commandLabel.setEnabled(jList.isEnabled());
        this._commandLabel.setFont(jList.getFont());
        Border border = null;
        if (bl2) {
            if (bl) {
                border = UIDefaultsLookup.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIDefaultsLookup.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = noFocusBorder;
        }
        this.setBorder(border);
        ShortcutSchema shortcutSchema = (ShortcutSchema)jList.getClientProperty("shortcutSchema");
        if (shortcutSchema != null) {
            object3 = shortcutSchema.getCommandIcon("" + object);
            if (object3 != null) {
                this._commandLabel.setIcon((Icon)object3);
            } else {
                this._commandLabel.setIcon(null);
            }
            object2 = shortcutSchema.getCommandDescription("" + object);
            if (object2 != null) {
                charSequence = this._commandLabel.getText();
                this._commandLabel.setText((String)charSequence + ": " + (String)object2);
                this._commandLabel.addStyleRange(new StyleRange(((String)charSequence).length() + 2, ((String)object2).length(), Color.GRAY));
            }
            if (shortcutSchema.isOverridden("" + object)) {
                this._commandLabel.setText(this._commandLabel.getText() + " *");
                if (bl) {
                    this._commandLabel.setForeground(COLOR_MODIFIED_SELECTED);
                } else {
                    this._commandLabel.setForeground(COLOR_MODIFIED);
                }
            } else if (bl) {
                this._commandLabel.setForeground(COLOR_DEFAULT_SELECTED);
            } else {
                this._commandLabel.setForeground(COLOR_DEFAULT);
            }
        }
        object3 = this._shortcutEditor.getSelectedShortcutSchema();
        this._shortcutLabel.setText("");
        if (object3 != null) {
            object2 = ((ShortcutSchema)object3).getShortcuts(this._commandLabel.getText());
            if (object2 != null) {
                charSequence = new StringBuilder();
                for (int i = 0; i < ((Shortcut[])object2).length; ++i) {
                    Shortcut shortcut = object2[i];
                    ((StringBuilder)charSequence).append(shortcut);
                    if (i == ((Shortcut[])object2).length - 1) continue;
                    ((StringBuilder)charSequence).append("; ");
                }
                this._shortcutLabel.setText(((StringBuilder)charSequence).toString());
            }
            if (bl) {
                this._shortcutLabel.setForeground(COLOR_DEFAULT_SELECTED);
            } else {
                this._shortcutLabel.setForeground(COLOR_DISABLE);
            }
        }
        return this;
    }
}

