/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.search;

import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.editor.CodeEditorFindAndReplaceTarget;
import com.jidesoft.editor.CodeEditorSelectionFindAndReplaceTarget;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.search.DbVisReplaceHelper;
import com.jidesoft.search.FindAndReplace;
import com.jidesoft.search.FindAndReplaceResource;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.swing.SelectAllUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class FindAndReplacePanel
extends JPanel {
    private JComboBox _searchComboBox;
    private JButton _findHelperButton;
    private JComboBox _replaceComboBox;
    private JButton _replaceHelperButton;
    private JCheckBox _matchCaseCheckBox;
    private JCheckBox _matchWholeWordCheckBox;
    private JCheckBox _useCheckBox;
    private JRadioButton _regexRadioButton;
    private JRadioButton _wildcardRadioButton;
    private JRadioButton _forwardRadioButton;
    private JRadioButton _backwardRadioButton;
    private JRadioButton _entireScopeRadioButton;
    private JRadioButton _fromCursorRadioButton;
    private JComponent _replacePanel;
    private JComponent _findPanel;
    private boolean _replace;
    private FindAndReplace _findAndReplace;

    public FindAndReplacePanel(FindAndReplace findAndReplace) {
        this._findAndReplace = findAndReplace;
        this.installComponents();
        this.installListeners();
        this.installModel();
    }

    protected void installComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._findPanel = this.createFindComboBox();
        jPanel.add((Component)this._findPanel, "fix");
        this._replacePanel = this.createReplaceComboBox();
        jPanel.add((Component)this._replacePanel, "fix");
        jPanel.add(Box.createVerticalStrut(12), "fix");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 6, 6));
        jPanel2.add(this.createTargetPanel());
        jPanel2.add(this.createDirectionPanel());
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 6, 6));
        jPanel3.add(this.createOptionsPanel());
        jPanel3.add(this.createOriginPanel());
        jPanel.add((Component)jPanel2, "fix");
        jPanel.add((Component)jPanel3, "fix");
        jPanel.add(Box.createGlue(), "vary");
        this.setLayout(new BorderLayout());
        this.add(jPanel);
    }

    protected JComponent createFindComboBox() {
        this._searchComboBox = new JComboBox();
        this._searchComboBox.setPrototypeDisplayValue("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        this._searchComboBox.setEditable(true);
        SelectAllUtils.install(this._searchComboBox);
        this._findHelperButton = new JButton(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
        this._findHelperButton.setPreferredSize(new Dimension(20, 20));
        this._findHelperButton.setRequestFocusEnabled(false);
        this._findHelperButton.setToolTipText(this._findAndReplace.getTarget().getResourceString("FindAndReplace.regexHelp"));
        JLabel jLabel = new JLabel(this._findAndReplace.getTarget().getResourceString("FindAndReplace.findWhat"));
        jLabel.setDisplayedMnemonic('F');
        jLabel.setLabelFor(this._searchComboBox);
        JPanel jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
        jPanel.add((Component)jLabel, "First");
        jPanel.add(this._searchComboBox);
        jPanel.add((Component)this._findHelperButton, "After");
        return jPanel;
    }

    protected JComponent createReplaceComboBox() {
        this._replaceComboBox = new JComboBox();
        this._replaceComboBox.setEditable(true);
        SelectAllUtils.install(this._replaceComboBox);
        this._replaceHelperButton = new JButton(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
        this._replaceHelperButton.setPreferredSize(new Dimension(20, 20));
        this._replaceHelperButton.setRequestFocusEnabled(false);
        this._replaceHelperButton.setToolTipText(this._findAndReplace.getTarget().getResourceString("FindAndReplace.regexHelp"));
        JLabel jLabel = new JLabel(this._findAndReplace.getTarget().getResourceString("FindAndReplace.replaceWith"));
        jLabel.setDisplayedMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.replaceWith.mnemonic").charAt(0));
        jLabel.setLabelFor(this._replaceComboBox);
        JPanel jPanel = new JPanel(new BorderLayout(4, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 0));
        jPanel.add((Component)jLabel, "First");
        jPanel.add(this._replaceComboBox);
        jPanel.add((Component)this._replaceHelperButton, "After");
        return jPanel;
    }

    public FindAndReplaceTarget[] getTargets() {
        return this._findAndReplace.getTargets();
    }

    protected JComponent createTargetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 1, 0));
        jPanel.setBorder(new JideTitledBorder(new PartialEtchedBorder(1), this._findAndReplace.getTarget().getResourceString("FindAndReplace.target")));
        FindAndReplaceTarget[] findAndReplaceTargetArray = this.getTargets();
        final JRadioButton[] jRadioButtonArray = new JRadioButton[findAndReplaceTargetArray.length];
        final JComponent[] jComponentArray = new JComponent[findAndReplaceTargetArray.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < findAndReplaceTargetArray.length; ++i) {
            final FindAndReplaceTarget findAndReplaceTarget = findAndReplaceTargetArray[i];
            JPanel jPanel2 = new JPanel(new BorderLayout(6, 6));
            jRadioButtonArray[i] = new JRadioButton();
            jPanel2.add((Component)jRadioButtonArray[i], "Before");
            final JComponent jComponent = findAndReplaceTarget.getConfigurationPanel();
            jRadioButtonArray[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(final ItemEvent itemEvent) {
                    JideSwingUtilities.setRecursively(jComponent, new JideSwingUtilities.Handler(){

                        @Override
                        public boolean condition(Component component) {
                            return !(component instanceof JLabel);
                        }

                        @Override
                        public void action(Component component) {
                            component.setEnabled(itemEvent.getStateChange() == 1);
                        }

                        @Override
                        public void postAction(Component component) {
                        }
                    });
                    if (itemEvent.getStateChange() == 1) {
                        FindAndReplacePanel.this._findAndReplace.setTarget(findAndReplaceTarget);
                        if (FindAndReplacePanel.this._entireScopeRadioButton != null) {
                            boolean bl = findAndReplaceTarget instanceof CodeEditorFindAndReplaceTarget && !(findAndReplaceTarget instanceof CodeEditorSelectionFindAndReplaceTarget);
                            FindAndReplacePanel.this._entireScopeRadioButton.setEnabled(bl);
                            FindAndReplacePanel.this._fromCursorRadioButton.setEnabled(bl);
                        }
                    }
                }
            });
            if (jComponent instanceof JLabel && jComponent.getClass() == JLabel.class && ((JLabel)jComponent).getIcon() == null) {
                jRadioButtonArray[i].setText(((JLabel)jComponent).getText());
            } else {
                jComponentArray[i] = jComponent;
                jComponent.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        for (int i = 0; i < jComponentArray.length; ++i) {
                            if (jComponentArray[i] != mouseEvent.getSource()) continue;
                            jRadioButtonArray[i].setSelected(true);
                            break;
                        }
                    }
                });
                jPanel2.add(jComponent);
            }
            jPanel.add(jPanel2);
            buttonGroup.add(jRadioButtonArray[i]);
            if (this._findAndReplace.getTarget() != findAndReplaceTarget) continue;
            jRadioButtonArray[i].setSelected(true);
        }
        if (buttonGroup.getSelection() == null && jRadioButtonArray.length > 0) {
            jRadioButtonArray[0].setSelected(true);
        }
        return jPanel;
    }

    protected JComponent createDirectionPanel() {
        this._forwardRadioButton = new JRadioButton(this._findAndReplace.getTarget().getResourceString("FindAndReplace.forward"));
        this._forwardRadioButton.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.forward.mnemonic").charAt(0));
        this._backwardRadioButton = new JRadioButton(this._findAndReplace.getTarget().getResourceString("FindAndReplace.backward"));
        this._backwardRadioButton.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.backward.mnemonic").charAt(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._forwardRadioButton);
        buttonGroup.add(this._backwardRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 1, 0));
        jPanel.setBorder(new JideTitledBorder(new PartialEtchedBorder(1), this._findAndReplace.getTarget().getResourceString("FindAndReplace.direction")));
        jPanel.add(this._forwardRadioButton);
        jPanel.add(this._backwardRadioButton);
        return jPanel;
    }

    protected JComponent createOriginPanel() {
        this._entireScopeRadioButton = new JRadioButton(this._findAndReplace.getTarget().getResourceString("FindAndReplace.entireScope"));
        this._entireScopeRadioButton.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.entireScope.mnemonic").charAt(0));
        this._fromCursorRadioButton = new JRadioButton(this._findAndReplace.getTarget().getResourceString("FindAndReplace.fromCursor"));
        this._fromCursorRadioButton.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.fromCursor.mnemonic").charAt(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._entireScopeRadioButton);
        buttonGroup.add(this._fromCursorRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 0));
        jPanel.setBorder(new JideTitledBorder(new PartialEtchedBorder(1), this._findAndReplace.getTarget().getResourceString("FindAndReplace.origin")));
        jPanel.add(this._entireScopeRadioButton);
        jPanel.add(this._fromCursorRadioButton);
        jPanel.add(new JPanel());
        jPanel.add(new JPanel());
        FindAndReplaceTarget findAndReplaceTarget = this._findAndReplace.getTarget();
        if (findAndReplaceTarget != null) {
            boolean bl = findAndReplaceTarget instanceof CodeEditorFindAndReplaceTarget && !(findAndReplaceTarget instanceof CodeEditorSelectionFindAndReplaceTarget);
            this._entireScopeRadioButton.setEnabled(bl);
            this._fromCursorRadioButton.setEnabled(bl);
        }
        return jPanel;
    }

    protected JComponent createOptionsPanel() {
        this._matchCaseCheckBox = new JCheckBox(this._findAndReplace.getTarget().getResourceString("FindAndReplace.matchCase"));
        this._matchCaseCheckBox.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.matchCase.mnemonic").charAt(0));
        this._matchWholeWordCheckBox = new JCheckBox(this._findAndReplace.getTarget().getResourceString("FindAndReplace.matchWholeWord"));
        this._matchWholeWordCheckBox.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.matchWholeWord.mnemonic").charAt(0));
        this._useCheckBox = new JCheckBox(this._findAndReplace.getTarget().getResourceString("FindAndReplace.use"));
        this._useCheckBox.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.use.mnemonic").charAt(0));
        this._regexRadioButton = new JRadioButton(this._findAndReplace.getTarget().getResourceString("FindAndReplace.regularExpressions"));
        this._regexRadioButton.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.regularExpressions.mnemonic").charAt(0));
        this._wildcardRadioButton = new JRadioButton(this._findAndReplace.getTarget().getResourceString("FindAndReplace.wildcards"));
        this._wildcardRadioButton.setMnemonic(this._findAndReplace.getTarget().getResourceString("FindAndReplace.wildcards.mnemonic").charAt(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._regexRadioButton);
        buttonGroup.add(this._wildcardRadioButton);
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        jPanel.setBorder(new JideTitledBorder(new PartialEtchedBorder(1), this._findAndReplace.getTarget().getResourceString("FindAndReplace.options")));
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        jPanel2.add(this._regexRadioButton);
        jPanel2.add(this._wildcardRadioButton);
        jPanel.setLayout(new GridLayout(0, 1, 0, 0));
        jPanel.add(this._matchCaseCheckBox);
        jPanel.add(this._matchWholeWordCheckBox);
        jPanel.add(this._useCheckBox);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected void installListeners() {
        final ActionListener actionListener = ((JComponent)this._searchComboBox.getEditor().getEditorComponent()).getActionForKeyStroke(KeyStroke.getKeyStroke(10, 0));
        final ActionListener actionListener2 = ((JComponent)this._searchComboBox.getEditor().getEditorComponent()).getActionForKeyStroke(KeyStroke.getKeyStroke(10, 0));
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!FindAndReplacePanel.this._searchComboBox.isPopupVisible() && !FindAndReplacePanel.this._replaceComboBox.isPopupVisible()) {
                    Container container = FindAndReplacePanel.this.getTopLevelAncestor();
                    if (container instanceof StandardDialog) {
                        ((StandardDialog)container).getDefaultAction().actionPerformed(actionEvent);
                    }
                } else {
                    if (FindAndReplacePanel.this._searchComboBox.isPopupVisible()) {
                        if (actionListener != null) {
                            actionListener.actionPerformed(actionEvent);
                        }
                        FindAndReplacePanel.this._searchComboBox.setPopupVisible(false);
                    }
                    if (FindAndReplacePanel.this._replaceComboBox.isPopupVisible()) {
                        if (actionListener2 != null) {
                            actionListener2.actionPerformed(actionEvent);
                        }
                        FindAndReplacePanel.this._replaceComboBox.setPopupVisible(false);
                    }
                }
            }
        };
        ((JComponent)this._searchComboBox.getEditor().getEditorComponent()).registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke(10, 0), 0);
        ((JComponent)this._replaceComboBox.getEditor().getEditorComponent()).registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke(10, 0), 0);
        this._useCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FindAndReplacePanel.this.enableHelperButtons(itemEvent.getStateChange() == 1);
            }
        });
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                if (FindAndReplacePanel.this.getFindAndReplace().isUseRegexOrWildcards()) {
                    JPopupMenu jPopupMenu = FindAndReplacePanel.this.getFindAndReplace().isUseRegex() ? FindAndReplacePanel.this.createRegexMenu(component == FindAndReplacePanel.this._findHelperButton ? FindAndReplacePanel.this._searchComboBox : FindAndReplacePanel.this._replaceComboBox) : FindAndReplacePanel.this.createWildcardsMenu(component == FindAndReplacePanel.this._findHelperButton ? FindAndReplacePanel.this._searchComboBox : FindAndReplacePanel.this._replaceComboBox);
                    JideSwingUtilities.showPopupMenu(jPopupMenu, component, component.getWidth(), 2);
                }
            }
        };
        this._findHelperButton.addActionListener(actionListener4);
        DbVisReplaceHelper.setup(this, this._searchComboBox, this._useCheckBox, this._regexRadioButton, this._replaceHelperButton, this._replaceComboBox, this.getFindAndReplace());
        this.enableHelperButtons(this._useCheckBox.isSelected());
        this._regexRadioButton.setSelected(true);
    }

    private void enableHelperButtons(boolean bl) {
        if (this._findHelperButton != null) {
            this._findHelperButton.setEnabled(bl);
        }
        if (this._replaceHelperButton != null) {
            this._replaceHelperButton.setEnabled(bl && this.getFindAndReplace().isUseRegex());
        }
        if (this._regexRadioButton != null) {
            this._regexRadioButton.setEnabled(bl);
        }
        if (this._wildcardRadioButton != null) {
            this._wildcardRadioButton.setEnabled(bl);
        }
    }

    @Deprecated
    protected ResourceBundle getResourceBundle() {
        return FindAndReplaceResource.getResourceBundle(this.getLocale());
    }

    protected void installModel() {
        if (this._findAndReplace != null) {
            this.setupFindReplaceComboBox(this._searchComboBox, new DefaultComboBoxModel<String>(this._findAndReplace.getFindHistory()), this._findAndReplace.getFindText());
            this.setupFindReplaceComboBox(this._replaceComboBox, new DefaultComboBoxModel<String>(this._findAndReplace.getReplaceHistory()), this._findAndReplace.getReplaceText());
            this._useCheckBox.setSelected(this._findAndReplace.isUseRegexOrWildcards());
            this._useCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    FindAndReplacePanel.this._findAndReplace.setUseRegexOrWildcards(itemEvent.getStateChange() == 1);
                }
            });
            this._regexRadioButton.setSelected(this._findAndReplace.isUseRegex());
            this._regexRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    FindAndReplacePanel.this._findAndReplace.setUseRegex(itemEvent.getStateChange() == 1);
                }
            });
            this._wildcardRadioButton.setSelected(this._findAndReplace.isUseWildcards());
            this._wildcardRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    FindAndReplacePanel.this._findAndReplace.setUseWildcards(itemEvent.getStateChange() == 1);
                }
            });
            this._matchCaseCheckBox.setSelected(this._findAndReplace.isMatchCase());
            this._matchCaseCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    FindAndReplacePanel.this._findAndReplace.setMatchCase(itemEvent.getStateChange() == 1);
                }
            });
            this._matchWholeWordCheckBox.setSelected(this._findAndReplace.isMatchWholeWord());
            this._matchWholeWordCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    FindAndReplacePanel.this._findAndReplace.setMatchWholeWord(itemEvent.getStateChange() == 1);
                }
            });
            this.setReplace(this._findAndReplace.isReplace());
            if (this._findAndReplace.isReversed()) {
                this._backwardRadioButton.setSelected(true);
            } else {
                this._forwardRadioButton.setSelected(true);
            }
            this._backwardRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    FindAndReplacePanel.this._findAndReplace.setReversed(itemEvent.getStateChange() == 1);
                }
            });
            if (this._findAndReplace.getOrigin() == 1) {
                this._fromCursorRadioButton.setSelected(true);
            } else {
                this._entireScopeRadioButton.setSelected(true);
            }
            this._fromCursorRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        FindAndReplacePanel.this._findAndReplace.setOrigin(1);
                    }
                }
            });
            this._entireScopeRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        FindAndReplacePanel.this._findAndReplace.setOrigin(0);
                    }
                }
            });
        }
    }

    protected void setupFindReplaceComboBox(JComboBox jComboBox, DefaultComboBoxModel defaultComboBoxModel, String string) {
        if (defaultComboBoxModel == null) {
            defaultComboBoxModel = new DefaultComboBoxModel<String>();
        }
        if (string != null && string.length() != 0) {
            int n = defaultComboBoxModel.getIndexOf(string);
            if (n != -1) {
                defaultComboBoxModel.removeElementAt(n);
            }
            defaultComboBoxModel.insertElementAt(string, 0);
            defaultComboBoxModel.setSelectedItem(string);
        }
        if (jComboBox != null) {
            jComboBox.setModel(defaultComboBoxModel);
        }
    }

    public void saveData() {
        this.setFindText("" + ((JTextField)this._searchComboBox.getEditor().getEditorComponent()).getText());
        this.setReplaceText("" + ((JTextField)this._replaceComboBox.getEditor().getEditorComponent()).getText());
        this._findAndReplace.setFindHistory(JideSwingUtilities.convertDefaultComboBoxModelToVector((DefaultComboBoxModel)this._searchComboBox.getModel()));
        this._findAndReplace.setReplaceHistory(JideSwingUtilities.convertDefaultComboBoxModelToVector((DefaultComboBoxModel)this._replaceComboBox.getModel()));
    }

    public boolean isReplace() {
        return this._replace;
    }

    public void setReplace(boolean bl) {
        this._replace = bl;
        this._replacePanel.setVisible(this._replace);
    }

    public Component getInitFocusedComponent() {
        return this._searchComboBox;
    }

    public void setFindText(String string) {
        this._findAndReplace.setFindText(string);
        this.setupFindReplaceComboBox(this._searchComboBox, new DefaultComboBoxModel<String>(this._findAndReplace.getFindHistory()), this._findAndReplace.getFindText());
    }

    public void setReplaceText(String string) {
        this._findAndReplace.setReplaceText(string);
        this.setupFindReplaceComboBox(this._replaceComboBox, new DefaultComboBoxModel<String>(this._findAndReplace.getReplaceHistory()), this._findAndReplace.getReplaceText());
    }

    public FindAndReplace getFindAndReplace() {
        return this._findAndReplace;
    }

    protected JPopupMenu createRegexMenu(JComboBox jComboBox) {
        if (this.getTargets() == null || this.getTargets().length < 1) {
            return new JidePopupMenu();
        }
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, ".", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperPeriod"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "*", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperStar"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "+", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperPlus"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "?", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperQuestionMark"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "{n}", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperRepeatExactly"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "{n,}", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperRepeatAtLeast"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "{n,m}", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperRepeatBetween"))));
        jidePopupMenu.addSeparator();
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "[", "]", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperAnyCharInSet"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "[^", "]", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperVetoAnyCharInSet"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "|", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperOr"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperEscape"))));
        jidePopupMenu.addSeparator();
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\d", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperDigit"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\D", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperNonDigit"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\s", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperWhitespace"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\S", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperNonWhitespace"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\w", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperWordChar"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\W", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperNonWordChar"))));
        jidePopupMenu.addSeparator();
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "^", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperLineBegin"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "$", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperLineEnd"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\b", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperWordBoundary"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\B", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperNonWordBoundary"))));
        jidePopupMenu.addSeparator();
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperBackslash"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\b", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperBackspace"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\f", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperFormFeed"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\n", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperNewLine"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\r", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperCarriageReturn"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "\\t", this.getTargets()[0].getResourceString("FindAndReplace.regexHelperTab"))));
        return jidePopupMenu;
    }

    protected JPopupMenu createWildcardsMenu(JComboBox jComboBox) {
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "?", this.getTargets()[0].getResourceString("FindAndReplace.wildcardHelperQuestionMark"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "*", this.getTargets()[0].getResourceString("FindAndReplace.wildcardHelperStar"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "#", this.getTargets()[0].getResourceString("FindAndReplace.wildcardHelperPond"))));
        jidePopupMenu.add(new JMenuItem(this.createAction(jComboBox, "+", this.getTargets()[0].getResourceString("FindAndReplace.wildcardHelperPlus"))));
        return jidePopupMenu;
    }

    protected Action createAction(JComboBox jComboBox, String string, String string2) {
        return this.createAction(jComboBox, string, null, string2);
    }

    protected Action createAction(final JComboBox jComboBox, final String string, final String string2, String string3) {
        return new AbstractAction(string + (string2 == null ? "" : " " + string2) + "  " + string3){
            private static final long serialVersionUID = 8306120150156569634L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
                int n = jTextField.getSelectionStart();
                int n2 = jTextField.getSelectionEnd();
                String string3 = jTextField.getText();
                string3 = string2 == null ? (n2 == -1 ? string3 + string2 : string3.substring(0, n) + string + string3.substring(n2)) : (n2 == -1 ? string3 + string + string2 : string3.substring(0, n) + string + string3.substring(n, n2) + string2 + string3.substring(n2));
                jTextField.setText(string3);
            }
        };
    }

    public static void main(String[] stringArray) {
    }
}

