/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.scale.Period;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleAreaPopupMenuCustomizer;
import com.jidesoft.scale.ScaleModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class VisiblePeriodsPopupMenuCustomizer<T>
implements ScaleAreaPopupMenuCustomizer<T>,
ActionListener {
    public static final String RESOURCE_PREFIX = "ScaleArea.MenuItem.";
    public static final String PERIOD_TIER_UP = "periodTierUp";
    public static final String PERIOD_TIER_DOWN = "periodTierDown";
    public static final String HIDE_PERIOD_TIER = "hidePeriodTier";
    public static final String TOGGLE_PERIOD_VISIBILITY_TIER_X = "togglePeriodTier";
    private ScaleArea<T> _scaleArea;
    private Period _clickedPeriod;

    @Override
    public void customizePopup(JPopupMenu jPopupMenu, ScaleArea<T> scaleArea, Period period, T t) {
        this._scaleArea = scaleArea;
        this._clickedPeriod = period;
        jPopupMenu.add(this.createMenuItem(PERIOD_TIER_UP));
        jPopupMenu.add(this.createMenuItem(PERIOD_TIER_DOWN));
        jPopupMenu.add(this.createMenuItem(HIDE_PERIOD_TIER));
        jPopupMenu.add(this.createMenuItem(TOGGLE_PERIOD_VISIBILITY_TIER_X));
    }

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem;
        List<Period> list = this._scaleArea.getVisiblePeriods();
        if (TOGGLE_PERIOD_VISIBILITY_TIER_X.equals(string)) {
            JMenu jMenu = new JMenu(this.getResourceString(string));
            jMenu.setName(string);
            ScaleModel<T> scaleModel = this._scaleArea.getScaleModel();
            if (scaleModel != null) {
                List<Period> list2 = scaleModel.getPeriods();
                for (int i = list2.size() - 1; i >= 0; --i) {
                    Period period = list2.get(i);
                    String string2 = this._scaleArea.getPeriodConverter(period).getDisplayName();
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string2);
                    boolean bl = list.contains(period);
                    jCheckBoxMenuItem.setSelected(bl);
                    if (bl && list.size() == 1) {
                        jCheckBoxMenuItem.setEnabled(false);
                    }
                    jCheckBoxMenuItem.setActionCommand(TOGGLE_PERIOD_VISIBILITY_TIER_X + i);
                    jCheckBoxMenuItem.addActionListener(this);
                    jMenu.add(jCheckBoxMenuItem);
                }
            } else {
                jMenu.setEnabled(false);
            }
            jMenuItem = jMenu;
        } else {
            jMenuItem = new JMenuItem(this.getResourceString(string));
            jMenuItem.setName(string);
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this);
            int n = list.indexOf(this._clickedPeriod);
            if (PERIOD_TIER_UP.equals(string)) {
                jMenuItem.setEnabled(n >= 0 && list.indexOf(this._clickedPeriod) < list.size() - 1);
            } else if (PERIOD_TIER_DOWN.equals(string)) {
                jMenuItem.setEnabled(n > 0);
            } else if (HIDE_PERIOD_TIER.equals(string)) {
                jMenuItem.setEnabled(n != -1 && list.size() > 1);
            }
        }
        return jMenuItem;
    }

    protected String getResourceString(String string) {
        return this._scaleArea.getResourceString(RESOURCE_PREFIX + string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        ArrayList<Period> arrayList = new ArrayList<Period>(this._scaleArea.getVisiblePeriods());
        int n = arrayList.indexOf(this._clickedPeriod);
        if (PERIOD_TIER_UP.equals(string)) {
            Collections.swap(arrayList, n, n + 1);
        } else if (PERIOD_TIER_DOWN.equals(string)) {
            Collections.swap(arrayList, n, n - 1);
        } else if (HIDE_PERIOD_TIER.equals(string)) {
            arrayList.remove(n);
        } else if (string != null && string.startsWith(TOGGLE_PERIOD_VISIBILITY_TIER_X)) {
            try {
                n = Integer.parseInt(string.substring(TOGGLE_PERIOD_VISIBILITY_TIER_X.length(), string.length()));
                List<Period> list = this._scaleArea.getScaleModel().getPeriods();
                Period period = list.get(n);
                if (arrayList.contains(period)) {
                    arrayList.remove(period);
                } else {
                    int n2 = arrayList.size();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (list.indexOf(arrayList.get(i)) <= n) continue;
                        n2 = i;
                        break;
                    }
                    arrayList.add(n2, period);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this._scaleArea.setVisiblePeriods(arrayList);
    }
}

