/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.rss.FeedReader;
import com.jidesoft.swing.SelectAllUtils;
import de.nava.informa.core.ChannelGroupIF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class GroupPropertyDialog
extends StandardDialog {
    private JTextField _titleField = null;
    private FeedReader _rss = null;
    private ChannelGroupIF _group = null;

    public GroupPropertyDialog(Frame frame, FeedReader feedReader) {
        super(frame);
        this._rss = feedReader;
        this.initDialog();
    }

    public GroupPropertyDialog(Dialog dialog, FeedReader feedReader) {
        super(dialog, true);
        this._rss = feedReader;
        this.initDialog();
    }

    private void initDialog() {
        this.setResizable(false);
        this.setTitle(this._rss.getResourceString("RssFeeds.GroupProperty.dialogTitle"));
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._rss.getFeedTree().getLastSelectedPathComponent();
        this._group = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
        this.setDefaultAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.okButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = GroupPropertyDialog.this._titleField.getText();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)GroupPropertyDialog.this._rss.getGroupTreeModel().getRoot();
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    ChannelGroupIF channelGroupIF;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    Object object = defaultMutableTreeNode2.getUserObject();
                    if (!(object instanceof ChannelGroupIF) || !string.equals((channelGroupIF = (ChannelGroupIF)object).getTitle())) continue;
                    JOptionPane.showMessageDialog(GroupPropertyDialog.this._rss, GroupPropertyDialog.this._rss.getResourceString("RssFeeds.message.failToAddGroup.duplicated"), GroupPropertyDialog.this._rss.getResourceString("RssFeeds.title"), 2);
                    return;
                }
                if (!string.equals(GroupPropertyDialog.this._group.getTitle())) {
                    GroupPropertyDialog.this._group.setTitle(string);
                    GroupPropertyDialog.this._rss.getGroupTreeModel().valueForPathChanged(GroupPropertyDialog.this._rss.getFeedTree().getSelectionPath(), GroupPropertyDialog.this._group);
                    GroupPropertyDialog.this._rss.fireGroupEvent(12206, GroupPropertyDialog.this._group);
                }
                GroupPropertyDialog.this.setVisible(false);
                GroupPropertyDialog.this.dispose();
            }
        });
        this.setDefaultCancelAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.cancelButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupPropertyDialog.this.setVisible(false);
                GroupPropertyDialog.this.dispose();
            }
        });
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JLabel jLabel = new JLabel(this._rss.getResourceString("RssFeeds.GroupProperty.title"));
        this._titleField = new JTextField(50);
        SelectAllUtils.install(this._titleField, false);
        jLabel.setLabelFor(this._titleField);
        jLabel.setDisplayedMnemonic(this._rss.getResourceString("RssFeeds.GroupProperty.title.mnemonic").charAt(0));
        if (this._group != null) {
            this._titleField.setText(this._group.getTitle());
            this._titleField.setCaretPosition(0);
        }
        jPanel.add((Component)this._titleField, "Center");
        jPanel.add((Component)jLabel, "First");
        return jPanel;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)jButton2, "CANCEL");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setPreferredSize(new Dimension(100, 45));
        jButton.setAction(this.getDefaultAction());
        jButton2.setAction(this.getDefaultCancelAction());
        return buttonPanel;
    }
}

