/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;

class FeedUtils {
    FeedUtils() {
    }

    public static byte[] getBytes(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        byte[] byArray = FeedUtils.loadBytes(inputStream);
        inputStream.close();
        return byArray;
    }

    public static byte[] loadBytes(InputStream inputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[4096];
        while ((n = inputStream.read(byArray2)) >= 0) {
            byte[] byArray3 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, n);
            byArray = byArray3;
        }
        return byArray;
    }

    public static String toDbString(String string) {
        if (string == null) {
            return "";
        }
        string = string.replace('\n', ' ');
        string = string.replace('|', ' ');
        return string;
    }

    public static void download(String string, String string2) throws IOException {
        FeedUtils.download(new URL(string), string2);
    }

    public static void download(URL uRL, String string) throws IOException {
        InputStream inputStream = uRL.openStream();
        byte[] byArray = FeedUtils.loadBytes(inputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ((OutputStream)fileOutputStream).write(byArray);
        fileOutputStream.flush();
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    public static byte[] objectToBytes(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object bytesToObject(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Object object = null;
        try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
            object = objectInputStream.readObject();
        }
        return object;
    }
}

