/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.DateConverter;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.rss.FeedIconsFactory;
import com.jidesoft.rss.FeedResource;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.ItemComparator;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class FeedItemTableModel
extends AbstractTableModel
implements ContextSensitiveTableModel,
StyleModel {
    private int _maxItems = 10;
    private PersistenceManagerIF _persistenceManager;
    private List<ItemIF> _items = new Vector<ItemIF>();
    private ChannelIF _channel;
    private boolean _ignoreLastSelectedItem = false;
    final CellStyle unreadCellStyle = new CellStyle();
    final CellStyle unreadIconCellStyle = new CellStyle();
    final CellStyle itemIconCellStyle = new CellStyle();
    final CellStyle unreadItemCellStyle = new CellStyle();

    public FeedItemTableModel() {
        this(10, null);
    }

    public FeedItemTableModel(int n) {
        this(n, null);
    }

    public FeedItemTableModel(int n, PersistenceManagerIF persistenceManagerIF) {
        this._maxItems = n;
        this._persistenceManager = persistenceManagerIF;
        this.unreadCellStyle.setFontStyle(1);
        this.unreadIconCellStyle.setIcon(FeedIconsFactory.getImageIcon("icons/unreadFlag.png"));
        this.unreadItemCellStyle.setFontStyle(1);
        this.unreadItemCellStyle.setIcon(FeedIconsFactory.getImageIcon("icons/rssItem.png"));
        this.itemIconCellStyle.setIcon(FeedIconsFactory.getImageIcon("icons/rssItem.png"));
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this._items.size();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        return n2 == 2 ? DateConverter.DATETIME_CONTEXT : null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        return null;
    }

    public long getItemID(int n) {
        return this._items.get(n).getId();
    }

    public ItemIF getItemAt(int n) {
        if (n >= 0 && n < this._items.size()) {
            return this._items.get(n);
        }
        return null;
    }

    public int getItemIndex(ItemIF itemIF) {
        return this._items.indexOf(itemIF);
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        return this.getColumnClass(n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Date.class;
            }
            case 3: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.getRowCount() > 0) {
            switch (n2) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this._items.get(n).getTitle();
                }
                case 2: {
                    return this._items.get(n).getDate();
                }
                case 3: {
                    return this._items.get(n).getCreator();
                }
            }
        }
        return null;
    }

    public void addItemAt(ItemIF itemIF, int n) {
        this._items.add(n, itemIF);
        this.fireTableRowsInserted(n, n);
    }

    public void setItemReadStatus(int n, boolean bl) {
        if (this._ignoreLastSelectedItem) {
            this._ignoreLastSelectedItem = false;
            return;
        }
        ItemIF itemIF = this.getItemAt(n);
        itemIF.setUnRead(bl);
        try {
            if (this._persistenceManager != null) {
                this._persistenceManager.updateItem(itemIF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void toggleItemReadStatus(int n) {
        ItemIF itemIF;
        itemIF.setUnRead(!(itemIF = this.getItemAt(n)).getUnRead());
        this._ignoreLastSelectedItem = true;
        try {
            if (this._persistenceManager != null) {
                this._persistenceManager.updateItem(itemIF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void setAllItemReadStatus(boolean bl) {
        for (ItemIF itemIF : this._items) {
            itemIF.setUnRead(bl);
            try {
                if (this._persistenceManager == null) continue;
                this._persistenceManager.updateItem(itemIF);
            }
            catch (Exception exception) {}
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public void removeAll() {
        int n = this.getRowCount();
        this._items.clear();
        if (n > 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    @Override
    public CellStyle getCellStyleAt(int n, int n2) {
        ItemIF itemIF = this.getItemAt(n);
        if (itemIF.getUnRead()) {
            if (n2 == 0) {
                return this.unreadIconCellStyle;
            }
            if (n2 == 1) {
                return this.unreadItemCellStyle;
            }
            return this.unreadCellStyle;
        }
        if (n2 == 1) {
            return this.itemIconCellStyle;
        }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return true;
    }

    public void openChannel(ChannelIF channelIF) {
        if (channelIF == null) {
            return;
        }
        if (channelIF.equals(this._channel)) {
            this._ignoreLastSelectedItem = false;
        }
        this._channel = channelIF;
        int n = 0;
        Set set = channelIF.getItems();
        ItemIF[] itemIFArray = set.toArray(new ItemIF[set.size()]);
        Arrays.sort(itemIFArray, new ItemComparator(true));
        this.removeAll();
        for (ItemIF itemIF : itemIFArray) {
            if (n >= this.getMaxItems()) break;
            this._items.add(itemIF);
            ++n;
        }
        if (n > 0) {
            this.fireTableRowsInserted(0, n - 1);
        }
    }

    public void closeCurrentChannel() {
        this.removeAll();
        this._channel = null;
    }

    protected String getResourceString(String string) {
        return this.getResourceBundle().getString(string);
    }

    public ResourceBundle getResourceBundle() {
        return FeedResource.getResourceBundle(Locale.getDefault());
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 1: {
                return this.getResourceString("RssFeeds.tableColumn.title");
            }
            case 2: {
                return this.getResourceString("RssFeeds.tableColumn.date");
            }
            case 3: {
                return this.getResourceString("RssFeeds.tableColumn.author");
            }
        }
        return " ";
    }

    public PersistenceManagerIF getPersistenceManager() {
        return this._persistenceManager;
    }

    public void setPersistenceManager(PersistenceManagerIF persistenceManagerIF) {
        this._persistenceManager = persistenceManagerIF;
    }

    public int getMaxItems() {
        return this._maxItems;
    }

    public void setMaxItems(int n) {
        this._maxItems = n;
    }

    public ChannelIF getChannel() {
        return this._channel;
    }

    public void setChannel(ChannelIF channelIF) {
        this._channel = channelIF;
    }
}

