/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.rss.FeedReader;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SelectAllUtils;
import de.nava.informa.core.ChannelGroupIF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class AddGroupDialog
extends StandardDialog {
    private JTextField _groupNameText = null;
    private FeedReader _rss = null;

    AddGroupDialog(Dialog dialog, FeedReader feedReader) {
        super(dialog, true);
        this.initDialog(feedReader);
    }

    AddGroupDialog(Frame frame, FeedReader feedReader) {
        super(frame);
        this.initDialog(feedReader);
    }

    private void initDialog(FeedReader feedReader) {
        this._rss = feedReader;
        this.setTitle(this._rss.getResourceString("RssFeeds.addGroupDialogTitle"));
        this.setDefaultAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.okButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = AddGroupDialog.this._groupNameText.getText();
                if (string == null || string.trim().length() == 0) {
                    JOptionPane.showMessageDialog(AddGroupDialog.this._rss, AddGroupDialog.this._rss.getResourceString("RssFeeds.message.failToAddGroup.nameEmpty"), AddGroupDialog.this._rss.getResourceString("RssFeeds.title"), 2);
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)AddGroupDialog.this._rss.getGroupTreeModel().getRoot();
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    ChannelGroupIF channelGroupIF;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (!(defaultMutableTreeNode2.getUserObject() instanceof ChannelGroupIF) || !string.equals((channelGroupIF = (ChannelGroupIF)defaultMutableTreeNode2.getUserObject()).getTitle())) continue;
                    JOptionPane.showMessageDialog(AddGroupDialog.this._rss, AddGroupDialog.this._rss.getResourceString("RssFeeds.message.failToAddGroup.duplicated"), AddGroupDialog.this._rss.getResourceString("RssFeeds.title"), 2);
                    return;
                }
                AddGroupDialog.this._rss.addChannelGroup(string);
                AddGroupDialog.this.setVisible(false);
                AddGroupDialog.this.dispose();
            }
        });
        this.setDefaultCancelAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.cancelButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddGroupDialog.this.setVisible(false);
                AddGroupDialog.this.dispose();
            }
        });
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel(this._rss.getResourceString("RssFeeds.Label.enterGroupName"));
        jPanel.add((Component)jLabel, "First");
        this._groupNameText = new JTextField(this._rss.getResourceString("RssFeeds.test.site.url"));
        this._groupNameText.setColumns(40);
        SelectAllUtils.install(this._groupNameText);
        jPanel.add((Component)this._groupNameText, "Center");
        return JideSwingUtilities.createTopPanel(jPanel);
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)jButton2, "CANCEL");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jButton.setAction(this.getDefaultAction());
        jButton2.setAction(this.getDefaultCancelAction());
        return buttonPanel;
    }
}

