/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.rss.AddChannelThread;
import com.jidesoft.rss.FeedReader;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SelectAllUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AddChannelDialog
extends StandardDialog {
    private JTextField _url = null;
    private FeedReader _rss = null;

    AddChannelDialog(Dialog dialog, FeedReader feedReader) {
        super(dialog, true);
        this.initDialog(feedReader);
    }

    AddChannelDialog(Frame frame, FeedReader feedReader) {
        super(frame);
        this.initDialog(feedReader);
    }

    private void initDialog(FeedReader feedReader) {
        this._rss = feedReader;
        this.setTitle(this._rss.getResourceString("RssFeeds.addChannelDialogTitle"));
        this.setDefaultAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.okButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = AddChannelDialog.this.getUrl();
                if (string == null || string.trim().length() == 0) {
                    JOptionPane.showMessageDialog(AddChannelDialog.this._rss, AddChannelDialog.this._rss.getResourceString("RssFeeds.message.failToAddChannel"), AddChannelDialog.this._rss.getResourceString("RssFeeds.title"), 2);
                    return;
                }
                AddChannelDialog.this.setVisible(false);
                AddChannelDialog.this.dispose();
                AddChannelDialog.this._rss.fireStatusChangedEvent(MessageFormat.format(AddChannelDialog.this._rss.getResourceString("RssFeeds.message.loadingChannel"), string));
                new AddChannelThread(AddChannelDialog.this._rss, string).start();
            }
        });
        this.setDefaultCancelAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.cancelButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddChannelDialog.this.setVisible(false);
                AddChannelDialog.this.dispose();
            }
        });
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel(this._rss.getResourceString("RssFeeds.Label.enterURL"));
        jPanel.add((Component)jLabel, "First");
        this._url = new JTextField(this._rss.getResourceString("RssFeeds.test.site.url"));
        this._url.setColumns(40);
        SelectAllUtils.install(this._url);
        jPanel.add((Component)this._url, "Center");
        return JideSwingUtilities.createTopPanel(jPanel);
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)jButton2, "CANCEL");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jButton.setAction(this.getDefaultAction());
        jButton2.setAction(this.getDefaultCancelAction());
        return buttonPanel;
    }

    public String getUrl() {
        return this._url.getText();
    }
}

