/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.gantt.TaskBar;
import com.jidesoft.plaf.TaskBarUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.TaskBarPainter;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicTaskBarUI
extends TaskBarUI {
    private TaskBar _taskBar;
    private TaskBarPainter _painter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTaskBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._taskBar = (TaskBar)jComponent;
        this.installDefaults(this._taskBar);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(this._taskBar);
    }

    protected void installDefaults(TaskBar taskBar) {
        taskBar.setForeground(UIDefaultsLookup.getColor("TaskBar.foreground"));
        taskBar.setGroupForeground(UIDefaultsLookup.getColor("TaskBar.groupForeground"));
        taskBar.setBorderColor(UIDefaultsLookup.getColor("TaskBar.borderColor"));
        taskBar.setPercentageColor(UIDefaultsLookup.getColor("TaskBar.percentageColor"));
        taskBar.setPadding(UIDefaultsLookup.getInsets("TaskBar.padding"));
        this._painter = (TaskBarPainter)UIDefaultsLookup.get("TaskBar.painter");
    }

    protected void uninstallDefaults(TaskBar taskBar) {
        this._painter = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Insets insets = this._taskBar.getPadding();
        int n = 12;
        int n2 = this._taskBar.getWidth() - 1;
        int n3 = this._taskBar.getHeight() - 1 - insets.top - insets.bottom;
        int n4 = insets.top + (n3 < n ? 0 : (n3 - n) / 2);
        int n5 = n3 = n3 < n ? n3 : n;
        if (this._taskBar.isRollover()) {
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
        }
        if (this._taskBar.isGroup()) {
            this._painter.paintTaskGroup(graphics2D, this._taskBar, new Rectangle(0, n4, n2, n3), insets, this._taskBar.getGroupForeground(), this._taskBar.getBorderColor(), this._taskBar.getPercentageColor());
        } else if (this._taskBar.isMilestone()) {
            this._painter.paintMilestone(graphics2D, this._taskBar, new Rectangle(0, n4, n2, n3), insets, this._taskBar.getGroupForeground(), this._taskBar.getBorderColor(), this._taskBar.getPercentageColor());
        } else {
            this._painter.paintTask(graphics2D, this._taskBar, new Rectangle(0, n4, n2, n3), insets, this._taskBar.getForeground(), this._taskBar.getBorderColor(), this._taskBar.getPercentageColor());
        }
        graphics2D.dispose();
    }
}

