/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.plaf.SidePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SidePane;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class BasicSidePaneUI
extends SidePaneUI {
    public DropTarget _dt;
    protected SidePane _sidePane;
    protected int _size;
    protected Insets _margin;
    protected int _iconTextGap;
    protected int _textBorderGap;
    protected int _itemGap;
    protected int _groupGap;
    protected Color _lineColor;
    protected Color _background;
    protected Color _buttonBackground;
    protected Color _selectedButtonBackground;
    protected Color _selectedButtonForeground;
    protected Font _font;
    protected boolean _showText = true;
    protected boolean _alwaysShowText = true;
    protected boolean _highlightSelectedTab = false;
    protected Rectangle[] _rects;
    protected int _displayOrientation;
    private MouseInputListener _inputListener;
    private DropTargetListener _dropListener;
    private ThemePainter _painter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSidePaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this._sidePane = (SidePane)jComponent;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this._sidePane = null;
    }

    protected LayoutManager createLayoutManager() {
        return new BorderLayout();
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installColorsAndFont(this._sidePane, "SidePane.background", "SidePane.foreground", "SidePane.font");
        LookAndFeel.installBorder(this._sidePane, "SidePane.border");
        this._background = UIDefaultsLookup.getColor("SidePane.background");
        this._margin = UIDefaultsLookup.getInsets("SidePane.margin");
        this._iconTextGap = UIDefaultsLookup.getInt("SidePane.iconTextGap");
        this._textBorderGap = UIDefaultsLookup.getInt("SidePane.textBorderGap");
        this._itemGap = UIDefaultsLookup.getInt("SidePane.itemGap");
        this._groupGap = UIDefaultsLookup.getInt("SidePane.groupGap");
        this._lineColor = UIDefaultsLookup.getColor("SidePane.lineColor");
        this._buttonBackground = UIDefaultsLookup.getColor("SidePane.buttonBackground");
        this._selectedButtonBackground = UIDefaultsLookup.getColor("SidePane.selectedButtonBackground");
        this._selectedButtonForeground = UIDefaultsLookup.getColor("SidePane.selectedButtonForeground");
        this._font = UIDefaultsLookup.getFont("SidePane.font");
        this._displayOrientation = UIDefaultsLookup.getInt("SidePane.orientation");
        this._showText = UIDefaultsLookup.getBoolean("SidePane.showSelectedTabText");
        this._alwaysShowText = UIDefaultsLookup.getBoolean("SidePane.alwaysShowTabText");
        this._highlightSelectedTab = UIDefaultsLookup.getBoolean("SidePane.highlighSelectedTab");
        this._size = 6;
        this._size += this._margin.top;
        this._size += this._margin.bottom;
        this._size += Math.max(this.getFontMetrics().getHeight(), 16);
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._background = null;
        this._margin = null;
        this._lineColor = null;
        this._buttonBackground = null;
        this._selectedButtonBackground = null;
        this._selectedButtonForeground = null;
        this._font = null;
    }

    protected void installListeners() {
        this._inputListener = this.createMouseInputListener();
        this._dropListener = this.createDropListener();
        this._sidePane.addMouseListener(this._inputListener);
        this._sidePane.addMouseMotionListener(this._inputListener);
        this._dt = new DropTarget(this._sidePane, this._dropListener);
        this._sidePane.setDropTarget(this._dt);
    }

    protected MouseInputListener createMouseInputListener() {
        if (this._sidePane.isRollover()) {
            return new RolloverMouseInputListener();
        }
        return new NonrolloverMouseInputListener();
    }

    protected DropListener createDropListener() {
        return new DropListener();
    }

    protected void uninstallListeners() {
        this._sidePane.removeMouseListener(this._inputListener);
        this._sidePane.removeMouseMotionListener(this._inputListener);
        this._dt.removeDropTargetListener(this._dropListener);
        this._dropListener = null;
        this._dt = null;
        this._sidePane.setDropTarget(null);
        this._inputListener = null;
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    @Override
    public int getSelectedItemIndex(Point point) {
        if (this._rects != null) {
            for (int i = 0; i < this._rects.length; ++i) {
                Rectangle rectangle = this._rects[i];
                if (!rectangle.contains(point)) continue;
                return i;
            }
        }
        return -1;
    }

    public Rectangle getGroupRect(int n) {
        if (n >= 0 && n < this._rects.length) {
            return this._rects[n];
        }
        return null;
    }

    @Override
    public SidePaneGroup getGroupForIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(i);
            if (n >= n2 && n < n2 + sidePaneGroup.size()) {
                return sidePaneGroup;
            }
            n2 += sidePaneGroup.size();
        }
        return null;
    }

    @Override
    public SidePaneItem getItemForIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(i);
            if (n >= n2 && n < n2 + sidePaneGroup.size()) {
                return (SidePaneItem)sidePaneGroup.get(n - n2);
            }
            n2 += sidePaneGroup.size();
        }
        return null;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this._sidePane.getFont();
        return this._sidePane.getFontMetrics(font);
    }

    protected void initButtonRects() {
        int n;
        int n2 = 0;
        for (n = 0; n < this._sidePane.getGroups().size(); ++n) {
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(n);
            n2 += sidePaneGroup.size();
        }
        this._rects = new Rectangle[n2];
        for (n = 0; n < this._rects.length; ++n) {
            this._rects[n] = new Rectangle(0, 0, 0, 0);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.paintBackground(graphics, jComponent);
        graphics.setColor(this._lineColor);
        FontMetrics fontMetrics = this.getFontMetrics();
        this.initButtonRects();
        boolean bl = this._sidePane.getComponentOrientation().isLeftToRight();
        switch (this._sidePane.getAttachedSide()) {
            case 3: {
                if (bl) {
                    this.drawEastPane(graphics, jComponent, fontMetrics);
                    break;
                }
                this.drawWestPane(graphics, jComponent, fontMetrics);
                break;
            }
            case 7: {
                if (bl) {
                    this.drawWestPane(graphics, jComponent, fontMetrics);
                    break;
                }
                this.drawEastPane(graphics, jComponent, fontMetrics);
                break;
            }
            case 1: {
                this.drawNorthPane(graphics, jComponent, fontMetrics);
                break;
            }
            case 5: {
                this.drawSouthPane(graphics, jComponent, fontMetrics);
            }
        }
    }

    protected void paintItemBackground(SidePaneItem sidePaneItem, Graphics graphics, Rectangle rectangle, int n) {
        Color[] colorArray = this.getGradientColors(sidePaneItem);
        this.getPainter().paintSidePaneItemBackground(this._sidePane, graphics, rectangle, colorArray, n, 0);
    }

    protected Color[] getGradientColors(SidePaneItem sidePaneItem) {
        Color color = sidePaneItem.getBackground() != null ? sidePaneItem.getBackground() : (this.isItemHighlighted(sidePaneItem) && this._selectedButtonBackground != null ? this._selectedButtonBackground : this._buttonBackground);
        Color[] colorArray = new Color[]{color, "true".equals(SecurityUtils.getProperty("shadingtheme", "false")) ? this._background : color};
        return colorArray;
    }

    protected boolean isItemHighlighted(SidePaneItem sidePaneItem) {
        return this._highlightSelectedTab && sidePaneItem.getComponent() instanceof DockableFrame && ((DockableFrame)sidePaneItem.getComponent()).isActive();
    }

    protected void drawWestPane(Graphics graphics, JComponent jComponent, FontMetrics fontMetrics) {
        int n = 0;
        int n2 = this._margin.top;
        int n3 = this._margin.left;
        int n4 = jComponent.getWidth() - this._margin.right - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            int n5 = n2++;
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(i);
            int n6 = 0;
            if (!this._alwaysShowText) {
                String string = sidePaneGroup.getLongestTitle();
                n6 = string.length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, string) + this._textBorderGap : 0;
            }
            int n7 = fontMetrics.getHeight();
            for (int j = 0; j < sidePaneGroup.size(); ++j) {
                Graphics2D graphics2D;
                SidePaneItem sidePaneItem = (SidePaneItem)sidePaneGroup.get(j);
                int n8 = n2;
                if (this._alwaysShowText) {
                    n6 = sidePaneItem.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, sidePaneItem.getTitle()) + this._textBorderGap : 0;
                }
                int n9 = 0;
                if (sidePaneItem.getIcon() != null) {
                    n9 = this._displayOrientation == 0 ? sidePaneItem.getIcon().getIconHeight() : sidePaneItem.getIcon().getIconWidth();
                }
                int n10 = 0;
                if (sidePaneItem.getIcon() != null) {
                    int n11 = n10 = this._displayOrientation == 0 ? sidePaneItem.getIcon().getIconWidth() : sidePaneItem.getIcon().getIconHeight();
                }
                Rectangle rectangle = this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null ? new Rectangle(n3, n2, n4 - 1, 2 + this._itemGap + n9 + (n6 != 0 ? this._iconTextGap : 0) + n6) : new Rectangle(n3, n2, n4 - 1, 2 + this._itemGap + n9);
                this.paintItemBackground(sidePaneItem, graphics, rectangle, 7);
                if (this._displayOrientation == 0) {
                    if (sidePaneItem.getIcon() != null) {
                        sidePaneItem.getIcon().paintIcon(jComponent, graphics, (n4 - n10 >> 1) + n3, n2 += 2);
                        n2 += n9;
                    }
                    n2 += this._itemGap;
                    if (this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null) {
                        if (sidePaneItem.getTitle().length() != 0) {
                            graphics2D = (Graphics2D)graphics.create();
                            graphics.setFont(sidePaneItem.getFont() == null ? this._font : sidePaneItem.getFont());
                            graphics2D.rotate(1.5707963267948966);
                            graphics2D.translate(n2 += this._iconTextGap, -n4);
                            if (sidePaneItem.getForeground() != null) {
                                graphics2D.setColor(sidePaneItem.getForeground());
                            } else if (this.isItemHighlighted(sidePaneItem)) {
                                graphics2D.setColor(this._selectedButtonForeground);
                            } else {
                                graphics2D.setColor(jComponent.getForeground());
                            }
                            JideSwingUtilities.drawString(jComponent, graphics2D, sidePaneItem.getTitle(), 0, (n4 - n7 - n3 >> 1) + fontMetrics.getAscent() - n3);
                            graphics2D.dispose();
                        }
                        n2 += n6;
                    }
                } else {
                    if (this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null) {
                        if (sidePaneItem.getTitle().length() != 0) {
                            graphics2D = (Graphics2D)graphics.create();
                            graphics2D.setFont(sidePaneItem.getFont() == null ? this._font : sidePaneItem.getFont());
                            graphics2D.rotate(-1.5707963267948966);
                            graphics2D.translate(-((n2 += this._iconTextGap) + n6), 0);
                            if (sidePaneItem.getForeground() != null) {
                                graphics2D.setColor(sidePaneItem.getForeground());
                            } else if (this.isItemHighlighted(sidePaneItem)) {
                                graphics2D.setColor(this._selectedButtonForeground);
                            } else {
                                graphics2D.setColor(jComponent.getForeground());
                            }
                            JideSwingUtilities.drawString(jComponent, graphics2D, sidePaneItem.getTitle(), 0, (n4 - n7 - n3 >> 1) + fontMetrics.getAscent() - n3);
                            graphics2D.dispose();
                        }
                        n2 += n6;
                    }
                    graphics2D = (Graphics2D)graphics.create();
                    graphics2D.rotate(-1.5707963267948966);
                    graphics2D.translate(-((n2 += this._itemGap) + n9), -(n2 - (n4 - n10 >> 1) - n3));
                    if (sidePaneItem.getIcon() != null) {
                        sidePaneItem.getIcon().paintIcon(jComponent, graphics2D, n4 >> 1 - n10 + n3, n2);
                        n2 += n9;
                        n2 += 2;
                    }
                    graphics2D.dispose();
                }
                graphics.setColor(this._lineColor);
                if (this.isRoundedCorner()) {
                    if (j == 0) {
                        graphics.drawLine(n3, n5, n4 - 2, n5);
                        graphics.drawLine(n4 - 1, n5 + 1, n4 - 1, n5 + 1);
                    }
                    graphics.drawLine(n4 - 1, n8, n4 - 1, n8);
                    graphics.drawLine(n4, n8 + 1, n4, n2 - 2);
                    graphics.drawLine(n4 - 1, n2 - 1, n4 - 1, n2 - 1);
                    graphics.drawLine(n3, n2, n4 - 2, n2);
                } else {
                    if (j == 0) {
                        graphics.drawLine(n3, n5, n4, n5);
                    }
                    graphics.drawLine(n4, n8, n4, n2);
                    graphics.drawLine(n3, n2, n4, n2);
                }
                this._rects[n].x = n3 + 1;
                this._rects[n].y = n8;
                this._rects[n].width = n4 - n3 + 1;
                this._rects[n].height = n2 - n8;
                ++n;
                ++n2;
            }
            n2 += this._groupGap;
        }
    }

    protected void drawEastPane(Graphics graphics, JComponent jComponent, FontMetrics fontMetrics) {
        int n = 0;
        int n2 = this._margin.top;
        int n3 = this._margin.right;
        int n4 = jComponent.getWidth() - this._margin.left - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            int n5 = n2++;
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(i);
            int n6 = 0;
            if (!this._alwaysShowText) {
                String string = sidePaneGroup.getLongestTitle();
                n6 = string.length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, string) + this._textBorderGap : 0;
            }
            int n7 = fontMetrics.getHeight();
            for (int j = 0; j < sidePaneGroup.size(); ++j) {
                Graphics2D graphics2D;
                SidePaneItem sidePaneItem = (SidePaneItem)sidePaneGroup.get(j);
                int n8 = n2;
                if (this._alwaysShowText) {
                    n6 = sidePaneItem.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, sidePaneItem.getTitle()) + this._textBorderGap : 0;
                }
                int n9 = 0;
                if (sidePaneItem.getIcon() != null) {
                    n9 = this._displayOrientation == 0 ? sidePaneItem.getIcon().getIconHeight() : sidePaneItem.getIcon().getIconWidth();
                }
                int n10 = 0;
                if (sidePaneItem.getIcon() != null) {
                    int n11 = n10 = this._displayOrientation == 0 ? sidePaneItem.getIcon().getIconWidth() : sidePaneItem.getIcon().getIconHeight();
                }
                Rectangle rectangle = this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null ? new Rectangle(n3 + 1, n2, n4, 2 + this._itemGap + n9 + (n6 != 0 ? this._iconTextGap : 0) + n6) : new Rectangle(n3 + 1, n2, n4, 2 + this._itemGap + n9);
                this.paintItemBackground(sidePaneItem, graphics, rectangle, 3);
                n2 += 2;
                if (sidePaneItem.getIcon() != null) {
                    if (this._displayOrientation == 0) {
                        sidePaneItem.getIcon().paintIcon(jComponent, graphics, 1 + (n4 + n3 - n10) >> 1, n2);
                    } else {
                        graphics2D = (Graphics2D)graphics.create();
                        graphics2D.rotate(1.5707963267948966);
                        graphics2D.translate(n2, -n4);
                        sidePaneItem.getIcon().paintIcon(jComponent, graphics2D, 0, n4 - n3 - n10 >> 1);
                        graphics2D.dispose();
                    }
                }
                n2 += n9;
                n2 += this._itemGap;
                if (this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null) {
                    if (sidePaneItem.getTitle().length() != 0) {
                        graphics2D = (Graphics2D)graphics.create();
                        graphics2D.setFont(sidePaneItem.getFont() == null ? this._font : sidePaneItem.getFont());
                        graphics2D.rotate(1.5707963267948966);
                        graphics2D.translate(n2 += this._iconTextGap, -n4);
                        if (sidePaneItem.getForeground() != null) {
                            graphics2D.setColor(sidePaneItem.getForeground());
                        } else if (this.isItemHighlighted(sidePaneItem)) {
                            graphics2D.setColor(this._selectedButtonForeground);
                        } else {
                            graphics2D.setColor(jComponent.getForeground());
                        }
                        JideSwingUtilities.drawString(jComponent, graphics2D, sidePaneItem.getTitle(), 0, (n4 - n3 - n7 >> 1) + fontMetrics.getAscent());
                        graphics2D.dispose();
                    }
                    n2 += n6;
                }
                graphics.setColor(this._lineColor);
                if (this.isRoundedCorner()) {
                    if (j == 0) {
                        graphics.drawLine(n3 + 2, n5, n4, n5);
                        graphics.drawLine(n3 + 1, n5 + 1, n3 + 1, n5 + 1);
                    }
                    graphics.drawLine(n3 + 1, n8, n3 + 1, n8);
                    graphics.drawLine(n3, n8 + 1, n3, n2 - 2);
                    graphics.drawLine(n3 + 1, n2 - 1, n3 + 1, n2 - 1);
                    graphics.drawLine(n3 + 2, n2, n4, n2);
                } else {
                    if (j == 0) {
                        graphics.drawLine(n3, n5, n4, n5);
                    }
                    graphics.drawLine(n3, n8, n3, n2);
                    graphics.drawLine(n3, n2, n4, n2);
                }
                this._rects[n].x = n3 + 1;
                this._rects[n].y = n8;
                this._rects[n].width = n4 - n3 + 1;
                this._rects[n].height = n2 - n8;
                ++n;
                ++n2;
            }
            n2 += this._groupGap;
        }
    }

    protected void drawNorthPane(Graphics graphics, JComponent jComponent, FontMetrics fontMetrics) {
        int n = 0;
        int n2 = this._margin.top;
        int n3 = this._margin.left;
        int n4 = jComponent.getHeight() - this._margin.right - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            int n5 = n2++;
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(i);
            int n6 = 0;
            if (!this._alwaysShowText) {
                String string = sidePaneGroup.getLongestTitle();
                n6 = string.length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, string) + this._textBorderGap : 0;
            }
            int n7 = fontMetrics.getHeight();
            for (int j = 0; j < sidePaneGroup.size(); ++j) {
                SidePaneItem sidePaneItem = (SidePaneItem)sidePaneGroup.get(j);
                int n8 = n2;
                if (this._alwaysShowText) {
                    int n9 = n6 = sidePaneItem.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, sidePaneItem.getTitle()) + this._textBorderGap : 0;
                }
                Rectangle rectangle = this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null ? new Rectangle(n2, n3, this._itemGap + (sidePaneItem.getIcon() == null ? 0 : sidePaneItem.getIcon().getIconWidth() + 2) + (n6 != 0 ? this._iconTextGap : 0) + n6, n4 - 1) : new Rectangle(n2, n3, this._itemGap + (sidePaneItem.getIcon() == null ? 0 : sidePaneItem.getIcon().getIconWidth() + 2), n4 - 1);
                this.paintItemBackground(sidePaneItem, graphics, rectangle, 1);
                if (sidePaneItem.getIcon() != null) {
                    sidePaneItem.getIcon().paintIcon(jComponent, graphics, n2 += 2, (n4 - sidePaneItem.getIcon().getIconHeight() >> 1) + n3);
                    n2 += sidePaneItem.getIcon().getIconWidth();
                }
                n2 += this._itemGap;
                if (this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null) {
                    if (sidePaneItem.getTitle().length() != 0) {
                        n2 += this._iconTextGap;
                        graphics.setFont(sidePaneItem.getFont() == null ? this._font : sidePaneItem.getFont());
                        if (sidePaneItem.getForeground() != null) {
                            graphics.setColor(sidePaneItem.getForeground());
                        } else if (this.isItemHighlighted(sidePaneItem)) {
                            graphics.setColor(this._selectedButtonForeground);
                        } else {
                            graphics.setColor(jComponent.getForeground());
                        }
                        JideSwingUtilities.drawString(jComponent, graphics, sidePaneItem.getTitle(), n2, (n4 + n3 - n7 >> 1) + fontMetrics.getAscent());
                    }
                    n2 += n6;
                }
                graphics.setColor(this._lineColor);
                if (this.isRoundedCorner()) {
                    if (j == 0) {
                        graphics.drawLine(n5, n3, n5, n4 - 2);
                        graphics.drawLine(n5 + 1, n4 - 1, n5 + 1, n4 - 1);
                    }
                    graphics.drawLine(n8, n4 - 1, n8, n4 - 1);
                    graphics.drawLine(n8 + 1, n4, n2 - 2, n4);
                    graphics.drawLine(n2 - 1, n4 - 1, n2 - 1, n4 - 1);
                    graphics.drawLine(n2, n3, n2, n4 - 2);
                } else {
                    if (j == 0) {
                        graphics.drawLine(n5, n3, n5, n4);
                    }
                    graphics.drawLine(n8, n4, n2, n4);
                    graphics.drawLine(n2, n3, n2, n4);
                }
                this._rects[n].y = n3 + 1;
                this._rects[n].x = n8;
                this._rects[n].height = n4 - n3 + 1;
                this._rects[n].width = n2 - n8;
                ++n;
                ++n2;
            }
            n2 += this._groupGap;
        }
    }

    protected void drawSouthPane(Graphics graphics, JComponent jComponent, FontMetrics fontMetrics) {
        int n = 0;
        int n2 = this._margin.top;
        int n3 = this._margin.right;
        int n4 = jComponent.getHeight() - this._margin.left - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            int n5 = n2++;
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(i);
            int n6 = 0;
            if (!this._alwaysShowText) {
                String string = sidePaneGroup.getLongestTitle();
                n6 = string.length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, string) + this._textBorderGap : 0;
            }
            int n7 = fontMetrics.getHeight();
            for (int j = 0; j < sidePaneGroup.size(); ++j) {
                SidePaneItem sidePaneItem = (SidePaneItem)sidePaneGroup.get(j);
                int n8 = n2;
                if (this._alwaysShowText) {
                    int n9 = n6 = sidePaneItem.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, sidePaneItem.getTitle()) + this._textBorderGap : 0;
                }
                Rectangle rectangle = this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null ? new Rectangle(n2, n3 + 1, this._itemGap + (sidePaneItem.getIcon() == null ? 0 : sidePaneItem.getIcon().getIconWidth() + 2) + (n6 != 0 ? this._iconTextGap : 0) + n6, n4 - 1) : new Rectangle(n2, n3 + 1, this._itemGap + (sidePaneItem.getIcon() == null ? 0 : sidePaneItem.getIcon().getIconWidth() + 2), n4 - 1);
                this.paintItemBackground(sidePaneItem, graphics, rectangle, 5);
                if (sidePaneItem.getIcon() != null) {
                    sidePaneItem.getIcon().paintIcon(jComponent, graphics, n2 += 2, (n4 + n3 - sidePaneItem.getIcon().getIconHeight() >> 1) + 1);
                    n2 += sidePaneItem.getIcon().getIconWidth();
                }
                n2 += this._itemGap;
                if (this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem) || sidePaneItem.getIcon() == null) {
                    if (sidePaneItem.getTitle().length() != 0) {
                        n2 += this._iconTextGap;
                        graphics.setFont(sidePaneItem.getFont() == null ? this._font : sidePaneItem.getFont());
                        if (sidePaneItem.getForeground() != null) {
                            graphics.setColor(sidePaneItem.getForeground());
                        } else if (this.isItemHighlighted(sidePaneItem)) {
                            graphics.setColor(this._selectedButtonForeground);
                        } else {
                            graphics.setColor(jComponent.getForeground());
                        }
                        JideSwingUtilities.drawString(jComponent, graphics, sidePaneItem.getTitle(), n2, (n4 + n3 - n7 >> 1) + fontMetrics.getAscent() + 1);
                    }
                    n2 += n6;
                }
                graphics.setColor(this._lineColor);
                if (this.isRoundedCorner()) {
                    if (j == 0) {
                        graphics.drawLine(n5, n3 + 2, n5, n4);
                        graphics.drawLine(n5 + 1, n3 + 1, n5 + 1, n3 + 1);
                    }
                    graphics.drawLine(n8, n3 + 1, n8, n3 + 1);
                    graphics.drawLine(n8 + 1, n3, n2 - 2, n3);
                    graphics.drawLine(n2 - 1, n3 + 1, n2 - 1, n3 + 1);
                    graphics.drawLine(n2, n3 + 2, n2, n4);
                } else {
                    if (j == 0) {
                        graphics.drawLine(n5, n3, n5, n4);
                    }
                    graphics.drawLine(n8, n3, n2, n3);
                    graphics.drawLine(n2, n3, n2, n4);
                }
                this._rects[n].y = n3 + 1;
                this._rects[n].x = n8;
                this._rects[n].height = n4 - n3 + 1;
                this._rects[n].width = n2 - n8;
                ++n;
                ++n2;
            }
            n2 += this._groupGap;
        }
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            graphics.setColor(this._background);
            graphics.fillRect(0, 0, n, n2);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this._sidePane.getGroups() != null && this._sidePane.getGroups().size() > 0) {
            switch (this._sidePane.getAttachedSide()) {
                case 3: 
                case 7: {
                    return new Dimension(this._size, this.getPreferredHeightVertical());
                }
                case 1: 
                case 5: {
                    return new Dimension(this.getPreferredWidthHorizontal(), this._size);
                }
            }
        }
        return new Dimension(0, 0);
    }

    protected int getPreferredWidthHorizontal() {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n = this._margin.top;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            ++n;
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(i);
            int n2 = 0;
            if (!this._alwaysShowText) {
                String string = sidePaneGroup.getLongestTitle();
                n2 = string.length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, string) + this._textBorderGap : 0;
            }
            for (int j = 0; j < sidePaneGroup.size(); ++j) {
                SidePaneItem sidePaneItem = (SidePaneItem)sidePaneGroup.get(j);
                if (this._alwaysShowText) {
                    int n3 = n2 = sidePaneItem.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, sidePaneItem.getTitle()) + this._textBorderGap : 0;
                }
                if (sidePaneItem.getIcon() != null) {
                    n += 2;
                    n += sidePaneItem.getIcon().getIconWidth();
                }
                n += this._itemGap;
                if (this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem)) {
                    if (sidePaneItem.getTitle().length() != 0) {
                        n += this._iconTextGap;
                    }
                    n += n2;
                }
                ++n;
            }
            n += this._groupGap;
        }
        return n;
    }

    protected int getPreferredHeightVertical() {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n = this._margin.top;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            ++n;
            SidePaneGroup sidePaneGroup = this._sidePane.getGroups().get(i);
            int n2 = 0;
            if (!this._alwaysShowText) {
                String string = sidePaneGroup.getLongestTitle();
                n2 = string.length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, string) + this._textBorderGap : 0;
            }
            for (int j = 0; j < sidePaneGroup.size(); ++j) {
                SidePaneItem sidePaneItem = (SidePaneItem)sidePaneGroup.get(j);
                if (this._alwaysShowText) {
                    int n3 = n2 = sidePaneItem.getTitle().length() != 0 ? SwingUtilities.computeStringWidth(fontMetrics, sidePaneItem.getTitle()) + this._textBorderGap : 0;
                }
                if (sidePaneItem.getIcon() != null) {
                    int n4 = this._displayOrientation == 0 ? sidePaneItem.getIcon().getIconHeight() : sidePaneItem.getIcon().getIconWidth();
                    n += 2;
                    n += n4;
                }
                n += this._itemGap;
                if (this._alwaysShowText || this._showText && sidePaneGroup.getSelectedItem().equals(sidePaneItem)) {
                    if (sidePaneItem.getTitle().length() != 0) {
                        n += this._iconTextGap;
                    }
                    n += n2;
                }
                ++n;
            }
            n += this._groupGap;
        }
        return n;
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected boolean isRoundedCorner() {
        return "true".equals(SecurityUtils.getProperty("shadingtheme", "false"));
    }

    class NonrolloverMouseInputListener
    implements MouseInputListener {
        private SidePaneItem _oldSelectedItem = null;

        NonrolloverMouseInputListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int n = BasicSidePaneUI.this.getSelectedItemIndex(mouseEvent.getPoint());
            if (n != -1) {
                SidePaneItem sidePaneItem = BasicSidePaneUI.this.getItemForIndex(n);
                if (sidePaneItem == null) {
                    this.resetOldSelectedItem(mouseEvent);
                    return;
                }
                if (!sidePaneItem.equals(this._oldSelectedItem)) {
                    this.resetOldSelectedItem(mouseEvent);
                    this._oldSelectedItem = sidePaneItem;
                    SidePaneGroup sidePaneGroup = BasicSidePaneUI.this.getGroupForIndex(n);
                    sidePaneGroup.setSelectedItem(sidePaneItem);
                    BasicSidePaneUI.this._sidePane.repaint();
                }
                sidePaneItem.getMouseListener().mouseEntered(mouseEvent);
                sidePaneItem.getMouseListener().mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            SidePaneItem sidePaneItem;
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int n = BasicSidePaneUI.this.getSelectedItemIndex(mouseEvent.getPoint());
            if (n != -1 && (sidePaneItem = BasicSidePaneUI.this.getItemForIndex(n)) != null) {
                sidePaneItem.getMouseListener().mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SidePaneItem sidePaneItem;
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int n = BasicSidePaneUI.this.getSelectedItemIndex(mouseEvent.getPoint());
            if (n != -1 && (sidePaneItem = BasicSidePaneUI.this.getItemForIndex(n)) != null) {
                sidePaneItem.getMouseListener().mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private void resetOldSelectedItem(MouseEvent mouseEvent) {
            if (this._oldSelectedItem != null) {
                this._oldSelectedItem.getMouseListener().mouseExited(mouseEvent);
                this._oldSelectedItem = null;
            }
        }
    }

    class RolloverMouseInputListener
    implements MouseInputListener {
        private SidePaneItem _oldSelectedItem = null;

        RolloverMouseInputListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SidePaneItem sidePaneItem;
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int n = BasicSidePaneUI.this.getSelectedItemIndex(mouseEvent.getPoint());
            if (n != -1 && (sidePaneItem = BasicSidePaneUI.this.getItemForIndex(n)) != null) {
                sidePaneItem.getMouseListener().mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            SidePaneItem sidePaneItem;
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int n = BasicSidePaneUI.this.getSelectedItemIndex(mouseEvent.getPoint());
            if (n != -1 && (sidePaneItem = BasicSidePaneUI.this.getItemForIndex(n)) != null) {
                sidePaneItem.getMouseListener().mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SidePaneItem sidePaneItem;
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int n = BasicSidePaneUI.this.getSelectedItemIndex(mouseEvent.getPoint());
            if (n != -1 && (sidePaneItem = BasicSidePaneUI.this.getItemForIndex(n)) != null) {
                sidePaneItem.getMouseListener().mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this._oldSelectedItem != null) {
                this._oldSelectedItem.getMouseListener().mouseExited(mouseEvent);
                this._oldSelectedItem = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (BasicSidePaneUI.this._rects == null) {
                return;
            }
            int n = BasicSidePaneUI.this.getSelectedItemIndex(mouseEvent.getPoint());
            if (n != -1) {
                SidePaneItem sidePaneItem = BasicSidePaneUI.this.getItemForIndex(n);
                if (sidePaneItem == null) {
                    this.resetOldSelectedItem(mouseEvent);
                    return;
                }
                if (!sidePaneItem.equals(this._oldSelectedItem)) {
                    this.resetOldSelectedItem(mouseEvent);
                    sidePaneItem.getMouseListener().mouseEntered(mouseEvent);
                    this._oldSelectedItem = sidePaneItem;
                }
                sidePaneItem.getMouseListener().mouseMoved(mouseEvent);
                SidePaneGroup sidePaneGroup = BasicSidePaneUI.this.getGroupForIndex(n);
                if (sidePaneGroup != null) {
                    sidePaneGroup.setSelectedItem(sidePaneItem);
                    BasicSidePaneUI.this._sidePane.repaint();
                }
            }
        }

        private void resetOldSelectedItem(MouseEvent mouseEvent) {
            if (this._oldSelectedItem != null) {
                this._oldSelectedItem.getMouseListener().mouseExited(mouseEvent);
                this._oldSelectedItem = null;
            }
        }
    }

    class DropListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            MouseEvent mouseEvent = new MouseEvent(BasicSidePaneUI.this._sidePane, 506, 0L, 0, dropTargetDragEvent.getLocation().x, dropTargetDragEvent.getLocation().y, 0, false);
            BasicSidePaneUI.this._inputListener.mouseMoved(mouseEvent);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }
    }
}

