/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.NestedTableHeaderUIDelegate;
import com.jidesoft.plaf.basic.BasicAutoFilterTableHeaderUIDelegate;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BasicNestedTableHeaderUIDelegate
extends BasicAutoFilterTableHeaderUIDelegate
implements NestedTableHeaderUIDelegate {
    private TableColumnGroup _resizingGroup;
    private List<TableColumn> _columnList;
    private List<Integer> _widthList;
    private int _resizingColumnWidth;
    private Point _mousePosition;
    private int[] _rowHeights;
    private Map<TableColumnGroup, StyledLabel> _columnGroupStyledLabelMap;
    private Map<TableColumnGroup, Integer> _columnGroupPreferredHeightMap;
    private Set<TableColumn> _groupMap;
    private Map<TableColumnGroup, Rectangle> _columnGroupRectangleMap;

    public BasicNestedTableHeaderUIDelegate(JTableHeader jTableHeader, CellRendererPane cellRendererPane) {
        super(jTableHeader, cellRendererPane);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this._groupMap = new HashSet<TableColumn>();
        this._columnGroupRectangleMap = new HashMap<TableColumnGroup, Rectangle>();
        try {
            super.paint(graphics, jComponent);
        }
        finally {
            this._groupMap.clear();
            this._columnGroupRectangleMap.clear();
        }
    }

    @Override
    protected void customizePaint(Graphics graphics, TableColumn tableColumn, Rectangle rectangle) {
        if (tableColumn instanceof TableColumnGroup) {
            return;
        }
        Enumeration enumeration = ((NestedTableHeader)this._header).getColumnGroups(tableColumn);
        if (enumeration != null) {
            rectangle = new Rectangle(rectangle);
            rectangle.y = 0;
            int n = 0;
            while (enumeration.hasMoreElements()) {
                TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
                Rectangle rectangle2 = this._columnGroupRectangleMap.get(tableColumnGroup);
                if (rectangle2 == null) {
                    int n2;
                    rectangle2 = new Rectangle(rectangle);
                    Dimension dimension = tableColumnGroup.getSize(this._header.getTable());
                    int n3 = n2 = this._header.getComponentOrientation().isLeftToRight() ? tableColumnGroup.getColumnIndex() : tableColumnGroup.getLastColumnIndex();
                    if (n2 >= 0 && n2 < this._header.getColumnModel().getColumnCount()) {
                        rectangle2.x = this._header.getHeaderRect((int)n2).x;
                    }
                    rectangle2.width = dimension.width;
                    rectangle2.height = dimension.height;
                    this._columnGroupRectangleMap.put(tableColumnGroup, rectangle2);
                }
                if (!this._groupMap.contains(tableColumnGroup)) {
                    this.customizePaint(graphics, tableColumnGroup, rectangle2);
                    this.paintCell(graphics, rectangle2, tableColumnGroup);
                    this._groupMap.add(tableColumnGroup);
                }
                rectangle.height = this._header.getHeight() - (n += rectangle2.height);
                rectangle.y = n;
            }
        }
    }

    @Override
    protected TableCellRenderer getHeaderRenderer(TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = null;
        if (tableColumn instanceof TableColumnGroup) {
            if (this._header instanceof AutoFilterTableHeader && ((AutoFilterTableHeader)this._header).isAutoFilterEnabled()) {
                tableCellRenderer = ((AutoFilterTableHeader)this._header).getAutoFilterTableHeaderRenderer();
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = ((TableColumnGroup)tableColumn).getDefaultHeaderRenderer();
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = this._header.getDefaultRenderer();
            }
        } else {
            tableCellRenderer = super.getHeaderRenderer(tableColumn);
        }
        return tableCellRenderer;
    }

    @Override
    protected void paintCell(Graphics graphics, Rectangle rectangle, int n, Object object, boolean bl, boolean bl2, boolean bl3) {
        TableColumn tableColumn;
        int n2;
        boolean bl4;
        boolean bl5 = bl4 = !(this._header instanceof NestedTableHeader) || ((NestedTableHeader)this._header).isOriginalTableHeaderVisible();
        if (!bl4 && this._header.getColumnModel() != null && n >= 0 && n < this._header.getColumnModel().getColumnCount() && this._header instanceof NestedTableHeader && (n2 = ((NestedTableHeader)this._header).getLevel(tableColumn = this._header.getColumnModel().getColumn(n))) < ((NestedTableHeader)this._header).getRowCount()) {
            bl4 = true;
        }
        if (bl4) {
            super.paintCell(graphics, rectangle, n, object, bl, bl2, bl3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintCell(Graphics graphics, Rectangle rectangle, TableColumnGroup tableColumnGroup) {
        Object object;
        boolean bl = false;
        if (this._columnGroupRectangleMap != null && (object = this._columnGroupRectangleMap.get(tableColumnGroup)) != null && this._mousePosition != null && ((Rectangle)object).contains(this._mousePosition)) {
            bl = true;
        }
        if (this._columnGroupStyledLabelMap == null) {
            this._columnGroupStyledLabelMap = new HashMap<TableColumnGroup, StyledLabel>();
        }
        object = tableColumnGroup.getHeaderValue();
        TableCellRenderer tableCellRenderer = this.getHeaderRenderer(tableColumnGroup);
        if (tableCellRenderer == null) {
            return;
        }
        int n = this.getLevel(tableColumnGroup);
        int n2 = tableColumnGroup.getColumnIndex();
        Component component = tableCellRenderer.getTableCellRendererComponent(this._header.getTable(), object, false, false, n, -2 - n2);
        if (!this._header.isEnabled()) {
            component.setEnabled(this._header.isEnabled());
        }
        StyledLabel styledLabel = null;
        if (object != null) {
            StyledLabel styledLabel2;
            styledLabel = this._columnGroupStyledLabelMap.get(tableColumnGroup);
            String string = object.toString();
            if (styledLabel == null) {
                styledLabel = StyledLabelBuilder.createStyledLabel(string);
                this._columnGroupStyledLabelMap.put(tableColumnGroup, styledLabel);
            }
            if (JideSwingUtilities.equals(string, styledLabel.getText())) {
                styledLabel = null;
            }
            if (component instanceof JLabel && !JideSwingUtilities.equals(((JLabel)component).getText(), object) && !JideSwingUtilities.equals((styledLabel2 = StyledLabelBuilder.createStyledLabel(((JLabel)component).getText())).getText(), ((JLabel)component).getText())) {
                styledLabel = styledLabel2;
                this._columnGroupStyledLabelMap.put(tableColumnGroup, styledLabel);
                this.clearHeightsCache(true, true);
            }
        }
        if (styledLabel != null && component instanceof JLabel) {
            ((JLabel)component).setText("");
        }
        this.customizeRendererComponent(component, n, n2, rectangle);
        this._rendererPane.paintComponent(graphics, component, this._header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        this.releaseRendererComponent(component, n, n2, rectangle);
        if (styledLabel != null && component instanceof JLabel) {
            Insets insets;
            int n3 = rectangle.x;
            int n4 = rectangle.y;
            int n5 = rectangle.width;
            int n6 = rectangle.height;
            Border border = ((JLabel)component).getBorder();
            if (border != null && (insets = border.getBorderInsets(component)) != null) {
                n4 += insets.top;
                n6 -= insets.top + insets.bottom;
                n5 -= insets.left + insets.right;
                n3 = this._header.getComponentOrientation().isLeftToRight() ? (n3 += insets.left) : (n3 += insets.right);
            }
            styledLabel.setOpaque(false);
            this.configureStyledLabel(component, styledLabel);
            this.customizeRendererComponent(styledLabel, n, n2, new Rectangle(n3, n4, n5, n6));
            int n7 = styledLabel.getPreferredWidth();
            try {
                styledLabel.setPreferredWidth(n5);
                styledLabel.setSize(n5, n6);
                this._rendererPane.paintComponent(graphics, styledLabel, this._header, n3, n4, n5, n6);
            }
            finally {
                styledLabel.setPreferredWidth(n7);
            }
            this.releaseRendererComponent(styledLabel, n, n2, new Rectangle(n3, n4, n5, n6));
        }
    }

    private int getLevel(TableColumnGroup tableColumnGroup) {
        int n = 0;
        for (TableColumnGroup tableColumnGroup2 = tableColumnGroup.getParent(); tableColumnGroup2 != null; tableColumnGroup2 = tableColumnGroup2.getParent()) {
            ++n;
        }
        return n;
    }

    @Override
    protected int getHeaderPreferredHeight() {
        if (!(this._header instanceof NestedTableHeader)) {
            return super.getHeaderPreferredHeight();
        }
        int n = 0;
        int n2 = ((NestedTableHeader)this._header).getRowCount();
        for (int i = 0; i < n2; ++i) {
            n += this.getRowPreferredHeight(i);
        }
        return n;
    }

    @Override
    public TableColumn getResizingColumn(Point point, int n) {
        int n2;
        if (n == -1) {
            return null;
        }
        int n3 = ((NestedTableHeader)this._header).rowAtPoint(point);
        if (n3 < 0) {
            return null;
        }
        Rectangle rectangle = ((NestedTableHeader)this._header).getCellRect(n3, n);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n4 = rectangle.x + rectangle.width / 2;
        if (this._header.getComponentOrientation().isLeftToRight()) {
            n2 = point.x < n4 ? n - 1 : n;
        } else {
            int n5 = n2 = point.x < n4 ? n : n - 1;
        }
        if (n2 == -1) {
            return null;
        }
        return this._header.getColumnModel().getColumn(n2);
    }

    @Override
    protected void startResizingColumn(Point point, TableColumn tableColumn) {
        int n;
        int n2;
        TableColumnGroup tableColumnGroup;
        if (this._header instanceof NestedTableHeader && (tableColumnGroup = ((NestedTableHeader)this._header).getTableColumnGroup(n2 = ((NestedTableHeader)this._header).rowAtPoint(point), n = this.viewIndexForColumn(tableColumn))) != null) {
            this.recordAllColumnsInGroup(tableColumnGroup);
        }
    }

    private void processMouseReleased(MouseEvent mouseEvent) {
        this._resizingGroup = null;
        this._columnList = null;
        this._widthList = null;
        this._resizingColumnWidth = -1;
    }

    @Override
    protected void dragColumn(int n, int n2) {
        int n3;
        int n4;
        Object object;
        int n5 = n2 - this._mouseXOffset;
        int n6 = n5 < 0 ? -1 : 1;
        int n7 = n + (this._header.getComponentOrientation().isLeftToRight() ? n6 : -n6);
        if (!(this._header instanceof NestedTableHeader)) {
            super.dragColumn(n, n2);
            return;
        }
        if (0 <= n7 && n7 < this._header.getColumnModel().getColumnCount() && (object = this._header.getColumnModel().getColumn(n7)) != null && !this.isColumnDraggable(((TableColumn)object).getModelIndex())) {
            super.dragColumn(n, n2);
            return;
        }
        object = this._header.getColumnModel();
        NestedTableHeader nestedTableHeader = (NestedTableHeader)this._header;
        TableColumnGroup tableColumnGroup = (TableColumnGroup)nestedTableHeader.getParent(this._header.getDraggedColumn());
        int n8 = object.getColumnCount() - 1;
        int n9 = 0;
        if (tableColumnGroup != null) {
            List list = tableColumnGroup.getChildren();
            n4 = object.getColumnCount() - 1;
            n3 = 0;
            for (Object e : list) {
                int n10 = -1;
                if (e instanceof TableColumnGroup) {
                    n10 = ((TableColumnGroup)e).getColumnIndex();
                    if (n10 < 0) continue;
                    if (n10 > n) {
                        if (n10 > n8) continue;
                        n8 = n10 - 1;
                        continue;
                    }
                    if (n10 < n9) continue;
                    n9 = n10 + 1;
                    n10 = ((TableColumnGroup)e).getLastColumnIndex();
                    if (n10 < n9) continue;
                    n9 = n10 + 1;
                    continue;
                }
                if (e instanceof TableColumn) {
                    n10 = this.viewIndexForColumn((TableColumn)e);
                }
                if (n10 < 0) continue;
                if (n10 > n3) {
                    n3 = n10;
                }
                if (n10 >= n4) continue;
                n4 = n10;
            }
            n3 = Math.min(n3, n8);
            n4 = Math.max(n4, n9);
        } else {
            n3 = n + 1;
            for (n4 = n - 1; n4 >= 0 && nestedTableHeader.getParent(object.getColumn(n4)) == null; --n4) {
            }
            while (n3 < object.getColumnCount() && nestedTableHeader.getParent(object.getColumn(n3)) == null) {
                ++n3;
            }
            ++n4;
            --n3;
        }
        if (n4 <= n7 && n7 <= n3) {
            int n11 = object.getColumn(n7).getWidth();
            if (Math.abs(n5) > n11 / 2) {
                this._mouseXOffset += n6 * n11;
                this._header.setDraggedDistance(n5 - n6 * n11);
                object.moveColumn(n, n7);
                return;
            }
        }
        this.setDraggedDistance(n, n5);
    }

    @Override
    protected void resizeColumn(TableColumn tableColumn, int n) {
        if (this._resizingGroup == null) {
            super.resizeColumn(tableColumn, n);
        } else {
            this.resizeAllColumnsInGroup(n);
        }
    }

    private void recordAllColumnsInGroup(TableColumnGroup tableColumnGroup) {
        this._columnList = new ArrayList<TableColumn>();
        this._widthList = new ArrayList<Integer>();
        this.getChildTableColumn(tableColumnGroup);
        TableColumn tableColumn = this._header.getResizingColumn();
        this._resizingColumnWidth = tableColumn.getWidth();
        for (TableColumn tableColumn2 : this._columnList) {
            this._widthList.add(tableColumn2.getWidth());
        }
        this._resizingGroup = tableColumnGroup;
    }

    private void resizeAllColumnsInGroup(int n) {
        int n2 = n - this._resizingColumnWidth;
        int n3 = n2 / this._columnList.size();
        int n4 = n2 % this._columnList.size();
        for (int i = 0; i < this._columnList.size(); ++i) {
            TableColumn tableColumn = this._columnList.get(i);
            int n5 = this._widthList.get(i) + (i < n4 ? n3 + 1 : n3);
            tableColumn.setWidth(n5);
            tableColumn.setPreferredWidth(n5);
        }
    }

    private void getChildTableColumn(TableColumnGroup tableColumnGroup) {
        List list = tableColumnGroup.getChildren();
        for (Object e : list) {
            if (e == null) continue;
            if (e instanceof TableColumnGroup) {
                this.getChildTableColumn((TableColumnGroup)e);
                continue;
            }
            if (!(e instanceof TableColumn)) continue;
            this._columnList.add((TableColumn)e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.processMouseReleased(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        this._mousePosition = mouseEvent.getPoint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this._mousePosition = null;
    }

    @Override
    void clearHeightsCache(boolean bl, boolean bl2) {
        int n;
        super.clearHeightsCache(bl, bl2);
        int n2 = n = this._header instanceof NestedTableHeader ? ((NestedTableHeader)this._header).getRowCount() : 1;
        if (!bl2 || this._rowHeights == null || this._rowHeights.length != n) {
            this._rowHeights = new int[n];
            Arrays.fill(this._rowHeights, -1);
        } else if (this._header instanceof NestedTableHeader && this._styledLabels != null) {
            for (int i = 0; i < ((NestedTableHeader)this._header).getRowCount(); ++i) {
                this._rowHeights[i] = -1;
            }
        }
        if (this._columnGroupPreferredHeightMap != null) {
            if (this._columnGroupStyledLabelMap == null || !bl2) {
                this._columnGroupPreferredHeightMap.clear();
            } else {
                Set<TableColumnGroup> set = this._columnGroupPreferredHeightMap.keySet();
                ArrayList<TableColumnGroup> arrayList = new ArrayList<TableColumnGroup>();
                for (TableColumnGroup tableColumnGroup : set) {
                    StyledLabel styledLabel = this._columnGroupStyledLabelMap.get(tableColumnGroup);
                    if (styledLabel != null && JideSwingUtilities.equals(styledLabel.getText(), tableColumnGroup.getHeaderValue())) continue;
                    arrayList.add(tableColumnGroup);
                }
                for (TableColumnGroup tableColumnGroup : arrayList) {
                    this._columnGroupPreferredHeightMap.remove(tableColumnGroup);
                    int n3 = this.getLevel(tableColumnGroup);
                    if (this._rowHeights == null || n3 < 0 || n3 >= this._rowHeights.length) continue;
                    this._rowHeights[n3] = -1;
                }
            }
        }
    }

    @Override
    void clearStyledLabelCache() {
        super.clearStyledLabelCache();
        if (this._columnGroupStyledLabelMap != null) {
            this._columnGroupStyledLabelMap.clear();
            this._columnGroupStyledLabelMap = null;
        }
    }

    private int getVisibleColumnCount(TableColumnGroup tableColumnGroup) {
        if (tableColumnGroup == null) {
            return 0;
        }
        int n = 0;
        for (Object e : tableColumnGroup.getChildren()) {
            if (e instanceof TableColumnGroup) {
                n += this.getVisibleColumnCount((TableColumnGroup)e);
                continue;
            }
            if (!(e instanceof TableColumn) || !TableColumnChooser.isVisibleColumn(this._header.getColumnModel(), (TableColumn)e)) continue;
            ++n;
        }
        return n;
    }

    private int getAvailableWidth(TableColumnGroup tableColumnGroup) {
        if (tableColumnGroup == null) {
            return -1;
        }
        int n = 0;
        for (Object e : tableColumnGroup.getChildren()) {
            if (e instanceof TableColumnGroup) {
                n += this.getSize((TableColumnGroup)((TableColumnGroup)e)).width;
                continue;
            }
            if (!(e instanceof TableColumn) || !TableColumnChooser.isVisibleColumn(this._header.getColumnModel(), (TableColumn)e)) continue;
            n += ((TableColumn)e).getWidth() + (this._header instanceof NestedTableHeader ? ((NestedTableHeader)this._header).getMargin() : 0);
        }
        return n;
    }

    @Override
    public Dimension getSize(TableColumnGroup tableColumnGroup) {
        return new Dimension(this.getAvailableWidth(tableColumnGroup), this.getRowPreferredHeight(((NestedTableHeader)this._header).getRowAt(tableColumnGroup)));
    }

    @Override
    public int getPreferredWidth(TableColumnGroup tableColumnGroup) {
        Object object;
        if (this._columnGroupStyledLabelMap == null) {
            this._columnGroupStyledLabelMap = new HashMap<TableColumnGroup, StyledLabel>();
        }
        Object object2 = tableColumnGroup.getHeaderValue();
        TableCellRenderer tableCellRenderer = this.getHeaderRenderer(tableColumnGroup);
        if (tableCellRenderer == null) {
            return -1;
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this._header.getTable(), object2, false, false, 0, -2);
        StyledLabel styledLabel = null;
        if (object2 != null) {
            styledLabel = this._columnGroupStyledLabelMap.get(tableColumnGroup);
            object = object2.toString();
            if (styledLabel == null) {
                styledLabel = StyledLabelBuilder.createStyledLabel((String)object);
                this._columnGroupStyledLabelMap.put(tableColumnGroup, styledLabel);
            }
            if (JideSwingUtilities.equals(object, styledLabel.getText())) {
                styledLabel = null;
            }
        }
        object = component.getPreferredSize();
        if (styledLabel != null && component instanceof JLabel) {
            Border border = ((JComponent)component).getBorder();
            Insets insets = border != null ? border.getBorderInsets(component) : UIManager.getInsets("TableHeader.DefaultRendererInsets");
            this.configureStyledLabel(component, styledLabel);
            object = styledLabel.getPreferredSize();
            if (insets != null) {
                ((Dimension)object).width += insets.left + insets.right;
            }
        }
        return ((Dimension)object).width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPreferredHeight(TableColumnGroup tableColumnGroup) {
        Object object;
        Integer n;
        if (tableColumnGroup == null) {
            return -1;
        }
        if (this._columnGroupPreferredHeightMap == null) {
            this._columnGroupPreferredHeightMap = new HashMap<TableColumnGroup, Integer>();
        }
        if ((n = this._columnGroupPreferredHeightMap.get(tableColumnGroup)) != null) {
            return n;
        }
        if (this._columnGroupStyledLabelMap == null) {
            this._columnGroupStyledLabelMap = new HashMap<TableColumnGroup, StyledLabel>();
        }
        Object object2 = tableColumnGroup.getHeaderValue();
        TableCellRenderer tableCellRenderer = this.getHeaderRenderer(tableColumnGroup);
        if (tableCellRenderer == null) {
            return -1;
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this._header.getTable(), object2, false, false, 0, -2);
        StyledLabel styledLabel = null;
        if (object2 != null) {
            styledLabel = this._columnGroupStyledLabelMap.get(tableColumnGroup);
            object = object2.toString();
            if (styledLabel == null) {
                styledLabel = StyledLabelBuilder.createStyledLabel((String)object);
                this._columnGroupStyledLabelMap.put(tableColumnGroup, styledLabel);
            }
            if (JideSwingUtilities.equals(object, styledLabel.getText())) {
                styledLabel = null;
            }
        }
        object = component.getPreferredSize();
        if (styledLabel != null && component instanceof JLabel) {
            int n2 = this.getAvailableWidth(tableColumnGroup);
            Border border = ((JComponent)component).getBorder();
            Insets insets = border != null ? border.getBorderInsets(component) : UIManager.getInsets("TableHeader.DefaultRendererInsets");
            if (insets != null) {
                n2 -= insets.left + insets.right;
            }
            int n3 = styledLabel.getPreferredWidth();
            try {
                this.configureStyledLabel(component, styledLabel);
                styledLabel.setPreferredWidth(n2);
                styledLabel.setSize(new Dimension(n2, 0));
                object = styledLabel.getPreferredSize();
            }
            finally {
                styledLabel.setPreferredWidth(n3);
            }
            if (insets != null) {
                ((Dimension)object).height += insets.top + insets.bottom;
            }
        }
        this._columnGroupPreferredHeightMap.put(tableColumnGroup, ((Dimension)object).height);
        return ((Dimension)object).height;
    }

    @Override
    public int getRowPreferredHeight(int n) {
        int n2;
        int n3 = n2 = this._header instanceof NestedTableHeader ? ((NestedTableHeader)this._header).getRowCount() : 1;
        if (this._rowHeights == null || this._rowHeights.length != n2) {
            this._rowHeights = new int[n2];
            Arrays.fill(this._rowHeights, -1);
        }
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this._rowHeights[n] >= 0) {
            return this._rowHeights[n];
        }
        this.calculateRowHeights();
        this.calculateRowHeights();
        return Math.max(this._rowHeights[n], 0);
    }

    private void calculateRowHeights() {
        int n = this._header instanceof NestedTableHeader ? ((NestedTableHeader)this._header).getRowCount() : 1;
        int n2 = this._header.getColumnModel().getColumnCount();
        for (int i = n - 1; i >= 0; --i) {
            int n3;
            int n4;
            int n5;
            this._rowHeights[i] = -1;
            if (i == n - 1 && (!(this._header instanceof NestedTableHeader) || ((NestedTableHeader)this._header).isOriginalTableHeaderVisible())) {
                JTable[] jTableArray;
                for (n5 = 0; n5 < n2; ++n5) {
                    int n6 = this.getPreferredHeight(n5);
                    if ((n6 = this.adjustedRowHeight(this._header, n6, i, n5)) <= this._rowHeights[i]) continue;
                    this._rowHeights[i] = n6;
                }
                if (this._header.getTable() == null || !(this._header.getTable().getClientProperty("TableScrollPane.Parent") instanceof TableScrollPane)) continue;
                TableScrollPane tableScrollPane = (TableScrollPane)this._header.getTable().getClientProperty("TableScrollPane.Parent");
                JTable[] jTableArray2 = jTableArray = tableScrollPane.getAllChildTables();
                n4 = jTableArray2.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    JTable jTable = jTableArray2[n3];
                    if (jTable == this._header.getTable() || jTable == null || jTable.getTableHeader() == null || jTable.getColumnCount() <= 0 || !(jTable.getTableHeader().getUI() instanceof DelegateTableHeaderUI) || !(((DelegateTableHeaderUI)((Object)jTable.getTableHeader().getUI())).getHeaderUIDelegate() instanceof BasicCellStyleTableHeaderUIDelegate)) continue;
                    BasicCellStyleTableHeaderUIDelegate basicCellStyleTableHeaderUIDelegate = (BasicCellStyleTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)jTable.getTableHeader().getUI())).getHeaderUIDelegate();
                    for (int j = 0; j < jTable.getColumnCount(); ++j) {
                        int n7 = basicCellStyleTableHeaderUIDelegate.getPreferredHeight(j);
                        n7 = this.adjustedRowHeight(jTable.getTableHeader(), n7, i, j);
                        if (n7 <= this._rowHeights[i]) continue;
                        this._rowHeights[i] = n7;
                    }
                }
                continue;
            }
            if (!(this._header instanceof NestedTableHeader)) continue;
            n5 = 0;
            while (n5 < n2) {
                TableColumn tableColumn;
                TableColumnGroup tableColumnGroup = ((NestedTableHeader)this._header).getTableColumnGroup(i, n5);
                if (tableColumnGroup != null) {
                    n5 += this.getVisibleColumnCount(tableColumnGroup);
                    int n8 = this.getPreferredHeight(tableColumnGroup);
                    if (n8 <= this._rowHeights[i]) continue;
                    this._rowHeights[i] = n8;
                    continue;
                }
                if (!((NestedTableHeader)this._header).isOriginalTableHeaderVisible() && (n4 = ((NestedTableHeader)this._header).getLevel(tableColumn = this._header.getColumnModel().getColumn(n5))) < ((NestedTableHeader)this._header).getRowCount() && (n3 = this.getPreferredHeight(n5)) > this._rowHeights[i]) {
                    this._rowHeights[i] = n3;
                }
                ++n5;
            }
        }
    }

    private int adjustedRowHeight(JTableHeader jTableHeader, int n, int n2, int n3) {
        int n4;
        TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n3);
        for (int i = n4 = jTableHeader instanceof NestedTableHeader ? ((NestedTableHeader)jTableHeader).getRowAt(tableColumn) : 0; i < n2; ++i) {
            n -= this._rowHeights[i];
        }
        return n;
    }
}

