/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.icons.ColorFilter;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.plaf.CollapsiblePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.xerto.VerticalLabelUI;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicCollapsiblePaneTitlePane
extends JComponent
implements FocusListener {
    protected BasicCollapseButton _collapseButton;
    protected JComponent _titleLabel;
    protected JLabel _titleIconLabel;
    protected Component _titleComponent;
    protected JPopupMenu _popupMenu;
    protected CollapsiblePane _pane;
    protected PropertyChangeListener _propertyChangeListener;
    protected String _collapseText;
    protected String _collapseToolTip;
    protected ImageIcon _upIcon = (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.upIcon");
    protected ImageIcon _downIcon = (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.downIcon");
    protected ImageIcon _emphasizedUpIcon = (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.upIcon");
    protected ImageIcon _emphasizedDownIcon = (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.downIcon");
    protected ImageIcon _upRolloverIcon = (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.upRolloverIcon");
    protected ImageIcon _downRolloverIcon = (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.downRolloverIcon");
    protected Icon _collapsedIcon = UIDefaultsLookup.getIcon("Tree.collapsedIcon");
    protected Icon _expandedIcon = UIDefaultsLookup.getIcon("Tree.expandedIcon");
    private ThemePainter _painter;
    private DropTargetListener _dropListener;
    private DropTarget _dt;

    public BasicCollapsiblePaneTitlePane(CollapsiblePane collapsiblePane) {
        this._pane = collapsiblePane;
        this.setOpaque(false);
        this.installTitlePane();
        if (this._collapseButton != null) {
            this._collapseButton.setVisible(collapsiblePane.isCollapsible());
        }
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.createSubComponents();
        this.installListeners();
        this.setLayout(this.createLayout());
        this.addSubComponents();
    }

    protected void addSubComponents() {
        this.add(this._collapseButton);
        this.add(this._titleLabel);
        this.add(this._titleIconLabel);
        if (this._titleComponent != null) {
            this.add(this._titleComponent);
        }
    }

    protected void createActions() {
    }

    protected void installListeners() {
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createPropertyChangeListener();
        }
        this._pane.addPropertyChangeListener(this._propertyChangeListener);
        this.addMouseMotionListener(this._collapseButton);
        this.addMouseListener(this._collapseButton);
        this._pane.addKeyListener(this._collapseButton);
        this._pane.addFocusListener(this);
        if (this._pane.isAutoExpandOnDragover()) {
            this._dropListener = this.createDropListener();
            this._dt = new DropTarget(this, this._dropListener);
            this.setDropTarget(this._dt);
        }
    }

    protected DropListener createDropListener() {
        return new DropListener();
    }

    protected void uninstallListeners() {
        if (this._pane.isAutoExpandOnDragover() && this._dt != null && this._dropListener != null) {
            this._dt.removeDropTargetListener(this._dropListener);
            this._dropListener = null;
            this._dt = null;
            this.setDropTarget(null);
        }
        this._pane.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
        this.removeMouseListener(this._collapseButton);
        this.removeMouseMotionListener(this._collapseButton);
        this._pane.removeKeyListener(this._collapseButton);
        this._collapseButton = null;
        this._titleLabel = null;
        this._titleIconLabel = null;
        this._titleComponent = null;
        this._pane.removeFocusListener(this);
        this._pane = null;
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installBorder(this, "CollapsiblePane.titleBorder");
        if (this._pane == null) {
            ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
            this._collapseText = resourceBundle.getString("CollapsiblePane.collapseText");
            this._collapseToolTip = resourceBundle.getString("CollapsiblePane.collapseToolTip");
        } else {
            this._collapseText = this._pane.getResourceString("CollapsiblePane.collapseText");
            this._collapseToolTip = this._pane.getResourceString("CollapsiblePane.collapseToolTip");
        }
        JideSwingUtilities.installFont(this, UIDefaultsLookup.getFont("CollapsiblePane.titleFont"));
        this._upIcon = this.getPainter().getCollapsiblePaneUpIcon();
        this._downIcon = this.getPainter().getCollapsiblePaneDownIcon();
        this._emphasizedUpIcon = this.getPainter().getCollapsiblePaneUpIconEmphasized();
        this._emphasizedDownIcon = this.getPainter().getCollapsiblePaneDownIconEmphasized();
    }

    protected void uninstallDefaults() {
        this.removeAll();
        this.setLayout(null);
        this._collapseText = null;
        this._collapseToolTip = null;
        LookAndFeel.uninstallBorder(this);
        this._painter = null;
    }

    protected void createSubComponents() {
        this._collapseButton = this.createCollapseButton();
        this.setupCollapseButton(this._collapseButton);
        if (this._pane.isCollapsible()) {
            this._collapseButton.setCursor(Cursor.getPredefinedCursor(12));
        }
        this._titleLabel = this._pane.getTitleLabelComponent();
        if (this._titleLabel == null) {
            this._titleLabel = this.createDefaultTitleLabel();
        }
        this._titleLabel.setEnabled(this._pane.isEnabled());
        this._titleLabel.setName("CollapsiblePane.titleLabel");
        if (this._pane.isCollapsible() && this._pane.isCollapseOnTitleClick()) {
            this._titleLabel.setCursor(Cursor.getPredefinedCursor(12));
        }
        this.setLabelAttribute();
        this._titleIconLabel = new JLabel(){

            @Override
            public void setUI(LabelUI labelUI) {
                if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 7) {
                    VerticalLabelUI verticalLabelUI = new VerticalLabelUI(true);
                    verticalLabelUI.setRotateIcon(BasicCollapsiblePaneTitlePane.this._pane.isRotateIcon());
                    super.setUI(verticalLabelUI);
                } else if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 3) {
                    VerticalLabelUI verticalLabelUI = new VerticalLabelUI(false);
                    verticalLabelUI.setRotateIcon(BasicCollapsiblePaneTitlePane.this._pane.isRotateIcon());
                    super.setUI(verticalLabelUI);
                } else {
                    super.setUI(labelUI);
                }
            }
        };
        this._titleIconLabel.setEnabled(this._pane.isEnabled());
        this._titleComponent = this._pane.getTitleComponent();
        this.setIconLabelAttribute();
    }

    protected JLabel createDefaultTitleLabel() {
        return new TitleLabel();
    }

    protected BasicCollapseButton createCollapseButton() {
        BasicCollapseButton basicCollapseButton = new BasicCollapseButton();
        basicCollapseButton.setName("Collapse/Expand");
        return basicCollapseButton;
    }

    private void setLabelAttribute() {
        this._titleLabel.setOpaque(false);
        this._titleLabel.setFont(this.getFont());
        this.updateTitleColor();
        if (this._titleLabel instanceof TitleLabel) {
            JLabel jLabel = (JLabel)this._titleLabel;
            jLabel.setText(this._pane.getTitle());
            jLabel.setIcon(this._pane.getIcon());
            jLabel.setIconTextGap(this._pane.getIconTextGap());
            jLabel.setVerticalAlignment(this._pane.getVerticalAlignment());
            jLabel.setVerticalTextPosition(this._pane.getVerticalTextPosition());
            jLabel.setHorizontalAlignment(this._pane.getHorizontalAlignment());
            jLabel.setHorizontalTextPosition(this._pane.getHorizontalTextPosition());
        }
    }

    private void setIconLabelAttribute() {
        this._titleIconLabel.setOpaque(false);
        this._titleIconLabel.setFont(this.getFont());
        this._titleIconLabel.setIcon(this._pane.getTitleIcon());
        this._titleIconLabel.setBorder(BorderFactory.createEmptyBorder());
    }

    protected void setupCollapseButton(BasicCollapseButton basicCollapseButton) {
        if (this._collapseToolTip != null && this._collapseToolTip.length() != 0) {
            basicCollapseButton.setToolTipText(this._collapseToolTip);
        }
        if (this._pane != null) {
            basicCollapseButton.setStill(this._pane.getStyle() == 0);
            basicCollapseButton.setType(this._pane.isCollapsed() ? 1 : 0);
        }
    }

    protected void addPopupMenuItems(JPopupMenu jPopupMenu) {
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.paintBorder(graphics);
        this.paintTitleBackground(graphics);
        this.updateTitleColor();
        this._titleLabel.setFont(this.getFont());
    }

    protected void paintTitleBackground(Graphics graphics) {
        Rectangle rectangle;
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        Dimension dimension = this.getActualTitlePaneDimension();
        if (this._pane.getSlidingDirection() == 1 || this._pane.getSlidingDirection() == 5) {
            int n5 = this.getHeight();
            int n6 = dimension.height;
            rectangle = new Rectangle(n, n2 += this._pane.getSlidingDirection() == 5 ? n5 - n6 : 0, n3, n6);
        } else {
            int n7 = this.getWidth();
            int n8 = dimension.width;
            rectangle = new Rectangle(n += this._pane.getSlidingDirection() == 3 ? n7 - n8 : 0, n2, n8, n4);
        }
        if (this._pane.isTitlePaneOpaque()) {
            if (this._pane.getStyle() == 2) {
                if (this._pane.isEmphasized()) {
                    this.getPainter().paintCollapsiblePaneTitlePaneBackgroundPlainEmphasized(this._pane, graphics, rectangle, this._pane.getSlidingDirection(), this.isRollover() ? 2 : 0);
                } else {
                    this.getPainter().paintCollapsiblePaneTitlePaneBackgroundPlain(this._pane, graphics, rectangle, this._pane.getSlidingDirection(), this.isRollover() ? 2 : 0);
                }
            } else if (this._pane.getStyle() == 3) {
                if (this._pane.isEmphasized()) {
                    this.getPainter().paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(this._pane, graphics, rectangle, this._pane.getSlidingDirection(), this.isRollover() ? 2 : 0);
                } else {
                    this.getPainter().paintCollapsiblePaneTitlePaneBackgroundSeparator(this._pane, graphics, rectangle, this._pane.getSlidingDirection(), this.isRollover() ? 2 : 0);
                }
            } else if (this._pane.isEmphasized()) {
                this.getPainter().paintCollapsiblePaneTitlePaneBackgroundEmphasized(this._pane, graphics, rectangle, this._pane.getSlidingDirection(), this.isRollover() ? 2 : 0);
            } else {
                this.getPainter().paintCollapsiblePaneTitlePaneBackground(this._pane, graphics, rectangle, this._pane.getSlidingDirection(), this.isRollover() ? 2 : 0);
            }
        }
        if (this._pane.getSlidingDirection() == 1 || this._pane.getSlidingDirection() == 5) {
            this.paintFocusIndicator(graphics, n, n2, n3, dimension.height);
        } else {
            this.paintFocusIndicator(graphics, n, n2, dimension.width, n4);
        }
    }

    protected void paintFocusIndicator(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this._pane.isFocusPainted() && this._pane.hasFocus()) {
            if (this._pane.getStyle() == 2) {
                n += 2;
                n2 += 2;
                n3 -= 4;
                n4 -= 4;
            } else {
                ++n;
                ++n2;
                n4 -= 2;
                n3 -= 2;
            }
            graphics.setColor(this.getCollapsiblePaneForeground());
            BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
        }
    }

    protected Dimension getActualTitlePaneDimension() {
        int n = 0;
        int n2 = 0;
        if (this._titleLabel != null) {
            n += this._titleLabel.getPreferredSize().width;
            n2 = Math.max(16, this._titleLabel.getPreferredSize().height);
        }
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(this._pane);
            n2 += insets.top + insets.bottom;
            n += insets.left + insets.right;
        }
        if (this._titleComponent != null) {
            n += this._titleComponent.getPreferredSize().width;
            n2 = Math.max(n2, this._titleComponent.getPreferredSize().height);
        }
        return new Dimension(n, n2);
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n) {
        String string2 = string;
        if (string2 == null || string2.equals("")) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string2);
        String string3 = "...";
        if (n2 > n) {
            int n3;
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string3);
            for (n3 = 0; n3 < string2.length() && (n4 += fontMetrics.charWidth(string2.charAt(n3))) <= n; ++n3) {
            }
            string2 = string2.substring(0, n3) + string3;
        }
        return string2;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new CollapsibleLayout();
    }

    protected void setBounds(Container container, Component component, int n, int n2, int n3, int n4) {
        if (this._pane.getSlidingDirection() == 1 || this._pane.getSlidingDirection() == 5) {
            JideSwingUtilities.setBounds(container, component, n, n2, n3, n4);
        } else {
            component.setBounds(n, n2, n3, n4);
        }
    }

    public void popupMenu(MouseEvent mouseEvent) {
        this._popupMenu.show(this, mouseEvent.getX() + 1, mouseEvent.getY() + 1);
        mouseEvent.consume();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public boolean isRollover() {
        return this._pane.isRollover();
    }

    public void setRollover(boolean bl) {
        this._pane.setRollover(bl);
    }

    private void updateTitleColor() {
        this._titleLabel.setForeground(this.getCollapsiblePaneForeground());
    }

    protected Color getCollapsiblePaneForeground() {
        Color color = this._pane.getForeground();
        if (color != null && !(color instanceof UIResource)) {
            return color;
        }
        if (this.isRollover()) {
            if (this._pane.getStyle() != 2 && this._pane.isEmphasized()) {
                return this.getPainter().getCollapsiblePaneFocusTitleForegroundEmphasized();
            }
            return this.getPainter().getCollapsiblePaneFocusTitleForeground();
        }
        if (this._pane.getStyle() != 2 && this._pane.isEmphasized()) {
            return this.getPainter().getCollapsiblePaneTitleForegroundEmphasized();
        }
        return this.getPainter().getCollapsiblePaneTitleForeground();
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected int getButtonSize() {
        return 14;
    }

    protected class BasicCollapseButton
    extends JButton
    implements MouseMotionListener,
    MouseListener,
    KeyListener {
        public static final int UP_BUTTON = 0;
        public static final int DOWN_BUTTON = 1;
        private int _type;
        private boolean _mousePressed = false;
        private boolean _still = true;
        private Point _pressedLocation = null;

        @Override
        public void updateUI() {
            super.updateUI();
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(null);
        }

        public BasicCollapseButton() {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public boolean isStill() {
            return this._still;
        }

        public void setStill(boolean bl) {
            this._still = bl;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            this.paintIcon(graphics);
        }

        protected void paintIcon(Graphics graphics) {
            Color color = BasicCollapsiblePaneTitlePane.this.getCollapsiblePaneForeground();
            if (BasicCollapsiblePaneTitlePane.this._pane.isEmphasized()) {
                switch (this._type) {
                    case 0: {
                        this.paintIcon(graphics, color, BasicCollapsiblePaneTitlePane.this._pane.getExpandedIcon() != null ? BasicCollapsiblePaneTitlePane.this._pane.getExpandedIcon() : BasicCollapsiblePaneTitlePane.this._expandedIcon, BasicCollapsiblePaneTitlePane.this._emphasizedUpIcon, BasicCollapsiblePaneTitlePane.this._upRolloverIcon);
                        break;
                    }
                    case 1: {
                        this.paintIcon(graphics, color, BasicCollapsiblePaneTitlePane.this._pane.getCollapsedIcon() != null ? BasicCollapsiblePaneTitlePane.this._pane.getCollapsedIcon() : BasicCollapsiblePaneTitlePane.this._collapsedIcon, BasicCollapsiblePaneTitlePane.this._emphasizedDownIcon, BasicCollapsiblePaneTitlePane.this._downRolloverIcon);
                    }
                }
            } else {
                switch (this._type) {
                    case 0: {
                        this.paintIcon(graphics, color, BasicCollapsiblePaneTitlePane.this._pane.getExpandedIcon() != null ? BasicCollapsiblePaneTitlePane.this._pane.getExpandedIcon() : BasicCollapsiblePaneTitlePane.this._expandedIcon, BasicCollapsiblePaneTitlePane.this._upIcon, BasicCollapsiblePaneTitlePane.this._upRolloverIcon);
                        break;
                    }
                    case 1: {
                        this.paintIcon(graphics, color, BasicCollapsiblePaneTitlePane.this._pane.getCollapsedIcon() != null ? BasicCollapsiblePaneTitlePane.this._pane.getCollapsedIcon() : BasicCollapsiblePaneTitlePane.this._collapsedIcon, BasicCollapsiblePaneTitlePane.this._downIcon, BasicCollapsiblePaneTitlePane.this._downRolloverIcon);
                    }
                }
            }
        }

        protected void paintIcon(Graphics graphics, Color color, Icon icon, ImageIcon imageIcon, ImageIcon imageIcon2) {
            Dimension dimension = BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 1 || BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 2 ? new Dimension(icon.getIconWidth(), icon.getIconHeight()) : new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            int n = dimension.width / 2;
            int n2 = dimension.height / 2;
            int n3 = this.getWidth() / 2 - n;
            int n4 = this.getHeight() / 2 - n2;
            Icon icon2 = BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 1 || BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 2 ? (BasicCollapsiblePaneTitlePane.this._pane.isEnabled() ? icon : IconsFactory.createBrighterImage(BasicCollapsiblePaneTitlePane.this._pane, icon)) : (this.isEnabled() ? (BasicCollapsiblePaneTitlePane.this.isRollover() && imageIcon2 != null ? new ImageIcon(MaskFilter.createImage(imageIcon2.getImage(), Color.black, color)) : new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color))) : (BasicCollapsiblePaneTitlePane.this.isRollover() && imageIcon2 != null ? new ImageIcon(ColorFilter.createBrighterImage(MaskFilter.createImage(imageIcon2.getImage(), Color.black, color))) : new ImageIcon(ColorFilter.createBrighterImage(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)))));
            icon2 = BasicCollapsiblePaneTitlePane.this._pane.rotateIcon(icon2);
            icon2.paintIcon(this, graphics, n3, n4);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JideSwingUtilities.retargetMouseEvent(506, mouseEvent, BasicCollapsiblePaneTitlePane.this._pane);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (BasicCollapsiblePaneTitlePane.this._pane.isEnabled() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible()) {
                BasicCollapsiblePaneTitlePane.this.setRollover(true);
                this.repaint();
            }
            JideSwingUtilities.retargetMouseEvent(503, mouseEvent, BasicCollapsiblePaneTitlePane.this._pane);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (BasicCollapsiblePaneTitlePane.this._pane.isEnabled() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this._mousePressed = false;
            }
            if (BasicCollapsiblePaneTitlePane.this._pane.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && BasicCollapsiblePaneTitlePane.this._pane.isRequestFocusEnabled()) {
                BasicCollapsiblePaneTitlePane.this._pane.requestFocus();
            }
            JideSwingUtilities.retargetMouseEvent(500, mouseEvent, BasicCollapsiblePaneTitlePane.this._pane);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicCollapsiblePaneTitlePane.this._pane.isEnabled() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this._mousePressed = true;
                    this.repaint();
                }
                try {
                    this._pressedLocation = BasicCollapsiblePaneTitlePane.this._pane.getLocationOnScreen();
                }
                catch (Exception exception) {
                    this._pressedLocation = null;
                }
            }
            JideSwingUtilities.retargetMouseEvent(501, mouseEvent, BasicCollapsiblePaneTitlePane.this._pane);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicCollapsiblePaneTitlePane.this._pane.isEnabled() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this._mousePressed && BasicCollapsiblePaneTitlePane.this.contains(mouseEvent.getPoint())) {
                    try {
                        Point point = BasicCollapsiblePaneTitlePane.this._pane.getLocationOnScreen();
                        if (point != null && point.equals(this._pressedLocation)) {
                            Action action = BasicCollapsiblePaneTitlePane.this._pane.getToggleAction();
                            if (action != null && action.isEnabled() && (mouseEvent.getSource() != BasicCollapsiblePaneTitlePane.this || BasicCollapsiblePaneTitlePane.this._pane.isCollapseOnTitleClick())) {
                                action.actionPerformed(new ActionEvent(this, mouseEvent.getID(), ""));
                            }
                            if (BasicCollapsiblePaneTitlePane.this._pane.isRequestFocusEnabled()) {
                                BasicCollapsiblePaneTitlePane.this._pane.requestFocus();
                            }
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this._pressedLocation = null;
                    }
                }
                this._mousePressed = false;
            }
            JideSwingUtilities.retargetMouseEvent(502, mouseEvent, BasicCollapsiblePaneTitlePane.this._pane);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Point point;
            Component component = ((CollapsiblePaneUI)BasicCollapsiblePaneTitlePane.this._pane.getUI()).getTitlePane();
            Point point2 = point = mouseEvent.getSource() == component ? mouseEvent.getPoint() : SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component);
            if (component.contains(point)) {
                if (BasicCollapsiblePaneTitlePane.this._pane.isEnabled() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible() && mouseEvent.getModifiers() != 16) {
                    BasicCollapsiblePaneTitlePane.this.setRollover(true);
                    this.repaint();
                }
                JideSwingUtilities.retargetMouseEvent(504, mouseEvent, BasicCollapsiblePaneTitlePane.this._pane);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Point point;
            Component component = ((CollapsiblePaneUI)BasicCollapsiblePaneTitlePane.this._pane.getUI()).getTitlePane();
            Point point2 = point = mouseEvent.getSource() == component ? mouseEvent.getPoint() : SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component);
            if (!component.contains(point)) {
                if (BasicCollapsiblePaneTitlePane.this._pane.isEnabled() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible() && mouseEvent.getModifiers() != 16) {
                    BasicCollapsiblePaneTitlePane.this.setRollover(false);
                    this._mousePressed = false;
                    this.repaint();
                }
                JideSwingUtilities.retargetMouseEvent(505, mouseEvent, BasicCollapsiblePaneTitlePane.this._pane);
            }
        }

        public int getType() {
            return this._type;
        }

        public void setType(int n) {
            this._type = n;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Action action;
            if ((keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == ' ') && (action = BasicCollapsiblePaneTitlePane.this._pane.getToggleAction()) != null) {
                action.actionPerformed(new ActionEvent(this, keyEvent.getID(), ""));
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class CollapsibleLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 1 || BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 5) {
                Dimension dimension;
                if (BasicCollapsiblePaneTitlePane.this._titleLabel != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleLabel.getPreferredSize();
                    n += dimension.width + BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap();
                    n2 = Math.max(16, dimension.height);
                }
                if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize();
                    n += dimension.width + 4;
                    n2 = Math.max(n2, dimension.height);
                }
                if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 0 && BasicCollapsiblePaneTitlePane.this._titleIconLabel != null && BasicCollapsiblePaneTitlePane.this._titleIconLabel.getIcon() != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleIconLabel.getPreferredSize();
                    n += dimension.width + 4;
                    n2 = Math.max(n2, dimension.height);
                }
                if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._collapseButton != null) {
                    int n3 = BasicCollapsiblePaneTitlePane.this.getButtonSize();
                    n += n3 + 4;
                }
            } else {
                Dimension dimension;
                if (BasicCollapsiblePaneTitlePane.this._titleLabel != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleLabel.getPreferredSize();
                    n2 += dimension.height + BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap();
                    n = Math.max(16, dimension.width);
                }
                if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize();
                    n2 += dimension.height + 4;
                    n = Math.max(n, dimension.width);
                }
                if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 0 && BasicCollapsiblePaneTitlePane.this._titleIconLabel != null && BasicCollapsiblePaneTitlePane.this._titleIconLabel.getIcon() != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleIconLabel.getPreferredSize();
                    n2 += dimension.height + 4;
                    n = Math.max(n, dimension.width);
                }
                if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._collapseButton != null) {
                    int n4 = BasicCollapsiblePaneTitlePane.this.getButtonSize();
                    n2 += n4 + 4;
                }
            }
            Dimension dimension = new Dimension(n, n2);
            if (BasicCollapsiblePaneTitlePane.this.getBorder() != null) {
                Insets insets = BasicCollapsiblePaneTitlePane.this.getBorder().getBorderInsets(container);
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            int n = 0;
            int n2 = 0;
            if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 1 || BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 5) {
                if (BasicCollapsiblePaneTitlePane.this._titleLabel != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleLabel.getMinimumSize();
                    n += dimension.width + BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap();
                    n2 = Math.max(16, dimension.height);
                }
                if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleComponent.getMinimumSize();
                    n += dimension.width + 4;
                    n2 = Math.max(n2, dimension.height);
                }
                if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 0 && BasicCollapsiblePaneTitlePane.this._titleIconLabel != null && BasicCollapsiblePaneTitlePane.this._titleIconLabel.getIcon() != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleIconLabel.getMinimumSize();
                    n += dimension.width + 4;
                    n2 = Math.max(n2, dimension.height);
                }
                if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._collapseButton != null) {
                    n += BasicCollapsiblePaneTitlePane.this.getButtonSize() + 4;
                }
            } else {
                if (BasicCollapsiblePaneTitlePane.this._titleLabel != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleLabel.getMinimumSize();
                    n2 += dimension.height + BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap();
                    n = Math.max(16, dimension.width);
                }
                if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleComponent.getMinimumSize();
                    n2 += dimension.height + 4;
                    n = Math.max(n, dimension.width);
                }
                if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 0 && BasicCollapsiblePaneTitlePane.this._titleIconLabel != null && BasicCollapsiblePaneTitlePane.this._titleIconLabel.getIcon() != null) {
                    dimension = BasicCollapsiblePaneTitlePane.this._titleIconLabel.getMinimumSize();
                    n2 += dimension.height + 4;
                    n = Math.max(n, dimension.width);
                }
                if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._collapseButton != null) {
                    n2 += BasicCollapsiblePaneTitlePane.this.getButtonSize() + 4;
                }
            }
            dimension = new Dimension(n, n2);
            if (BasicCollapsiblePaneTitlePane.this.getBorder() != null) {
                Insets insets = BasicCollapsiblePaneTitlePane.this.getBorder().getBorderInsets(container);
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            int n = BasicCollapsiblePaneTitlePane.this.getWidth();
            int n2 = BasicCollapsiblePaneTitlePane.this.getHeight();
            Insets insets = BasicCollapsiblePaneTitlePane.this.getInsets();
            if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 1 || BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 5) {
                int n3 = BasicCollapsiblePaneTitlePane.this.getActualTitlePaneDimension().height;
                if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 1 || BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 2) {
                    int n4;
                    int n5 = insets.left;
                    int n6 = 0;
                    if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible()) {
                        n4 = BasicCollapsiblePaneTitlePane.this.getButtonSize();
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._collapseButton, n5, n6 + (n2 - n4) / 2, n4, n4);
                        n5 += n4;
                    } else {
                        BasicCollapsiblePaneTitlePane.this._collapseButton.setBounds(0, 0, 0, 0);
                    }
                    n4 = BasicCollapsiblePaneTitlePane.this._titleComponent != null ? BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().width : 0;
                    BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleLabel, n5 += BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap(), n6, n - n5 - BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap() - n4, n2);
                    n5 = n - BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap() - n4;
                    if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                        int n7 = BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().height;
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleComponent, n5, n6 + (n2 - n7) / 2, n4, n7);
                    }
                } else {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = n - insets.right;
                    int n12 = n10 = BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 5 ? n2 - n3 : 0;
                    if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible()) {
                        n9 = BasicCollapsiblePaneTitlePane.this.getButtonSize();
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._collapseButton, n11 -= n9 + 4, n10 + (n3 - n9) / 2, n9, n9);
                    } else {
                        BasicCollapsiblePaneTitlePane.this._collapseButton.setBounds(0, 0, 0, 0);
                    }
                    n9 = BasicCollapsiblePaneTitlePane.this._titleComponent != null ? BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().width : 0;
                    n11 -= n9;
                    if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                        n8 = BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().height;
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleComponent, n11, n10 + (n3 - n8) / 2, n9, n8);
                    }
                    n8 = insets.left;
                    if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() != 3) {
                        if (BasicCollapsiblePaneTitlePane.this._titleIconLabel != null && BasicCollapsiblePaneTitlePane.this._titleIconLabel.getIcon() != null) {
                            int n13 = BasicCollapsiblePaneTitlePane.this._titleIconLabel.getPreferredSize().width;
                            BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleIconLabel, n8, insets.top + insets.bottom - 1, n13, BasicCollapsiblePaneTitlePane.this._titleIconLabel.getPreferredSize().height);
                            n8 += n13;
                        } else if (BasicCollapsiblePaneTitlePane.this._titleIconLabel != null) {
                            BasicCollapsiblePaneTitlePane.this._titleIconLabel.setBounds(0, 0, 0, 0);
                        }
                    }
                    BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleLabel, n8 + BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap(), n10, n11 - BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap() - n8, n3);
                }
            } else if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 7) {
                int n14 = BasicCollapsiblePaneTitlePane.this.getActualTitlePaneDimension().width;
                if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 1 || BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 2) {
                    int n15;
                    int n16 = insets.top + 4;
                    int n17 = 0;
                    if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible()) {
                        n15 = BasicCollapsiblePaneTitlePane.this.getButtonSize();
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._collapseButton, n17 + (n - n15) / 2, n16, n15, n15);
                        n16 += n15;
                    } else {
                        BasicCollapsiblePaneTitlePane.this._collapseButton.setBounds(0, 0, 0, 0);
                    }
                    n15 = BasicCollapsiblePaneTitlePane.this._titleComponent != null ? BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().height : 0;
                    BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleLabel, n17, n16 += BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap(), n, n2 - n16 - BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap() - n15);
                    n16 = n2 - BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap() - n15;
                    if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                        int n18 = BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().width;
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleComponent, n17 + (n - n18) / 2, n16, n18, n15);
                    }
                } else {
                    int n19;
                    int n20 = insets.top;
                    if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() != 3) {
                        if (BasicCollapsiblePaneTitlePane.this._titleIconLabel != null && BasicCollapsiblePaneTitlePane.this._titleIconLabel.getIcon() != null) {
                            n19 = BasicCollapsiblePaneTitlePane.this._titleIconLabel.getPreferredSize().height;
                            BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleIconLabel, insets.left + insets.right - 1, n20, BasicCollapsiblePaneTitlePane.this._titleIconLabel.getPreferredSize().width, n19);
                            n20 += n19 + 4;
                        } else if (BasicCollapsiblePaneTitlePane.this._titleIconLabel != null) {
                            BasicCollapsiblePaneTitlePane.this._titleIconLabel.setBounds(0, 0, 0, 0);
                        }
                    }
                    int n21 = n2 - insets.bottom;
                    int n22 = 0;
                    if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible()) {
                        n19 = BasicCollapsiblePaneTitlePane.this.getButtonSize();
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._collapseButton, n22 + (n14 - n19) / 2, n21 -= n19 + 4, n19, n19);
                    } else {
                        BasicCollapsiblePaneTitlePane.this._collapseButton.setBounds(0, 0, 0, 0);
                    }
                    n19 = BasicCollapsiblePaneTitlePane.this._titleComponent != null ? BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().height : 0;
                    n21 -= n19;
                    if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                        int n23 = BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().width;
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleComponent, n22 + (n14 - n23) / 2, n21, n23, n19);
                    }
                    BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleLabel, n22, n20 + BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap(), n14, n21 - BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap() - n20);
                }
            } else if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 3) {
                int n24 = BasicCollapsiblePaneTitlePane.this.getActualTitlePaneDimension().width;
                if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 1 || BasicCollapsiblePaneTitlePane.this._pane.getStyle() == 2) {
                    int n25;
                    int n26;
                    int n27 = n2 - insets.bottom;
                    int n28 = 0;
                    if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible()) {
                        n26 = BasicCollapsiblePaneTitlePane.this.getButtonSize();
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._collapseButton, n28 + (n - n26) / 2, n27 -= n26 + 4, n26, n26);
                    } else {
                        n27 -= 4;
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._collapseButton, 0, 0, 0, 0);
                    }
                    n26 = insets.top;
                    int n29 = n25 = BasicCollapsiblePaneTitlePane.this._titleComponent != null ? BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().height : 0;
                    if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                        int n30 = BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().width;
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleComponent, n28 + (n - n30) / 2, n26, n30, n25);
                    }
                    BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleLabel, n28, n26 += n25, n, n27 - BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap() - n26);
                } else {
                    int n31;
                    int n32;
                    int n33 = n2 - insets.bottom;
                    if (BasicCollapsiblePaneTitlePane.this._pane.getStyle() != 3) {
                        if (BasicCollapsiblePaneTitlePane.this._titleIconLabel != null && BasicCollapsiblePaneTitlePane.this._titleIconLabel.getIcon() != null) {
                            n32 = BasicCollapsiblePaneTitlePane.this._titleIconLabel.getPreferredSize().height;
                            BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleIconLabel, insets.left + insets.right - 1, n33 -= n32, BasicCollapsiblePaneTitlePane.this._titleIconLabel.getPreferredSize().width, n32);
                        } else if (BasicCollapsiblePaneTitlePane.this._titleIconLabel != null) {
                            BasicCollapsiblePaneTitlePane.this._titleIconLabel.setBounds(0, 0, 0, 0);
                        }
                    }
                    int n34 = n - n24;
                    n32 = insets.top;
                    if (BasicCollapsiblePaneTitlePane.this._pane.isShowExpandButton() && BasicCollapsiblePaneTitlePane.this._pane.isCollapsible()) {
                        n31 = BasicCollapsiblePaneTitlePane.this.getButtonSize();
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._collapseButton, n34 + (n24 - n31) / 2, n32, n31, n31);
                        n32 += n31 + 4;
                    } else {
                        BasicCollapsiblePaneTitlePane.this._collapseButton.setBounds(0, 0, 0, 0);
                    }
                    int n35 = n31 = BasicCollapsiblePaneTitlePane.this._titleComponent != null ? BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().height : 0;
                    if (BasicCollapsiblePaneTitlePane.this._titleComponent != null) {
                        int n36 = BasicCollapsiblePaneTitlePane.this._titleComponent.getPreferredSize().width;
                        BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleComponent, n34 + (n24 - n36) / 2, n32, n36, n31);
                    }
                    BasicCollapsiblePaneTitlePane.this.setBounds(container, BasicCollapsiblePaneTitlePane.this._titleLabel, n34, n32 += n31, n24, n33 - BasicCollapsiblePaneTitlePane.this._pane.getTitleLabelGap() - n32);
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("collapsed".equals(string)) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicCollapsiblePaneTitlePane.this._collapseButton.setType(1);
                } else {
                    BasicCollapsiblePaneTitlePane.this._collapseButton.setType(0);
                }
            } else if ("enabled".equals(string)) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicCollapsiblePaneTitlePane.this._collapseButton.setEnabled(true);
                    BasicCollapsiblePaneTitlePane.this._titleLabel.setEnabled(true);
                    BasicCollapsiblePaneTitlePane.this._titleIconLabel.setEnabled(true);
                } else {
                    BasicCollapsiblePaneTitlePane.this._collapseButton.setEnabled(false);
                    BasicCollapsiblePaneTitlePane.this._titleLabel.setEnabled(false);
                    BasicCollapsiblePaneTitlePane.this._titleIconLabel.setEnabled(false);
                }
            } else if ("style".equals(string)) {
                BasicCollapsiblePaneTitlePane.this.setupCollapseButton(BasicCollapsiblePaneTitlePane.this._collapseButton);
            } else if ("showExpandButton".equals(string)) {
                BasicCollapsiblePaneTitlePane.this.invalidate();
                BasicCollapsiblePaneTitlePane.this._pane.updateUI();
            } else if ("emphasized".equals(string)) {
                BasicCollapsiblePaneTitlePane.this.updateTitleColor();
            } else if ("collapseOnTitleClick".equals(string)) {
                if (BasicCollapsiblePaneTitlePane.this._titleLabel != null) {
                    if (BasicCollapsiblePaneTitlePane.this._pane.isCollapsible() && BasicCollapsiblePaneTitlePane.this._pane.isCollapseOnTitleClick()) {
                        BasicCollapsiblePaneTitlePane.this._titleLabel.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        BasicCollapsiblePaneTitlePane.this._titleLabel.setCursor(Cursor.getDefaultCursor());
                    }
                }
            } else if ("title".equals(string)) {
                if (BasicCollapsiblePaneTitlePane.this._titleLabel instanceof JLabel) {
                    ((JLabel)BasicCollapsiblePaneTitlePane.this._titleLabel).setText("" + propertyChangeEvent.getNewValue());
                }
            } else if ("collapsible".equals(string)) {
                BasicCollapsiblePaneTitlePane.this._pane.updateUI();
            } else if ("titleComponent".equals(string)) {
                BasicCollapsiblePaneTitlePane.this._pane.updateUI();
            } else if ("titleLabelComponent".equals(string)) {
                BasicCollapsiblePaneTitlePane.this._pane.updateUI();
            } else if ("iconTextGap".equals(string) || "icon".equals(string) || "horizontalAlignment".equals(string) || "horizontalTextPosition".equals(string) || "verticalAlignment".equals(string) || "verticalTextPosition".equals(string)) {
                BasicCollapsiblePaneTitlePane.this.setLabelAttribute();
            } else if ("titleIcon".equals(string)) {
                BasicCollapsiblePaneTitlePane.this.setIconLabelAttribute();
            }
            BasicCollapsiblePaneTitlePane.this.revalidate();
            BasicCollapsiblePaneTitlePane.this.repaint();
        }
    }

    class TitleLabel
    extends JLabel {
        @Override
        public void setUI(LabelUI labelUI) {
            if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 7) {
                VerticalLabelUI verticalLabelUI = new VerticalLabelUI(true);
                verticalLabelUI.setRotateIcon(BasicCollapsiblePaneTitlePane.this._pane.isRotateIcon());
                super.setUI(verticalLabelUI);
            } else if (BasicCollapsiblePaneTitlePane.this._pane.getSlidingDirection() == 3) {
                VerticalLabelUI verticalLabelUI = new VerticalLabelUI(false);
                verticalLabelUI.setRotateIcon(BasicCollapsiblePaneTitlePane.this._pane.isRotateIcon());
                super.setUI(verticalLabelUI);
            } else {
                super.setUI(labelUI);
            }
        }
    }

    private class DropListener
    implements DropTargetListener {
        private DragOverTimer _timer;

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!BasicCollapsiblePaneTitlePane.this._pane.isEnabled()) {
                return;
            }
            if (BasicCollapsiblePaneTitlePane.this._pane.isExpanded()) {
                return;
            }
            this.startTimer();
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        private void startTimer() {
            if (this._timer == null) {
                this._timer = new DragOverTimer();
                this._timer.start();
            }
        }

        private void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.stopTimer();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.stopTimer();
        }
    }

    private class DragOverTimer
    extends Timer
    implements ActionListener {
        private static final long serialVersionUID = 6530558910842429957L;

        public DragOverTimer() {
            super(500, null);
            this.addActionListener(this);
            this.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicCollapsiblePaneTitlePane.this._pane.collapse(false);
            this.stop();
        }
    }
}

