/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.grid.CellStyleTableHeader;
import com.jidesoft.grid.ColumnDraggableSupport;
import com.jidesoft.grid.FilterableTableHeaderCellDecorator;
import com.jidesoft.grid.HeaderLineWrapModel;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.TableHeaderUIDelegate;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BasicCellStyleTableHeaderUIDelegate
extends TableHeaderUIDelegate
implements TableModelListener,
PropertyChangeListener,
TableColumnModelListener {
    protected JTableHeader _header;
    protected CellRendererPane _rendererPane;
    protected int _mouseXOffset;
    Point _currentMousePoint;
    private Cursor _resizeCursor = Cursor.getPredefinedCursor(11);
    StyledLabel[] _styledLabels;
    private int[] _preferredHeights;
    private static final String CLIENT_PROPERTY_DELEGATE_INSTANCE = "TableHeaderUIDelegate.instance";
    static final String CLIENT_PROPERTY_CELL_DECORATOR_PROPERTIES = "TableHeaderUIDelegate.cellDecoratorProperties";

    public BasicCellStyleTableHeaderUIDelegate(JTableHeader jTableHeader, CellRendererPane cellRendererPane) {
        this._header = jTableHeader;
        this._header.addPropertyChangeListener("table", this);
        this._header.addPropertyChangeListener("font", this);
        this._header.addPropertyChangeListener("columnModel", this);
        this._header.getColumnModel().addColumnModelListener(this);
        if (this._header.getTable() != null) {
            this._header.getTable().addPropertyChangeListener("model", this);
            if (this._header.getTable().getModel() != null) {
                this._header.getTable().getModel().addTableModelListener(this);
            }
        }
        this._rendererPane = cellRendererPane;
    }

    @Override
    public void uninstallAllListeners() {
        if (this._header != null) {
            this._header.removePropertyChangeListener("table", this);
            this._header.removePropertyChangeListener("font", this);
            this._header.removePropertyChangeListener("columnModel", this);
            this._header.getColumnModel().removeColumnModelListener(this);
            if (this._header.getTable() != null) {
                this._header.getTable().removePropertyChangeListener("model", this);
                if (this._header.getTable().getModel() != null) {
                    this._header.getTable().getModel().removeTableModelListener(this);
                }
            }
        }
    }

    public int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this._header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    protected TableCellRenderer getHeaderRenderer(TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this._header.getDefaultRenderer();
        }
        return tableCellRenderer;
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this._header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this._header.getDefaultRenderer();
        }
        boolean bl = !this._header.isPaintingForPrint() && this._header.hasFocus();
        return tableCellRenderer.getTableCellRendererComponent(this._header.getTable(), tableColumn.getHeaderValue(), false, bl, 0, n);
    }

    public Insets getBorderInsets(Graphics graphics, int n, Rectangle rectangle) {
        if (this._header instanceof CellStyleTableHeader) {
            Insets insets = new Insets(0, 0, 0, 0);
            Rectangle rectangle2 = new Rectangle(rectangle);
            for (TableHeaderCellDecorator tableHeaderCellDecorator : ((CellStyleTableHeader)this._header).getCellDecorators()) {
                if (tableHeaderCellDecorator == null) continue;
                Insets insets2 = tableHeaderCellDecorator.getInsets(graphics, this._header, n, rectangle2);
                Rectangle rectangle3 = this.adjustPaintCellRect(rectangle2, insets2);
                if (insets2 != null) {
                    insets.left += insets2.left;
                    insets.right += insets2.right;
                    insets.top += insets2.top;
                    insets.bottom += insets2.bottom;
                }
                rectangle2 = rectangle3;
            }
            if (insets.top == 0 && insets.right == 0 && insets.bottom == 0 && insets.left == 0) {
                return null;
            }
            if (!this._header.getComponentOrientation().isLeftToRight()) {
                return new Insets(insets.top, insets.right, insets.bottom, insets.left);
            }
            return insets;
        }
        return null;
    }

    Rectangle adjustPaintCellRect(Rectangle rectangle, Insets insets) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (insets != null) {
            rectangle2.x = this._header.getComponentOrientation().isLeftToRight() ? (rectangle2.x += insets.left) : (rectangle2.x += insets.right);
            rectangle2.width -= insets.left + insets.right;
            rectangle2.y += insets.top;
            rectangle2.height -= insets.top + insets.bottom;
        }
        return rectangle2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintCell(Graphics graphics, Rectangle rectangle, int n, Object object, boolean bl, boolean bl2, boolean bl3) {
        block26: {
            this._header.putClientProperty(CLIENT_PROPERTY_CELL_DECORATOR_PROPERTIES, new Object[]{bl, bl2});
            try {
                Border n8;
                int n2;
                Object object3;
                Object object4;
                TableColumn tableColumn = this._header.getColumnModel().getColumn(n);
                if (this._styledLabels == null || tableColumn.getModelIndex() >= this._styledLabels.length) {
                    this.buildStyledLabelCache();
                }
                if (this._styledLabels == null || tableColumn.getModelIndex() >= this._styledLabels.length || tableColumn.getModelIndex() < 0) {
                    Component component = this.getHeaderRenderer(n);
                    this._rendererPane.paintComponent(graphics, component, this._header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                    this._rendererPane.remove(component);
                    return;
                }
                TableCellRenderer tableCellRenderer = this.getHeaderRenderer(tableColumn);
                if (tableCellRenderer == null) {
                    return;
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(this._header.getTable(), object, bl, bl2, 0, n);
                if (!this._header.isEnabled()) {
                    component.setEnabled(this._header.isEnabled());
                }
                Insets insets = this.getBorderInsets(graphics, n, rectangle);
                Insets insets2 = null;
                Border border = null;
                JPanel jPanel = null;
                if (insets != null && component instanceof JComponent) {
                    border = ((JComponent)component).getBorder();
                    if (border != null) {
                        insets2 = border.getBorderInsets(component);
                    }
                    object4 = this.createMarginBorder(insets, border);
                    ((JComponent)component).setBorder((Border)object4);
                    if (((JComponent)component).getBorder() == object4) {
                        insets2 = ((JComponent)component).getBorder().getBorderInsets(component);
                    } else {
                        insets2.right += insets.right;
                        insets2.left += insets.left;
                        insets2.top += insets.top;
                        insets2.bottom += insets.bottom;
                        jPanel = new JPanel(new BorderLayout());
                        jPanel.add(component);
                        jPanel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
                    }
                }
                object4 = this._styledLabels[tableColumn.getModelIndex()];
                if (component instanceof JLabel && !JideSwingUtilities.equals(((JLabel)component).getText(), object) && !JideSwingUtilities.equals(((JLabel)(object3 = StyledLabelBuilder.createStyledLabel(((JLabel)component).getText()))).getText(), ((JLabel)component).getText())) {
                    object4 = object3;
                    this._styledLabels[tableColumn.getModelIndex()] = object3;
                    this.clearHeightsCache(true, true);
                }
                object3 = null;
                if (object4 != null && component instanceof JLabel && JideSwingUtilities.equals(object, tableColumn.getHeaderValue())) {
                    ((JLabel)component).setText("");
                    object3 = ((JLabel)component).getIcon();
                    ((JLabel)component).setIcon(null);
                }
                int n3 = n2 = this._header instanceof NestedTableHeader ? ((NestedTableHeader)this._header).getRowCount() - 1 : 0;
                if (jPanel != null) {
                    this.customizeRendererComponent(jPanel, n2, n, rectangle);
                    this._rendererPane.paintComponent(graphics, jPanel, this._header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                    this._rendererPane.remove(jPanel);
                    this.releaseRendererComponent(jPanel, n2, n, rectangle);
                } else {
                    this.customizeRendererComponent(component, n2, n, rectangle);
                    this._rendererPane.paintComponent(graphics, component, this._header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                    this._rendererPane.remove(component);
                    this.releaseRendererComponent(component, n2, n, rectangle);
                }
                if (object3 != null && component instanceof JLabel) {
                    ((JLabel)component).setIcon((Icon)object3);
                }
                if (insets != null && component instanceof JComponent) {
                    ((JComponent)component).setBorder(border);
                }
                if (this._header instanceof CellStyleTableHeader && bl3) {
                    Rectangle rectangle2 = new Rectangle(rectangle);
                    for (TableHeaderCellDecorator object22 : ((CellStyleTableHeader)this._header).getCellDecorators()) {
                        if (object22 == null) continue;
                        Insets insets3 = object22.getInsets(graphics, this._header, n, rectangle2);
                        Rectangle rectangle3 = insets3 == null ? new Rectangle(rectangle) : new Rectangle(rectangle2);
                        object22.paint(graphics, this._header, n, rectangle3, this.isMouseOverPaintArea(this._currentMousePoint, rectangle2, insets3));
                        rectangle2 = this.adjustPaintCellRect(rectangle2, insets3);
                    }
                }
                if (object4 == null || !(component instanceof JLabel) || !JideSwingUtilities.equals(object, tableColumn.getHeaderValue())) break block26;
                int n4 = rectangle.x;
                int n5 = rectangle.y;
                int n6 = rectangle.width;
                int n7 = rectangle.height;
                if (insets2 == null && (n8 = ((JLabel)component).getBorder()) != null) {
                    insets2 = n8.getBorderInsets(component);
                }
                if (insets2 != null) {
                    n5 += insets2.top;
                    n7 -= insets2.top + insets2.bottom;
                    n6 -= insets2.left + insets2.right;
                    n4 = this._header.getComponentOrientation().isLeftToRight() ? (n4 += insets2.left) : (n4 += insets2.right);
                }
                ((JComponent)object4).setOpaque(false);
                this.configureStyledLabel(component, (StyledLabel)object4);
                ((Component)object4).setSize(n6, n7);
                this.customizeRendererComponent((Component)object4, n2, n, new Rectangle(n4, n5, n6, n7));
                int n9 = ((StyledLabel)object4).getPreferredWidth();
                try {
                    ((StyledLabel)object4).setPreferredWidth(n6);
                    this._rendererPane.paintComponent(graphics, (Component)object4, this._header, n4, n5, n6, n7);
                    this._rendererPane.remove((Component)object4);
                }
                finally {
                    ((StyledLabel)object4).setPreferredWidth(n9);
                }
                this.releaseRendererComponent((Component)object4, n2, n, new Rectangle(n4, n5, n6, n7));
            }
            finally {
                this._header.putClientProperty(CLIENT_PROPERTY_CELL_DECORATOR_PROPERTIES, null);
            }
        }
    }

    void configureStyledLabel(Component component, StyledLabel styledLabel) {
        styledLabel.setFont(component.getFont());
        styledLabel.setBackground(component.getBackground());
        styledLabel.setForeground(component.getForeground());
        if (component instanceof JLabel) {
            styledLabel.setHorizontalAlignment(((JLabel)component).getHorizontalAlignment());
            styledLabel.setVerticalAlignment(((JLabel)component).getVerticalAlignment());
            styledLabel.setVerticalTextPosition(((JLabel)component).getVerticalTextPosition());
            styledLabel.setIcon(((JLabel)component).getIcon());
        }
    }

    protected Border createMarginBorder(Insets insets, Border border) {
        return BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
    }

    protected boolean isMouseOverPaintArea(Point point, Rectangle rectangle, Insets insets) {
        if (point == null || rectangle == null) {
            return false;
        }
        if (rectangle.contains(point)) {
            Rectangle rectangle2 = this.adjustPaintCellRect(rectangle, insets);
            return !rectangle2.contains(point);
        }
        return false;
    }

    protected void customizeRendererComponent(Component component, int n, int n2, Rectangle rectangle) {
        if (this._header instanceof CellStyleTableHeader) {
            ((CellStyleTableHeader)this._header).customizeRendererComponent(component, n, n2, rectangle);
        } else {
            component.applyComponentOrientation(this._header.getComponentOrientation());
        }
    }

    protected void releaseRendererComponent(Component component, int n, int n2, Rectangle rectangle) {
        if (this._header instanceof CellStyleTableHeader) {
            ((CellStyleTableHeader)this._header).releaseRendererComponent(component, n, n2, rectangle);
        }
    }

    protected void customizePaint(Graphics graphics, TableColumn tableColumn, Rectangle rectangle) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        int n;
        int n2;
        int n3;
        TableColumnModel tableColumnModel;
        if (this._header.getClientProperty(CLIENT_PROPERTY_DELEGATE_INSTANCE) != this) {
            this._header.putClientProperty(CLIENT_PROPERTY_DELEGATE_INSTANCE, this);
        }
        if ((tableColumnModel = this._header.getColumnModel()) == null) {
            return;
        }
        boolean bl = this._header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle2 = graphics.getClipBounds();
        Point point = rectangle2.getLocation();
        Point point2 = new Point(rectangle2.x + rectangle2.width - 1, rectangle2.y);
        int n4 = this._header instanceof CellStyleTableHeader ? ((CellStyleTableHeader)this._header).originalColumnAtPoint(bl ? point : point2) : (n3 = this._header.columnAtPoint(bl ? point : point2));
        int n5 = this._header instanceof CellStyleTableHeader ? ((CellStyleTableHeader)this._header).originalColumnAtPoint(bl ? point2 : point) : (n2 = this._header.columnAtPoint(bl ? point2 : point));
        if (n3 == -1) {
            n3 = 0;
        }
        if (n2 == -1) {
            n2 = tableColumnModel.getColumnCount() - 1;
        }
        Dimension dimension = this._header.getSize();
        Rectangle rectangle3 = this._header.getHeaderRect(bl ? n3 : n2);
        int n6 = 0;
        TableColumn tableColumn = this._header.getDraggedColumn();
        Rectangle rectangle4 = null;
        if (this._header.getComponentOrientation().isLeftToRight()) {
            for (n = n3; n <= n2; ++n) {
                rectangle = this._header.getHeaderRect(n);
                rectangle3.y = rectangle.y;
                rectangle3.height = rectangle.height;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                rectangle3.width = tableColumn2.getWidth() + n6;
                this.customizePaint(graphics, tableColumn2, rectangle3);
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle3, n, tableColumn2.getHeaderValue(), false, false, true);
                } else {
                    rectangle4 = (Rectangle)rectangle3.clone();
                }
                rectangle3.x += rectangle3.width;
            }
        } else {
            for (n = n2; n >= n3; --n) {
                rectangle = this._header.getHeaderRect(n);
                rectangle3.y = rectangle.y;
                rectangle3.height = rectangle.height;
                TableColumn tableColumn3 = tableColumnModel.getColumn(n);
                rectangle3.width = tableColumn3.getWidth() + n6;
                this.customizePaint(graphics, tableColumn3, rectangle3);
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle3, n, tableColumn3.getHeaderValue(), false, false, true);
                } else {
                    rectangle4 = (Rectangle)rectangle3.clone();
                }
                rectangle3.x += rectangle3.width;
            }
        }
        if (tableColumn != null && rectangle4 != null) {
            n = this.viewIndexForColumn(tableColumn);
            rectangle = this._header.getHeaderRect(n);
            rectangle.y = rectangle4.y;
            rectangle.height = rectangle4.height;
            graphics.setColor(this._header.getParent().getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle.x += this._header.getDraggedDistance();
            graphics.setColor(this._header.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.customizePaint(graphics, tableColumn, rectangle);
            this.paintCell(graphics, rectangle, n, tableColumn.getHeaderValue(), false, false, true);
        }
    }

    protected int getHeaderPreferredHeight() {
        int n = 0;
        TableColumnModel tableColumnModel = this._header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            n = Math.max(this.getPreferredHeight(i), n);
        }
        return n;
    }

    private Dimension createHeaderSize(long l) {
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderPreferredHeight());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this._header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this._currentMousePoint = mouseEvent.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this._currentMousePoint = mouseEvent.getPoint();
        int n = mouseEvent.getX();
        TableColumn tableColumn = this._header.getResizingColumn();
        TableColumn tableColumn2 = this._header.getDraggedColumn();
        boolean bl = this._header.getComponentOrientation().isLeftToRight();
        if (tableColumn != null) {
            Container container;
            int n2 = tableColumn.getWidth();
            int n3 = bl ? n - this._mouseXOffset : this._mouseXOffset - n;
            this.resizeColumn(tableColumn, n3);
            if (this._header.getParent() == null || (container = this._header.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                return;
            }
            JTable jTable = this._header.getTable();
            if (jTable != null) {
                JComponent jComponent;
                Object object = jTable.getClientProperty("TableScrollPane.Parent");
                boolean bl2 = false;
                if (object instanceof TableScrollPane && (((TableScrollPane)(jComponent = (TableScrollPane)object)).getColumnFooterTable() == jTable || ((TableScrollPane)jComponent).getRowHeaderColumnFooterTable() == jTable || ((TableScrollPane)jComponent).getRowFooterColumnFooterTable() == jTable)) {
                    bl2 = true;
                }
                if (!container.getComponentOrientation().isLeftToRight() && !bl || bl2) {
                    jComponent = ((JScrollPane)container).getViewport();
                    int n4 = jComponent.getWidth();
                    int n5 = n3 - n2;
                    int n6 = jTable.getWidth() + n5;
                    Dimension dimension = jTable.getSize();
                    dimension.width += n5;
                    jTable.setSize(dimension);
                    if (n6 >= n4 && jTable.getAutoResizeMode() == 0) {
                        Point point = ((JViewport)jComponent).getViewPosition();
                        point.x = Math.max(0, Math.min(n6 - n4, point.x + n5));
                        ((JViewport)jComponent).setViewPosition(point);
                        this._mouseXOffset += n5;
                    }
                }
            }
        } else if (tableColumn2 != null) {
            int n7 = this.viewIndexForColumn(tableColumn2);
            this.dragColumn(n7, n);
        }
        this.updateRolloverColumn(mouseEvent.getPoint());
    }

    protected void dragColumn(int n, int n2) {
        TableColumn tableColumn;
        int n3 = n2 - this._mouseXOffset;
        int n4 = n3 < 0 ? -1 : 1;
        int n5 = n + (this._header.getComponentOrientation().isLeftToRight() ? n4 : -n4);
        if (0 <= n5 && n5 < this._header.getColumnModel().getColumnCount() && (tableColumn = this._header.getColumnModel().getColumn(n5)) != null && this.isColumnDraggable(tableColumn.getModelIndex())) {
            int n6 = tableColumn.getWidth();
            if (Math.abs(n3) > n6 / 2) {
                this._mouseXOffset += n4 * n6;
                this._header.setDraggedDistance(n3 -= n4 * n6);
                this._header.getColumnModel().moveColumn(n, n5);
                this.dragColumn(n5, n2);
                return;
            }
        }
        this.setDraggedDistance(n, n3);
    }

    void setDraggedDistance(int n, int n2) {
        this._header.setDraggedDistance(n2);
        if (n != -1) {
            this._header.getColumnModel().moveColumn(n, n);
        }
    }

    protected void resizeColumn(TableColumn tableColumn, int n) {
        tableColumn.setWidth(n);
    }

    boolean isColumnDraggable(int n) {
        int n2;
        TableModel tableModel;
        if (this._header != null && this._header.getTable() != null && (tableModel = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), ColumnDraggableSupport.class)) instanceof ColumnDraggableSupport && (n2 = TableModelWrapperUtils.getActualColumnAt(this._header.getTable().getModel(), n, tableModel)) >= 0 && n2 < tableModel.getColumnCount()) {
            return ((ColumnDraggableSupport)((Object)tableModel)).isColumnDraggable(n2);
        }
        return true;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) && this._header.getComponentPopupMenu() != null) {
            this._header.setDraggedColumn(null);
        }
        this._currentMousePoint = mouseEvent.getPoint();
        this._header.setDraggedColumn(null);
        this._header.setResizingColumn(null);
        this._header.setDraggedDistance(0);
        Point point = mouseEvent.getPoint();
        TableColumnModel tableColumnModel = this._header.getColumnModel();
        int n = this._header instanceof CellStyleTableHeader ? ((CellStyleTableHeader)this._header).originalColumnAtPoint(point) : this._header.columnAtPoint(point);
        int n2 = 0;
        if (n != -1) {
            TableColumn tableColumn = this.getResizingColumn(point, n);
            if (this.canResize(tableColumn)) {
                this._header.setResizingColumn(tableColumn);
                n2 = this._header.getComponentOrientation().isLeftToRight() ? point.x - tableColumn.getWidth() : point.x + tableColumn.getWidth();
                this.startResizingColumn(point, tableColumn);
            } else if (this._header.getReorderingAllowed()) {
                TableColumn tableColumn2;
                int n3;
                int n4 = n3 = this._header instanceof CellStyleTableHeader ? ((CellStyleTableHeader)this._header).getActualHeaderY() : 0;
                if (point.y >= n3 && this.isColumnDraggable((tableColumn2 = tableColumnModel.getColumn(n)).getModelIndex())) {
                    this._header.setDraggedColumn(tableColumn2);
                    n2 = point.x;
                }
            }
        }
        this._mouseXOffset = n2;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor;
        Point point;
        this._currentMousePoint = point = mouseEvent.getPoint();
        int n = this._header instanceof CellStyleTableHeader ? ((CellStyleTableHeader)this._header).originalColumnAtPoint(point) : this._header.columnAtPoint(point);
        Cursor cursor2 = cursor = this._header instanceof CellStyleTableHeader ? ((CellStyleTableHeader)this._header).getDefaultCursor() : Cursor.getDefaultCursor();
        if (this.canResize(this.getResizingColumn(point, n))) {
            if (this._header.getCursor() != this._resizeCursor) {
                this._header.setCursor(this._resizeCursor);
            }
        } else if (this._header.getCursor() != cursor) {
            this._header.setCursor(cursor);
        }
        this.updateRolloverColumn(mouseEvent.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._currentMousePoint = mouseEvent.getPoint();
        this.updateRolloverColumn(mouseEvent.getPoint());
        if (!this._header.getReorderingAllowed()) {
            this._header.invalidate();
            this._header.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this._currentMousePoint = mouseEvent.getPoint();
        this.updateRolloverColumn(mouseEvent.getPoint());
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this._currentMousePoint = null;
        if (this._header.getUI() instanceof DelegateTableHeaderUI) {
            ((DelegateTableHeaderUI)((Object)this._header.getUI())).setRolloverColumn(-1);
        }
    }

    void updateRolloverColumn(Point point) {
        int n;
        int n2 = n = this._header.getDraggedColumn() != null ? -1 : this._header.columnAtPoint(point);
        if (this._header.getUI() instanceof DelegateTableHeaderUI) {
            ((DelegateTableHeaderUI)((Object)this._header.getUI())).setRolloverColumn(n);
        }
    }

    private boolean canResize(TableColumn tableColumn) {
        return tableColumn != null && this._header.getResizingAllowed() && tableColumn.getResizable();
    }

    public TableColumn getResizingColumn(Point point, int n) {
        int n2;
        if (n < -1 || n >= this._header.getColumnModel().getColumnCount()) {
            return null;
        }
        Rectangle rectangle = this._header.getHeaderRect(n);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n3 = rectangle.x + rectangle.width / 2;
        if (this._header.getComponentOrientation().isLeftToRight()) {
            n2 = point.x < n3 ? n - 1 : n;
        } else {
            int n4 = n2 = point.x < n3 ? n : n - 1;
        }
        if (n2 < 0 || n2 >= this._header.getColumnModel().getColumnCount()) {
            return null;
        }
        return this._header.getColumnModel().getColumn(n2);
    }

    protected void startResizingColumn(Point point, TableColumn tableColumn) {
    }

    public boolean hasStyledLabelColumn() {
        if (this._styledLabels == null) {
            return false;
        }
        for (StyledLabel styledLabel : this._styledLabels) {
            if (styledLabel == null) continue;
            return true;
        }
        return false;
    }

    private void buildStyledLabelCache() {
        this._styledLabels = null;
        if (this._header.getTable() == null || this._header.getTable().getModel() == null) {
            this._styledLabels = new StyledLabel[0];
            return;
        }
        TableModel tableModel = this._header.getTable().getModel();
        HeaderLineWrapModel headerLineWrapModel = (HeaderLineWrapModel)((Object)TableModelWrapperUtils.getActualTableModel(tableModel, HeaderLineWrapModel.class));
        int n = tableModel.getColumnCount();
        this._styledLabels = new StyledLabel[n];
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            int n2 = this._header.getTable().convertColumnIndexToView(i);
            String string = null;
            if (n2 >= 0 && n2 < this._header.getColumnModel().getColumnCount()) {
                serializable = this._header.getColumnModel().getColumn(n2);
                String string2 = string = ((TableColumn)serializable).getHeaderValue() == null ? null : "" + ((TableColumn)serializable).getHeaderValue();
            }
            if (string == null) {
                string = tableModel.getColumnName(i);
            }
            if (string == null || string.trim().length() == 0) continue;
            serializable = StyledLabelBuilder.createStyledLabel(string);
            boolean bl = false;
            if (headerLineWrapModel != null) {
                if (headerLineWrapModel.getPreferredRows(i) >= 1) {
                    bl = true;
                    ((StyledLabel)serializable).setLineWrap(true);
                    if (((StyledLabel)serializable).getRows() <= 0) {
                        ((StyledLabel)serializable).setRows(headerLineWrapModel.getPreferredRows(i));
                    }
                }
                if (headerLineWrapModel.getMaximumRows(i) >= 1) {
                    bl = true;
                    ((StyledLabel)serializable).setLineWrap(true);
                    if (((StyledLabel)serializable).getMaxRows() <= 0) {
                        ((StyledLabel)serializable).setMaxRows(headerLineWrapModel.getMaximumRows(i));
                    }
                }
                if (headerLineWrapModel.getMinimumRows(i) >= 1) {
                    bl = true;
                    ((StyledLabel)serializable).setLineWrap(true);
                    if (((StyledLabel)serializable).getMinRows() <= 0) {
                        ((StyledLabel)serializable).setMinRows(headerLineWrapModel.getMinimumRows(i));
                    }
                }
                if (headerLineWrapModel.getPreferredWidth(i) >= 1) {
                    bl = true;
                    ((StyledLabel)serializable).setLineWrap(true);
                    if (((StyledLabel)serializable).getPreferredWidth() <= 0) {
                        ((StyledLabel)serializable).setPreferredWidth(headerLineWrapModel.getPreferredWidth(i));
                    }
                }
            }
            if (!bl && JideSwingUtilities.equals(string, ((JLabel)serializable).getText())) continue;
            this._styledLabels[i] = serializable;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
            this.invalidateCache(true);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.clearHeightsCache(true, false);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.clearHeightsCache(true, false);
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.hasStyledLabelColumn()) {
            this.clearHeightsCache(true, true);
        }
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("table".equals(propertyChangeEvent.getPropertyName())) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof JTable) {
                ((JTable)object2).removePropertyChangeListener("model", this);
                if (((JTable)object2).getModel() != null) {
                    ((JTable)object2).getModel().removeTableModelListener(this);
                }
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof JTable) {
                ((JTable)object).removePropertyChangeListener("model", this);
                ((JTable)object).addPropertyChangeListener("model", this);
                if (((JTable)object).getModel() != null) {
                    ((JTable)object).getModel().removeTableModelListener(this);
                    ((JTable)object).getModel().addTableModelListener(this);
                }
            }
            this.invalidateCache(true);
        } else if ("font".equals(propertyChangeEvent.getPropertyName())) {
            this.clearHeightsCache(true, false);
        } else if ("model".equals(propertyChangeEvent.getPropertyName())) {
            Object object;
            Object object3 = propertyChangeEvent.getOldValue();
            if (object3 instanceof TableModel) {
                ((TableModel)object3).removeTableModelListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof TableModel) {
                ((TableModel)object).removeTableModelListener(this);
                ((TableModel)object).addTableModelListener(this);
            }
            this.invalidateCache(true);
        } else if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
            Object object;
            Object object4 = propertyChangeEvent.getOldValue();
            if (object4 instanceof TableColumnModel) {
                ((TableColumnModel)object4).removeColumnModelListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof TableColumnModel) {
                ((TableColumnModel)object).removeColumnModelListener(this);
                ((TableColumnModel)object).addColumnModelListener(this);
            }
        }
    }

    void clearStyledLabelCache() {
        this._styledLabels = null;
    }

    void clearHeightsCache(boolean bl, boolean bl2) {
        if (this._preferredHeights != null) {
            if (!bl2 || this._styledLabels == null || this._styledLabels.length != this._preferredHeights.length) {
                if (this._header != null && this._header.getTable() != null && this._header.getTable().getModel() != null) {
                    this._preferredHeights = new int[this._header.getTable().getModel().getColumnCount()];
                }
                Arrays.fill(this._preferredHeights, -1);
            } else {
                for (int i = 0; i < this._styledLabels.length; ++i) {
                    if (this._styledLabels[i] == null) continue;
                    this._preferredHeights[i] = -1;
                }
            }
        }
        if (bl && this._header != null && this._header.getTable() != null && this._header.getTable().getClientProperty("TableScrollPane.Parent") instanceof TableScrollPane) {
            JTable[] jTableArray;
            TableScrollPane tableScrollPane = (TableScrollPane)this._header.getTable().getClientProperty("TableScrollPane.Parent");
            for (JTable jTable : jTableArray = tableScrollPane.getAllChildTables()) {
                if (jTable == this._header.getTable() || jTable == null || jTable.getTableHeader() == null || jTable.getColumnCount() <= 0 || !(jTable.getTableHeader().getUI() instanceof DelegateTableHeaderUI) || !(((DelegateTableHeaderUI)((Object)jTable.getTableHeader().getUI())).getHeaderUIDelegate() instanceof BasicCellStyleTableHeaderUIDelegate)) continue;
                ((BasicCellStyleTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)jTable.getTableHeader().getUI())).getHeaderUIDelegate()).clearHeightsCache(false, true);
            }
        }
    }

    public void invalidateCache(boolean bl) {
        this.clearStyledLabelCache();
        this.clearHeightsCache(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredHeight(int n) {
        TableCellRenderer tableCellRenderer;
        if (this._header.getTable() == null) {
            return -1;
        }
        int n2 = this._header.getTable().convertColumnIndexToModel(n);
        if (this._preferredHeights == null || n2 >= this._preferredHeights.length) {
            this._preferredHeights = new int[this._header.getTable().getModel().getColumnCount()];
            Arrays.fill(this._preferredHeights, -1);
        }
        if (n2 >= this._preferredHeights.length || n2 < 0) {
            return -1;
        }
        if (this._preferredHeights[n2] >= 0) {
            return this._preferredHeights[n2];
        }
        TableColumn tableColumn = this._header.getColumnModel().getColumn(n);
        if (this._styledLabels == null || n >= this._styledLabels.length) {
            this.buildStyledLabelCache();
        }
        if ((tableCellRenderer = this.getHeaderRenderer(tableColumn)) != null) {
            StyledLabel styledLabel;
            Component component = tableCellRenderer.getTableCellRendererComponent(this._header.getTable(), tableColumn.getHeaderValue(), false, false, 0, n);
            Dimension dimension = component.getPreferredSize();
            if (this._styledLabels != null && n2 < this._styledLabels.length && n >= 0 && (styledLabel = this._styledLabels[tableColumn.getModelIndex()]) != null && component instanceof JLabel) {
                int n3 = tableColumn.getWidth();
                Border border = ((JComponent)component).getBorder();
                Insets insets = border != null ? border.getBorderInsets(component) : UIManager.getInsets("TableHeader.DefaultRendererInsets");
                if (insets != null) {
                    n3 -= insets.left + insets.right;
                }
                int n4 = styledLabel.getPreferredWidth();
                try {
                    this.configureStyledLabel(component, styledLabel);
                    styledLabel.setPreferredWidth(n3);
                    styledLabel.setSize(new Dimension(n3, 0));
                    dimension = styledLabel.getPreferredSize();
                }
                finally {
                    styledLabel.setPreferredWidth(n4);
                }
                if (insets != null) {
                    dimension.height += insets.top + insets.bottom;
                }
            }
            this._preferredHeights[n2] = dimension.height;
            return dimension.height;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredWidth(int n) {
        Dimension dimension = new Dimension();
        this._header.putClientProperty(CLIENT_PROPERTY_CELL_DECORATOR_PROPERTIES, new Object[]{false, false});
        try {
            Object object;
            Object object2;
            TableColumn tableColumn = this._header.getColumnModel().getColumn(n);
            if (this._styledLabels == null || tableColumn.getModelIndex() >= this._styledLabels.length) {
                this.buildStyledLabelCache();
            }
            if (this._styledLabels == null || tableColumn.getModelIndex() >= this._styledLabels.length) {
                int n2 = tableColumn.getPreferredWidth();
                return n2;
            }
            int n3 = 0;
            if (this._header instanceof NestedTableHeader) {
                n3 = ((NestedTableHeader)this._header).getRowCount() - 1;
            }
            Component component = this.getHeaderRenderer(tableColumn).getTableCellRendererComponent(this._header.getTable(), tableColumn.getHeaderValue(), false, false, n3, n);
            this.customizeRendererComponent(component, n3, n, new Rectangle());
            StyledLabel styledLabel = this._styledLabels[tableColumn.getModelIndex()];
            if (styledLabel != null && component instanceof JLabel) {
                dimension = styledLabel.getPreferredSize();
                object2 = ((JComponent)component).getBorder();
                object = object2 != null ? object2.getBorderInsets(component) : UIManager.getInsets("TableHeader.DefaultRendererInsets");
                if (object != null) {
                    dimension.width += object.left + object.right;
                }
            } else {
                dimension = component.getPreferredSize();
            }
            this.releaseRendererComponent(component, 0, n, new Rectangle());
            object2 = new Rectangle(0, 0, dimension.width, dimension.height);
            if (this._header instanceof CellStyleTableHeader) {
                for (TableHeaderCellDecorator tableHeaderCellDecorator : object = ((CellStyleTableHeader)this._header).getCellDecorators()) {
                    if (tableHeaderCellDecorator instanceof FilterableTableHeaderCellDecorator) {
                        this._header.putClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties", new int[]{n, n});
                    }
                    try {
                        Insets insets = tableHeaderCellDecorator.getInsets(null, this._header, n, (Rectangle)object2);
                        if (insets == null) continue;
                        dimension.width += insets.left + insets.right;
                    }
                    finally {
                        this._header.putClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties", null);
                    }
                }
            }
        }
        finally {
            this._header.putClientProperty(CLIENT_PROPERTY_CELL_DECORATOR_PROPERTIES, null);
        }
        return dimension.width;
    }
}

