/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterUtils;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.grid.Field;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.QuickFilterField;
import com.jidesoft.pivot.CompareToConverter;
import com.jidesoft.pivot.DefaultExpandableValue;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.RunningSummary;
import com.jidesoft.pivot.RunningSummaryValues;
import com.jidesoft.pivot.SummaryValue;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PersistenceUtilsCallback;
import com.jidesoft.utils.Q;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PivotTablePersistenceUtils {
    private static final String NODE_PIVOT_TABLE = "pivotTable";
    private static final String ATTRIBUTE_GRAND_TOTAL_FOR_ROW = "grandTotalForRow";
    private static final String ATTRIBUTE_GRAND_TOTAL_FOR_COLUMN = "grandTotalForColumn";
    private static final String NODE_FIELD = "field";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_AREA_INDEX = "areaIndex";
    private static final String ATTRIBUTE_AREA_TYPE = "areaType";
    private static final String ATTRIBUTE_MODEL_INDEX = "modelIndex";
    private static final String ATTRIBUTE_DUPLICATED = "duplicated";
    private static final String ATTRIBUTE_SUBTOTALS = "subtotal";
    private static final String ATTRIBUTE_SUBTOTALS_FOR_ROW = "subtotalForRow";
    private static final String ATTRIBUTE_SUBTOTALS_FOR_COLUMN = "subtotalForColumn";
    private static final String ATTRIBUTE_SUBTOTAL_TYPE = "subtotalType";
    private static final String ATTRIBUTE_SUBTOTAL_SUMMARY_TYPE = "subtotalSummaryType";
    private static final String ATTRIBUTE_SUBTOTAL_TYPE_FOR_ROW = "subtotalTypeForRow";
    private static final String ATTRIBUTE_SUBTOTAL_TYPE_FOR_COLUMN = "subtotalTypeForColumn";
    private static final String ATTRIBUTE_SEPARATE_SUBTOTAL_SETTINGS = "separateSubtotalSettings";
    private static final String ATTRIBUTE_SUMMARY_TYPE = "summaryType";
    private static final String ATTRIBUTE_GRAND_TOTAL_SUMMARY_TYPE = "grandTotalSummaryType";
    private static final String ATTRIBUTE_PREFERRED_WIDTH = "preferredWidth";
    private static final String ATTRIBUTE_ASCENDING = "ascending";
    private static final String ATTRIBUTE_SORT_BY_SUMMARY_TYPE = "sortBySummaryType";
    private static final String ATTRIBUTE_SORT_BY_COLUMN_KEYS = "sortByColumnKeys";
    private static final String ATTRIBUTE_SORT_BY_ROW_KEYS = "sortByRowKeys";
    private static final String ATTRIBUTE_SORT_BY_ASCENDING = "sortByAscending";
    private static final String ATTRIBUTE_SORT_BY_DATA_FIELD_MODEL_INDEX = "sortByDataFieldIndex";
    private static final String ATTRIBUTE_HIDE_ORIGINAL = "hideOriginal";
    private static final String ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST = "displayGrandTotalFirst";
    private static final String ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_ROW = "displayGrandTotalFirstForRow";
    private static final String ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_COLUMN = "displayGrandTotalFirstForColumn";
    private static final String ATTRIBUTE_FIELD_CHOOSER_FILTER_FIELD_VISIBLE = "fieldChooserFilterFieldVisible";
    private static final String ATTRIBUTE_FIELD_CHOOSER_FILTER = "fieldChooserFilter";
    private static final String ATTRIBUTE_SHOW_DATA_FIELDS_IN_ROW_AREA = "showDataFieldsInDataArea";
    private static final String ATTRIBUTE_LAYOUT_DATA_FIELDS_FIRST = "layoutDataFieldFirst";
    private static final String ATTRIBUTE_SHOW_FILTER_BUTTON_ON_MOUSE_OVER = "showFilterButtonOnMouseOver";
    private static final String ATTRIBUTE_SHOW_FIELD_LIST = "showFieldList";
    private static final String ATTRIBUTE_FILTER = "filter";
    private static final String ATTRIBUTE_HIDDEN_COLUMNS = "hiddenColumns";
    private static final String ATTRIBUTE_ROW_HEADER_COLLAPSED_NODES = "rowHeaderCollapsedNodes";
    private static final String ATTRIBUTE_COLUMN_HEADER_COLLAPSED_NODES = "columnHeaderCollapsedNodes";
    private static final String ATTRIBUTE_FILTER_FIELD = "filterField";
    private static final String ATTRIBUTE_FILTER_BASE_VALUES = "filterBaseValues";
    private static final String ATTRIBUTE_VALUE_FILTERS = "valueFilters";
    private static final String NODE_RUNNING_SUMMARY = "runningSummary";
    private static final String ATTRIBUTE_RUNNING_SUMMARY_TYPE = "runningSummaryType";
    private static final String ATTRIBUTE_BASE_ON_FIELD = "baseOnField";
    private static final String ATTRIBUTE_RANGE_IN_FIELD = "rangeInField";
    private static final String ATTRIBUTE_COMPARE_TO = "compareTo";
    private static final String NODE_HIDDEN_COLUMNS_IN_DATA_TABLE = "hiddenColumnInDataTable";
    private static final String ATTRIBUTE_HIDDEN_VALUES = "hiddenValue";
    private static final String ATTRIBUTE_HIDDEN_DATA_FIELDS = "hiddenDataField";
    private static final String ATTRIBUTE_HIDDEN_WIDTHS = "hiddenWidth";
    private static final String NODE_HIDDEN_ROW_VALUES = "hiddenRowValues";
    private static final String NODE_HIDDEN_COLUMN_VALUES = "hiddenColumnValues";
    private static PivotField _pivotField;
    private static String sortByAscending;
    private static String sortByColumnKeys;
    private static String sortByRowKeys;
    private static String sortByDataFieldIndex;
    private static String sortBySummaryType;
    private static List<Object> _hiddenColumns;
    private static List<String> _hiddenRowValues;
    private static List<String> _hiddenColumnValues;

    public static void save(PivotTablePane pivotTablePane, String string) throws ParserConfigurationException, IOException {
        PivotTablePersistenceUtils.save(pivotTablePane, string, null);
    }

    public static void save(PivotTablePane pivotTablePane, OutputStream outputStream) throws ParserConfigurationException, IOException {
        PivotTablePersistenceUtils.save(pivotTablePane, outputStream, null);
    }

    public static Document save(PivotTablePane pivotTablePane) throws ParserConfigurationException {
        return PivotTablePersistenceUtils.save(pivotTablePane, (PersistenceUtilsCallback.Save)null);
    }

    public static void save(PivotTablePane pivotTablePane, String string, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        PivotTablePersistenceUtils.save(pivotTablePane, string, save, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(PivotTablePane pivotTablePane, String string, PersistenceUtilsCallback.Save save, String string2) throws ParserConfigurationException, IOException {
        Document document = PivotTablePersistenceUtils.save(pivotTablePane, save);
        PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
    }

    public static void save(PivotTablePane pivotTablePane, OutputStream outputStream, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        PivotTablePersistenceUtils.save(pivotTablePane, outputStream, save, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(PivotTablePane pivotTablePane, OutputStream outputStream, PersistenceUtilsCallback.Save save, String string) throws ParserConfigurationException, IOException {
        Document document = PivotTablePersistenceUtils.save(pivotTablePane, save);
        PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
    }

    public static Document save(PivotTablePane pivotTablePane, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("component");
        if (pivotTablePane.getVersion() != null) {
            element.setAttribute("version", pivotTablePane.getVersion());
        }
        document.appendChild(element);
        Element element2 = document.createElement(NODE_PIVOT_TABLE);
        element.appendChild(element2);
        PivotTablePersistenceUtils.writePivotTableElement(pivotTablePane, document, element2, save);
        return document;
    }

    public static void writePivotTableElement(PivotTablePane pivotTablePane, Document document, Element element, PersistenceUtilsCallback.Save save) {
        Object object;
        element.setAttribute(ATTRIBUTE_GRAND_TOTAL_FOR_COLUMN, pivotTablePane.getPivotDataModel().isShowGrandTotalForColumn() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_GRAND_TOTAL_FOR_ROW, pivotTablePane.getPivotDataModel().isShowGrandTotalForRow() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_ROW, pivotTablePane.getPivotDataModel().isDisplayGrandTotalFirstForRow() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_COLUMN, pivotTablePane.getPivotDataModel().isDisplayGrandTotalFirstForColumn() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_SHOW_DATA_FIELDS_IN_ROW_AREA, pivotTablePane.getPivotDataModel().isAlwaysRowDataFields() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_LAYOUT_DATA_FIELDS_FIRST, pivotTablePane.getPivotDataModel().isLayoutDataFieldsFirst() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_SHOW_FILTER_BUTTON_ON_MOUSE_OVER, pivotTablePane.isShowFilterButtonsOnMouseOver() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_SHOW_FIELD_LIST, pivotTablePane.isFieldChooserVisible() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_FIELD_CHOOSER_FILTER_FIELD_VISIBLE, pivotTablePane.isFieldChooserFilterFieldVisible() ? "1" : "0");
        PivotTablePersistenceUtils.writeCollapseStateInformation(pivotTablePane, element, true);
        PivotTablePersistenceUtils.writeCollapseStateInformation(pivotTablePane, element, false);
        PivotField[] pivotFieldArray = pivotTablePane.getHiddenRowFields();
        if (pivotFieldArray.length > 0) {
            object = "";
            for (PivotField pivotField : pivotFieldArray) {
                object = (String)object + pivotField.getName() + "\t";
            }
            if (((String)object).length() > 0) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            element.setAttribute(ATTRIBUTE_HIDDEN_COLUMNS, (String)object);
        }
        if (pivotTablePane.getFilterField() != null) {
            object = new StringBuffer();
            ((StringBuffer)object).append(pivotTablePane.getFilterField().getFilter() instanceof QuickFilterField.FieldFilter ? ((QuickFilterField.FieldFilter)pivotTablePane.getFilterField().getFilter()).getSearchingText() : "");
            ((StringBuffer)object).append("\t").append(pivotTablePane.getFilterField().isCaseSensitive() ? "1" : "0");
            ((StringBuffer)object).append("\t").append(pivotTablePane.getFilterField().isFromStart() ? "1" : "0");
            ((StringBuffer)object).append("\t").append(pivotTablePane.getFilterField().isFromEnd() ? "1" : "0");
            ((StringBuffer)object).append("\t").append(pivotTablePane.getFilterField().isRegexEnabled() ? "1" : "0");
            ((StringBuffer)object).append("\t").append(pivotTablePane.getFilterField().isWildcardEnabled() ? "1" : "0");
            element.setAttribute(ATTRIBUTE_FIELD_CHOOSER_FILTER, ((StringBuffer)object).toString());
        }
        object = pivotTablePane.getPivotDataModel().getFields();
        for (PivotField pivotField : object) {
            Element object2 = document.createElement(NODE_FIELD);
            element.appendChild(object2);
            PivotTablePersistenceUtils.writeFieldElement(document, pivotTablePane, pivotField, object2, save);
        }
        PivotField[] pivotFieldArray2 = pivotTablePane.getPivotDataModel().getHiddenColumns();
        if (pivotFieldArray2 != null && pivotFieldArray2.length > 0) {
            for (PivotField pivotField : pivotFieldArray2) {
                Element element2 = document.createElement(NODE_HIDDEN_COLUMNS_IN_DATA_TABLE);
                element.appendChild(element2);
                PivotTablePersistenceUtils.writeHiddenColumnElement(pivotTablePane, document, (Object[])pivotField, element2, save);
            }
        }
        if (pivotTablePane.getPivotDataModel() instanceof PivotDataModel) {
            Element element3;
            String string;
            Values[] valuesArray = ((PivotDataModel)pivotTablePane.getPivotDataModel()).getHiddenRowValues();
            if (valuesArray != null && valuesArray.length > 0) {
                PivotField[] pivotFieldArray3 = pivotTablePane.getPivotDataModel().getRowFields();
                for (Values values : valuesArray) {
                    string = PivotTablePersistenceUtils.convertValuesToString(values, pivotFieldArray3);
                    element3 = document.createElement(NODE_HIDDEN_ROW_VALUES);
                    element.appendChild(element3);
                    element3.setAttribute(ATTRIBUTE_HIDDEN_VALUES, string);
                }
            }
            if ((valuesArray = ((PivotDataModel)pivotTablePane.getPivotDataModel()).getHiddenColumnValues()) != null && valuesArray.length > 0) {
                PivotField[] pivotFieldArray4 = pivotTablePane.getPivotDataModel().getColumnFields();
                for (Values values : valuesArray) {
                    string = PivotTablePersistenceUtils.convertValuesToString(values, pivotFieldArray4);
                    element3 = document.createElement(NODE_HIDDEN_COLUMN_VALUES);
                    element.appendChild(element3);
                    element3.setAttribute(ATTRIBUTE_HIDDEN_VALUES, string);
                }
            }
        }
        if (save != null) {
            save.save(document, element, pivotTablePane);
        }
    }

    private static String convertValuesToString(Values values, PivotField[] pivotFieldArray) {
        String string;
        block4: {
            block6: {
                block5: {
                    block3: {
                        string = values.toString();
                        if (!(values instanceof GrandTotalValues)) break block3;
                        string = "GrandTotalValues";
                        break block4;
                    }
                    if (!(values instanceof SummaryValues)) break block5;
                    int n = ((SummaryValues)values).getSummaryType();
                    string = "SummaryValues\t" + n + "\t";
                    int n2 = values.getCount();
                    for (int i = 0; i < n2 && i < pivotFieldArray.length; ++i) {
                        Object object = values.getValueAt(i).getValue();
                        string = string + ObjectConverterManager.toString(object, pivotFieldArray[i].getType(), pivotFieldArray[i].getConverterContext());
                        if (i == n2 - 1) continue;
                        string = string + "\t";
                    }
                    break block4;
                }
                if (!(values instanceof RunningSummaryValues)) break block6;
                int n = ((RunningSummaryValues)values).getRunningType();
                string = "RunningSummaryValues\t" + n + "\t";
                int n3 = values.getCount();
                for (int i = 0; i < n3 && i < pivotFieldArray.length; ++i) {
                    Object object = values.getValueAt(i).getValue();
                    string = string + ObjectConverterManager.toString(object, pivotFieldArray[i].getType(), pivotFieldArray[i].getConverterContext());
                    if (i == n3 - 1) continue;
                    string = string + "\t";
                }
                break block4;
            }
            if (!(values instanceof DefaultValues)) break block4;
            string = "DefaultValues\t";
            int n = values.getCount();
            for (int i = 0; i < n && i < pivotFieldArray.length; ++i) {
                Object object = values.getValueAt(i).getValue();
                string = string + ObjectConverterManager.toString(object, pivotFieldArray[i].getType(), pivotFieldArray[i].getConverterContext());
                if (i == n - 1) continue;
                string = string + "\t";
            }
        }
        return string;
    }

    private static void writeCollapseStateInformation(PivotTablePane pivotTablePane, Element element, boolean bl) {
        Map<String, Boolean> map = bl ? pivotTablePane.getPivotDataModel().getRowHeaderTableModel().getExpansionState() : pivotTablePane.getPivotDataModel().getColumnHeaderTableModel().getExpansionState();
        if (map != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : map.keySet()) {
                Boolean bl2 = map.get(string);
                if (bl2 == null || bl2.booleanValue()) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer = stringBuffer.append('\t');
                }
                stringBuffer = stringBuffer.append(string);
            }
            if (stringBuffer.length() > 0) {
                element.setAttribute(bl ? ATTRIBUTE_ROW_HEADER_COLLAPSED_NODES : ATTRIBUTE_COLUMN_HEADER_COLLAPSED_NODES, stringBuffer.toString());
            }
        }
    }

    private static void writeFieldElement(Document document, PivotTablePane pivotTablePane, PivotField pivotField, Element element, PersistenceUtilsCallback.Save save) {
        Filter[] filterArray;
        PivotField[] pivotFieldArray;
        Object object;
        Object object2;
        element.setAttribute(ATTRIBUTE_NAME, pivotField.getName());
        element.setAttribute(ATTRIBUTE_TITLE, pivotField.getOldTitle() != null ? pivotField.getOldTitle() : pivotField.getTitle());
        element.setAttribute(ATTRIBUTE_AREA_INDEX, "" + pivotField.getAreaIndex());
        element.setAttribute(ATTRIBUTE_AREA_TYPE, "" + pivotField.getAreaType());
        element.setAttribute(ATTRIBUTE_MODEL_INDEX, "" + pivotField.getModelIndex());
        element.setAttribute(ATTRIBUTE_DUPLICATED, pivotField.isDuplicated() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_SUBTOTAL_TYPE, "" + pivotField.getSubtotalType());
        element.setAttribute(ATTRIBUTE_SUBTOTAL_SUMMARY_TYPE, "" + pivotField.getSubtotalSummaryType());
        element.setAttribute(ATTRIBUTE_SUBTOTAL_TYPE_FOR_ROW, "" + pivotField.getSubtotalTypeForRow());
        element.setAttribute(ATTRIBUTE_SUBTOTAL_TYPE_FOR_COLUMN, "" + pivotField.getSubtotalTypeForColumn());
        int[] nArray = pivotField.getCustomSubtotals();
        element.setAttribute(ATTRIBUTE_SUBTOTALS, PersistenceUtils.intArrayToString(nArray));
        int[] nArray2 = pivotField.getCustomSubtotalsForRow();
        element.setAttribute(ATTRIBUTE_SUBTOTALS_FOR_ROW, PersistenceUtils.intArrayToString(nArray2));
        int[] nArray3 = pivotField.getCustomSubtotalsForColumn();
        element.setAttribute(ATTRIBUTE_SUBTOTALS_FOR_COLUMN, PersistenceUtils.intArrayToString(nArray3));
        element.setAttribute(ATTRIBUTE_SEPARATE_SUBTOTAL_SETTINGS, "" + pivotField.isSeparateSubtotalSettings());
        element.setAttribute(ATTRIBUTE_SUMMARY_TYPE, "" + pivotField.getSummaryType());
        element.setAttribute(ATTRIBUTE_GRAND_TOTAL_SUMMARY_TYPE, "" + pivotField.getGrandTotalSummaryType());
        element.setAttribute(ATTRIBUTE_PREFERRED_WIDTH, "" + pivotField.getPreferredWidth());
        element.setAttribute(ATTRIBUTE_ASCENDING, "" + pivotField.isAscending());
        element.setAttribute(ATTRIBUTE_HIDE_ORIGINAL, "" + pivotField.isHideOriginalData());
        if (pivotField.getSortByColumnKeys() != null) {
            element.setAttribute(ATTRIBUTE_SORT_BY_ASCENDING, pivotField.isSortByAscending() ? "1" : "0");
            element.setAttribute(ATTRIBUTE_SORT_BY_DATA_FIELD_MODEL_INDEX, "" + pivotField.getSortByDataFieldModelIndex());
            element.setAttribute(ATTRIBUTE_SORT_BY_SUMMARY_TYPE, "" + pivotField.getSortBySummaryType());
            element.setAttribute(ATTRIBUTE_SORT_BY_COLUMN_KEYS, "" + pivotTablePane.getPivotDataModel().getColumnHeaderTableModel().getFlatData().indexOf(pivotField.getSortByColumnKeys()));
        } else if (pivotField.getSortByRowKeys() != null) {
            element.setAttribute(ATTRIBUTE_SORT_BY_ASCENDING, pivotField.isSortByAscending() ? "1" : "0");
            element.setAttribute(ATTRIBUTE_SORT_BY_DATA_FIELD_MODEL_INDEX, "" + pivotField.getSortByDataFieldModelIndex());
            element.setAttribute(ATTRIBUTE_SORT_BY_SUMMARY_TYPE, "" + pivotField.getSortBySummaryType());
            element.setAttribute(ATTRIBUTE_SORT_BY_ROW_KEYS, "" + pivotTablePane.getPivotDataModel().getRowHeaderTableModel().getFlatData().indexOf(pivotField.getSortByRowKeys()));
        }
        Filter filter = pivotField.getActualFilter();
        if (filter != null) {
            element.setAttribute(ATTRIBUTE_FILTER, FilterUtils.getFilterPreference(filter, pivotField.getType(), pivotField.getConverterContext()));
        }
        if (pivotField.getFilterField() != null) {
            element.setAttribute(ATTRIBUTE_FILTER_FIELD, pivotField.getFilterField().getName());
            object2 = pivotField.getFilterBaseValues();
            if (object2 != null) {
                boolean bl = true;
                object = pivotTablePane.getPivotDataModel().getColumnFields();
                for (PivotField pivotField2 : object) {
                    if (pivotField2 != pivotField.getFilterField()) continue;
                    bl = false;
                    break;
                }
                pivotFieldArray = bl ? pivotTablePane.getPivotDataModel().getColumnFields() : pivotTablePane.getPivotDataModel().getRowFields();
                String string = PivotTablePersistenceUtils.convertValuesToString((Values)object2, pivotFieldArray);
                element.setAttribute(ATTRIBUTE_FILTER_BASE_VALUES, string);
            }
            if ((filterArray = pivotField.getValueFilters()) != null && filterArray.length > 0 && (object = filterArray[0]) != null) {
                element.setAttribute(ATTRIBUTE_VALUE_FILTERS, FilterUtils.getFilterPreference((Filter)object, pivotField.getType(), pivotField.getConverterContext()));
            }
        }
        if ((object2 = pivotField.getRunningSummaryList()) != null && object2.size() > 0) {
            filterArray = object2.iterator();
            while (filterArray.hasNext()) {
                object = (RunningSummary)filterArray.next();
                pivotFieldArray = document.createElement(NODE_RUNNING_SUMMARY);
                element.appendChild((Node)pivotFieldArray);
                PivotTablePersistenceUtils.writeRunningSummaryElement(document, (RunningSummary)object, (Element)pivotFieldArray, save);
            }
        }
        if (save != null) {
            save.save(document, element, pivotField);
        }
    }

    private static void writeRunningSummaryElement(Document document, RunningSummary runningSummary, Element element, PersistenceUtilsCallback.Save save) {
        element.setAttribute(ATTRIBUTE_RUNNING_SUMMARY_TYPE, "" + runningSummary.getRunningType());
        element.setAttribute(ATTRIBUTE_BASE_ON_FIELD, runningSummary.getBaseOnField().getName());
        element.setAttribute(ATTRIBUTE_RANGE_IN_FIELD, runningSummary.getRangeInField().getName());
        element.setAttribute(ATTRIBUTE_COMPARE_TO, "" + ObjectConverterManager.toString(runningSummary.getCompareTo(), RunningSummary.CompareToObject.class, CompareToConverter.CONTEXT));
        if (save != null) {
            save.save(document, element, runningSummary);
        }
    }

    private static void writeHiddenColumnElement(PivotTablePane pivotTablePane, Document document, Object[] objectArray, Element element, PersistenceUtilsCallback.Save save) {
        if (objectArray.length >= 3 && objectArray[0] instanceof Values && objectArray[1] instanceof PivotField && objectArray[2] instanceof String) {
            element.setAttribute(ATTRIBUTE_HIDDEN_VALUES, "" + pivotTablePane.getPivotDataModel().getColumnHeaderTableModel().getFlatData().indexOf(objectArray[0]));
            element.setAttribute(ATTRIBUTE_HIDDEN_DATA_FIELDS, ((PivotField)objectArray[1]).getName());
            element.setAttribute(ATTRIBUTE_HIDDEN_WIDTHS, "" + objectArray[2]);
        }
        if (save != null) {
            save.save(document, element, objectArray);
        }
    }

    public static void load(PivotTablePane pivotTablePane, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        PivotTablePersistenceUtils.load(pivotTablePane, PersistenceUtils.getDocument(inputStream));
    }

    public static void load(PivotTablePane pivotTablePane, String string) throws ParserConfigurationException, SAXException, IOException {
        PivotTablePersistenceUtils.load(pivotTablePane, PersistenceUtils.getDocument(string));
    }

    public static void load(PivotTablePane pivotTablePane, Document document) {
        PivotTablePersistenceUtils.load(pivotTablePane, document, null);
    }

    public static void load(PivotTablePane pivotTablePane, InputStream inputStream, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        PivotTablePersistenceUtils.load(pivotTablePane, PersistenceUtils.getDocument(inputStream), load);
    }

    public static void load(PivotTablePane pivotTablePane, String string, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        PivotTablePersistenceUtils.load(pivotTablePane, PersistenceUtils.getDocument(string), load);
    }

    public static void load(PivotTablePane pivotTablePane, Document document, PersistenceUtilsCallback.Load load) {
        Object object;
        Integer n;
        Integer n2;
        int n3;
        Object object3;
        Object object422;
        Object object5;
        Object object6;
        _pivotField = null;
        sortByAscending = null;
        sortByColumnKeys = null;
        sortByRowKeys = null;
        sortByDataFieldIndex = null;
        sortBySummaryType = null;
        _hiddenColumns = null;
        _hiddenRowValues = null;
        _hiddenColumnValues = null;
        IPivotDataModel iPivotDataModel = pivotTablePane.getPivotDataModel();
        if (iPivotDataModel instanceof PivotDataModel) {
            object6 = iPivotDataModel.getFields();
            object5 = new ArrayList();
            for (Object object422 : object6) {
                if (object422 == null || !((Field)object422).isDuplicated()) continue;
                object5.add(object422);
            }
            object3 = object5.iterator();
            while (object3.hasNext()) {
                PivotField pivotField = (PivotField)object3.next();
                ((PivotDataModel)iPivotDataModel).removeDuplicatedField(pivotField);
            }
        }
        if ((object6 = document.getElementsByTagName("component").item(0)) == null) {
            throw new IllegalArgumentException(pivotTablePane.getResourceString("PivotTablePane.invalidLayoutFile"));
        }
        object5 = object6.getAttributes();
        object3 = null;
        for (int i = 0; i < object5.getLength(); ++i) {
            Node node = object5.item(i);
            if (!"version".equals(node.getNodeName())) continue;
            object3 = node.getNodeValue();
            break;
        }
        if (object3 != null) {
            pivotTablePane.setVersion((String)object3);
        }
        NodeList nodeList = object6.getChildNodes();
        for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
            object422 = nodeList.item(n3);
            if (!(object422 instanceof Element) || !NODE_PIVOT_TABLE.equals(object422.getNodeName())) continue;
            PivotTablePersistenceUtils.readPivotTableElement(pivotTablePane, document, (Element)object422, load);
        }
        nodeList = object6.getChildNodes();
        for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
            object422 = nodeList.item(n3);
            if (!(object422 instanceof Element) || !NODE_FIELD.equals(object422.getNodeName())) continue;
            PivotTablePersistenceUtils.readFieldElement(pivotTablePane, document, (Element)object422, load);
        }
        if (sortByColumnKeys != null && _pivotField != null && (n2 = Integer.valueOf(sortByColumnKeys)) != null) {
            Object object22;
            iPivotDataModel.calculate();
            if (sortByDataFieldIndex != null) {
                _pivotField.setSortByDataFieldModelIndex(Integer.valueOf(sortByDataFieldIndex));
            }
            if (sortByAscending != null) {
                _pivotField.setSortByAscending("1".equals(sortByAscending));
            }
            if (sortBySummaryType != null) {
                _pivotField.setSortBySummaryType(Integer.valueOf(sortBySummaryType));
            }
            object422 = iPivotDataModel.getColumnHeaderTableModel().getFlatData();
            if (n2 >= 0 && n2 < object422.size() && (object22 = object422.get(n2)) instanceof Values) {
                _pivotField.setSortByColumnKeys((Values)object22);
            }
        }
        if (sortByRowKeys != null && _pivotField != null && (n = Integer.valueOf(sortByRowKeys)) != null) {
            Object e;
            iPivotDataModel.calculate();
            if (sortByDataFieldIndex != null) {
                _pivotField.setSortByDataFieldModelIndex(Integer.valueOf(sortByDataFieldIndex));
            }
            if (sortByAscending != null) {
                _pivotField.setSortByAscending("1".equals(sortByAscending));
            }
            if (sortBySummaryType != null) {
                _pivotField.setSortBySummaryType(Integer.valueOf(sortBySummaryType));
            }
            object422 = iPivotDataModel.getRowHeaderTableModel().getFlatData();
            if (n >= 0 && n < object422.size() && (e = object422.get(n)) instanceof Values) {
                _pivotField.setSortByRowKeys((Values)e);
            }
        }
        pivotTablePane.fieldsUpdated();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object422 = nodeList.item(i);
            if (!(object422 instanceof Element) || !NODE_PIVOT_TABLE.equals(object422.getNodeName())) continue;
            PivotTablePersistenceUtils.readCollapsedNodes(pivotTablePane, (Element)object422, true);
            PivotTablePersistenceUtils.readCollapsedNodes(pivotTablePane, (Element)object422, false);
        }
        if (_hiddenColumns != null) {
            TableColumnModel tableColumnModel = pivotTablePane.getDataTable().getColumnModel();
            object422 = pivotTablePane.getColumnHeaderTable().getColumnModel();
            PivotField[] pivotFieldArray = iPivotDataModel.getDataFields();
            object = iPivotDataModel.getColumnHeaderTableModel().getFlatData();
            for (Object object2 : _hiddenColumns) {
                Object[] objectArray;
                if (!(object2 instanceof Object[]) || (objectArray = (Object[])object2).length < 3 || !(objectArray[0] instanceof String)) continue;
                Integer n4 = Integer.valueOf((String)objectArray[0]);
                if (n4 >= 0 && n4 < object.size()) {
                    objectArray[0] = object.get(n4);
                }
                if (objectArray.length < 3 || !(objectArray[0] instanceof Values) || !(objectArray[1] instanceof PivotField) || !(objectArray[2] instanceof String)) continue;
                int n5 = n4 * Math.max(1, pivotFieldArray.length);
                int n6 = 0;
                while (n6 < pivotFieldArray.length && objectArray[1] != pivotFieldArray[n6]) {
                    ++n6;
                    ++n5;
                }
                iPivotDataModel.addHiddenColumn((Values)objectArray[0], (PivotField)objectArray[1], (String)objectArray[2]);
                TableColumn tableColumn = tableColumnModel.getColumn(n5);
                pivotTablePane.installPropertyChangeListenerForColumn(tableColumn);
                tableColumn.setMinWidth(0);
                tableColumn.setPreferredWidth(0);
                tableColumn.setWidth(0);
                tableColumn = object422.getColumn(n5);
                pivotTablePane.installPropertyChangeListenerForColumn(tableColumn);
                tableColumn.setMinWidth(0);
                tableColumn.setPreferredWidth(0);
                tableColumn.setWidth(0);
            }
        }
        boolean bl = false;
        if (_hiddenRowValues != null) {
            for (String string : _hiddenRowValues) {
                if (!(string instanceof String) || (object = PivotTablePersistenceUtils.convertStringToValues(string, iPivotDataModel.getRowFields())) == null) continue;
                iPivotDataModel.addHiddenValues((Values)object);
                bl = true;
            }
        }
        if (_hiddenColumnValues != null) {
            for (String string : _hiddenColumnValues) {
                if (!(string instanceof String) || (object = PivotTablePersistenceUtils.convertStringToValues(string, iPivotDataModel.getColumnFields())) == null) continue;
                iPivotDataModel.addHiddenValues((Values)object);
                bl = true;
            }
        }
        if (bl) {
            pivotTablePane.bothHeadersUpdated();
            pivotTablePane.hideRowHeaderTableColumns();
        }
        _pivotField = null;
        _hiddenColumns = null;
        _hiddenRowValues = null;
        _hiddenColumnValues = null;
    }

    private static void readCollapsedNodes(PivotTablePane pivotTablePane, Element element, boolean bl) {
        Object object;
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (ATTRIBUTE_ROW_HEADER_COLLAPSED_NODES.equals(object.getNodeName()) && bl) {
                string = object.getNodeValue();
                break;
            }
            if (!ATTRIBUTE_COLUMN_HEADER_COLLAPSED_NODES.equals(object.getNodeName()) || bl) continue;
            string = object.getNodeValue();
            break;
        }
        if (string != null) {
            String[] stringArray = string.split("\t");
            object = new HashMap();
            for (String string2 : stringArray) {
                object.put(string2, Boolean.FALSE);
            }
            if (bl) {
                pivotTablePane.getPivotDataModel().getRowHeaderTableModel().setExpansionState((Map<String, Boolean>)object);
            } else {
                pivotTablePane.getPivotDataModel().getColumnHeaderTableModel().setExpansionState((Map<String, Boolean>)object);
            }
        }
    }

    public static void readPivotTableElement(PivotTablePane pivotTablePane, Document document, Element element, PersistenceUtilsCallback.Load load) {
        String[] stringArray;
        Object object;
        int n;
        Object object2;
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object2 = namedNodeMap.item(i);
            if (ATTRIBUTE_GRAND_TOTAL_FOR_COLUMN.equals(object2.getNodeName())) {
                string = object2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_GRAND_TOTAL_FOR_ROW.equals(object2.getNodeName())) {
                string2 = object2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST.equals(object2.getNodeName())) {
                string3 = object2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_ROW.equals(object2.getNodeName())) {
                string4 = object2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_COLUMN.equals(object2.getNodeName())) {
                string5 = object2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SHOW_DATA_FIELDS_IN_ROW_AREA.equals(object2.getNodeName())) {
                string6 = object2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_LAYOUT_DATA_FIELDS_FIRST.equals(object2.getNodeName())) {
                string7 = object2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SHOW_FILTER_BUTTON_ON_MOUSE_OVER.equals(object2.getNodeName())) {
                pivotTablePane.setShowFilterButtonsOnMouseOver(object2.getNodeValue().equals("1"));
                continue;
            }
            if (ATTRIBUTE_SHOW_FIELD_LIST.equals(object2.getNodeName())) {
                pivotTablePane.setFieldChooserVisible(object2.getNodeValue().equals("1"));
                continue;
            }
            if (ATTRIBUTE_FIELD_CHOOSER_FILTER_FIELD_VISIBLE.equals(object2.getNodeName())) {
                pivotTablePane.setFieldChooserFilterFieldVisible(object2.getNodeValue().equals("1"));
                continue;
            }
            if (ATTRIBUTE_FIELD_CHOOSER_FILTER.equals(object2.getNodeName())) {
                string8 = object2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_HIDDEN_COLUMNS.equals(object2.getNodeName())) continue;
            string9 = object2.getNodeValue();
        }
        IPivotDataModel iPivotDataModel = pivotTablePane.getPivotDataModel();
        if (iPivotDataModel != null) {
            iPivotDataModel.setShowGrandTotalForColumn("1".equals(string));
            iPivotDataModel.setShowGrandTotalForRow("1".equals(string2));
            if (string3 != null) {
                iPivotDataModel.setDisplayGrandTotalFirstForColumn("1".equals(string3));
                iPivotDataModel.setDisplayGrandTotalFirstForRow("1".equals(string3));
            }
            if (string4 != null) {
                iPivotDataModel.setDisplayGrandTotalFirstForRow("1".equals(string4));
            }
            if (string5 != null) {
                iPivotDataModel.setDisplayGrandTotalFirstForColumn("1".equals(string5));
            }
            if (string6 != null) {
                iPivotDataModel.setAlwaysRowDataFields("1".equals(string6));
            }
            if (string7 != null) {
                iPivotDataModel.setLayoutDataFieldsFirst("1".equals(string7));
            }
        }
        object2 = element.getChildNodes();
        for (n = 0; n < object2.getLength(); ++n) {
            object = object2.item(n);
            if (!(object instanceof Element) || !NODE_FIELD.equals(object.getNodeName())) continue;
            PivotTablePersistenceUtils.readFieldElement(pivotTablePane, document, (Element)object, load);
        }
        if (string8 != null && pivotTablePane.getFilterField() != null && (stringArray = string8.split("\t")).length >= 6) {
            pivotTablePane.getFilterField().setSearchingText(stringArray[0]);
            pivotTablePane.getFilterField().setCaseSensitive("1".equals(stringArray[1]));
            pivotTablePane.getFilterField().setFromStart("1".equals(stringArray[2]));
            pivotTablePane.getFilterField().setFromEnd("1".equals(stringArray[3]));
            pivotTablePane.getFilterField().setRegexEnabled("1".equals(stringArray[4]));
            pivotTablePane.getFilterField().setWildcardEnabled("1".equals(stringArray[5]));
        }
        if (string9 != null) {
            String[] stringArray2 = string9.split("\t");
            for (String string10 : stringArray2) {
                pivotTablePane.addHiddenRowField(pivotTablePane.getPivotDataModel().getField(string10));
            }
        }
        object2 = element.getChildNodes();
        _hiddenColumns = new ArrayList<Object>();
        _hiddenRowValues = new ArrayList<String>();
        _hiddenColumnValues = new ArrayList<String>();
        for (n = 0; n < object2.getLength(); ++n) {
            object = object2.item(n);
            if (!(object instanceof Element)) continue;
            if (NODE_HIDDEN_COLUMNS_IN_DATA_TABLE.equals(object.getNodeName())) {
                Object[] objectArray = PivotTablePersistenceUtils.readHiddenColumnElement(pivotTablePane, document, (Element)object, load);
                _hiddenColumns.add(objectArray);
                continue;
            }
            if (NODE_HIDDEN_ROW_VALUES.equals(object.getNodeName())) {
                String string11 = PivotTablePersistenceUtils.readHiddenValuesElement(pivotTablePane, document, (Element)object, load);
                _hiddenRowValues.add(string11);
                continue;
            }
            if (!NODE_HIDDEN_COLUMN_VALUES.equals(object.getNodeName())) continue;
            String string12 = PivotTablePersistenceUtils.readHiddenValuesElement(pivotTablePane, document, (Element)object, load);
            _hiddenColumnValues.add(string12);
        }
        if (load != null) {
            load.load(document, element, pivotTablePane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFieldElement(PivotTablePane pivotTablePane, Document document, Element element, PersistenceUtilsCallback.Load load) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = "false";
        String string15 = null;
        String string16 = null;
        String string17 = null;
        String string18 = null;
        String string19 = null;
        String string20 = null;
        String string21 = null;
        String string22 = null;
        String string23 = null;
        String string24 = null;
        String string25 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (ATTRIBUTE_NAME.equals(node.getNodeName())) {
                string = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_TITLE.equals(node.getNodeName())) {
                string2 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_AREA_INDEX.equals(node.getNodeName())) {
                string3 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_AREA_TYPE.equals(node.getNodeName())) {
                string4 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_MODEL_INDEX.equals(node.getNodeName())) {
                string5 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DUPLICATED.equals(node.getNodeName())) {
                string6 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUBTOTAL_TYPE.equals(node.getNodeName())) {
                string7 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUBTOTAL_SUMMARY_TYPE.equals(node.getNodeName())) {
                string8 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUBTOTAL_TYPE_FOR_ROW.equals(node.getNodeName())) {
                string9 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUBTOTAL_TYPE_FOR_COLUMN.equals(node.getNodeName())) {
                string10 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SEPARATE_SUBTOTAL_SETTINGS.equals(node.getNodeName())) {
                string14 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUBTOTALS.equals(node.getNodeName())) {
                string11 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUBTOTALS_FOR_ROW.equals(node.getNodeName())) {
                string12 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUBTOTALS_FOR_COLUMN.equals(node.getNodeName())) {
                string13 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUMMARY_TYPE.equals(node.getNodeName())) {
                string15 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_GRAND_TOTAL_SUMMARY_TYPE.equals(node.getNodeName())) {
                string16 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_WIDTH.equals(node.getNodeName())) {
                string17 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_ASCENDING.equals(node.getNodeName())) {
                string18 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_HIDE_ORIGINAL.equals(node.getNodeName())) {
                string19 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_FILTER.equals(node.getNodeName())) {
                string20 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SORT_BY_COLUMN_KEYS.equals(node.getNodeName())) {
                string21 = sortByColumnKeys = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SORT_BY_ROW_KEYS.equals(node.getNodeName())) {
                string22 = sortByRowKeys = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SORT_BY_DATA_FIELD_MODEL_INDEX.equals(node.getNodeName())) {
                sortByDataFieldIndex = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SORT_BY_ASCENDING.equals(node.getNodeName())) {
                sortByAscending = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SORT_BY_SUMMARY_TYPE.equals(node.getNodeName())) {
                sortBySummaryType = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_FILTER_FIELD.equals(node.getNodeName())) {
                string23 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_FILTER_BASE_VALUES.equals(node.getNodeName())) {
                string24 = node.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_VALUE_FILTERS.equals(node.getNodeName())) continue;
            string25 = node.getNodeValue();
        }
        PivotField pivotField = null;
        if (string != null) {
            int n;
            pivotField = pivotTablePane.getPivotDataModel().getField(string);
            if (pivotField == null && "1".equals(string6) && string.contains(":") && (n = string.lastIndexOf(58)) > 0 && n < string.length()) {
                string = string.substring(0, n);
                pivotField = pivotTablePane.getPivotDataModel().getField(string);
            }
            if (pivotField == null && string5 != null) {
                try {
                    Integer n2 = Integer.parseInt(string5);
                    pivotField = pivotTablePane.getPivotDataModel().getField(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (pivotField != null) {
            PropertyChangeListener[] propertyChangeListenerArray;
            if (string21 != null || string22 != null) {
                _pivotField = pivotField;
            }
            if ("1".equals(string6) && pivotTablePane.getPivotDataModel() instanceof PivotDataModel) {
                pivotField = ((PivotDataModel)pivotTablePane.getPivotDataModel()).duplicateField(pivotField);
            }
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = pivotField.getPropertyChangeListeners()) {
                pivotField.removePropertyChangeListener(propertyChangeListener);
            }
            try {
                pivotField.setTitle(string2);
                if (string3 != null) {
                    pivotField.setAreaIndex(Integer.parseInt(string3));
                }
                try {
                    if (string4 != null) {
                        pivotField.setAreaType(Integer.parseInt(string4));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (string7 != null) {
                    pivotField.setSubtotalType(Integer.parseInt(string7));
                }
                if (string8 != null) {
                    pivotField.setSubtotalSummaryType(Integer.parseInt(string8));
                }
                if (string9 != null) {
                    pivotField.setSubtotalTypeForRow(Integer.parseInt(string9));
                }
                if (string10 != null) {
                    pivotField.setSubtotalTypeForColumn(Integer.parseInt(string10));
                }
                if (string11 != null) {
                    pivotField.setCustomSubtotals(PersistenceUtils.stringToIntArray(string11));
                }
                if (string12 != null) {
                    pivotField.setCustomSubtotalsForRow(PersistenceUtils.stringToIntArray(string12));
                }
                if (string13 != null) {
                    pivotField.setCustomSubtotalsForColumn(PersistenceUtils.stringToIntArray(string13));
                }
                if (string14 != null) {
                    pivotField.setSeparateSubtotalSettings(PivotTablePersistenceUtils.parseBoolean(string14));
                }
                if (string15 != null) {
                    pivotField.setSummaryType(Integer.parseInt(string15));
                }
                if (string16 != null) {
                    pivotField.setGrandTotalSummaryType(Integer.parseInt(string16));
                }
                if (string17 != null) {
                    pivotField.setPreferredWidth(Integer.parseInt(string17));
                }
                if (string18 != null) {
                    pivotField.setAscending(PivotTablePersistenceUtils.parseBoolean(string18));
                }
                if (string19 != null) {
                    pivotField.setHideOriginalData(PivotTablePersistenceUtils.parseBoolean(string19));
                }
                if (string20 != null) {
                    Filter propertyChangeListenerArray2 = FilterUtils.setFilterPreference(string20, pivotField.getType(), pivotField.getConverterContext());
                    if (propertyChangeListenerArray2 instanceof MultipleValuesFilter) {
                        pivotField.setPreferSelectedPossibleValues(true);
                        pivotField.setSelectedPossibleValues(((MultipleValuesFilter)propertyChangeListenerArray2).getValues());
                    } else if (propertyChangeListenerArray2 instanceof NotFilter && ((NotFilter)propertyChangeListenerArray2).getFilter() instanceof MultipleValuesFilter) {
                        pivotField.setPreferSelectedPossibleValues(false);
                        pivotField.setFilteredPossibleValues(((MultipleValuesFilter)((NotFilter)propertyChangeListenerArray2).getFilter()).getValues());
                    } else {
                        pivotField.setFilter(propertyChangeListenerArray2);
                    }
                } else {
                    pivotField.setFilter(null);
                    pivotField.setFilteredPossibleValues(null);
                    pivotField.setSelectedPossibleValues(null);
                }
                if (string25 != null) {
                    Filter filter = FilterUtils.setFilterPreference(string25, pivotField.getType(), pivotField.getConverterContext());
                    pivotField.setValueFilters(new Filter[]{filter});
                }
                if (string23 != null) {
                    pivotField.setFilterField(pivotTablePane.getPivotDataModel().getField(string23));
                }
                if (string24 != null) {
                    boolean bl;
                    PivotField[] pivotFieldArray;
                    boolean bl2 = true;
                    for (PivotField pivotField2 : pivotFieldArray = pivotTablePane.getPivotDataModel().getColumnFields()) {
                        if (pivotField2 != pivotField.getFilterField()) continue;
                        bl = false;
                        break;
                    }
                    PivotField[] pivotFieldArray2 = bl ? pivotTablePane.getPivotDataModel().getColumnFields() : pivotTablePane.getPivotDataModel().getRowFields();
                    pivotField.setFilterBaseValues(PivotTablePersistenceUtils.convertStringToValues(string24, pivotFieldArray2));
                }
                NodeList nodeList = element.getChildNodes();
                ArrayList<RunningSummary> arrayList = new ArrayList<RunningSummary>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    RunningSummary runningSummary;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !NODE_RUNNING_SUMMARY.equals(node.getNodeName()) || (runningSummary = PivotTablePersistenceUtils.readRunningSummaryElement(pivotTablePane, document, (Element)node, load)) == null) continue;
                    arrayList.add(runningSummary);
                }
                pivotField.setRunningSummaryList(arrayList);
            }
            finally {
                for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
                    pivotField.addPropertyChangeListener(propertyChangeListener);
                }
            }
        }
        if (load != null) {
            load.load(document, element, pivotField);
        }
    }

    private static Values convertStringToValues(String string, PivotField[] pivotFieldArray) {
        String[] stringArray = string.split("\t");
        if (stringArray.length > 0) {
            if (stringArray[0].equals("GrandTotalValues")) {
                return new GrandTotalValues();
            }
            if (stringArray[0].equals("SummaryValues")) {
                if (stringArray.length > 2) {
                    int n = 0;
                    try {
                        n = Integer.valueOf(stringArray[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int n2 = stringArray.length - 2;
                    ArrayList<Value> arrayList = new ArrayList<Value>();
                    for (int i = 0; i < n2 && i < pivotFieldArray.length; ++i) {
                        Object object = ObjectConverterManager.fromString(stringArray[i + 2], pivotFieldArray[i].getType(), pivotFieldArray[i].getConverterContext());
                        if (i != n2 - 1) {
                            arrayList.add(new DefaultExpandableValue(object));
                            continue;
                        }
                        arrayList.add(new SummaryValue(object, n));
                    }
                    return new SummaryValues(arrayList);
                }
            } else if (!stringArray[0].equals("RunningSummaryValues") && stringArray[0].equals("DefaultValues") && stringArray.length > 2) {
                int n = stringArray.length - 1;
                ArrayList<Value> arrayList = new ArrayList<Value>();
                for (int i = 0; i < n && i < pivotFieldArray.length; ++i) {
                    Object object = ObjectConverterManager.fromString(stringArray[i + 1], pivotFieldArray[i].getType(), pivotFieldArray[i].getConverterContext());
                    arrayList.add(new DefaultExpandableValue(object));
                }
                return new DefaultValues(arrayList);
            }
        }
        return null;
    }

    private static RunningSummary readRunningSummaryElement(PivotTablePane pivotTablePane, Document document, Element element, PersistenceUtilsCallback.Load load) {
        Object object;
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (ATTRIBUTE_RUNNING_SUMMARY_TYPE.equals(object.getNodeName())) {
                string = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_BASE_ON_FIELD.equals(object.getNodeName())) {
                string2 = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_RANGE_IN_FIELD.equals(object.getNodeName())) {
                string3 = object.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_COMPARE_TO.equals(object.getNodeName())) continue;
            string4 = object.getNodeValue();
        }
        RunningSummary runningSummary = new RunningSummary();
        runningSummary.setRunningType(Integer.parseInt(string));
        if (pivotTablePane.getPivotDataModel().getField(string2) == null) {
            return null;
        }
        runningSummary.setBaseOnField(pivotTablePane.getPivotDataModel().getField(string2));
        if (pivotTablePane.getPivotDataModel().getField(string3) != null) {
            runningSummary.setRangeInField(pivotTablePane.getPivotDataModel().getField(string3));
        } else {
            runningSummary.setRangeInField(RunningSummary.RangeTotalField.INSTANCE);
        }
        object = null;
        if ("1".equals(string4)) {
            object = RunningSummary.CompareToObject.COMPARE_NEXT;
        } else if ("0".equals(string4)) {
            object = RunningSummary.CompareToObject.COMPARE_PREVIOUS;
        }
        if (object == null) {
            Object object2 = ObjectConverterManager.fromString(string4, RunningSummary.CompareToObject.class, CompareToConverter.CONTEXT);
            object = object2 instanceof RunningSummary.CompareToObject ? (RunningSummary.CompareToObject)object2 : RunningSummary.CompareToObject.COMPARE_PREVIOUS;
        }
        runningSummary.setCompareTo(object);
        if (load != null) {
            load.load(document, element, runningSummary);
        }
        return runningSummary;
    }

    private static Object[] readHiddenColumnElement(PivotTablePane pivotTablePane, Document document, Element element, PersistenceUtilsCallback.Load load) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (ATTRIBUTE_HIDDEN_VALUES.equals(node.getNodeName())) {
                string = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_HIDDEN_DATA_FIELDS.equals(node.getNodeName())) {
                string2 = node.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_HIDDEN_WIDTHS.equals(node.getNodeName())) continue;
            string3 = node.getNodeValue();
        }
        Object[] objectArray = new Object[]{string, pivotTablePane.getPivotDataModel().getField(string2), string3};
        if (load != null) {
            load.load(document, element, objectArray);
        }
        return objectArray;
    }

    private static String readHiddenValuesElement(PivotTablePane pivotTablePane, Document document, Element element, PersistenceUtilsCallback.Load load) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (!ATTRIBUTE_HIDDEN_VALUES.equals(node.getNodeName())) continue;
            string = node.getNodeValue();
        }
        if (load != null) {
            load.load(document, element, string);
        }
        return string;
    }

    private static boolean parseBoolean(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }

    public static String getVersion(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return PivotTablePersistenceUtils.getVersion(PersistenceUtils.getDocument(inputStream));
    }

    public static String getVersion(String string) throws ParserConfigurationException, SAXException, IOException {
        return PivotTablePersistenceUtils.getVersion(PersistenceUtils.getDocument(string));
    }

    public static String getVersion(Document document) {
        return PersistenceUtils.getVersion(document);
    }

    public static void isLayoutValid(PivotTablePane pivotTablePane, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException, IllegalArgumentException {
        PivotTablePersistenceUtils.isLayoutValid(pivotTablePane, PersistenceUtils.getDocument(inputStream));
    }

    public static void isLayoutValid(PivotTablePane pivotTablePane, String string) throws ParserConfigurationException, SAXException, IOException, IllegalArgumentException {
        PivotTablePersistenceUtils.isLayoutValid(pivotTablePane, PersistenceUtils.getDocument(string));
    }

    public static void isLayoutValid(PivotTablePane pivotTablePane, Document document) throws IllegalArgumentException {
        Node node = document.getElementsByTagName("component").item(0);
        if (node == null) {
            throw new IllegalArgumentException(pivotTablePane.getResourceString("PivotTablePane.invalidLayoutFile"));
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!"version".equals(node2.getNodeName())) continue;
            string = node2.getNodeValue();
            break;
        }
        if (string != null) {
            throw new IllegalArgumentException("There is no version information in the layout.");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!NODE_FIELD.equals(node3.getNodeName())) continue;
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            String string2 = null;
            for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                Node node4 = namedNodeMap2.item(j);
                if (!ATTRIBUTE_NAME.equals(node4.getNodeName())) continue;
                string2 = node4.getNodeValue();
            }
            PivotField pivotField = pivotTablePane.getPivotDataModel().getField(string2);
            if (pivotField != null) continue;
            throw new IllegalArgumentException("The layout has a field \"" + string2 + "\" which is no longer in the PivotTablePane.");
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(32)) {
            Lm.showInvalidProductMessage(PivotTablePersistenceUtils.class.getName(), 32);
        }
        sortByAscending = null;
        sortByColumnKeys = null;
        sortByRowKeys = null;
        sortByDataFieldIndex = null;
        sortBySummaryType = null;
        _hiddenColumns = null;
        _hiddenRowValues = null;
        _hiddenColumnValues = null;
    }
}

