/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.Field;
import com.jidesoft.pivot.PivotConstants;
import com.jidesoft.pivot.PivotDataSource;
import com.jidesoft.pivot.RunningSummary;
import com.jidesoft.pivot.Summary;
import com.jidesoft.pivot.TableModelPivotDataSource;
import com.jidesoft.pivot.Values;
import com.jidesoft.range.BooleanRange;
import com.jidesoft.range.IntegerRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.StringRange;
import com.jidesoft.range.TimeRange;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.TypeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class PivotField
extends Field
implements Comparable<PivotField>,
PivotConstants,
Cloneable {
    private static final long serialVersionUID = -8318753344345181030L;
    private int _areaType;
    private int _areaIndex;
    private Summary _customSummary;
    private int _summaryType = 0;
    private int _subtotalSummaryType = 0;
    private int _grandTotalSummaryType = 0;
    private boolean _separateSubtotalSettings = false;
    private int _subtotalType;
    private int[] _customSubtotals;
    private int _subtotalTypeForRow;
    private int[] _customSubtotalsForRow;
    private int _subtotalTypeForColumn;
    private int[] _customSubtotalsForColumn;
    private boolean _hideOriginalData;
    private List<RunningSummary> _runningSummaryList;
    private PivotField _filterField;
    private Values _filterBaseValues;
    private Filter[] _valueFilters;
    private boolean _andMode = true;
    private Object[] _filterEditorPossibleValues;
    public static final int LOCATION_AFTER = 0;
    public static final int LOCATION_BEFORE = 1;
    private int _subtotalLocation = 0;
    public static final String PROPERTY_SUMMARY_TYPE = "summaryType";
    public static final String PROPERTY_GRAND_TOTAL_SUMMARY_TYPE = "grandTotalSummaryType";
    public static final String PROPERTY_SUBTOTAL_SUMMARY_TYPE = "subtotalSummaryType";
    public static final String PROPERTY_SUBTOTAL_TYPE = "subtotalType";
    public static final String PROPERTY_SUBTOTAL_LOCATION = "subtotalLocation";
    public static final String PROPERTY_CUSTOM_SUBTOTALS = "customSubtotals";
    public static final String PROPERTY_AREA_TYPE = "areaType";
    public static final String PROPERTY_AREA_INDEX = "areaIndex";
    public static final String PROPERTY_SORT_BY = "sortBy";
    public static final String PROPERTY_SORT_BY_ROW = "sortByRow";
    public static final String PROPERTY_FILTER_ON_SUMMARY = "filterOnSummary";
    public static final String PROPERTY_RUNNING_SUMMARY_LIST = "runningSummaryList";
    private boolean _allowedAsDataField = true;
    private boolean _allowedAsFilterField = true;
    private boolean _allowedAsRowField = true;
    private boolean _allowedAsColumnField = true;
    private boolean _allowedAsUnassignedField = true;
    private int _sortByDataFieldModelIndex = -1;
    private Values _sortByColumnKeys;
    private Values _sortByRowKeys;
    private boolean _sortByAscending;
    private int _sortBySummaryType;
    private boolean _dataFieldFilterOnSummary = false;
    private final Map<Object, String> _dataFieldFilteredValues = new HashMap<Object, String>();
    private int _statisticsCalculationType = -1;
    private String _oldTitle;

    public PivotField() {
    }

    public PivotField(TableModel tableModel, int n) {
        this._areaType = -1;
        this._areaIndex = -1;
        this._subtotalType = 0;
        this.updateFromTableModel(tableModel, n);
    }

    public PivotField(PivotDataSource pivotDataSource, int n) {
        this._areaType = -1;
        this._areaIndex = -1;
        this._subtotalType = 0;
        this.updateFromDataSource(pivotDataSource, n, false);
    }

    void updateFromDataSource(PivotDataSource pivotDataSource, int n, boolean bl) {
        this._modelIndex = n;
        if (!bl) {
            this.setName(pivotDataSource.getFieldName(n));
            this.setTitle(pivotDataSource.getFieldTitle(n));
            this.setType(pivotDataSource.getFieldType(n));
        }
        if (pivotDataSource instanceof TableModelPivotDataSource && ((TableModelPivotDataSource)pivotDataSource).getTableModel() instanceof ContextSensitiveTableModel) {
            this._tableModel = ((TableModelPivotDataSource)pivotDataSource).getTableModel();
            try {
                if (!this._isConverterContextSet) {
                    this.internalSetConverterContext(((ContextSensitiveTableModel)this._tableModel).getConverterContextAt(-1, n));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!this._isEditorContextSet) {
                    this.internalSetEditorContext(((ContextSensitiveTableModel)this._tableModel).getEditorContextAt(-1, n));
                }
            }
            catch (Exception exception) {}
        } else {
            if (!this._isConverterContextSet) {
                this.internalSetConverterContext(null);
            }
            if (!this._isEditorContextSet) {
                this.internalSetEditorContext(null);
            }
        }
    }

    public int getAreaType() {
        return this._areaType;
    }

    public boolean isNumericType() {
        return TypeUtils.isNumericType(this.getType());
    }

    public void setAreaType(int n) {
        int n2 = this._areaType;
        if (n2 != n) {
            if (!this.isAllowedAsDataField() && n == 3) {
                throw new IllegalArgumentException("PivotField \"" + this.getName() + "\" is not allowed as data field");
            }
            if (!this.isAllowedAsFilterField() && n == 2) {
                throw new IllegalArgumentException("PivotField \"" + this.getName() + "\" is not allowed as a filter field");
            }
            if (!this.isAllowedAsRowField() && n == 0) {
                throw new IllegalArgumentException("PivotField \"" + this.getName() + "\" is not allowed as a row field");
            }
            if (!this.isAllowedAsColumnField() && n == 1) {
                throw new IllegalArgumentException("PivotField \"" + this.getName() + "\" is not allowed as a column field");
            }
            this._areaType = n;
            this.firePropertyChange(PROPERTY_AREA_TYPE, n2, n);
        }
    }

    public int getAreaIndex() {
        return this._areaIndex;
    }

    public void setAreaIndex(int n) {
        int n2 = this._areaIndex;
        if (n2 != n) {
            this._areaIndex = n;
            this.firePropertyChange(PROPERTY_AREA_INDEX, n2, n);
        }
    }

    @Override
    public int compareTo(PivotField pivotField) {
        if (pivotField.getAreaIndex() > this.getAreaIndex()) {
            return -1;
        }
        if (pivotField.getAreaIndex() < this.getAreaIndex()) {
            return 1;
        }
        return 0;
    }

    public Summary getCustomSummary() {
        return this._customSummary;
    }

    public void setCustomSummary(Summary summary) {
        this._customSummary = summary;
    }

    public int getSummaryType() {
        return this._summaryType;
    }

    public void setSummaryType(int n) {
        int n2 = this._summaryType;
        if (n2 != n) {
            this._summaryType = n;
            this.firePropertyChange(PROPERTY_SUMMARY_TYPE, n2, n);
        }
    }

    public int getGrandTotalSummaryType() {
        return this._grandTotalSummaryType;
    }

    public void setGrandTotalSummaryType(int n) {
        int n2 = this._grandTotalSummaryType;
        if (n2 != n) {
            this._grandTotalSummaryType = n;
            this.firePropertyChange(PROPERTY_GRAND_TOTAL_SUMMARY_TYPE, n2, n);
        }
    }

    public int getSubtotalSummaryType() {
        return this._subtotalSummaryType;
    }

    public void setSubtotalSummaryType(int n) {
        int n2 = this._subtotalSummaryType;
        if (n2 != n) {
            this._subtotalSummaryType = n;
            this.firePropertyChange(PROPERTY_SUBTOTAL_SUMMARY_TYPE, n2, n);
        }
    }

    public int getSubtotalType() {
        return this._subtotalType;
    }

    public void setSubtotalType(int n) {
        int n2 = this._subtotalType;
        if (n2 != n) {
            this._subtotalType = n;
            this.firePropertyChange(PROPERTY_SUBTOTAL_TYPE, n2, n);
        }
        this.setSeparateSubtotalSettings(false);
    }

    public int getSubtotalLocation() {
        return this._subtotalLocation;
    }

    public void setSubtotalLocation(int n) {
        int n2 = this._subtotalLocation;
        if (n2 != n) {
            this._subtotalLocation = n;
            this.firePropertyChange(PROPERTY_SUBTOTAL_LOCATION, n2, n);
        }
    }

    public int[] getCustomSubtotals() {
        return this._customSubtotals;
    }

    public void setCustomSubtotals(int[] nArray) {
        int[] nArray2 = this._customSubtotals;
        this._customSubtotals = nArray;
        this.firePropertyChange(PROPERTY_CUSTOM_SUBTOTALS, nArray2, nArray);
    }

    public int getSubtotalTypeForRow() {
        if (this.isSeparateSubtotalSettings()) {
            return this._subtotalTypeForRow;
        }
        return this.getSubtotalType();
    }

    public void setSubtotalTypeForRow(int n) {
        int n2 = this._subtotalTypeForRow;
        if (n2 != n) {
            this._subtotalTypeForRow = n;
            this.firePropertyChange(PROPERTY_SUBTOTAL_TYPE, n2, n);
        }
        this.setSeparateSubtotalSettings(true);
    }

    public void setSeparateSubtotalSettings(boolean bl) {
        this._separateSubtotalSettings = bl;
    }

    public boolean isSeparateSubtotalSettings() {
        return this._separateSubtotalSettings;
    }

    public int[] getCustomSubtotalsForRow() {
        if (this.isSeparateSubtotalSettings()) {
            return this._customSubtotalsForRow;
        }
        return this.getCustomSubtotals();
    }

    public void setCustomSubtotalsForRow(int[] nArray) {
        int[] nArray2 = this._customSubtotalsForRow;
        this._customSubtotalsForRow = nArray;
        this.firePropertyChange(PROPERTY_CUSTOM_SUBTOTALS, nArray2, nArray);
    }

    public int getSubtotalTypeForColumn() {
        if (this.isSeparateSubtotalSettings()) {
            return this._subtotalTypeForColumn;
        }
        return this.getSubtotalType();
    }

    public void setSubtotalTypeForColumn(int n) {
        int n2 = this._subtotalTypeForColumn;
        if (n2 != n) {
            this._subtotalTypeForColumn = n;
            this.firePropertyChange(PROPERTY_SUBTOTAL_TYPE, n2, n);
        }
        this.setSeparateSubtotalSettings(true);
    }

    public int[] getCustomSubtotalsForColumn() {
        if (this.isSeparateSubtotalSettings()) {
            return this._customSubtotalsForColumn;
        }
        return this.getCustomSubtotals();
    }

    public void setCustomSubtotalsForColumn(int[] nArray) {
        int[] nArray2 = this._customSubtotalsForColumn;
        this._customSubtotalsForColumn = nArray;
        this.firePropertyChange(PROPERTY_CUSTOM_SUBTOTALS, nArray2, nArray);
    }

    public Class<?> getSummaryClass(int n) {
        switch (n) {
            case 6: {
                return Long.class;
            }
            case 1: 
            case 2: {
                return this.getType();
            }
            case 7: {
                Class<?> clazz = this.getType();
                if (TypeUtils.isIntegerType(clazz)) {
                    return IntegerRange.class;
                }
                if (TypeUtils.isStringType(clazz)) {
                    return StringRange.class;
                }
                if (TypeUtils.isBooleanType(clazz)) {
                    return BooleanRange.class;
                }
                if (TypeUtils.isNumericType(clazz)) {
                    return NumericRange.class;
                }
                if (TypeUtils.isTemporalType(clazz)) {
                    return TimeRange.class;
                }
                return Object.class;
            }
        }
        return null;
    }

    @Override
    public void setSortOrder(int n) {
        int n2 = this._sortOrder;
        if (n2 != n) {
            this._sortOrder = n;
            this._sortByColumnKeys = null;
            this._sortByRowKeys = null;
            this.firePropertyChange("sortOrder", n2, this._sortOrder);
        }
    }

    public int getStatisticsCalculationType() {
        return this._statisticsCalculationType;
    }

    public void setStatisticsCalculationType(int n) {
        this._statisticsCalculationType = n;
    }

    public boolean isAllowedAsDataField() {
        return this._allowedAsDataField;
    }

    public void setAllowedAsDataField(boolean bl) {
        this._allowedAsDataField = bl;
    }

    public boolean isAllowedAsFilterField() {
        return this._allowedAsFilterField;
    }

    public void setAllowedAsFilterField(boolean bl) {
        this._allowedAsFilterField = bl;
    }

    public boolean isAllowedAsRowField() {
        return this._allowedAsRowField;
    }

    public void setAllowedAsRowField(boolean bl) {
        this._allowedAsRowField = bl;
    }

    public boolean isAllowedAsColumnField() {
        return this._allowedAsColumnField;
    }

    public void setAllowedAsColumnField(boolean bl) {
        this._allowedAsColumnField = bl;
    }

    public boolean isAllowedAsUnassignedField() {
        return this._allowedAsUnassignedField;
    }

    public void setAllowedAsUnassignedField(boolean bl) {
        this._allowedAsUnassignedField = bl;
    }

    public boolean isAllowedAsField(int n) {
        switch (n) {
            case 3: {
                return this.isAllowedAsDataField();
            }
            case 0: {
                return this.isAllowedAsRowField();
            }
            case 1: {
                return this.isAllowedAsColumnField();
            }
            case 2: {
                return this.isAllowedAsFilterField();
            }
            case -1: {
                return this.isAllowedAsUnassignedField();
            }
        }
        return true;
    }

    public Values getSortByRowKeys() {
        return this._sortByRowKeys;
    }

    public void setSortByRowKeys(Values values) {
        this._sortByRowKeys = values;
        if (this._sortByRowKeys == null) {
            this._sortByDataFieldModelIndex = -1;
            this._sortBySummaryType = -1;
        } else {
            this._sortOrder = 0;
            this._sortByColumnKeys = null;
        }
        if (this._sortByRowKeys == null) {
            this.firePropertyChange(PROPERTY_SORT_BY_ROW, "", this._sortByRowKeys);
        } else {
            this.firePropertyChange(PROPERTY_SORT_BY_ROW, null, this._sortByRowKeys);
        }
    }

    public Values getSortByColumnKeys() {
        return this._sortByColumnKeys;
    }

    public void setSortByColumnKeys(Values values) {
        this._sortByColumnKeys = values;
        if (this._sortByColumnKeys == null) {
            this._sortByDataFieldModelIndex = -1;
            this._sortBySummaryType = -1;
        } else {
            this._sortOrder = 0;
            this._sortByRowKeys = null;
        }
        if (this._sortByColumnKeys == null) {
            this.firePropertyChange(PROPERTY_SORT_BY, "", this._sortByColumnKeys);
        } else {
            this.firePropertyChange(PROPERTY_SORT_BY, null, this._sortByColumnKeys);
        }
    }

    public int getSortByDataFieldModelIndex() {
        return this._sortByDataFieldModelIndex;
    }

    public void setSortByDataFieldModelIndex(int n) {
        this._sortByDataFieldModelIndex = n;
    }

    public boolean isSortByAscending() {
        return this._sortByAscending;
    }

    public void setSortByAscending(boolean bl) {
        this._sortByAscending = bl;
    }

    public int getSortBySummaryType() {
        return this._sortBySummaryType;
    }

    public void setSortBySummaryType(int n) {
        this._sortBySummaryType = n;
    }

    @Override
    public void setSelectedPossibleValues(Object[] objectArray) {
        super.setSelectedPossibleValues(objectArray);
    }

    @Override
    public void setFilteredPossibleValues(Object[] objectArray) {
        super.setFilteredPossibleValues(objectArray);
    }

    private void internalSetConverterContext(ConverterContext converterContext) {
        ConverterContext converterContext2 = this._converterContext;
        if (converterContext2 != converterContext) {
            this._converterContext = converterContext;
            this.firePropertyChange("converterContext", converterContext2, converterContext);
        }
    }

    private void internalSetEditorContext(EditorContext editorContext) {
        EditorContext editorContext2 = this._editorContext;
        if (editorContext2 != editorContext) {
            this._editorContext = editorContext;
            this.firePropertyChange("editorContext", editorContext2, editorContext);
        }
    }

    public boolean isDataFieldFilterOnSummary() {
        return this._dataFieldFilterOnSummary;
    }

    public void setDataFieldFilterOnSummary(boolean bl) {
        boolean bl2 = this._dataFieldFilterOnSummary;
        if (bl2 != bl) {
            this._dataFieldFilterOnSummary = bl;
            this.firePropertyChange(PROPERTY_FILTER_ON_SUMMARY, bl2, bl);
        }
    }

    Map<Object, String> getDataFieldFilteredValues() {
        return this._dataFieldFilteredValues;
    }

    public List<RunningSummary> getRunningSummaryList() {
        return this._runningSummaryList;
    }

    public void setRunningSummaryList(List<RunningSummary> list) {
        if (this._runningSummaryList != list) {
            List<RunningSummary> list2 = this._runningSummaryList;
            this._runningSummaryList = list;
            this.firePropertyChange(PROPERTY_RUNNING_SUMMARY_LIST, list2, this._runningSummaryList);
        }
    }

    public boolean isHideOriginalData() {
        return this._hideOriginalData;
    }

    public void setHideOriginalData(boolean bl) {
        this._hideOriginalData = bl;
    }

    protected Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        if (object instanceof PivotField) {
            ((PivotField)object).changeSupport = null;
        }
        return object instanceof PivotField ? object : null;
    }

    @Override
    public void setTitle(String string) {
        if (!JideSwingUtilities.equals(string, this.getTitle())) {
            this._oldTitle = null;
            super.setTitle(string);
        }
    }

    void replaceTitleWith(String string) {
        if (this._oldTitle == null) {
            this.setOldTitle(this.getTitle());
        }
        super.setTitle(string);
    }

    String getOldTitle() {
        return this._oldTitle;
    }

    void setOldTitle(String string) {
        this._oldTitle = string;
    }

    public PivotField getFilterField() {
        return this._filterField;
    }

    public void setFilterField(PivotField pivotField) {
        this._filterField = pivotField;
    }

    public Values getFilterBaseValues() {
        return this._filterBaseValues;
    }

    public void setFilterBaseValues(Values values) {
        this._filterBaseValues = values;
    }

    public Filter[] getValueFilters() {
        return this._valueFilters;
    }

    public void setValueFilters(Filter[] filterArray) {
        this._valueFilters = filterArray;
    }

    public boolean isAndMode() {
        return this._andMode;
    }

    public void setAndMode(boolean bl) {
        this._andMode = bl;
    }

    public Object[] getFilterEditorPossibleValues() {
        return this._filterEditorPossibleValues != null ? this._filterEditorPossibleValues : new Object[]{};
    }

    public void setFilterEditorPossibleValues(Object[] objectArray) {
        this._filterEditorPossibleValues = objectArray;
    }
}

