/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.IndexChangeEvent;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.pivot.CompoundKey;
import com.jidesoft.pivot.CopiedExpandableValue;
import com.jidesoft.pivot.DefaultExpandableValue;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.DummyValue;
import com.jidesoft.pivot.DummyValues;
import com.jidesoft.pivot.ExpandableValue;
import com.jidesoft.pivot.GrandTotalValue;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotCellStyleProvider;
import com.jidesoft.pivot.PivotConstants;
import com.jidesoft.pivot.PivotDataEditingProvider;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotResources;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.RowIndexValue;
import com.jidesoft.pivot.RowIndexesValue;
import com.jidesoft.pivot.RunningSummaryValue;
import com.jidesoft.pivot.RunningSummaryValues;
import com.jidesoft.pivot.SummaryValue;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.CachedArrayList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class HeaderTableModel
extends AbstractTableModel
implements ColumnIdentifierTableModel,
SpanModel,
ContextSensitiveTableModel,
PivotConstants,
StyleModel {
    private IPivotDataModel _pivotDataModel;
    List<Values> _flatData;
    List _hierarchicalData;
    List _hierarchicalDataWithSummary;
    PivotField[] _fields;
    private boolean _rowHeader = true;
    PivotField[] _dataFields;
    int _dataIndex = -1;
    private CompoundKey[] _previousRows;
    private boolean _cellSpanOn = true;
    private transient List<Expandable> _statusChangedNodes;
    private static final long serialVersionUID = -7688855337003637190L;
    private int[] _sortOrders;

    public HeaderTableModel(IPivotDataModel iPivotDataModel, CompoundKey[] compoundKeyArray, boolean bl) {
        this._pivotDataModel = iPivotDataModel;
        this._rowHeader = bl;
        this.setRows(compoundKeyArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean optimizeSuccess(CompoundKey[] compoundKeyArray) {
        if (this._previousRows == null || this.getPivotDataModel().isAggregateMode()) {
            return false;
        }
        this.prepareSortOrders();
        if (this._sortOrders == null) {
            return false;
        }
        for (int n : this._sortOrders) {
            if (n != 0) continue;
            return false;
        }
        try {
            Object object;
            int n;
            Object object2 = new ArrayList();
            ArrayList<CompoundKey> arrayList = new ArrayList<CompoundKey>();
            int n2 = 0;
            n = 0;
            int n3 = compoundKeyArray.length;
            int n4 = this._previousRows.length;
            int n5 = 0;
            while (n2 < n3 && n < n4) {
                object = compoundKeyArray[n2];
                CompoundKey compoundKey = this._previousRows[n];
                int n6 = ((CompoundKey)object).compareTo(compoundKey, this.getPivotDataModel(), this._fields, this._sortOrders);
                if (n6 == 0) {
                    ++n2;
                    ++n;
                    continue;
                }
                if (n6 < 0) {
                    object2.add(object);
                    ++n2;
                    if (this.shouldOptimize(++n5, n3)) continue;
                    boolean bl = false;
                    return bl;
                }
                arrayList.add(compoundKey);
                ++n;
                if (this.shouldOptimize(++n5, n3)) continue;
                boolean bl = false;
                return bl;
            }
            while (n < n4) {
                arrayList.add(this._previousRows[n]);
                if (!this.shouldOptimize(++n5, n3)) {
                    boolean bl = false;
                    return bl;
                }
                ++n;
            }
            while (n2 < n3) {
                object2.add(compoundKeyArray[n2]);
                if (!this.shouldOptimize(++n5, n3)) {
                    boolean bl = false;
                    return bl;
                }
                ++n2;
            }
            object = this.getPivotDataModel();
            if (object.isHighPerformanceMode() && arrayList.size() > 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = object instanceof PivotDataModel && object.isAggregateMode() && (this.isRowHeader() ? object.getColumnFields().length == 0 : object.getRowFields().length == 0);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                CompoundKey compoundKey = (CompoundKey)iterator.next();
                this.addValues(this._hierarchicalData, compoundKey.getKeys(), bl, true);
            }
            for (CompoundKey compoundKey : arrayList) {
                this.removeValues(compoundKey.getKeys());
            }
            this.removeDataFieldsFiltering(this._flatData);
            this.removeHiddenSummaryValues(this._flatData);
            if (!(this.getPivotDataModel() instanceof PivotDataModel) || !this.getPivotDataModel().isAggregateMode()) {
                this.fireTableStructureChanged();
            }
        }
        finally {
            if (this.getPivotDataModel() instanceof PivotDataModel) {
                ((PivotDataModel)this.getPivotDataModel()).disposeSortingMap();
            }
        }
        return true;
    }

    private void prepareSortOrders() {
        this._sortOrders = new int[this._fields.length];
        boolean bl = false;
        for (int i = 0; i < this._sortOrders.length; ++i) {
            Values values;
            Values values2 = this._fields[i].getAreaType() == 0 ? this._fields[i].getSortByColumnKeys() : (values = this._fields[i].getAreaType() == 1 ? this._fields[i].getSortByRowKeys() : null);
            this._sortOrders[i] = values != null ? (this._fields[i].isSortByAscending() ? 1 : -1) : this._fields[i].getSortOrder();
            if (bl) continue;
            bl = this._sortOrders[i] != 0;
        }
        if (!bl) {
            this._sortOrders = null;
        }
    }

    CompoundKey[] getPreviousRows() {
        return this._previousRows;
    }

    protected boolean shouldOptimize(int n, int n2) {
        return n <= 10;
    }

    protected void setRows(CompoundKey[] compoundKeyArray) {
        if (!this.getPivotDataModel().isSummaryLayer()) {
            return;
        }
        IPivotDataModel iPivotDataModel = this.getPivotDataModel();
        this._fields = this.isRowHeader() ? iPivotDataModel.getRowFields() : iPivotDataModel.getColumnFields();
        this._dataFields = iPivotDataModel.getDataFields();
        this._dataIndex = -1;
        if (this.isRowHeader()) {
            if (iPivotDataModel.isRowDataFields() && (!iPivotDataModel.isHideSingleDataField() || this.getNumberOfDataFields() > 1)) {
                this._dataIndex = iPivotDataModel.isLayoutDataFieldsFirst() ? 0 : this.internalGetColumnCount();
            } else if (this._fields.length == 0 && this.getNumberOfDataFields() >= 1) {
                this._dataIndex = iPivotDataModel.isLayoutDataFieldsFirst() ? 0 : this.internalGetColumnCount();
            }
        } else if (iPivotDataModel.isColumnDataFields() && (!iPivotDataModel.isHideSingleDataField() || this.getNumberOfDataFields() > 1)) {
            this._dataIndex = iPivotDataModel.isLayoutDataFieldsFirst() ? 0 : this.internalGetRowCount();
        } else if (this._fields.length == 0 && this.getNumberOfDataFields() >= 1) {
            int n = this._dataIndex = iPivotDataModel.isLayoutDataFieldsFirst() ? 0 : this.internalGetRowCount();
        }
        if (iPivotDataModel instanceof PivotDataModel && ((PivotDataModel)iPivotDataModel).isAutoSortKeys()) {
            if (((PivotDataModel)iPivotDataModel).isOriginalDataUpdate() && this.optimizeSuccess(compoundKeyArray)) {
                this._previousRows = compoundKeyArray;
                return;
            }
            this._previousRows = compoundKeyArray;
        } else {
            this._previousRows = null;
        }
        boolean bl = iPivotDataModel instanceof PivotDataModel && iPivotDataModel.isAggregateMode() && (this.isRowHeader() ? iPivotDataModel.getColumnFields().length == 0 : iPivotDataModel.getRowFields().length == 0);
        this.prepareSortOrders();
        compoundKeyArray = this.filterRows(compoundKeyArray);
        this._hierarchicalData = this.hierarchize(compoundKeyArray, bl);
        this.refresh();
    }

    protected CompoundKey[] filterRows(CompoundKey[] compoundKeyArray) {
        if (this._dataFields.length > 0) {
            for (PivotField pivotField : this._dataFields) {
                compoundKeyArray = this.filterRows(pivotField, compoundKeyArray);
            }
        }
        return compoundKeyArray;
    }

    protected CompoundKey[] filterRows(PivotField pivotField, CompoundKey[] compoundKeyArray) {
        PivotField pivotField2 = pivotField.getFilterField();
        Values values = pivotField.getFilterBaseValues();
        Filter[] filterArray = pivotField.getValueFilters();
        if (pivotField2 != null && values != null && filterArray != null && filterArray.length > 0) {
            for (int i = 0; i < this._fields.length; ++i) {
                PivotField pivotField3 = this._fields[i];
                if (pivotField3 != pivotField2) continue;
                ArrayList<CompoundKey> arrayList = new ArrayList<CompoundKey>();
                HashMap<Values, String> hashMap = new HashMap<Values, String>();
                for (CompoundKey compoundKey : compoundKeyArray) {
                    Values values2 = compoundKey.toValues(i + 1, pivotField.getSummaryType());
                    Object object = hashMap.get(values2);
                    if (object == null) {
                        object = this.isRowHeader() ? this.getPivotDataModel().getValueAt(pivotField, values2, values) : this.getPivotDataModel().getValueAt(pivotField, values, values2);
                        if (object == null) {
                            hashMap.put(values2, "null");
                        } else {
                            hashMap.put(values2, (String)object);
                        }
                    } else if (object.equals("null")) {
                        object = null;
                    }
                    boolean bl = false;
                    if (pivotField.isAndMode()) {
                        for (Filter filter : filterArray) {
                            if (filter == null || !filter.isValueFiltered(object)) continue;
                            bl = true;
                            break;
                        }
                    } else {
                        bl = true;
                        for (Filter filter : filterArray) {
                            if (filter == null || filter.isValueFiltered(object)) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (bl) continue;
                    arrayList.add(compoundKey);
                }
                compoundKeyArray = arrayList.toArray(new CompoundKey[arrayList.size()]);
                break;
            }
        }
        return compoundKeyArray;
    }

    protected int getNumberOfDataFields() {
        return this._dataFields.length;
    }

    public void refreshAfterUpdateExpandable(int n) {
        if (this.getPivotDataModel() instanceof PivotDataModel) {
            ((PivotDataModel)this.getPivotDataModel()).firePivotValueProviderChanged(4, this);
        }
        this._hierarchicalDataWithSummary = this.getPivotDataModel().isHighPerformanceMode() ? this._hierarchicalData : this.createList();
        this.summarize(this._hierarchicalDataWithSummary, this._hierarchicalData, null, 0);
        this._flatData = this.flatten(this._hierarchicalDataWithSummary);
        int n2 = this.getColumnCount();
        if (n2 == n && (!this.isRowHeader() || n > 1 || ((PivotDataModel)this.getPivotDataModel()).isAggregateMode())) {
            this.fireTableDataChanged();
        } else {
            this.fireTableStructureChanged();
        }
        if (this.getPivotDataModel() instanceof PivotDataModel) {
            ((PivotDataModel)this.getPivotDataModel()).firePivotValueProviderChanged(this.isRowHeader() ? 5 : 6, this._statusChangedNodes != null ? this._statusChangedNodes.toArray() : null);
        }
        if (this._statusChangedNodes != null) {
            this._statusChangedNodes.clear();
        }
    }

    protected void setValueExpanded(Expandable expandable, boolean bl) {
        if (expandable != null) {
            expandable.setExpanded(bl);
        }
    }

    private void refresh() {
        this._hierarchicalDataWithSummary = this.getPivotDataModel().isHighPerformanceMode() ? this._hierarchicalData : this.createList();
        this.summarize(this._hierarchicalDataWithSummary, this._hierarchicalData, null, 0);
        this.expandSingleChildRow(this._hierarchicalDataWithSummary);
        this._flatData = this.flatten(this._hierarchicalDataWithSummary);
        if (!(this.getPivotDataModel() instanceof PivotDataModel) || !this.getPivotDataModel().isAggregateMode()) {
            this.fireTableStructureChanged();
        }
    }

    private void expandSingleChildRow(List list) {
        if (list == null) {
            return;
        }
        if (this._pivotDataModel instanceof PivotDataModel && ((PivotDataModel)this._pivotDataModel).isHideExpandIconOnSingleRow()) {
            for (Object e : list) {
                Object object;
                Expandable expandable;
                this.expandSingleChildRow(((Expandable)e).getChildren());
                if (!(e instanceof Expandable) || ((Expandable)e).isExpanded() || !(expandable = (Expandable)e).hasChildren()) continue;
                while (expandable.getChildrenCount() == 1 && (object = expandable.getChildAt(0)) instanceof Expandable) {
                    expandable = (Expandable)object;
                }
                if (expandable.getChildrenCount() > 1) continue;
                ((Expandable)e).setExpanded(true);
            }
        }
    }

    @Override
    public void fireTableStructureChanged() {
        this.fireIndexChangeEvent(0, -1);
        super.fireTableStructureChanged();
        this.fireIndexChangeEvent(1, -1);
    }

    protected List<Values> createList() {
        if (this.getPivotDataModel() instanceof PivotDataModel && ((PivotDataModel)this.getPivotDataModel()).isAutoSortKeys()) {
            return new ArrayList<Values>();
        }
        return new CachedArrayList<Values>(){
            private static final long serialVersionUID = -4283459055727835175L;

            @Override
            protected Map<Object, CachedArrayList.IntegerWrapper> createCache() {
                return new HashMap<Object, CachedArrayList.IntegerWrapper>();
            }
        };
    }

    public boolean isRowHeader() {
        return this._rowHeader;
    }

    private List hierarchize(CompoundKey[] compoundKeyArray, boolean bl) {
        Object object;
        boolean bl2 = false;
        if (this.getPivotDataModel() instanceof PivotDataModel && ((PivotDataModel)this.getPivotDataModel()).isAutoSortKeys()) {
            object = new int[this._fields.length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                Values values;
                Values values2 = this._fields[i].getAreaType() == 0 ? this._fields[i].getSortByColumnKeys() : (values = this._fields[i].getAreaType() == 1 ? this._fields[i].getSortByRowKeys() : null);
                object[i] = values != null ? (Object)(this._fields[i].isSortByAscending() ? 1 : -1) : (Object)this._fields[i].getSortOrder();
                if (object[i] != false) continue;
                bl2 = true;
                break;
            }
        }
        object = this.createList();
        for (CompoundKey compoundKey : compoundKeyArray) {
            if (compoundKey == null) continue;
            this.addValues((List)object, compoundKey.getKeys(), bl, bl2);
        }
        return object;
    }

    void summarize(ExpandableValue expandableValue) {
        Object object;
        int n;
        int n2;
        Object object2;
        ArrayList<ExpandableValue> arrayList = new ArrayList<ExpandableValue>();
        for (object2 = expandableValue; object2 != null; object2 = (ExpandableValue)object2.getParent()) {
            arrayList.add(0, (ExpandableValue)object2);
        }
        int n3 = arrayList.size() - 1;
        for (ExpandableValue expandableValue2 = expandableValue; expandableValue2 != null && expandableValue2.getChildrenCount() == 1; expandableValue2 = (ExpandableValue)expandableValue2.getChildAt(0)) {
            arrayList.add(expandableValue2);
        }
        ExpandableValue expandableValue3 = null;
        ExpandableValue expandableValue4 = null;
        object2 = (ExpandableValue)expandableValue.getParent();
        if (object2 == null) {
            n2 = this._hierarchicalData.indexOf(expandableValue);
            if (n2 >= 1) {
                expandableValue3 = (ExpandableValue)this._hierarchicalData.get(n2 - 1);
            } else if (this._hierarchicalData.size() > 1) {
                expandableValue4 = (ExpandableValue)this._hierarchicalData.get(1);
            }
        } else {
            n2 = object2.getChildIndex(expandableValue);
            if (n2 >= 1) {
                expandableValue3 = (ExpandableValue)object2.getChildAt(n2 - 1);
            } else if (object2.getChildrenCount() > 1) {
                expandableValue4 = (ExpandableValue)object2.getChildAt(1);
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        List<?> list = this._hierarchicalDataWithSummary;
        object2 = null;
        boolean bl = this._hierarchicalData != this._hierarchicalDataWithSummary;
        for (n = 0; n < arrayList.size() && n < this._fields.length; ++n) {
            Object object3;
            int n4;
            int n5;
            PivotField pivotField;
            Object object4;
            block42: {
                block43: {
                    object4 = object = (ExpandableValue)arrayList.get(n);
                    if (bl) {
                        object4 = new CopiedExpandableValue((ExpandableValue)object);
                    }
                    if (n < n3) {
                        int n6 = list.indexOf(object4);
                        if (n6 < 0) {
                            return;
                        }
                        object4 = (ExpandableValue)list.get(n6);
                        list = object4.getChildren();
                        object2 = object4;
                        continue;
                    }
                    if (bl) {
                        object4.setParent((Expandable)object2);
                    }
                    if (object2 instanceof DefaultExpandableValue) {
                        ((DefaultExpandableValue)object2).invalidateCache();
                    }
                    pivotField = this._fields[n];
                    n5 = 0;
                    if (n == n3) {
                        n5 = this.getInsertIndex((ExpandableValue)object2, (ExpandableValue)object4, list);
                    }
                    int n7 = n4 = this.isRowHeader() ? pivotField.getSubtotalTypeForRow() : pivotField.getSubtotalTypeForColumn();
                    if (n == n3) {
                        arrayList2.add(object4);
                    }
                    if (bl && pivotField.getSubtotalLocation() == 0) {
                        list.add(n5++, object4);
                    }
                    if (this.getPivotDataModel().isShowSubtotalAsChild()) break block42;
                    if (n4 != 1) break block43;
                    if (!object4.isExpanded() || this.getPivotDataModel().isHideRedundantSubtotal() && object.getChildrenCount() <= 1) break block42;
                    object3 = new SummaryValue(object);
                    object3.setParent((Expandable)object2);
                    list.add(n5++, object3);
                    if (n != n3) break block42;
                    arrayList2.add(object3);
                    break block42;
                }
                if (n4 == 2) {
                    int[] nArray = object3 = this.isRowHeader() ? pivotField.getCustomSubtotalsForRow() : pivotField.getCustomSubtotalsForColumn();
                    if (object3 != null) {
                        for (int n8 : object3) {
                            SummaryValue summaryValue = new SummaryValue(object, n8);
                            summaryValue.setParent((Expandable)object2);
                            list.add(n5++, summaryValue);
                            if (n != n3) continue;
                            arrayList2.add(summaryValue);
                        }
                    }
                }
            }
            if (bl) {
                if (n + 1 < this._fields.length) {
                    object3 = this.createList();
                    object4.setChildren((List<?>)object3);
                } else {
                    object3 = new ArrayList();
                    object4.setChildren((List<?>)object3);
                    List<?> list2 = object.getChildren();
                    if (list2 != null) {
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            object4.addChild(e);
                        }
                    }
                }
            }
            if (this.getPivotDataModel().isShowSubtotalAsChild()) {
                if (n4 == 1) {
                    if (object4.isExpanded() && (!this.getPivotDataModel().isHideRedundantSubtotal() || object.getChildrenCount() > 1)) {
                        object3 = new SummaryValue(object);
                        if (pivotField.getSubtotalLocation() == 1) {
                            object4.addChild(0, object3);
                        } else {
                            object4.addChild(object3);
                        }
                    }
                } else if (n4 == 2) {
                    object3 = this.isRowHeader() ? pivotField.getCustomSubtotalsForRow() : pivotField.getCustomSubtotalsForColumn();
                    for (int i = 0; i < ((int[])object3).length; ++i) {
                        int n9 = object3[i];
                        SummaryValue summaryValue = new SummaryValue(object, n9);
                        if (pivotField.getSubtotalLocation() == 1) {
                            object4.addChild(i, summaryValue);
                            continue;
                        }
                        object4.addChild(summaryValue);
                    }
                }
            }
            if (bl && pivotField.getSubtotalLocation() == 1) {
                list.add(n5, object4);
            }
            list = object4.getChildren();
            object2 = object4;
        }
        n = -2;
        for (Object object4 : arrayList2) {
            n = this.addValue(this._flatData, (ExpandableValue)object4, n);
        }
        if (n3 == 0 && this.isGrandTotalDisplayed() && expandableValue3 == null && expandableValue4 == null) {
            object = new GrandTotalValue();
            if (this.isDisplayGrandTotalFirst() && !(this._hierarchicalDataWithSummary.get(0) instanceof GrandTotalValue)) {
                this._hierarchicalDataWithSummary.add(0, object);
                this.addValue(this._flatData, (ExpandableValue)object, 0);
            } else if (!this.isDisplayGrandTotalFirst() && !(this._hierarchicalDataWithSummary.get(this._hierarchicalDataWithSummary.size() - 1) instanceof GrandTotalValue)) {
                this._hierarchicalDataWithSummary.add(object);
                this.addValue(this._flatData, (ExpandableValue)object, -1);
            }
        }
    }

    void summarize(List list, List list2, Expandable expandable, int n) {
        Object object;
        int n2;
        boolean bl;
        boolean bl2 = bl = list2 != list;
        if (!bl) {
            for (n2 = n; n2 < this._fields.length; ++n2) {
                int n3;
                object = this._fields[n2];
                int n4 = n3 = this.isRowHeader() ? ((PivotField)object).getSubtotalTypeForRow() : ((PivotField)object).getSubtotalTypeForColumn();
                if (n3 == 0) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            n2 = list2 != list ? 1 : 0;
            object = n2 != 0 ? list : this.createList();
            for (Object e : list2) {
                Object object2;
                int n5;
                ExpandableValue expandableValue;
                ExpandableValue expandableValue2 = expandableValue = (ExpandableValue)e;
                if (n2 != 0) {
                    expandableValue2 = new CopiedExpandableValue(expandableValue);
                    expandableValue2.setParent(expandable);
                } else if (expandableValue instanceof SummaryValue || expandableValue instanceof GrandTotalValue) continue;
                PivotField pivotField = this._fields[n];
                int n6 = n5 = this.isRowHeader() ? pivotField.getSubtotalTypeForRow() : pivotField.getSubtotalTypeForColumn();
                if (pivotField.getSubtotalLocation() == 0) {
                    object.add(expandableValue2);
                }
                if (!this.getPivotDataModel().isShowSubtotalAsChild()) {
                    if (n5 == 1) {
                        if (expandableValue2.isExpanded() && (!this.getPivotDataModel().isHideRedundantSubtotal() || expandableValue.getChildrenCount() > 1)) {
                            object2 = new SummaryValue(expandableValue);
                            object2.setParent(expandable);
                            object.add(object2);
                        }
                    } else if (n5 == 2) {
                        int[] nArray = object2 = this.isRowHeader() ? pivotField.getCustomSubtotalsForRow() : pivotField.getCustomSubtotalsForColumn();
                        if (object2 != null) {
                            for (int n7 : object2) {
                                SummaryValue summaryValue = new SummaryValue(expandableValue, n7);
                                summaryValue.setParent(expandable);
                                object.add(summaryValue);
                            }
                        }
                    }
                }
                if (n + 1 < this._fields.length) {
                    if (n2 != 0) {
                        object2 = this.createList();
                        expandableValue2.setChildren((List<?>)object2);
                    }
                    this.summarize(expandableValue2.getChildren(), expandableValue.getChildren(), expandableValue2, n + 1);
                } else if (n2 != 0) {
                    object2 = new ArrayList();
                    expandableValue2.setChildren((List<?>)object2);
                    List<?> list3 = expandableValue.getChildren();
                    if (list3 != null) {
                        Iterator iterator = list3.iterator();
                        while (iterator.hasNext()) {
                            Object e2 = iterator.next();
                            expandableValue2.addChild(e2);
                        }
                    }
                }
                if (this.getPivotDataModel().isShowSubtotalAsChild() && n + 1 < this._fields.length) {
                    if (n5 == 1) {
                        if (expandableValue2.isExpanded() && (!this.getPivotDataModel().isHideRedundantSubtotal() || expandableValue.getChildrenCount() > 1)) {
                            object2 = new SummaryValue(expandableValue);
                            if (pivotField.getSubtotalLocation() == 1) {
                                expandableValue2.addChild(0, object2);
                            } else {
                                expandableValue2.addChild(object2);
                            }
                        }
                    } else if (n5 == 2) {
                        object2 = this.isRowHeader() ? pivotField.getCustomSubtotalsForRow() : pivotField.getCustomSubtotalsForColumn();
                        for (int i = 0; i < ((int[])object2).length; ++i) {
                            int n8 = object2[i];
                            SummaryValue summaryValue = new SummaryValue(expandableValue, n8);
                            if (pivotField.getSubtotalLocation() == 1) {
                                expandableValue2.addChild(i, summaryValue);
                                continue;
                            }
                            expandableValue2.addChild(summaryValue);
                        }
                    }
                }
                if (n2 == 0 || pivotField.getSubtotalLocation() != 1) continue;
                object.add(expandableValue2);
            }
            if (n2 == 0) {
                list.clear();
                list.addAll((Collection<Values>)object);
            }
        }
        if (n == 0 && this.isGrandTotalDisplayed()) {
            if (this.isDisplayGrandTotalFirst()) {
                if (!this.getPivotDataModel().isHighPerformanceMode() || list.size() <= 0 || !(list.get(0) instanceof GrandTotalValue)) {
                    list.add(0, (Values)((Object)new GrandTotalValue()));
                }
            } else if (!this.getPivotDataModel().isHighPerformanceMode() || list.size() <= 0 || !(list.get(list.size() - 1) instanceof GrandTotalValue)) {
                list.add((Values)((Object)new GrandTotalValue()));
            }
        }
        if ((this.isRowHeader() && !this.getPivotDataModel().isAllowEmptyRowHeader() || !this.isRowHeader() && !this.getPivotDataModel().isAllowEmptyColumnHeader()) && this.getPivotDataModel().getDataFields().length > 0 && this._fields.length == 0 && list.size() == 0) {
            list.add((Values)((Object)new DummyValue()));
        }
    }

    private void removeValues(Object[] objectArray) {
        ExpandableValue expandableValue;
        ExpandableValue expandableValue2;
        int n;
        List<?> list = this._hierarchicalData;
        ExpandableValue expandableValue3 = null;
        for (n = 0; n < objectArray.length; ++n) {
            expandableValue2 = new DefaultExpandableValue(objectArray[n]);
            if (list == null) {
                return;
            }
            int n2 = list.indexOf(expandableValue2);
            if (n2 < 0) {
                return;
            }
            expandableValue = (ExpandableValue)list.get(n2);
            list = expandableValue.getChildren();
            expandableValue3 = expandableValue;
        }
        if (n < objectArray.length || expandableValue3 == null) {
            return;
        }
        expandableValue2 = expandableValue3;
        do {
            if ((expandableValue3 = (ExpandableValue)expandableValue2.getParent()) != null) {
                expandableValue3.removeChild(expandableValue2);
                if (expandableValue3.getChildrenCount() >= 1) break;
                expandableValue2 = expandableValue3;
                continue;
            }
            this._hierarchicalData.remove(expandableValue2);
        } while (expandableValue3 != null);
        ArrayList<ExpandableValue> arrayList = new ArrayList<ExpandableValue>();
        for (expandableValue = expandableValue3; expandableValue != null; expandableValue = (ExpandableValue)expandableValue.getParent()) {
            arrayList.add(0, expandableValue);
        }
        List<?> list2 = this._hierarchicalDataWithSummary;
        for (ExpandableValue expandableValue4 : arrayList) {
            int n3 = list2.indexOf(new CopiedExpandableValue(expandableValue4));
            if (n3 < 0) {
                return;
            }
            expandableValue3 = (ExpandableValue)list2.get(n3);
            list2 = expandableValue3.getChildren();
        }
        int n4 = list2.indexOf(new CopiedExpandableValue(expandableValue2));
        int n5 = n4--;
        Object object = expandableValue2.getValue();
        while (n4 >= 0 && JideSwingUtilities.equals(((ExpandableValue)list2.get(n4)).getValue(), object)) {
            --n4;
        }
        ++n5;
        while (n5 < list2.size() && JideSwingUtilities.equals(((ExpandableValue)list2.get(n5)).getValue(), object)) {
            ++n5;
        }
        --n5;
        ArrayList<ExpandableValue> arrayList2 = new ArrayList<ExpandableValue>();
        for (int i = ++n4; i <= n5; ++i) {
            arrayList2.add((ExpandableValue)list2.get(n4));
            list2.remove(n4);
        }
        if (expandableValue3 instanceof DefaultExpandableValue) {
            ((DefaultExpandableValue)expandableValue3).invalidateCache();
            if (this._pivotDataModel instanceof PivotDataModel && ((PivotDataModel)this._pivotDataModel).isHideExpandIconOnSingleRow() && !expandableValue3.isExpanded() && expandableValue3.getChildrenCount() == 1) {
                expandableValue3.setExpanded(true);
            }
        }
        for (ExpandableValue expandableValue5 : arrayList2) {
            this.removeValue(this._flatData, expandableValue5);
        }
    }

    int getInsertIndexInFlatData(DefaultValues defaultValues, List<Values> list) {
        CompoundKey compoundKey = defaultValues.toCompoundKey();
        int n = 0;
        int n2 = list.size();
        int n3 = n2 / 2;
        while (n < n2) {
            int n4;
            Values values = list.get(n3);
            if (values instanceof GrandTotalValues) {
                n4 = this.isDisplayGrandTotalFirst() ? -1 : 1;
            } else {
                CompoundKey compoundKey2 = ((DefaultValues)values).toCompoundKey();
                n4 = compoundKey2.compareTo(compoundKey, this.getPivotDataModel(), this._fields, this._sortOrders);
                if (n4 == 0) {
                    int n5;
                    if (defaultValues instanceof SummaryValues && !(values instanceof SummaryValues)) {
                        n4 = -1;
                        n5 = defaultValues.getCount() - 1;
                        if (n5 >= 0 && n5 < this._fields.length && this._fields[n5].getSubtotalLocation() == 1) {
                            n4 = 1;
                        }
                    } else if (!(defaultValues instanceof SummaryValues) && values instanceof SummaryValues) {
                        n4 = 1;
                        n5 = values.getCount() - 1;
                        if (n5 >= 0 && n5 < this._fields.length && this._fields[n5].getSubtotalLocation() == 1) {
                            n4 = -1;
                        }
                    } else if (defaultValues instanceof RunningSummaryValues && !(values instanceof RunningSummaryValues)) {
                        n4 = -1;
                    } else if (!(defaultValues instanceof RunningSummaryValues) && values instanceof RunningSummaryValues) {
                        n4 = 1;
                    }
                }
            }
            if (n4 == 0) {
                return 0 - n3 - 1;
            }
            if (n4 < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return n3;
    }

    private int getInsertIndex(ExpandableValue expandableValue, ExpandableValue expandableValue2, List list) {
        if (this.getPivotDataModel() instanceof PivotDataModel && !((PivotDataModel)this.getPivotDataModel()).isAutoSortKeys()) {
            return list.size();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (expandableValue != null) {
            arrayList.add(0, expandableValue.getValue());
            expandableValue = (ExpandableValue)expandableValue.getParent();
        }
        arrayList.add(expandableValue2.getValue());
        Object[] objectArray = arrayList.toArray();
        CompoundKey compoundKey = new CompoundKey(arrayList.toArray());
        int n = 0;
        int n2 = list.size();
        int n3 = n2 / 2;
        while (n < n2) {
            int n4;
            objectArray[objectArray.length - 1] = ((ExpandableValue)list.get(n3)).getValue();
            if (objectArray.length == 1 && objectArray[objectArray.length - 1] == null) {
                n4 = this.isDisplayGrandTotalFirst() ? -1 : 1;
            } else {
                CompoundKey compoundKey2 = new CompoundKey(objectArray);
                n4 = compoundKey2.compareTo(compoundKey, this.getPivotDataModel(), this._fields, this._sortOrders);
            }
            if (n4 == 0) {
                return list.size();
            }
            if (n4 < 0) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return n3;
    }

    private void addValues(List list, Object[] objectArray, boolean bl, boolean bl2) {
        List<?> list2 = list;
        DefaultExpandableValue defaultExpandableValue = null;
        StringBuffer stringBuffer = null;
        if (!this.getPivotDataModel().isHighPerformanceMode()) {
            stringBuffer = new StringBuffer();
        }
        ExpandableValue expandableValue = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            ExpandableValue expandableValue2 = null;
            DefaultExpandableValue defaultExpandableValue2 = new DefaultExpandableValue(object);
            if (list2 != null && list2.size() > 0 && defaultExpandableValue2.equals(list2.get(list2.size() - 1))) {
                expandableValue2 = (ExpandableValue)list2.get(list2.size() - 1);
                if (stringBuffer != null) {
                    stringBuffer.append(this._pivotDataModel.getExpansionStateSeparator()).append(expandableValue2.getValue());
                }
            }
            if (expandableValue2 == null && this.getPivotDataModel() instanceof PivotDataModel && (!((PivotDataModel)this.getPivotDataModel()).isAutoSortKeys() || bl2)) {
                int n = -1;
                if (list2 != null) {
                    n = list2.indexOf(defaultExpandableValue2);
                }
                if (n != -1) {
                    expandableValue2 = (ExpandableValue)list2.get(n);
                    if (stringBuffer != null) {
                        stringBuffer.append(this._pivotDataModel.getExpansionStateSeparator()).append(expandableValue2.getValue());
                    }
                }
            }
            if (expandableValue2 == null) {
                List<Integer> list3;
                expandableValue2 = defaultExpandableValue2;
                Boolean bl3 = null;
                if (stringBuffer != null) {
                    stringBuffer.append(this._pivotDataModel.getExpansionStateSeparator()).append(expandableValue2.getValue());
                    if (this._pivotDataModel instanceof PivotDataModel) {
                        if (this.isRowHeader() && ((PivotDataModel)this._pivotDataModel).getRowExpansion() != null) {
                            bl3 = ((PivotDataModel)this._pivotDataModel).getRowExpansion().get(stringBuffer.toString());
                        } else if (!this.isRowHeader() && ((PivotDataModel)this._pivotDataModel).getColumnExpansion() != null) {
                            bl3 = ((PivotDataModel)this._pivotDataModel).getColumnExpansion().get(stringBuffer.toString());
                        }
                    }
                }
                if (bl3 != null) {
                    expandableValue2.setExpanded(bl3);
                } else {
                    expandableValue2.setExpanded(this._pivotDataModel.isExpandByDefault());
                }
                expandableValue2.setChildren(new ArrayList());
                int n = list2.size();
                if (bl2 && expandableValue == null) {
                    expandableValue = expandableValue2;
                    n = this.getInsertIndex(defaultExpandableValue, expandableValue2, list2);
                    if (n < 0) {
                        return;
                    }
                }
                if (defaultExpandableValue != null) {
                    defaultExpandableValue.addChild(n, expandableValue2);
                } else {
                    list2.add(n, expandableValue2);
                }
                if (bl && i == objectArray.length - 1 && (list3 = this._pivotDataModel.getDataAt(new CompoundKey(objectArray), new CompoundKey(new Object[0]))) != null) {
                    if (this._pivotDataModel instanceof PivotDataModel && ((PivotDataModel)this._pivotDataModel).isShowSummaryOnAggregate()) {
                        expandableValue2.addChild(new RowIndexesValue(list3));
                    }
                    for (Integer n2 : list3) {
                        expandableValue2.addChild(new RowIndexValue(n2));
                    }
                }
            }
            list2 = expandableValue2.getChildren();
            defaultExpandableValue = expandableValue2;
        }
        if (expandableValue != null && this._hierarchicalData != null) {
            this.summarize(expandableValue);
        }
    }

    List<Values> flatten(List list) {
        List<Values> list2 = this.createList();
        for (Object e : list) {
            ExpandableValue expandableValue = (ExpandableValue)e;
            this.addValue(list2, expandableValue, -1);
        }
        this.removeDataFieldsFiltering(list2);
        this.removeHiddenSummaryValues(list2);
        return list2;
    }

    List<Values> getPossibleValues(int n) {
        if (this._hierarchicalData == null) {
            return null;
        }
        List<Values> list = this.createList();
        for (Object e : this._hierarchicalData) {
            ExpandableValue expandableValue = (ExpandableValue)e;
            this.addPossibleValue(list, expandableValue, n);
        }
        return list;
    }

    private void addPossibleValue(List<Values> list, ExpandableValue expandableValue, int n) {
        if (expandableValue instanceof SummaryValue || expandableValue instanceof RunningSummaryValue || expandableValue instanceof GrandTotalValue || expandableValue instanceof DummyValue) {
            return;
        }
        DefaultValues defaultValues = new DefaultValues(expandableValue);
        if (defaultValues.getCount() == n + 1) {
            if (this._pivotDataModel.isValuesVisible(defaultValues) && (list.size() <= 0 || !JideSwingUtilities.equals(list.get(list.size() - 1), defaultValues))) {
                list.add(defaultValues);
            }
        } else if (defaultValues.getCount() < n + 1) {
            for (int i = 0; i < expandableValue.getChildrenCount(); ++i) {
                ExpandableValue expandableValue2 = (ExpandableValue)expandableValue.getChildAt(i);
                this.addPossibleValue(list, expandableValue2, n);
            }
        }
    }

    Values getValuesFromValue(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0 || objectArray.length > this._fields.length) {
            return null;
        }
        List<?> list = this._hierarchicalData;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (list == null || list.size() <= 0) {
                return null;
            }
            boolean bl = false;
            for (Object e : list) {
                if (!(e instanceof ExpandableValue) || !JideSwingUtilities.equals(object, ((ExpandableValue)e).getValue())) continue;
                if (i == objectArray.length - 1) {
                    return new DefaultValues((ExpandableValue)e);
                }
                list = ((ExpandableValue)e).getChildren();
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return null;
    }

    private void removeDataFieldsFiltering(List list) {
        if (!(this.getPivotDataModel() instanceof PivotDataModel)) {
            return;
        }
        List<Values> list2 = this.isRowHeader() ? ((PivotDataModel)this.getPivotDataModel()).getFilteredRowValues() : ((PivotDataModel)this.getPivotDataModel()).getFitleredColumnValues();
        if (list2 != null && list2.size() > 0) {
            int n;
            boolean bl;
            Object object;
            int n2;
            int n3;
            HashMap<Values, Integer> hashMap = new HashMap<Values, Integer>();
            boolean[] blArray = new boolean[list2.size()];
            for (n3 = 0; n3 < blArray.length; ++n3) {
                blArray[n3] = false;
            }
            for (n3 = 0; n3 < list2.size(); ++n3) {
                if (blArray[n3]) continue;
                blArray[n3] = true;
                Values values = list2.get(n3);
                if (!(values instanceof SummaryValues)) {
                    hashMap.put(values, 1);
                    continue;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(values);
                for (n2 = n3 + 1; n2 < list2.size(); ++n2) {
                    object = list2.get(n2);
                    if (values.getCount() != object.getCount()) continue;
                    bl = true;
                    for (n = values.getCount() - 1; n >= 0; --n) {
                        if (values.getValueAt(n).getValue().equals(object.getValueAt(n).getValue())) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    arrayList.add(object);
                    blArray[n2] = true;
                }
                hashMap.put(values, arrayList.size());
                arrayList.clear();
            }
            for (Values values : hashMap.keySet()) {
                if (!(values instanceof SummaryValues)) {
                    list.remove(values);
                    continue;
                }
                int n4 = (Integer)hashMap.get(values);
                for (n2 = list.size() - 1; n2 >= 0; --n2) {
                    object = list.get(n2);
                    if (!(object instanceof SummaryValues) || values.getCount() != ((SummaryValues)object).getCount()) continue;
                    bl = true;
                    for (n = values.getCount() - 1; n >= 0; --n) {
                        if (values.getValueAt(n).getValue().equals(((DefaultValues)object).getValueAt(n).getValue())) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    --n4;
                }
                if (n4 < 0) continue;
                for (n2 = list.size() - 1; n2 >= 0; --n2) {
                    object = list.get(n2);
                    if (values.getCount() > ((DefaultValues)object).getCount()) continue;
                    bl = true;
                    for (n = values.getCount() - 1 - (this.getPivotDataModel().isShowSubtotalAsChild() ? 1 : 0); n >= 0; --n) {
                        if (values.getValueAt(n).getValue().equals(((DefaultValues)object).getValueAt(n).getValue())) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    list.remove(n2);
                }
            }
        }
    }

    private void removeHiddenSummaryValues(List list) {
        if (this.getPivotDataModel().isHideSummaryValues() && !this.getPivotDataModel().isAggregateMode()) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Value value;
                Value value2;
                int n;
                boolean bl;
                Object e;
                int n2;
                Object e2 = list.get(i);
                if (!(e2 instanceof SummaryValues)) continue;
                boolean bl2 = false;
                for (n2 = i - 1; n2 >= 0; --n2) {
                    e = list.get(n2);
                    if (e instanceof SummaryValues || e instanceof GrandTotalValues || e instanceof DummyValues || !(e instanceof DefaultValues)) continue;
                    bl = true;
                    for (n = ((SummaryValues)e2).getCount() - 1 - (this.getPivotDataModel().isShowSubtotalAsChild() ? 1 : 0); n >= 0; --n) {
                        value2 = ((DefaultValues)e).getValueAt(n);
                        value = ((SummaryValues)e2).getValueAt(n);
                        if (value2 != null && value != null && (value.getValue() != null || value2.getValue() == null) && (value.getValue() == null || value.getValue().equals(value2.getValue()))) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) break;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    for (n2 = i + 1; n2 < list.size(); ++n2) {
                        e = list.get(n2);
                        if (e instanceof SummaryValues || e instanceof GrandTotalValues || e instanceof DummyValues || !(e instanceof DefaultValues)) continue;
                        bl = true;
                        for (n = ((SummaryValues)e2).getCount() - 1 - (this.getPivotDataModel().isShowSubtotalAsChild() ? 1 : 0); n >= 0; --n) {
                            value2 = ((DefaultValues)e).getValueAt(n);
                            value = ((SummaryValues)e2).getValueAt(n);
                            if (value2 != null && value != null && (value.getValue() != null || value2.getValue() == null) && (value.getValue() == null || value.getValue().equals(value2.getValue()))) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) break;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) continue;
                list.remove(i);
            }
        }
    }

    private void removeValue(List<Values> list, ExpandableValue expandableValue) {
        boolean bl;
        boolean bl2 = expandableValue.isExpanded() && expandableValue.hasChildren();
        boolean bl3 = bl = !this._pivotDataModel.isSummaryMode() && !expandableValue.isExpanded() && expandableValue.hasChildren();
        if (bl2) {
            for (int i = 0; i < expandableValue.getChildrenCount(); ++i) {
                ExpandableValue expandableValue2 = (ExpandableValue)expandableValue.getChildAt(i);
                this.removeValue(list, expandableValue2);
            }
        } else if (bl) {
            ExpandableValue expandableValue3 = (ExpandableValue)expandableValue.getChildAt(0);
            expandableValue3.setExpanded(false);
            this.removeValue(list, expandableValue3);
        } else {
            DefaultValues defaultValues = expandableValue instanceof SummaryValue ? new SummaryValues(expandableValue, ((SummaryValue)expandableValue).getSummaryType()) : (expandableValue instanceof RunningSummaryValue ? new RunningSummaryValues(expandableValue) : (expandableValue instanceof GrandTotalValue ? new GrandTotalValues() : (expandableValue instanceof DummyValue ? new DummyValues() : new DefaultValues(expandableValue))));
            int n = this.indexOf(defaultValues, list);
            if (n >= 0) {
                list.remove(n);
            }
        }
    }

    private int addValue(List<Values> list, ExpandableValue expandableValue, int n) {
        boolean bl;
        boolean bl2 = expandableValue.isExpanded() && expandableValue.hasChildren();
        boolean bl3 = bl = !this._pivotDataModel.isSummaryMode() && !expandableValue.isExpanded() && expandableValue.hasChildren();
        if (bl2) {
            for (int i = 0; i < expandableValue.getChildrenCount(); ++i) {
                ExpandableValue expandableValue2 = (ExpandableValue)expandableValue.getChildAt(i);
                n = this.addValue(list, expandableValue2, n);
            }
        } else if (bl) {
            ExpandableValue expandableValue3 = (ExpandableValue)expandableValue.getChildAt(0);
            expandableValue3.setExpanded(false);
            n = this.addValue(list, expandableValue3, n);
        } else {
            DefaultValues defaultValues = expandableValue instanceof SummaryValue ? new SummaryValues(expandableValue, ((SummaryValue)expandableValue).getSummaryType()) : (expandableValue instanceof RunningSummaryValue ? new RunningSummaryValues(expandableValue) : (expandableValue instanceof GrandTotalValue ? new GrandTotalValues() : (expandableValue instanceof DummyValue ? new DummyValues() : new DefaultValues(expandableValue))));
            if (this._pivotDataModel.isHighPerformanceMode() || this._pivotDataModel.isValuesVisible(defaultValues)) {
                if (n == -2) {
                    n = this.getInsertIndexInFlatData(defaultValues, list);
                    if (n < 0) {
                        n = -2;
                    } else {
                        list.add(n++, defaultValues);
                    }
                } else if (n == -1) {
                    list.add(defaultValues);
                } else {
                    list.add(n++, defaultValues);
                }
            }
        }
        return n;
    }

    List getFlatData() {
        if (this._flatData == null) {
            throw new IllegalStateException("Please call calculate first.");
        }
        return this._flatData;
    }

    @Override
    public int getRowCount() {
        if (this.isRowHeader()) {
            if (this.getPivotDataModel() instanceof PivotDataModel && ((PivotDataModel)this.getPivotDataModel()).isAggregateMode() && this.getPivotDataModel().getRowFields().length == 0) {
                return this.getPivotDataModel().getDataSource().getRowCount();
            }
            return this.internalGetRowCount() * (this.isDataFieldAdded() ? this.getNumberOfDataFields() : 1);
        }
        return this.internalGetRowCount() + (this.isDataFieldAdded() ? 1 : 0);
    }

    int internalGetRowCount() {
        if (this.isRowHeader()) {
            if (this._flatData != null) {
                return this.getFlatData().size();
            }
            return 0;
        }
        return Math.max(this._fields.length, this._fields.length == 0 && this.isGrandTotalDisplayed() ? 1 : 0);
    }

    private boolean isGrandTotalDisplayed() {
        return this._rowHeader ? this._pivotDataModel.isShowGrandTotalForRow() : this._pivotDataModel.isShowGrandTotalForColumn();
    }

    private boolean isDisplayGrandTotalFirst() {
        return this.isRowHeader() ? this._pivotDataModel.isDisplayGrandTotalFirstForRow() : this._pivotDataModel.isDisplayGrandTotalFirstForColumn();
    }

    @Override
    public Object getColumnIdentifier(int n) {
        if (this.isRowHeader()) {
            String string = n < this._fields.length ? this._fields[n].getName() : super.getColumnName(n);
            return string + ":::HEADER";
        }
        return super.getColumnName(n);
    }

    @Override
    public String getColumnName(int n) {
        if (this.isRowHeader()) {
            return n < this._fields.length ? this._fields[n].getTitle() : super.getColumnName(n);
        }
        return super.getColumnName(n);
    }

    @Override
    public int getColumnCount() {
        if (this.isRowHeader()) {
            return this.internalGetColumnCount() + (this._pivotDataModel instanceof PivotDataModel && ((PivotDataModel)this._pivotDataModel).isAggregateMode() ? 0 : (this.isDataFieldAdded() ? 1 : 0));
        }
        return this.internalGetColumnCount() * (this.isDataFieldAdded() ? this.getNumberOfDataFields() : 1);
    }

    int internalGetColumnCount() {
        if (this.isRowHeader()) {
            return this._fields == null ? 0 : Math.max(this._fields.length, this._fields.length == 0 && this.isGrandTotalDisplayed() ? 1 : 0);
        }
        return this._flatData != null ? this.getFlatData().size() : 0;
    }

    int getIndexInFlatData(int n) {
        if (this.isDataFieldAdded()) {
            int n2 = this.getNumberOfDataFields();
            if (n2 == 0) {
                return -1;
            }
            if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst()) {
                return n % this._flatData.size();
            }
            return n / n2;
        }
        return n;
    }

    int getVisualIndex(int n) {
        if (this.isDataFieldAdded()) {
            int n2 = this.getNumberOfDataFields();
            if (n2 == 0) {
                return -1;
            }
            if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst()) {
                return n;
            }
            return n * n2;
        }
        return n;
    }

    public Values getValuesAt(int n) {
        if ((n = this.getIndexInFlatData(n)) < 0 || n >= this.getFlatData().size()) {
            return null;
        }
        return (DefaultValues)this.getFlatData().get(n);
    }

    public Object[] getKeyValuesAt(int n) {
        Values values = this.getValuesAt(n);
        if (values != null) {
            Object[] objectArray = new Object[values.getCount()];
            for (int i = 0; i < values.getCount(); ++i) {
                objectArray[i] = values.getValueAt(i).getValue();
            }
            return objectArray;
        }
        return new Object[0];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.isRowHeader()) {
            if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst() && this.isDataFieldAdded()) {
                if (n2 == 0) {
                    int n3 = this.getNumberOfDataFields();
                    if (n3 == 0) {
                        return null;
                    }
                    return this._dataFields[n / this.getFlatData().size()].getTitle();
                }
                Values values = this.getValuesAt(n);
                if (values == null) {
                    return null;
                }
                if (n2 <= values.getCount()) {
                    return values.getValueAt(n2 - 1).getValue();
                }
                if (this._pivotDataModel.isSummaryMode()) {
                    if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isAggregateMode() && (n2 = values.getCount() - 1) >= 0) {
                        return values.getValueAt(n2).getValue();
                    }
                    return null;
                }
                Value value = values.getValueAt(0);
                if (value instanceof DefaultExpandableValue) {
                    return ((DefaultExpandableValue)value).getFirstDescendantValueAt(n2 - 1);
                }
                return null;
            }
            if (n2 == this._dataIndex) {
                int n4 = this.getNumberOfDataFields();
                if (n4 == 0) {
                    return null;
                }
                return this._dataFields[n % n4].getTitle();
            }
            Values values = this.getValuesAt(n);
            if (values == null) {
                return null;
            }
            if (n2 < values.getCount()) {
                return values.getValueAt(n2).getValue();
            }
            if (this._pivotDataModel.isSummaryMode()) {
                if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isAggregateMode() && (n2 = values.getCount() - 1) >= 0) {
                    return values.getValueAt(n2).getValue();
                }
                return null;
            }
            Value value = values.getValueAt(0);
            if (value instanceof DefaultExpandableValue) {
                return ((DefaultExpandableValue)value).getFirstDescendantValueAt(n2);
            }
            return null;
        }
        if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst() && this.isDataFieldAdded()) {
            if (n == 0) {
                int n5 = this.getNumberOfDataFields();
                if (n5 == 0) {
                    return null;
                }
                return this._dataFields[n2 / this.getFlatData().size()].getTitle();
            }
            Values values = this.getValuesAt(n2 % this.getFlatData().size());
            if (values == null) {
                return null;
            }
            return n - 1 < values.getCount() ? values.getValueAt(n - 1).getValue() : null;
        }
        if (n == this._dataIndex) {
            int n6 = this.getNumberOfDataFields();
            if (n6 == 0) {
                return null;
            }
            return this._dataFields[n2 % n6].getTitle();
        }
        Values values = this.getValuesAt(n2);
        if (values == null) {
            return null;
        }
        return n < values.getCount() ? values.getValueAt(n).getValue() : null;
    }

    public synchronized Class<?> getRowValueClass(int n) {
        if (this.getFlatData() == null || n >= this.getFlatData().size()) {
            return null;
        }
        return this.getFlatData().get(n).getClass();
    }

    public int getSummaryType(int n) {
        if (this.getFlatData() == null || n >= this.getFlatData().size()) {
            return -1;
        }
        Object e = this.getFlatData().get(n);
        if (e instanceof SummaryValues) {
            return ((SummaryValues)e).getSummaryType();
        }
        return -1;
    }

    public int getSummaryColumn(int n) {
        if (this.getFlatData() == null || n >= this.getFlatData().size()) {
            return -1;
        }
        Object e = this.getFlatData().get(n);
        if (e instanceof SummaryValues) {
            return ((SummaryValues)e).getCount() - 1;
        }
        return -1;
    }

    public Expandable getExpandable(int n, int n2) {
        int n3;
        int n4 = this.isRowHeader() ? n : n2;
        int n5 = n3 = this.isRowHeader() ? n2 : n;
        if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst() && this.isDataFieldAdded()) {
            if (n3 == 0) {
                return null;
            }
            --n3;
        } else if (n3 == this._dataIndex) {
            --n3;
        }
        Values values = this.getValuesAt(n4);
        if (values == null) {
            return null;
        }
        if (this.isDataFieldAdded()) {
            int n6 = this.getNumberOfDataFields();
            if (n6 == 0) {
                n6 = 1;
            }
            n4 /= n6;
        }
        if (values instanceof GrandTotalValues) {
            return new GrandTotalValue();
        }
        if (values instanceof DummyValues) {
            return new DummyValue();
        }
        Expandable expandable = (Expandable)((Object)values.getValueAt(n3));
        if (this._pivotDataModel instanceof PivotDataModel && ((PivotDataModel)this._pivotDataModel).isAggregateMode() && expandable == null && values.getCount() > 0) {
            n3 = values.getCount() - 1;
            expandable = (Expandable)((Object)values.getValueAt(n3));
        }
        if (expandable instanceof CopiedExpandableValue) {
            return ((CopiedExpandableValue)expandable).getOriginal();
        }
        return expandable;
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.isRowHeader() ? n : n2;
        int n6 = this.isRowHeader() ? n2 : n;
        int n7 = -1;
        if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst() && this.isDataFieldAdded() && n6 == 0) {
            if (this.isRowHeader()) {
                return new CellSpan(n5 / this.getFlatData().size() * this.getFlatData().size(), n6, this.getFlatData().size(), 1);
            }
            return new CellSpan(n6, n5 / this.getFlatData().size() * this.getFlatData().size(), 1, this.getFlatData().size());
        }
        if (!(n6 != this._dataIndex || this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst())) {
            if (this.isRowHeader()) {
                return new CellSpan(n5, n6, 1, 1);
            }
            return new CellSpan(n6, n5, 1, 1);
        }
        Values values = this.getValuesAt(n5);
        if (values == null) {
            return null;
        }
        if (this.isDataFieldAdded()) {
            if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst()) {
                n7 = n5 / this.getFlatData().size();
                n5 %= this.getFlatData().size();
                --n6;
            } else {
                int n8 = this.getNumberOfDataFields();
                if (n8 == 0) {
                    n8 = 1;
                }
                n5 /= n8;
            }
        }
        ExpandableValue expandableValue = null;
        List<?> list = this._hierarchicalDataWithSummary;
        ArrayList<Value> arrayList = new ArrayList<Value>();
        int n9 = 1;
        int n10 = 1;
        if (values instanceof GrandTotalValues) {
            n9 = Math.max(1, this.isRowHeader() ? this.internalGetColumnCount() : this.internalGetRowCount());
            n6 = 0;
            n4 = n5;
        } else {
            int n11;
            Object object;
            for (int i = 0; i <= n6; ++i) {
                object = values.getValueAt(i);
                int n12 = n11 = list != null ? list.indexOf(object) : -1;
                if (n11 != -1) {
                    expandableValue = (ExpandableValue)object;
                    arrayList.add(expandableValue);
                }
                if (i == n6 || expandableValue == null) break;
                list = expandableValue.getChildren();
            }
            if (!(values instanceof GrandTotalValues) && expandableValue == null) {
                return null;
            }
            Values values2 = null;
            if (expandableValue == null) {
                n10 = 1;
            } else if (this._pivotDataModel.hasHiddenValues()) {
                object = new ArrayList();
                this.addValue((List<Values>)object, expandableValue, -1);
                n10 = object.size();
                values2 = (Values)object.get(0);
            } else if (!(values instanceof SummaryValues) && this._pivotDataModel instanceof PivotDataModel && (this.isRowHeader() && ((PivotDataModel)this._pivotDataModel).getFilteredRowValues() != null || !this.isRowHeader() && ((PivotDataModel)this._pivotDataModel).getFitleredColumnValues() != null)) {
                Values values3;
                Values values4;
                int n13;
                for (n13 = n5 - 1; !(n13 < 0 || (values4 = this.getValuesAt(n13)).getCount() <= n6 || values4 instanceof SummaryValues && values4.getCount() <= n6 + 1); --n13) {
                    int n14;
                    for (n14 = 0; n14 <= n6 && n14 < values.getCount() && values.getValueAt(n14).getValue().equals(values4.getValueAt(n14).getValue()); ++n14) {
                    }
                    if (n14 <= n6 && n14 < values.getCount()) break;
                }
                for (n11 = n5 + 1; !(n11 >= this._flatData.size() || (values3 = this.getValuesAt(n11)).getCount() <= n6 || values3 instanceof SummaryValues && values3.getCount() <= n6 + 1); ++n11) {
                    int n15;
                    for (n15 = 0; n15 <= n6 && n15 < values.getCount() && values.getValueAt(n15).getValue().equals(values3.getValueAt(n15).getValue()); ++n15) {
                    }
                    if (n15 <= n6 && n15 < values.getCount()) break;
                }
                n10 = n11 - n13 - 1;
            } else {
                n10 = expandableValue.getNumberOfVisibleExpandable();
            }
            if (values instanceof SummaryValues) {
                if (arrayList.get(arrayList.size() - 1) instanceof SummaryValue && n6 == arrayList.size() - 1) {
                    n9 = this.isRowHeader() ? this.internalGetColumnCount() - arrayList.size() + 1 : this.internalGetRowCount() - arrayList.size() + 1;
                } else if (n6 > arrayList.size() - 1) {
                    n6 = arrayList.size() - 1;
                    n9 = this.isRowHeader() ? this.internalGetColumnCount() - arrayList.size() + 1 : this.internalGetRowCount() - arrayList.size() + 1;
                } else {
                    while (expandableValue.hasChildren()) {
                        Object object2 = expandableValue.getChildAt(0);
                        arrayList.add((Value)object2);
                        if (!this._pivotDataModel.isSummaryMode() || ((ExpandableValue)object2).isExpanded()) {
                            expandableValue = (ExpandableValue)object2;
                            continue;
                        }
                        break;
                    }
                }
            } else if (!expandableValue.isExpanded()) {
                if (!this._pivotDataModel.isSummaryMode()) {
                    n9 = 1;
                } else if (n6 == arrayList.size() - 1) {
                    n9 = this.isRowHeader() ? this.internalGetColumnCount() - arrayList.size() + 1 : this.internalGetRowCount() - arrayList.size() + 1;
                } else if (n6 > arrayList.size() - 1) {
                    n6 = arrayList.size() - 1;
                    n9 = this.isRowHeader() ? this.internalGetColumnCount() - arrayList.size() + 1 : this.internalGetRowCount() - arrayList.size() + 1;
                }
            } else {
                while (expandableValue.hasChildren()) {
                    int n16 = 0;
                    Object object3 = expandableValue.getChildAt(n16);
                    arrayList.add((Value)object3);
                    if (!this._pivotDataModel.isSummaryMode() || ((ExpandableValue)object3).isExpanded()) {
                        expandableValue = (ExpandableValue)object3;
                        continue;
                    }
                    break;
                }
            }
            if (values2 == null) {
                if (arrayList.size() > 1 && arrayList.get(arrayList.size() - 1) instanceof SummaryValue) {
                    SummaryValue summaryValue = (SummaryValue)arrayList.get(arrayList.size() - 1);
                    values2 = new SummaryValues(summaryValue, summaryValue.getSummaryType());
                } else {
                    values2 = arrayList.size() > 1 && arrayList.get(arrayList.size() - 1) instanceof GrandTotalValue ? new GrandTotalValues() : new DefaultValues(arrayList);
                }
            }
            if ((n4 = this.indexOf(values2)) == -1) {
                n4 = n5;
            }
        }
        int n17 = n3 = this.isDataFieldAdded() && (!(this._pivotDataModel instanceof PivotDataModel) || !this._pivotDataModel.isLayoutDataFieldsFirst()) ? this.getNumberOfDataFields() : 1;
        if (this.isDataFieldAdded() && this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst()) {
            ++n6;
            if (n7 > 0) {
                n4 += n7 * this.getFlatData().size();
            }
        }
        if (this.isRowHeader()) {
            return new CellSpan(n4 * n3, n6, n10 * n3, n9);
        }
        return new CellSpan(n6, n4 * n3, n9, n10 * n3);
    }

    public void setCellSpanOn(boolean bl) {
        if (this._cellSpanOn != bl) {
            this._cellSpanOn = bl;
            this.fireTableDataChanged();
        }
    }

    @Override
    public boolean isCellSpanOn() {
        return this._cellSpanOn;
    }

    int getDataIndex() {
        return this._dataIndex;
    }

    Object getValuesAt(int n, int n2) {
        if (this.isRowHeader()) {
            if (this._dataIndex == n2 && this.getNumberOfDataFields() != 0 && n >= 0) {
                n /= this.getNumberOfDataFields();
            }
            return this._flatData.get(n);
        }
        if (this._dataIndex == n && this.getNumberOfDataFields() != 0 && n2 >= 0) {
            n2 /= this.getNumberOfDataFields();
        }
        return this._flatData.get(n2);
    }

    public PivotField getFieldAt(int n, int n2) {
        Values values;
        if (this.isRowHeader()) {
            Values values2;
            if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst() && this.isDataFieldAdded()) {
                Values values3;
                if (0 == n2) {
                    if (this.getFlatData().size() != 0 && n >= 0) {
                        return this._dataFields[n / this.getFlatData().size()];
                    }
                    return null;
                }
                if (n2 <= 0 || n2 > this._fields.length) {
                    return null;
                }
                if (this.getPivotDataModel().isShowSubtotalAsChild() && (values3 = this.getValuesAt(n2)) instanceof SummaryValues && n2 == values3.getCount()) {
                    return this._fields[n2 - 2];
                }
                return this._fields[n2 - 1];
            }
            if (this._dataIndex == n2) {
                if (this.getNumberOfDataFields() != 0 && n >= 0) {
                    return this._dataFields[n % this.getNumberOfDataFields()];
                }
                return null;
            }
            if (n2 < 0 || n2 >= this._fields.length) {
                return null;
            }
            if (this.getPivotDataModel().isShowSubtotalAsChild() && (values2 = this.getValuesAt(n)) instanceof SummaryValues && n2 == values2.getCount() - 1) {
                return this._fields[n2 - 1];
            }
            return this._fields[n2];
        }
        if (this._pivotDataModel instanceof PivotDataModel && this._pivotDataModel.isLayoutDataFieldsFirst() && this._dataIndex >= 0) {
            Values values4;
            if (0 == n) {
                if (this.getFlatData().size() != 0 && n2 >= 0) {
                    return this._dataFields[n2 / this.getFlatData().size()];
                }
                return null;
            }
            if (n <= 0 || n > this._fields.length) {
                return null;
            }
            if (this.getPivotDataModel().isShowSubtotalAsChild() && (values4 = this.getValuesAt(n2)) instanceof SummaryValues && n == values4.getCount()) {
                return this._fields[n - 2];
            }
            return this._fields[n - 1];
        }
        if (this._dataIndex == n) {
            if (this.getNumberOfDataFields() != 0 && n2 >= 0) {
                return this._dataFields[n2 % this.getNumberOfDataFields()];
            }
            return null;
        }
        if (n < 0 || n >= this._fields.length) {
            return null;
        }
        if (this.getPivotDataModel().isShowSubtotalAsChild() && (values = this.getValuesAt(n2)) instanceof SummaryValues && n == values.getCount() - 1) {
            return this._fields[n - 1];
        }
        return this._fields[n];
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        PivotField pivotField = this.getFieldAt(n, n2);
        if (pivotField != null) {
            for (PivotField pivotField2 : this._fields) {
                if (pivotField2 != pivotField) continue;
                return pivotField.getConverterContext();
            }
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        PivotField pivotField = this.getFieldAt(n, n2);
        if (pivotField != null) {
            for (PivotField pivotField2 : this._fields) {
                if (pivotField2 != pivotField) continue;
                return pivotField.getEditorContext();
            }
        }
        return null;
    }

    public Class getCellClassAt(int n, int n2) {
        PivotField pivotField = this.getFieldAt(n, n2);
        if (pivotField != null) {
            for (PivotField pivotField2 : this._fields) {
                if (pivotField2 != pivotField) continue;
                return pivotField.getType();
            }
        }
        return String.class;
    }

    List getHierarchy() {
        return this._hierarchicalData;
    }

    public boolean isExpandable(int n, int n2) {
        Expandable expandable = this.getExpandable(n, n2);
        return expandable != null && expandable.isExpandable() && expandable.hasChildren();
    }

    public boolean isExpanded(int n, int n2) {
        Expandable expandable = this.getExpandable(n, n2);
        return expandable != null && expandable.hasChildren() && expandable.isExpanded();
    }

    public boolean isCollapsed(int n, int n2) {
        Expandable expandable = this.getExpandable(n, n2);
        return expandable != null && expandable.hasChildren() && !expandable.isExpanded();
    }

    private void addChangedExpandable(Expandable expandable) {
        if (this._statusChangedNodes == null) {
            this._statusChangedNodes = new ArrayList<Expandable>();
        }
        this._statusChangedNodes.add(expandable);
    }

    public void expand(int n, int n2) {
        Expandable expandable = this.getExpandable(n, n2);
        if (expandable != null && expandable.isExpandable() && expandable.hasChildren()) {
            this.setValueExpanded(expandable, true);
            this.addChangedExpandable(expandable);
            this.refreshAfterUpdateExpandable(this.getColumnCount());
        }
    }

    public void expand(int n) {
        this.expand(n, true);
    }

    public void collapse(int n) {
        this.expand(n, false);
    }

    private void expand(int n, boolean bl) {
        boolean bl2 = false;
        if (this.isRowHeader()) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                boolean bl3;
                Expandable expandable = this.getExpandable(i, n);
                if (expandable == null || !expandable.isExpandable() || !expandable.hasChildren() || (bl3 = expandable.isExpanded()) == bl) continue;
                this.setValueExpanded(expandable, bl);
                bl2 = true;
            }
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                boolean bl4;
                Expandable expandable = this.getExpandable(n, i);
                if (expandable == null || !expandable.isExpandable() || !expandable.hasChildren() || (bl4 = expandable.isExpanded()) == bl) continue;
                this.setValueExpanded(expandable, bl);
                this.addChangedExpandable(expandable);
                bl2 = true;
            }
        }
        if (bl2) {
            this.refreshAfterUpdateExpandable(this.getColumnCount());
        }
    }

    public void collapse(int n, int n2) {
        Expandable expandable = this.getExpandable(n, n2);
        if (expandable != null && expandable.isExpandable() && expandable.hasChildren()) {
            this.setValueExpanded(expandable, false);
            this.addChangedExpandable(expandable);
            this.refreshAfterUpdateExpandable(this.getColumnCount());
        }
    }

    public void toggle(int n, int n2) {
        Expandable expandable = this.getExpandable(n, n2);
        if (expandable != null && expandable.isExpandable() && expandable.hasChildren()) {
            this.setValueExpanded(expandable, !expandable.isExpanded());
            this.addChangedExpandable(expandable);
            this.refreshAfterUpdateExpandable(this.getColumnCount());
        }
    }

    public void expandAll() {
        this.expandAll(new int[0]);
    }

    public void expandAll(int[] nArray) {
        boolean bl = this.shouldExpandOrCollapse(nArray, 0);
        for (Object e : this._hierarchicalData) {
            ExpandableValue expandableValue = (ExpandableValue)e;
            if (bl) {
                this.setValueExpanded(expandableValue, true);
                this.addChangedExpandable(expandableValue);
            }
            this.expandAll(expandableValue, true, 1, nArray);
        }
        this.refreshAfterUpdateExpandable(this.getColumnCount());
    }

    public void collapseAll() {
        this.collapseAll(new int[0]);
    }

    public void collapseAll(int[] nArray) {
        boolean bl = this.shouldExpandOrCollapse(nArray, 0);
        for (Object e : this._hierarchicalData) {
            ExpandableValue expandableValue = (ExpandableValue)e;
            if (bl) {
                this.setValueExpanded(expandableValue, false);
                this.addChangedExpandable(expandableValue);
            }
            this.expandAll(expandableValue, false, 1, nArray);
        }
        this.refreshAfterUpdateExpandable(this.getColumnCount());
    }

    private boolean shouldExpandOrCollapse(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return false;
        }
        return true;
    }

    private void expandAll(Expandable expandable, boolean bl, int n, int[] nArray) {
        boolean bl2 = this.shouldExpandOrCollapse(nArray, n);
        if (expandable != null && expandable.hasChildren()) {
            for (int i = 0; i < expandable.getChildrenCount(); ++i) {
                ExpandableValue expandableValue = (ExpandableValue)expandable.getChildAt(i);
                if (!expandableValue.isExpandable() || !expandableValue.hasChildren()) continue;
                if (bl2) {
                    this.setValueExpanded(expandableValue, bl);
                    this.addChangedExpandable(expandableValue);
                }
                this.expandAll(expandableValue, bl, n + 1, nArray);
            }
        }
    }

    protected boolean isDataFieldAdded() {
        return this._dataIndex != -1;
    }

    public boolean isDataCell(int n, int n2) {
        if (this.isRowHeader()) {
            return this._dataIndex == n2;
        }
        return this._dataIndex == n;
    }

    @Override
    public final CellStyle getCellStyleAt(int n, int n2) {
        PivotCellStyleProvider pivotCellStyleProvider = this._pivotDataModel.getCellStyleProvider();
        if (pivotCellStyleProvider != null) {
            if (this.isRowHeader()) {
                return pivotCellStyleProvider.getRowHeaderCellStyleAt(this, n, n2);
            }
            return pivotCellStyleProvider.getColumnHeaderCellStyleAt(this, n, n2);
        }
        return null;
    }

    @Override
    public final boolean isCellStyleOn() {
        return this._pivotDataModel.getCellStyleProvider() != null;
    }

    public boolean isRunningSummaryRowOrColumn(int n) {
        DefaultValues defaultValues = (DefaultValues)this.getValuesAt(n);
        return defaultValues != null && defaultValues.getCount() != 0 && defaultValues instanceof RunningSummaryValues;
    }

    public boolean isSubtotalRowOrColumn(int n) {
        DefaultValues defaultValues = (DefaultValues)this.getValuesAt(n);
        if (defaultValues == null || defaultValues.getCount() == 0) {
            return false;
        }
        if (defaultValues.getValueAt(defaultValues.getCount() - 1) instanceof RowIndexesValue) {
            return true;
        }
        return defaultValues instanceof SummaryValues;
    }

    public boolean isGrandTotalRowOrColumn(int n) {
        DefaultValues defaultValues = (DefaultValues)this.getValuesAt(n);
        return defaultValues instanceof GrandTotalValues;
    }

    public IPivotDataModel getPivotDataModel() {
        return this._pivotDataModel;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        PivotDataEditingProvider pivotDataEditingProvider;
        PivotDataEditingProvider pivotDataEditingProvider2 = pivotDataEditingProvider = this.isRowHeader() ? this._pivotDataModel.getRowHeaderEditingProvider() : this._pivotDataModel.getColumnHeaderEditingProvider();
        if (pivotDataEditingProvider != null && this._pivotDataModel instanceof PivotDataModel) {
            pivotDataEditingProvider.setValueAt((PivotDataModel)this._pivotDataModel, object, n, n2);
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        PivotDataEditingProvider pivotDataEditingProvider;
        PivotDataEditingProvider pivotDataEditingProvider2 = pivotDataEditingProvider = this.isRowHeader() ? this._pivotDataModel.getRowHeaderEditingProvider() : this._pivotDataModel.getColumnHeaderEditingProvider();
        if (pivotDataEditingProvider != null && this._pivotDataModel instanceof PivotDataModel) {
            return pivotDataEditingProvider.isCellEditable((PivotDataModel)this._pivotDataModel, n, n2);
        }
        return super.isCellEditable(n, n2);
    }

    public int indexOf(Object[] objectArray) {
        Value[] valueArray = new Value[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            valueArray[i] = new DefaultExpandableValue(objectArray[i]);
        }
        return this.indexOf(new DefaultValues(valueArray));
    }

    int indexOf(Values values) {
        if (this.getPivotDataModel() instanceof PivotDataModel && ((PivotDataModel)this.getPivotDataModel()).isAutoSortKeys() && values instanceof DefaultValues) {
            this.prepareSortOrders();
            if (this._sortOrders != null) {
                int n = this.indexOf(values, this._flatData);
                ((PivotDataModel)this.getPivotDataModel()).disposeSortingMap();
                return n;
            }
        }
        return this.getFlatData().indexOf(values);
    }

    private int indexOf(Values values, List list) {
        CompoundKey compoundKey;
        int n;
        int n2 = this.getInsertIndexInFlatData((DefaultValues)values, list);
        int n3 = list.size();
        if (n2 >= 0) {
            return list.indexOf(values);
        }
        n2 = 0 - n2 - 1;
        CompoundKey compoundKey2 = ((DefaultValues)values).toCompoundKey();
        for (n = n2; n < n3; ++n) {
            if (values.equals(this._flatData.get(n))) {
                return n;
            }
            compoundKey = ((DefaultValues)list.get(n)).toCompoundKey();
            if (compoundKey.compareTo(compoundKey2, this.getPivotDataModel(), this._fields, this._sortOrders) != 0) break;
        }
        for (n = n2 - 1; n >= 0; --n) {
            if (values.equals(list.get(n))) {
                return n;
            }
            compoundKey = ((DefaultValues)list.get(n)).toCompoundKey();
            if (compoundKey.compareTo(compoundKey2, this.getPivotDataModel(), this._fields, this._sortOrders) != 0) break;
        }
        return -1;
    }

    @Deprecated
    String appendSummaryOrTotal(int n, int n2, Value value, String string, PivotTablePane pivotTablePane) {
        return this.appendSummaryOrTotal(n, n2, value, string, pivotTablePane.getLocale());
    }

    String appendSummaryOrTotal(int n, int n2, Value value, String string, Locale locale) {
        if (value instanceof SummaryValue && !this.isDataCell(n, n2)) {
            int n3 = ((SummaryValue)value).getSummaryType();
            string = MessageFormat.format(PivotResources.getResourceBundle(locale).getString("Renderer.totalPhrase"), string, n3 == -1 ? PivotResources.getResourceBundle(locale).getString("Renderer.total") : this.getPivotDataModel().getSummaryCalculator().getSummaryName(locale, n3));
        } else if (value instanceof GrandTotalValue && !this.isDataCell(n, n2)) {
            String string2;
            PivotField[] pivotFieldArray = this.getPivotDataModel().getDataFields();
            int n4 = 0;
            boolean bl = false;
            if (pivotFieldArray != null) {
                for (int i = 0; i < pivotFieldArray.length; ++i) {
                    if (i == 0) {
                        n4 = pivotFieldArray[i].getGrandTotalSummaryType();
                        continue;
                    }
                    if (n4 == pivotFieldArray[i].getGrandTotalSummaryType()) continue;
                    bl = true;
                }
            }
            if (this.isRowHeader()) {
                try {
                    string2 = PivotResources.getResourceBundle(locale).getString("Renderer.grandTotal.row");
                }
                catch (Exception exception) {
                    string2 = null;
                }
            } else {
                try {
                    string2 = PivotResources.getResourceBundle(locale).getString("Renderer.grandTotal.column");
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
            string = string2 != null ? string2 : (bl ? MessageFormat.format(PivotResources.getResourceBundle(locale).getString("Renderer.grandTotalPhrase"), PivotResources.getResourceBundle(locale).getString("Renderer.grandTotal"), PivotResources.getResourceBundle(locale).getString("Renderer.mixed")) : (n4 == 0 ? PivotResources.getResourceBundle(locale).getString("Renderer.grandTotal") : MessageFormat.format(PivotResources.getResourceBundle(locale).getString("Renderer.grandTotalPhrase"), PivotResources.getResourceBundle(locale).getString("Renderer.grandTotal"), n4 == -1 ? PivotResources.getResourceBundle(locale).getString("Renderer.total") : this.getPivotDataModel().getSummaryCalculator().getSummaryName(locale, n4))));
        }
        return string;
    }

    @Deprecated
    String appendSummaryOrTotal(int n, int n2, Value value, String string, JTable jTable) {
        return this.appendSummaryOrTotal(n, n2, value, string, jTable.getLocale());
    }

    @Deprecated
    public String getValueAtInString(PivotTablePane pivotTablePane, int n, int n2) {
        return this.getValueAtInString(pivotTablePane.getLocale(), n, n2);
    }

    @Deprecated
    public String getValueAtInString(Locale locale, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        return this.getValueAtInString(locale, object, n, n2);
    }

    @Deprecated
    public String getValueAtInString(PivotTablePane pivotTablePane, Object object, int n, int n2) {
        return this.getValueAtInString(pivotTablePane.getLocale(), object, n, n2);
    }

    @Deprecated
    public String getValueAtInString(Locale locale, Object object, int n, int n2) {
        Expandable expandable = this.getExpandable(n, n2);
        Class clazz = this.getCellClassAt(n, n2);
        ConverterContext converterContext = this.getConverterContextAt(n, n2);
        String string = ObjectConverterManager.toString(object, clazz, converterContext);
        return this.appendSummaryOrTotal(n, n2, (Value)((Object)expandable), string, locale);
    }

    public Map<String, Boolean> getExpansionState() {
        if (this.getPivotDataModel().isHighPerformanceMode()) {
            return null;
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (int i = this._hierarchicalData.size() - 1; i >= 0; --i) {
            StringBuffer stringBuffer = new StringBuffer();
            Object e = this._hierarchicalData.get(i);
            if (!((ExpandableValue)e).hasChildren()) continue;
            this.getExpansionState(hashMap, stringBuffer, (ExpandableValue)e, this.getPivotDataModel().getExpansionStateSeparator());
        }
        return hashMap;
    }

    private void getExpansionState(Map<String, Boolean> map, StringBuffer stringBuffer, ExpandableValue expandableValue, String string) {
        StringBuilder stringBuilder = new StringBuilder(stringBuffer);
        stringBuilder.append(string).append(expandableValue.getValue());
        map.put(stringBuilder.toString(), expandableValue.isExpanded());
        for (int i = expandableValue.getChildrenCount() - 1; i >= 0; --i) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuilder);
            Object object = expandableValue.getChildAt(i);
            if (!(object instanceof ExpandableValue) || !((ExpandableValue)object).hasChildren()) continue;
            this.getExpansionState(map, stringBuffer2, (ExpandableValue)object, this.getPivotDataModel().getExpansionStateSeparator());
        }
    }

    public void setExpansionState(Map<String, Boolean> map) {
        if (this.getPivotDataModel().isHighPerformanceMode()) {
            return;
        }
        if (this.getPivotDataModel() instanceof PivotDataModel) {
            if (this.isRowHeader()) {
                ((PivotDataModel)this.getPivotDataModel()).updateRowHeaderTableModel(map);
            } else {
                ((PivotDataModel)this.getPivotDataModel()).updateColumnHeaderTableModel(map);
            }
        }
    }

    void fireIndexChangeEvent(int n, int n2) {
        IndexChangeEvent indexChangeEvent = new IndexChangeEvent(this, n, n2);
        IndexChangeListener[] indexChangeListenerArray = this.getIndexChangeListeners();
        for (int i = indexChangeListenerArray.length - 1; i >= 0; --i) {
            indexChangeListenerArray[i].indexChanged(indexChangeEvent);
        }
    }

    IndexChangeListener[] getIndexChangeListeners() {
        return (IndexChangeListener[])this.listenerList.getListeners(IndexChangeListener.class);
    }

    void addIndexChangeListener(IndexChangeListener indexChangeListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, IndexChangeListener.class, (EventListener)indexChangeListener)) {
            this.listenerList.add(IndexChangeListener.class, indexChangeListener);
        }
    }

    void removeIndexChangeListener(IndexChangeListener indexChangeListener) {
        this.listenerList.remove(IndexChangeListener.class, indexChangeListener);
    }
}

