/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.pivot.FieldBox;
import com.jidesoft.pivot.PivotTablePane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;

public class FieldArea
extends JPanel {
    private int _areaType;
    private PivotTablePane _pivotTablePane;
    private int _minimumSize = 25;
    private JTable _table;
    private int _startingColumnIndex;

    public FieldArea(PivotTablePane pivotTablePane, int n) {
        this._areaType = n;
        this._pivotTablePane = pivotTablePane;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new FieldAreaLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.setForeground(Color.GRAY);
        this.setOpaque(false);
    }

    public Component[] getFieldBoxes() {
        return this.getComponents();
    }

    public int getAreaType() {
        return this._areaType;
    }

    public void setAreaType(int n) {
        this._areaType = n;
    }

    public int getMinimumHeight() {
        return this._minimumSize;
    }

    public void setMinimumHeight(int n) {
        this._minimumSize = n;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension;
        Insets insets = this.getInsets();
        if (this.getComponentCount() == 0) {
            int n = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this._pivotTablePane.getFieldAreaMessage(this.getAreaType())) + 12;
            dimension = new Dimension(n + insets.left + insets.right, this._minimumSize + insets.top + insets.bottom);
        } else {
            dimension = new Dimension(super.getMinimumSize().width, this._minimumSize + insets.top + insets.bottom);
        }
        if (!this._pivotTablePane.isShrinkDataFieldArea()) {
            dimension.width += 4;
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getComponentCount() == 0) {
            dimension = this.getAreaType() == 0 && this._pivotTablePane.getRowHeaderTable().getColumnCount() == 1 ? new Dimension(this._pivotTablePane.getRowHeaderTable().getColumnModel().getColumn(0).getWidth(), dimension.height) : new Dimension(Math.max(dimension.width, this.getMinimumSize().width), dimension.height);
        } else {
            Insets insets = this.getInsets();
            if (dimension.width < this._minimumSize) {
                dimension.width = this._minimumSize + insets.left + insets.right;
            }
            if (dimension.height < this._minimumSize) {
                dimension.height = this._minimumSize + insets.top + insets.bottom;
            }
        }
        if (this._areaType == 3 && !this._pivotTablePane.isShrinkDataFieldArea()) {
            dimension.width += 4;
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.getComponentCount() == 0) {
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            Insets insets = this.getInsets();
            graphics.drawString(this._pivotTablePane.getFieldAreaMessage(this.getAreaType()), insets.left + 6, insets.top + (this.getHeight() - insets.top - insets.bottom) / 2 + graphics.getFontMetrics().getAscent() / 2);
        }
    }

    public void setTable(JTable jTable, int n) {
        this._table = jTable;
        this._startingColumnIndex = n;
    }

    @Override
    public void invalidate() {
        Component[] componentArray;
        super.invalidate();
        for (Component component : componentArray = this.getComponents()) {
            component.invalidate();
        }
    }

    @Override
    public void doLayout() {
        Component[] componentArray;
        super.doLayout();
        for (Component component : componentArray = this.getComponents()) {
            component.doLayout();
        }
    }

    public void savePreferredWidth() {
        int n;
        Component[] componentArray = this.getComponents();
        TableColumnModel tableColumnModel = this._pivotTablePane.getRowHeaderTable().getColumnModel();
        int n2 = n = this._pivotTablePane.getPivotDataModel().getRowHeaderTableModel().getDataIndex() >= 0 ? 1 : 0;
        if (tableColumnModel.getColumnCount() != componentArray.length + n) {
            return;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof FieldBox) || tableColumnModel.getColumn(i).getWidth() != tableColumnModel.getColumn(i).getPreferredWidth()) continue;
            FieldBox fieldBox = (FieldBox)component;
            fieldBox.getField().setPreferredWidth(fieldBox.getWidth());
            fieldBox.setSize(new Dimension(fieldBox.getWidth(), fieldBox.getSize().height));
        }
    }

    private class FieldAreaLayout
    implements LayoutManager {
        int hgap = 2;

        private FieldAreaLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, FieldArea.this._minimumSize);
                int n = container.getComponentCount();
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension2 = FieldArea.this._pivotTablePane.isKeepFieldAreaFit() ? component.getSize() : component.getPreferredSize();
                    dimension.height = Math.max(dimension.height, dimension2.height);
                    if (bl) {
                        bl = false;
                    } else {
                        dimension.width += this.hgap * 2;
                    }
                    dimension.width += dimension2.width;
                }
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right + this.hgap * 2;
                dimension.height += insets.top + insets.bottom;
                return dimension;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, FieldArea.this._minimumSize);
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right + this.hgap * 2;
                dimension.height += insets.top + insets.bottom;
                return dimension;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension actualPreferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, FieldArea.this._minimumSize);
                int n = container.getComponentCount();
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension2 = component.getPreferredSize();
                    dimension.height = Math.max(dimension.height, dimension2.height);
                    if (bl) {
                        bl = false;
                    } else {
                        dimension.width += this.hgap * 2;
                    }
                    dimension.width += dimension2.width;
                }
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right + this.hgap * 2;
                dimension.height += insets.top + insets.bottom;
                return dimension;
            }
        }

        public boolean notFit(Container container) {
            if (!FieldArea.this._pivotTablePane.isKeepFieldAreaFit() && !FieldArea.this._pivotTablePane.isShrinkDataFieldArea() && FieldArea.this.getAreaType() == 3) {
                return false;
            }
            Dimension dimension = this.actualPreferredLayoutSize(container);
            return dimension.width > container.getWidth();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = container.getWidth() - (insets.left + insets.right + this.hgap * 2);
                int n2 = container.getComponentCount();
                if (n2 == 0) {
                    return;
                }
                int n3 = 0;
                int n4 = insets.top;
                int n5 = 0;
                int n6 = 0;
                boolean bl = container.getComponentOrientation().isLeftToRight();
                boolean bl2 = this.notFit(container);
                int n7 = container.getWidth() / n2 - this.hgap * 2;
                for (int i = 0; i < n2; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    Dimension dimension = component.getPreferredSize();
                    if (bl2) {
                        dimension.width = n7;
                    }
                    if (FieldArea.this._table != null && i >= 0 && i < FieldArea.this._table.getColumnModel().getColumnCount() - FieldArea.this._startingColumnIndex) {
                        dimension.width = FieldArea.this._table.getColumnModel().getColumn(i + FieldArea.this._startingColumnIndex).getWidth() - this.hgap * 2;
                    }
                    Dimension dimension2 = new Dimension(dimension.width, Math.max(dimension.height, FieldArea.this._minimumSize));
                    component.setSize(dimension2);
                    if (n3 + dimension.width > n) {
                        dimension.width = n - n3;
                    }
                    if (n3 == 0 || n3 + dimension.width <= n) {
                        if (n3 > 0) {
                            n3 += this.hgap * 2;
                        }
                        n3 += dimension.width;
                        n5 = Math.max(n5, dimension.height);
                        continue;
                    }
                    System.out.println("not gonna happen");
                }
                this.moveComponents(container, insets.left + this.hgap, n4, n - n3, FieldArea.this.getHeight() - insets.top - insets.bottom, n6, n2, bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            Object object = container.getTreeLock();
            synchronized (object) {
                for (int i = n5; i < n6; ++i) {
                    Component component = container.getComponent(i);
                    if (!component.isVisible()) continue;
                    if (bl) {
                        component.setLocation(n, n2 + (n4 - component.getHeight()) / 2);
                    } else {
                        component.setLocation(container.getWidth() - n - component.getWidth(), n2 + (n4 - component.getHeight()) / 2);
                    }
                    n += component.getWidth() + this.hgap * 2;
                }
            }
        }
    }
}

