/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.grid.DefaultExpandable;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Row;
import com.jidesoft.pivot.ExpandableValue;
import com.jidesoft.pivot.PivotDataModel;
import java.util.List;

public class DefaultExpandableValue
extends DefaultExpandable
implements ExpandableValue {
    private Object _value;
    private int _hashCode = 0;
    private transient int _numberOfVisibleExpandable = -1;

    public DefaultExpandableValue(Object object) {
        this.setValue(object);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public void setValue(Object object) {
        this._value = object;
        this._hashCode = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DefaultExpandableValue)) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        DefaultExpandableValue defaultExpandableValue = (DefaultExpandableValue)object;
        return !(this._value == null ? defaultExpandableValue._value != null : !this._value.equals(defaultExpandableValue._value));
    }

    public int hashCode() {
        if (this._value == null) {
            this._hashCode = 0;
        } else if (!PivotDataModel.isValueImmutable() || this._hashCode == 0) {
            this._hashCode = this._value.hashCode();
        }
        return this._hashCode;
    }

    public String toString() {
        return "" + this.getValue();
    }

    @Override
    public int getNumberOfVisibleExpandable() {
        int n = 1;
        if (!this.isExpanded()) {
            return n;
        }
        if (this._numberOfVisibleExpandable != -1) {
            return this._numberOfVisibleExpandable;
        }
        if (this.hasChildren()) {
            n = 0;
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                Object object = this.getChildAt(i);
                if (!(object instanceof Expandable)) continue;
                n += ((Expandable)object).getNumberOfVisibleExpandable();
            }
        }
        this._numberOfVisibleExpandable = n;
        return n;
    }

    @Override
    public Object addChild(int n, Object object) {
        this.invalidateCache();
        return super.addChild(n, object);
    }

    @Override
    public void addChildren(int n, List<? extends Row> list) {
        this.invalidateCache();
        super.addChildren(n, list);
    }

    @Override
    public void removeAllChildren() {
        this.invalidateCache();
        super.removeAllChildren();
    }

    @Override
    public boolean removeChild(Object object) {
        this.invalidateCache();
        return super.removeChild(object);
    }

    void invalidateCache() {
        this._numberOfVisibleExpandable = -1;
        if (this._parent instanceof DefaultExpandableValue) {
            ((DefaultExpandableValue)this._parent).invalidateCache();
        }
    }

    public Object getFirstDescendantValueAt(int n) {
        Object object;
        if (n == 0) {
            return this.getValue();
        }
        if (this.getChildrenCount() > 0 && (object = this.getChildAt(0)) instanceof DefaultExpandableValue) {
            return ((DefaultExpandableValue)object).getFirstDescendantValueAt(n - 1);
        }
        return null;
    }
}

