/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.pivot.CalculatedHeaderTableModel;
import com.jidesoft.pivot.CompoundKey;
import com.jidesoft.pivot.DataTableModel;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.ExpandableValue;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotDataSource;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotNullCell;
import com.jidesoft.pivot.PivotValueProvider;
import com.jidesoft.pivot.PivotValueProviderEvent;
import com.jidesoft.pivot.PivotValueProviderListener;
import com.jidesoft.pivot.RunningSummary;
import com.jidesoft.pivot.RunningSummaryValue;
import com.jidesoft.pivot.RunningSummaryValues;
import com.jidesoft.pivot.SummaryCalculatorFactory;
import com.jidesoft.pivot.SummaryValue;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class CalculatedPivotDataModel
extends PivotDataModel
implements IPivotDataModel,
PivotValueProviderListener,
TableModelListener {
    private IPivotDataModel _pivotDataModel;
    private PivotValueProvider _pivotValueProvider;
    private boolean _cacheEnabled = true;
    private boolean _runningCalculateSummary = true;
    private Map<Values, Map<Values, Object[]>> _cache;
    private TableModel _tableModel;
    private Map<Values, Map<Values, Object[]>> _savedCache;
    private List<Object> _affectedValues;

    public CalculatedPivotDataModel(TableModel tableModel) {
        this.setPivotDataModel(this.createPivotDataModel(tableModel));
        if (!(this._pivotDataModel instanceof PivotValueProvider)) {
            throw new IllegalArgumentException("No PivotValueProvider could be created in the constructor.");
        }
        this.setPivotValueProvider((PivotValueProvider)((Object)this._pivotDataModel));
    }

    public CalculatedPivotDataModel(PivotDataSource pivotDataSource) {
        this.setPivotDataModel(this.createPivotDataModel(pivotDataSource));
        if (!(this._pivotDataModel instanceof PivotValueProvider)) {
            throw new IllegalArgumentException("No PivotValueProvider could be created in the constructor.");
        }
        this.setPivotValueProvider((PivotValueProvider)((Object)this._pivotDataModel));
    }

    public CalculatedPivotDataModel(IPivotDataModel iPivotDataModel) {
        this.setPivotDataModel(iPivotDataModel);
        if (!(this._pivotDataModel instanceof PivotValueProvider)) {
            throw new IllegalArgumentException("No PivotValueProvider could be created in the constructor.");
        }
        this.setPivotValueProvider((PivotValueProvider)((Object)this._pivotDataModel));
    }

    public CalculatedPivotDataModel(PivotValueProvider pivotValueProvider, TableModel tableModel) {
        this.setPivotValueProvider(pivotValueProvider);
        this.setOriginalTableModel(tableModel);
    }

    public void setPivotValueProvider(PivotValueProvider pivotValueProvider) {
        if (this._pivotValueProvider != null) {
            this._pivotValueProvider.removePivotValueProviderListener(this);
        }
        this._pivotValueProvider = pivotValueProvider;
        if (this._pivotValueProvider != null) {
            this._pivotValueProvider.addPivotValueProviderListener(this);
        }
    }

    public PivotValueProvider getPivotValueProvider() {
        return this._pivotValueProvider;
    }

    protected IPivotDataModel createPivotDataModel(TableModel tableModel) {
        PivotDataModel pivotDataModel = new PivotDataModel(tableModel);
        pivotDataModel.setSummaryLayer(false);
        return pivotDataModel;
    }

    protected IPivotDataModel createPivotDataModel(PivotDataSource pivotDataSource) {
        PivotDataModel pivotDataModel = new PivotDataModel(pivotDataSource);
        pivotDataModel.setSummaryLayer(false);
        return pivotDataModel;
    }

    public Object getPivotDataModel() {
        return this._pivotDataModel;
    }

    public void setPivotDataModel(IPivotDataModel iPivotDataModel) {
        this._pivotDataModel = iPivotDataModel;
    }

    @Override
    public void setOriginalTableModel(TableModel tableModel) {
        if (this._pivotDataModel instanceof PivotDataModel) {
            ((PivotDataModel)this._pivotDataModel).setOriginalTableModel(tableModel);
        } else if (this._pivotDataModel == null) {
            if (this._tableModel != null) {
                this._tableModel.removeTableModelListener(this);
            }
            this._tableModel = tableModel;
            if (this._tableModel != null) {
                this._tableModel.addTableModelListener(this);
            }
            this.initialize();
        }
    }

    @Override
    public void initialize() {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.initialize();
            return;
        }
        HashMap<String, PivotField> hashMap = new HashMap<String, PivotField>();
        if (this._fields != null) {
            for (PivotField object : this._fields) {
                hashMap.put(object.getName(), object);
            }
        }
        this._fields = new PivotField[this._tableModel.getColumnCount()];
        for (int i = 0; i < this._fields.length; ++i) {
            String string = this._tableModel instanceof ColumnIdentifierTableModel ? ((ColumnIdentifierTableModel)((Object)this._tableModel)).getColumnIdentifier(i).toString() : this._tableModel.getColumnName(i);
            PivotField pivotField = (PivotField)hashMap.get(string);
            if (pivotField != null) {
                this._fields[i] = pivotField;
                this._fields[i].updateFromTableModel(this._tableModel, i);
            } else {
                this._fields[i] = this.createPivotField(this._tableModel, i);
            }
            int[] nArray = this.getSummaryCalculator().getAllowedSummaries(this._fields[i].getType(), this._fields[i].getConverterContext());
            if (this._fields[i].getSummaryType() == -1 || Arrays.binarySearch(nArray, this._fields[i].getSummaryType()) != -1) continue;
            if (nArray.length > 0) {
                this._fields[i].setSummaryType(nArray[0]);
                continue;
            }
            this._fields[i].setSummaryType(-2);
        }
    }

    protected PivotField createPivotField(TableModel tableModel, int n) {
        return new PivotField(tableModel, n);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    @Override
    protected void handleFieldPropertyEvent(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedPossibleValues".equals(propertyChangeEvent.getPropertyName()) || "deselectedPossibleValues".equals(propertyChangeEvent.getPropertyName())) {
            PivotField pivotField = (PivotField)propertyChangeEvent.getSource();
            if (pivotField.getAreaType() == 3 && pivotField.isDataFieldFilterOnSummary()) {
                this.filterDataFieldsOnSummary();
            }
        } else if ("filter".equals(propertyChangeEvent.getPropertyName()) || "filterOnSummary".equals(propertyChangeEvent.getPropertyName())) {
            PivotField pivotField = (PivotField)propertyChangeEvent.getSource();
            if (pivotField.getAreaType() == 3 && pivotField.isDataFieldFilterOnSummary()) {
                this.filterDataFieldsOnSummary();
            }
        } else if ("sortOrder".equals(propertyChangeEvent.getPropertyName()) || "sortBy".equals(propertyChangeEvent.getPropertyName())) {
            PivotField pivotField = (PivotField)propertyChangeEvent.getSource();
            switch (pivotField.getAreaType()) {
                case 0: {
                    this.firePivotValueProviderChanged(4, this.getRowHeaderTableModel());
                    this.firePivotValueProviderChanged(5);
                    break;
                }
                case 1: {
                    this.firePivotValueProviderChanged(4, this.getColumnHeaderTableModel());
                    this.firePivotValueProviderChanged(6);
                }
            }
        } else if ("sortByRow".equals(propertyChangeEvent.getPropertyName())) {
            this.firePivotValueProviderChanged(4, this.getColumnHeaderTableModel());
            this.firePivotValueProviderChanged(6);
        } else if ("summaryType".equals(propertyChangeEvent.getPropertyName()) || "subtotalType".equals(propertyChangeEvent.getPropertyName()) || "grandTotalSummaryType".equals(propertyChangeEvent.getPropertyName())) {
            this.invalidateCache();
        }
    }

    @Override
    public TableModel getTableModel() {
        if (this._pivotDataModel instanceof PivotDataModel) {
            return ((PivotDataModel)this._pivotDataModel).getTableModel();
        }
        return super.getTableModel();
    }

    @Override
    public void setDataSource(PivotDataSource pivotDataSource) {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setDataSource(pivotDataSource);
        } else {
            super.setDataSource(pivotDataSource);
        }
    }

    @Override
    public PivotDataSource getDataSource() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getDataSource();
        }
        throw new IllegalStateException("should not get data source in CalculatedPivotDataModel");
    }

    @Override
    public int getStatisticsType(Values values, Values values2, PivotField pivotField) {
        if (values2 instanceof RunningSummaryValues || values instanceof RunningSummaryValues) {
            return 1;
        }
        if (pivotField != null && pivotField.getStatisticsCalculationType() >= 0) {
            return pivotField.getStatisticsCalculationType();
        }
        if (this.isRunningCalculateSummary()) {
            if (values instanceof SummaryValues) {
                return 1;
            }
            if (values2 instanceof SummaryValues) {
                return 1;
            }
            if (values instanceof GrandTotalValues || values2 instanceof GrandTotalValues) {
                return 1;
            }
        }
        return this.getPivotValueProvider().getStatisticsType(values, values2, pivotField);
    }

    @Override
    public PivotField getField(String string) {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getField(string);
        }
        return super.getField(string);
    }

    @Override
    public PivotField getField(int n) {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getField(n);
        }
        return super.getField(n);
    }

    @Override
    public PivotField[] getFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getFields();
        }
        return super.getFields();
    }

    @Override
    void setFields(PivotField[] pivotFieldArray) {
        if (this._pivotDataModel instanceof PivotDataModel) {
            ((PivotDataModel)this._pivotDataModel).setFields(pivotFieldArray);
        } else {
            super.setFields(pivotFieldArray);
        }
    }

    @Override
    public void updateFields() {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.updateFields();
        } else {
            super.updateFields();
        }
    }

    @Override
    public boolean isCalculating() {
        return this._pivotValueProvider.isCalculating();
    }

    @Override
    public Object[] getPossibleValues(PivotField pivotField) {
        return this._pivotValueProvider.getPossibleValues(pivotField);
    }

    @Override
    public PivotField[] getRowFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getRowFields();
        }
        return super.getRowFields();
    }

    @Override
    public int[] getRowFieldIndices() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getRowFieldIndices();
        }
        return super.getRowFieldIndices();
    }

    @Override
    public PivotField[] getColumnFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getColumnFields();
        }
        return super.getColumnFields();
    }

    @Override
    public int[] getColumnFieldIndices() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getColumnFieldIndices();
        }
        return super.getColumnFieldIndices();
    }

    @Override
    public PivotField[] getDataFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getDataFields();
        }
        return super.getDataFields();
    }

    @Override
    public void resetDataFields() {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.resetDataFields();
        } else {
            super.resetDataFields();
        }
    }

    @Override
    public int[] getDataFieldIndices() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getDataFieldIndices();
        }
        return super.getDataFieldIndices();
    }

    @Override
    public PivotField[] getFilterFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getFilterFields();
        }
        return super.getFilterFields();
    }

    @Override
    public int[] getFilterFieldIndices() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getFilterFieldIndices();
        }
        return super.getFilterFieldIndices();
    }

    @Override
    public PivotField[] getUnassignedFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getUnassignedFields();
        }
        return super.getUnassignedFields();
    }

    @Override
    public int[] getUnassignedFieldIndices() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getUnassignedFieldIndices();
        }
        return super.getUnassignedFieldIndices();
    }

    @Override
    public boolean isAggregateMode() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.isAggregateMode();
        }
        return super.isAggregateMode();
    }

    @Override
    protected HeaderTableModel createRowHeaderTableModel(CompoundKey[] compoundKeyArray) {
        return new CalculatedHeaderTableModel(this, this.sortCompoundKeys(compoundKeyArray, this.getRowFields()), true);
    }

    @Override
    protected HeaderTableModel createColumnHeaderTableModel(CompoundKey[] compoundKeyArray) {
        return new CalculatedHeaderTableModel(this, this.sortCompoundKeys(compoundKeyArray, this.getColumnFields()), false);
    }

    @Override
    public CompoundKey[] getRowKeys() {
        return this._pivotValueProvider.getRowKeys();
    }

    @Override
    public CompoundKey[] getColumnKeys() {
        return this._pivotValueProvider.getColumnKeys();
    }

    @Override
    public void setRowMerger(PivotDataModel.RowMerger rowMerger) {
        if (this._pivotDataModel instanceof PivotDataModel) {
            ((PivotDataModel)this._pivotDataModel).setRowMerger(rowMerger);
        } else {
            super.setRowMerger(rowMerger);
        }
    }

    @Override
    public PivotDataModel.RowMerger getRowMerger() {
        if (this._pivotDataModel instanceof PivotDataModel) {
            return ((PivotDataModel)this._pivotDataModel).getRowMerger();
        }
        return super.getRowMerger();
    }

    @Override
    public void setHideSingleDataField(boolean bl) {
        super.setHideSingleDataField(bl);
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setHideSingleDataField(bl);
        }
    }

    @Override
    public void setAlwaysRowDataFields(boolean bl) {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setAlwaysRowDataFields(bl);
        } else {
            super.setAlwaysRowDataFields(bl);
        }
    }

    @Override
    public boolean isAlwaysRowDataFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.isAlwaysRowDataFields();
        }
        return super.isAlwaysRowDataFields();
    }

    @Override
    public void setAlwaysColumnDataFields(boolean bl) {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setAlwaysColumnDataFields(bl);
        } else {
            super.setAlwaysColumnDataFields(bl);
        }
    }

    @Override
    public boolean isAlwaysColumnDataFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.isAlwaysColumnDataFields();
        }
        return super.isAlwaysColumnDataFields();
    }

    @Override
    public void setSummaryCalculator(SummaryCalculator summaryCalculator) {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setSummaryCalculator(summaryCalculator);
        } else {
            super.setSummaryCalculator(summaryCalculator);
        }
    }

    @Override
    public SummaryCalculator getSummaryCalculator() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getSummaryCalculator();
        }
        return super.getSummaryCalculator();
    }

    @Override
    public void setSummaryCalculatorFactory(SummaryCalculatorFactory summaryCalculatorFactory) {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setSummaryCalculatorFactory(summaryCalculatorFactory);
        } else {
            super.setSummaryCalculatorFactory(summaryCalculatorFactory);
        }
    }

    @Override
    public SummaryCalculatorFactory getSummaryCalculatorFactory() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getSummaryCalculatorFactory();
        }
        return super.getSummaryCalculatorFactory();
    }

    @Override
    public void setSummaryLayer(boolean bl) {
    }

    @Override
    public boolean isSummaryLayer() {
        return true;
    }

    @Override
    public void calculate() {
        this.firePivotValueProviderChanged(0);
        if (this._pivotDataModel == null) {
            this.updateFields();
            this._pivotValueProvider.setPivotFields(this.getRowFields(), this.getColumnFields(), this.getDataFields(), this.getFilterFields());
        } else {
            this._pivotDataModel.updateFields();
        }
        this._pivotValueProvider.forceCalculate();
    }

    Object getValueAt(int n, int n2) {
        Values values = this.getRowHeaderTableModel().getValuesAt(n);
        Values values2 = this.getColumnHeaderTableModel().getValuesAt(n2);
        PivotField pivotField = ((DataTableModel)this.getDataTableModel()).getDataFieldAt(n, n2);
        return this.getValueAt(pivotField, values, values2);
    }

    private void invalidateCache() {
        if (this._cache != null) {
            this._cache.clear();
        }
    }

    private Object getValueFromCache(Values values, Values values2, int n) {
        return this.getValueFromCache(this._cache, values, values2, n);
    }

    private Object getValueFromCache(Map<Values, Map<Values, Object[]>> map, Values values, Values values2, int n) {
        if (map == null) {
            return null;
        }
        Map<Values, Object[]> map2 = map.get(values);
        if (map2 == null) {
            return null;
        }
        Object[] objectArray = map2.get(values2);
        if (objectArray == null || n >= objectArray.length) {
            return null;
        }
        return objectArray[n];
    }

    private void putValueToCache(Values values, Values values2, int n, Object object) {
        Object[] objectArray;
        Map<Values, Object[]> map;
        if (this._cache == null) {
            this._cache = new HashMap<Values, Map<Values, Object[]>>();
        }
        if ((map = this._cache.get(values)) == null) {
            map = new HashMap<Values, Object[]>();
            this._cache.put(values, map);
        }
        if ((objectArray = map.get(values2)) == null || n >= objectArray.length) {
            objectArray = new Object[Math.max(this.getDataFields().length, 1)];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
            map.put(values2, objectArray);
        }
        objectArray[n] = object == null ? PivotNullCell.getInstance() : object;
    }

    @Override
    public boolean isAutoUpdate() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.isAutoUpdate();
        }
        return super.isAutoUpdate();
    }

    @Override
    public void setAutoUpdate(boolean bl) {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setAutoUpdate(bl);
        } else {
            super.setAutoUpdate(bl);
        }
    }

    @Override
    public boolean isRowDataFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.isRowDataFields();
        }
        return super.isRowDataFields();
    }

    @Override
    public boolean isColumnDataFields() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.isColumnDataFields();
        }
        return super.isColumnDataFields();
    }

    @Override
    public boolean isSingleValueMode() {
        return this._pivotValueProvider.isSingleValueMode();
    }

    @Override
    public void setSingleValueMode(boolean bl) {
        this._pivotValueProvider.setSingleValueMode(bl);
    }

    @Override
    public boolean verify() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.verify();
        }
        return super.verify();
    }

    public boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public void setCacheEnabled(boolean bl) {
        this._cacheEnabled = bl;
    }

    private void cacheCurrentValues(boolean bl) {
        if (bl) {
            TableModel tableModel = this.getDataTableModel();
            for (int i = tableModel.getRowCount() - 1; i >= 0; --i) {
                for (int j = tableModel.getColumnCount() - 1; j >= 0; --j) {
                    tableModel.getValueAt(i, j);
                }
            }
        }
        this._savedCache = new HashMap<Values, Map<Values, Object[]>>();
        if (this._cache != null) {
            this._savedCache.putAll(this._cache);
        }
    }

    private void compareWithSavedCache(Values values, Values values2, int n, Object object) {
        if (this._savedCache != null) {
            Object object2 = this.getValueFromCache(this._savedCache, values, values2, n);
            if (object2 == PivotNullCell.getInstance()) {
                object2 = null;
            }
            if (object == PivotNullCell.getInstance()) {
                object = null;
            }
            if (!JideSwingUtilities.equals(object, object2, true)) {
                this.addAffectedValues(values, values2, this.getDataFields()[n], object2, object);
            }
        }
    }

    private Object[] getAffectedValues() {
        this.invalidateCache();
        TableModel tableModel = this.getDataTableModel();
        for (int i = tableModel.getRowCount() - 1; i >= 0; --i) {
            for (int j = tableModel.getColumnCount() - 1; j >= 0; --j) {
                tableModel.getValueAt(i, j);
            }
        }
        return this._affectedValues == null ? null : this._affectedValues.toArray();
    }

    private void addAffectedValues(Values values, Values values2, PivotField pivotField, Object object, Object object2) {
        if (this._affectedValues == null) {
            this._affectedValues = new ArrayList<Object>();
        }
        this._affectedValues.add(values);
        this._affectedValues.add(values2);
        this._affectedValues.add(pivotField);
        this._affectedValues.add(object);
        this._affectedValues.add(object2);
    }

    @Override
    public void pivotValueProviderEventHandler(PivotValueProviderEvent pivotValueProviderEvent) {
        switch (pivotValueProviderEvent.getType()) {
            case 1: {
                if (this.isCacheEnabled() && this.isComputeAffectedCellOnUpdate() && (!(pivotValueProviderEvent.getObject() instanceof Boolean) || ((Boolean)pivotValueProviderEvent.getObject()).booleanValue())) {
                    this.cacheCurrentValues(pivotValueProviderEvent.getObject() == null);
                }
                this.firePivotValueProviderChanged(pivotValueProviderEvent.getType());
                this.invalidateCache();
                break;
            }
            case 2: 
            case 3: {
                if (this.isCacheEnabled() && this.isComputeAffectedCellOnUpdate()) {
                    Object object = pivotValueProviderEvent.getObject();
                    this.firePivotValueProviderChanged(pivotValueProviderEvent.getType(), object);
                    if (object == null || object instanceof Boolean) {
                        this.invalidateCache();
                    } else if (object instanceof Integer) {
                        this._affectedValues = null;
                        this.firePivotValueProviderChanged(9, this.getAffectedValues());
                    } else if (object instanceof Object[]) {
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        Object[] objectArray = (Object[])object;
                        for (int i = 0; i < objectArray.length - 1; i += 2) {
                            if (!(objectArray[i] instanceof Values) || !(objectArray[i + 1] instanceof Values)) continue;
                            Values values = (Values)objectArray[i];
                            Values values2 = (Values)objectArray[i + 1];
                            PivotField[] pivotFieldArray = this.getDataFields();
                            for (int j = 0; j < pivotFieldArray.length; ++j) {
                                PivotField pivotField = pivotFieldArray[j];
                                Object object2 = this.getValueFromCache(this._savedCache, values, values2, j);
                                Object object3 = this.getValueAt(pivotField, values, values2);
                                arrayList.add(values);
                                arrayList.add(values2);
                                arrayList.add(pivotField);
                                arrayList.add(object2 == PivotNullCell.getInstance() ? null : object2);
                                arrayList.add(object3);
                            }
                        }
                        this.firePivotValueProviderChanged(9, arrayList.toArray());
                    }
                    this._savedCache = null;
                    this._affectedValues = null;
                    break;
                }
                this.invalidateCache();
                this.firePivotValueProviderChanged(pivotValueProviderEvent.getType(), pivotValueProviderEvent.getObject());
                break;
            }
            default: {
                if (this.isCacheEnabled()) {
                    this.invalidateCache();
                }
                this.firePivotValueProviderChanged(pivotValueProviderEvent.getType(), pivotValueProviderEvent.getObject());
            }
        }
    }

    @Override
    public List<Integer> getDataAt(CompoundKey compoundKey, CompoundKey compoundKey2) {
        if (this._pivotDataModel == null) {
            return super.getDataAt(compoundKey, compoundKey2);
        }
        return this._pivotDataModel.getDataAt(compoundKey, compoundKey2);
    }

    @Override
    public boolean isAdjusting() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.isAdjusting();
        }
        return super.isAdjusting();
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setAdjusting(bl);
        } else {
            super.setAdjusting(bl);
        }
    }

    @Override
    public boolean isSummaryMode() {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.isSummaryMode();
        }
        return this._pivotValueProvider.isSummaryMode();
    }

    @Override
    public void setSummaryMode(boolean bl) {
        if (this._pivotDataModel != null) {
            this._pivotDataModel.setSummaryMode(bl);
        } else {
            this._pivotValueProvider.setSummaryMode(bl);
        }
    }

    @Override
    public int getRowHeaderRowIndexAt(int n) {
        if (this._pivotDataModel != null) {
            return this._pivotDataModel.getRowHeaderRowIndexAt(n);
        }
        throw new IllegalStateException("Not implemented for PivotValueProvider scenario yet");
    }

    @Override
    public int getColumnHeaderColumnIndexAt(int n) {
        if (this._pivotDataModel != null) {
            return super.getColumnHeaderColumnIndexAt(n);
        }
        throw new IllegalStateException("Not implemented for PivotValueProvider scenario yet");
    }

    private Values getRunningSummaryPeerValues(Values values, RunningSummary runningSummary) {
        int n;
        Object object;
        if (runningSummary == null) {
            return null;
        }
        int n2 = -1;
        if (runningSummary.getCompareTo() instanceof RunningSummary.CompareToObject) {
            n2 = ((RunningSummary.CompareToObject)runningSummary.getCompareTo()).getCompareTo();
        }
        boolean bl = runningSummary.getBaseOnField() != null ? runningSummary.getBaseOnField().getAreaType() == 1 : runningSummary.isColumnField();
        PivotField pivotField = runningSummary.getRangeInField();
        int n3 = -1;
        if (pivotField == RunningSummary.RangeTotalField.INSTANCE) {
            n3 = 0;
        } else {
            object = bl ? this.getColumnFields() : this.getRowFields();
            for (n = 0; n < ((PivotField[])object).length; ++n) {
                if (object[n] != pivotField) continue;
                n3 = n + 1;
                break;
            }
        }
        if (n3 < 0 || n3 >= values.getCount()) {
            return null;
        }
        switch (runningSummary.getRunningType()) {
            case 0: 
            case 1: 
            case 2: {
                if (n2 < 0 && runningSummary.getCompareTo() instanceof RunningSummary.CompareToObject) {
                    return ((RunningSummary.CompareToObject)runningSummary.getCompareTo()).getValues();
                }
            }
            case 3: {
                Expandable expandable;
                object = bl ? this.getColumnHeaderTableModel().getHierarchy() : this.getRowHeaderTableModel().getHierarchy();
                Value value = values.getValueAt(n);
                int n4 = -1;
                for (n = values.getCount() - 1; n >= n3; --n) {
                    int n5;
                    if (!(value instanceof Expandable)) {
                        return null;
                    }
                    expandable = ((Expandable)((Object)value)).getParent();
                    if (expandable != null) {
                        n4 = expandable.getChildIndex(value);
                        n5 = expandable.getChildrenCount();
                    } else {
                        n4 = object.indexOf(value);
                        n5 = object.size();
                    }
                    if (n2 != 0 ? n2 == 1 && n4 < n5 - 1 : n4 > 0) break;
                    if (!(expandable instanceof Value)) {
                        return null;
                    }
                    value = (Value)((Object)expandable);
                }
                if (value == null) {
                    return null;
                }
                Object object2 = null;
                if (n2 == 0) {
                    if (n4 <= 0) {
                        return null;
                    }
                    expandable = ((Expandable)((Object)value)).getParent();
                    object2 = expandable != null ? expandable.getChildAt(n4 - 1) : object.get(n4 - 1);
                    while (n < values.getCount() - 1) {
                        if (!(object2 instanceof Expandable)) {
                            return null;
                        }
                        object2 = ((Expandable)object2).getChildAt(((Expandable)object2).getChildrenCount() - 1);
                        ++n;
                    }
                } else if (n2 == 1) {
                    expandable = ((Expandable)((Object)value)).getParent();
                    if (expandable != null) {
                        if (n4 >= expandable.getChildrenCount() - 1) {
                            return null;
                        }
                        object2 = expandable.getChildAt(n4 + 1);
                    } else {
                        if (n4 >= object.size() - 1) {
                            return null;
                        }
                        object2 = object.get(n4 + 1);
                    }
                    while (n < values.getCount() - 1) {
                        if (!(object2 instanceof Expandable)) {
                            return null;
                        }
                        object2 = ((Expandable)object2).getChildAt(0);
                        ++n;
                    }
                }
                if (!(object2 instanceof ExpandableValue)) break;
                if (runningSummary.getRunningType() != 3) {
                    return new DefaultValues((ExpandableValue)object2);
                }
                ArrayList<Value> arrayList = new ArrayList<Value>();
                Expandable expandable2 = ((ExpandableValue)object2).getParent();
                while (expandable2 instanceof Value) {
                    arrayList.add(0, (Value)((Object)expandable2));
                    expandable2 = expandable2.getParent();
                }
                arrayList.add(new RunningSummaryValue(object2, runningSummary));
                return new RunningSummaryValues(arrayList);
            }
            case 4: {
                if (n3 == 0) {
                    return new GrandTotalValues();
                }
                Value value = values.getValueAt(n3 - 1);
                if (!(value instanceof ExpandableValue)) break;
                return new DefaultValues((ExpandableValue)value);
            }
        }
        return null;
    }

    @Deprecated
    protected Values[] collectChildrenValues(Values values, boolean bl, int n) {
        return this.collectChildrenValues(values, bl, n, 1);
    }

    protected Values[] collectChildrenValues(Values values, boolean bl, int n, int n2) {
        if (values instanceof RunningSummaryValues) {
            Values[] valuesArray = new Values[2];
            Value value = values.getValueAt(values.getCount() - 1);
            if (!(value instanceof RunningSummaryValue)) {
                return new Values[0];
            }
            Object object = ((RunningSummaryValue)value).getActualValue();
            if (!(object instanceof ExpandableValue)) {
                return new Values[0];
            }
            valuesArray[0] = new DefaultValues((ExpandableValue)object);
            valuesArray[1] = this.getRunningSummaryPeerValues(valuesArray[0], ((RunningSummaryValue)value).getRunningSummary());
            return valuesArray;
        }
        if (values instanceof GrandTotalValues) {
            List list = bl ? this.getRowHeaderTableModel().getHierarchy() : this.getColumnHeaderTableModel().getHierarchy();
            int n3 = list.size();
            Values[] valuesArray = new Values[n3];
            for (int i = 0; i < n3; ++i) {
                Object e = list.get(i);
                if (e instanceof ExpandableValue) {
                    if (n >= 0) {
                        valuesArray[i] = new SummaryValues((ExpandableValue)e, n);
                        continue;
                    }
                    valuesArray[i] = new DefaultValues((ExpandableValue)e);
                    continue;
                }
                valuesArray[i] = null;
            }
            return valuesArray;
        }
        if (values instanceof SummaryValues) {
            Value[] valueArray;
            int n4 = values.getCount();
            Value value = values.getValueAt(n4 - 1);
            if (value instanceof SummaryValue) {
                valueArray = ((SummaryValue)value).getActualValue();
                Value value2 = value = valueArray instanceof Value ? (Value)valueArray : null;
            }
            if (!(value instanceof ExpandableValue)) {
                return new Values[0];
            }
            if (!((ExpandableValue)value).hasChildren()) {
                if (((ExpandableValue)value).getParent() != null) {
                    return new Values[]{new DefaultValues((ExpandableValue)value)};
                }
                valueArray = new Value[n4];
                for (int i = 0; i < n4; ++i) {
                    valueArray[i] = values.getValueAt(i);
                }
                return new Values[]{new DefaultValues(valueArray)};
            }
            int n5 = ((ExpandableValue)value).getChildrenCount();
            Values[] valuesArray = new Values[n5];
            for (int i = 0; i < n5; ++i) {
                Values[] valuesArray2 = ((ExpandableValue)value).getChildAt(i);
                if (valuesArray2 instanceof ExpandableValue) {
                    if (((ExpandableValue)valuesArray2).hasChildren() && n >= 0) {
                        valuesArray[i] = new SummaryValues((ExpandableValue)valuesArray2);
                        continue;
                    }
                    valuesArray[i] = new DefaultValues((ExpandableValue)valuesArray2);
                    continue;
                }
                valuesArray[i] = null;
            }
            if (n2 == 3) {
                ArrayList<Values> arrayList = new ArrayList<Values>();
                for (Values values2 : valuesArray) {
                    if (values2 instanceof SummaryValues) {
                        Values[] valuesArray3 = this.collectChildrenValues(values2, bl, n, n2);
                        arrayList.addAll(Arrays.asList(valuesArray3));
                        continue;
                    }
                    if (values2 == null) continue;
                    arrayList.add(values2);
                }
                valuesArray = arrayList.toArray(new Values[arrayList.size()]);
            }
            return valuesArray;
        }
        return new Values[0];
    }

    @Override
    protected Object[] collectValuesForCell(PivotField pivotField, Values values, Values values2, int n) {
        int n2 = this.getStatisticsType(values, values2, pivotField);
        if (n2 == 0 || pivotField == null) {
            return super.collectValuesForCell(pivotField, values, values2, n);
        }
        if (!(n2 != 1 && n2 != 3 || !(values2 instanceof RunningSummaryValues) && values instanceof RunningSummaryValues)) {
            Values[] valuesArray = n2 != 3 ? this.collectChildrenValues(values2, false, n) : this.collectChildrenValues(values2, false, n, n2);
            if (valuesArray.length <= 1) {
                Values[] valuesArray2 = n2 != 3 ? this.collectChildrenValues(values, true, n) : this.collectChildrenValues(values, true, n, n2);
                if (valuesArray2.length < 1) {
                    if (valuesArray.length == 1) {
                        return new Object[]{this.getValueAt(pivotField, values, valuesArray[0])};
                    }
                    if (values2 instanceof GrandTotalValues || values instanceof GrandTotalValues) {
                        return super.collectValuesForCell(pivotField, values, values2, n);
                    }
                    return super.collectValuesForCell(pivotField, values, values2, n);
                }
                Object[] objectArray = new Object[valuesArray2.length];
                for (int i = 0; i < valuesArray2.length; ++i) {
                    objectArray[i] = valuesArray2[i] != null ? this.getValueAt(pivotField, valuesArray2[i], values2) : null;
                }
                return objectArray;
            }
            Object[] objectArray = new Object[valuesArray.length];
            for (int i = 0; i < valuesArray.length; ++i) {
                objectArray[i] = valuesArray[i] != null ? this.getValueAt(pivotField, values, valuesArray[i]) : null;
            }
            return objectArray;
        }
        Values[] valuesArray = n2 != 3 ? this.collectChildrenValues(values, true, n) : this.collectChildrenValues(values, true, n, n2);
        if (valuesArray.length <= 1) {
            Values[] valuesArray3 = n2 != 3 ? this.collectChildrenValues(values2, false, n) : this.collectChildrenValues(values2, false, n, n2);
            if (valuesArray3.length <= 1) {
                if (values2 instanceof GrandTotalValues || values instanceof GrandTotalValues) {
                    return super.collectValuesForCell(pivotField, values, values2, n);
                }
                return super.collectValuesForCell(pivotField, values, values2, n);
            }
            Object[] objectArray = new Object[valuesArray3.length];
            for (int i = 0; i < valuesArray3.length; ++i) {
                objectArray[i] = valuesArray3[i] != null ? this.getValueAt(pivotField, values, valuesArray3[i]) : null;
            }
            return objectArray;
        }
        Object[] objectArray = new Object[valuesArray.length];
        for (int i = 0; i < valuesArray.length; ++i) {
            objectArray[i] = valuesArray[i] != null ? this.getValueAt(pivotField, valuesArray[i], values2) : null;
        }
        return objectArray;
    }

    @Override
    public Object getValueAt(PivotField pivotField, Values values, Values values2) {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        PivotField[] pivotFieldArray = this.getDataFields();
        for (n = 0; n < pivotFieldArray.length; ++n) {
            if (pivotFieldArray[n] != pivotField) continue;
            n2 = n;
            break;
        }
        if (this.isCacheEnabled() && (object2 = this.getValueFromCache(values, values2, n2)) != null) {
            this.compareWithSavedCache(values, values2, n2, object2);
            return object2 instanceof PivotNullCell ? null : object2;
        }
        n = this.getStatisticsType(values, values2, pivotField);
        switch (n) {
            case 0: {
                if (this._pivotDataModel == null) {
                    object = this._pivotValueProvider.getValueAt(pivotField, values, values2);
                    break;
                }
                object = this._pivotDataModel.getValueAt(pivotField, values, values2);
                break;
            }
            default: {
                if (values2 instanceof RunningSummaryValues) {
                    int n3 = this.getSummaryTypeAt(values, values2, pivotField);
                    Object[] objectArray = this.collectValuesForCell(pivotField, values, values2, n3);
                    object = this.calculateStatistics(((RunningSummaryValues)values2).getRunningSummary(), objectArray);
                    break;
                }
                if (values instanceof RunningSummaryValues) {
                    int n4 = this.getSummaryTypeAt(values, values2, pivotField);
                    Object[] objectArray = this.collectValuesForCell(pivotField, values, values2, n4);
                    object = this.calculateStatistics(((RunningSummaryValues)values).getRunningSummary(), objectArray);
                    break;
                }
                object = super.getValueAt(pivotField, values, values2);
            }
        }
        if (this.isCacheEnabled()) {
            this.putValueToCache(values, values2, n2, object);
        }
        this.compareWithSavedCache(values, values2, n2, object);
        return object;
    }

    protected Object calculateStatistics(RunningSummary runningSummary, Object[] objectArray) {
        if (runningSummary == null || objectArray.length < 2) {
            return null;
        }
        if (objectArray[0] instanceof BigDecimal || objectArray[1] instanceof BigDecimal) {
            if (!(objectArray[0] instanceof BigDecimal)) {
                objectArray[0] = new BigDecimal(0);
            }
            if (!(objectArray[1] instanceof BigDecimal)) {
                objectArray[1] = new BigDecimal(0);
            }
        } else if (objectArray[0] instanceof Number || objectArray[1] instanceof Number) {
            if (!(objectArray[0] instanceof Number)) {
                objectArray[0] = 0.0;
            }
            if (!(objectArray[1] instanceof Number)) {
                objectArray[1] = 0.0;
            }
        }
        try {
            switch (runningSummary.getRunningType()) {
                case 0: {
                    if (objectArray[0] instanceof BigDecimal && objectArray[1] instanceof BigDecimal) {
                        return ((BigDecimal)objectArray[0]).subtract((BigDecimal)objectArray[1]);
                    }
                    if (!(objectArray[0] instanceof Number) || !(objectArray[1] instanceof Number)) break;
                    return ((Number)objectArray[0]).doubleValue() - ((Number)objectArray[1]).doubleValue();
                }
                case 1: 
                case 4: {
                    if (objectArray[0] instanceof BigDecimal && objectArray[1] instanceof BigDecimal) {
                        return ((BigDecimal)objectArray[0]).doubleValue() / ((BigDecimal)objectArray[1]).doubleValue();
                    }
                    if (!(objectArray[0] instanceof Number) || !(objectArray[1] instanceof Number)) break;
                    return ((Number)objectArray[0]).doubleValue() / ((Number)objectArray[1]).doubleValue();
                }
                case 2: {
                    if (objectArray[0] instanceof BigDecimal && objectArray[1] instanceof BigDecimal) {
                        return ((BigDecimal)objectArray[0]).doubleValue() / ((BigDecimal)objectArray[1]).doubleValue() - 1.0;
                    }
                    if (!(objectArray[0] instanceof Number) || !(objectArray[1] instanceof Number)) break;
                    return ((Number)objectArray[0]).doubleValue() / ((Number)objectArray[1]).doubleValue() - 1.0;
                }
                case 3: {
                    if (objectArray[0] instanceof BigDecimal && objectArray[1] instanceof BigDecimal) {
                        return ((BigDecimal)objectArray[0]).add((BigDecimal)objectArray[1]);
                    }
                    if (!(objectArray[0] instanceof Number) || !(objectArray[1] instanceof Number)) break;
                    return ((Number)objectArray[0]).doubleValue() + ((Number)objectArray[1]).doubleValue();
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    @Override
    public void setComputeAffectedCellOnUpdate(boolean bl) {
        super.setComputeAffectedCellOnUpdate(bl);
        if (!bl) {
            this._savedCache = null;
            this._affectedValues = null;
        }
        if (this._pivotDataModel instanceof PivotDataModel) {
            ((PivotDataModel)this._pivotDataModel).setComputeAffectedCellOnUpdate(bl);
        }
    }

    public boolean isRunningCalculateSummary() {
        return this._runningCalculateSummary;
    }

    public void setRunningCalculateSummary(boolean bl) {
        this._runningCalculateSummary = bl;
    }
}

