/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.grid.Field;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.pivot.AggregateTable;
import com.jidesoft.pivot.AggregateTableModel;
import com.jidesoft.pivot.AggregateTablePane;
import com.jidesoft.pivot.AggregateTableUtils;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotResources;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PersistenceUtilsCallback;
import com.jidesoft.utils.Q;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableColumn;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AggregateTablePersistenceUtils {
    private static final String NODE_AGGREGATE_TABLE = "aggregateTable";
    private static final String NODE_AGGREGATE_TABLE_PANE = "aggregateTablePane";
    private static final String ATTRIBUTE_GRAND_TOTAL = "grandTotal";
    private static final String ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST = "displayGrandTotalFirst";
    private static final String ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_ROW = "displayGrandTotalFirstForRow";
    private static final String ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_COLUMN = "displayGrandTotalFirstForColumn";
    private static final String ATTRIBUTE_AGGREGATE_COLUMNS = "aggregateColumns";
    private static final String NODE_COLUMN = "column";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_COLUMN_INDEX = "columnIndex";
    private static final String ATTRIBUTE_SUMMARY_TYPE = "summaryType";
    private static final String ATTRIBUTE_GRAND_TOTAL_SUMMARY_TYPE = "grandTotalSummaryType";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_MIN_WIDTH = "minWidth";
    private static final String ATTRIBUTE_MAX_WIDTH = "maxWidth";
    private static final String ATTRIBUTE_PREFERRED_WIDTH = "preferredWidth";
    private static final String ATTRIBUTE_CUSTOM_SUBTOTAL = "customSubtotal";
    private static final String ATTRIBUTE_SUBTOTAL_TYPE = "subtotalType";
    private static final String NODE_SORTING = "sorting";
    private static final String ATTRIBUTE_SORTING_COLUMN_INDEX = "sortingColumnIndex";
    private static final String ATTRIBUTE_ASCENDING = "ascending";

    public static void save(AggregateTable aggregateTable, String string) throws ParserConfigurationException, IOException {
        AggregateTablePersistenceUtils.save(aggregateTable, string, null);
    }

    public static void save(AggregateTable aggregateTable, OutputStream outputStream) throws ParserConfigurationException, IOException {
        AggregateTablePersistenceUtils.save(aggregateTable, outputStream, null);
    }

    public static Document save(AggregateTable aggregateTable) throws ParserConfigurationException {
        return AggregateTablePersistenceUtils.save(aggregateTable, (PersistenceUtilsCallback.Save)null);
    }

    public static void save(AggregateTable aggregateTable, String string, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        AggregateTablePersistenceUtils.save(aggregateTable, string, save, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(AggregateTable aggregateTable, String string, PersistenceUtilsCallback.Save save, String string2) throws ParserConfigurationException, IOException {
        Document document = AggregateTablePersistenceUtils.save(aggregateTable, save);
        PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
    }

    public static void save(AggregateTable aggregateTable, OutputStream outputStream, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        AggregateTablePersistenceUtils.save(aggregateTable, outputStream, save, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(AggregateTable aggregateTable, OutputStream outputStream, PersistenceUtilsCallback.Save save, String string) throws ParserConfigurationException, IOException {
        Document document = AggregateTablePersistenceUtils.save(aggregateTable, save);
        PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
    }

    public static Document save(AggregateTable aggregateTable, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("component");
        if (aggregateTable.getVersion() != null) {
            element.setAttribute("version", aggregateTable.getVersion());
        }
        document.appendChild(element);
        Element element2 = AggregateTableUtils.getAggregateTablePane(aggregateTable) == null ? document.createElement(NODE_AGGREGATE_TABLE) : document.createElement(NODE_AGGREGATE_TABLE_PANE);
        element.appendChild(element2);
        AggregateTablePersistenceUtils.writeAggregateTableElement(aggregateTable, document, element2, save);
        return document;
    }

    private static void writeAggregateTableElement(AggregateTable aggregateTable, Document document, Element element, PersistenceUtilsCallback.Save save) {
        List<ISortableTableModel.SortItem> list;
        AggregateTableModel aggregateTableModel = aggregateTable.getAggregateTableModel();
        element.setAttribute(ATTRIBUTE_GRAND_TOTAL, aggregateTableModel.getPivotDataModel().isShowGrandTotalForRow() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_ROW, aggregateTableModel.getPivotDataModel().isDisplayGrandTotalFirstForRow() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_COLUMN, aggregateTableModel.getPivotDataModel().isDisplayGrandTotalFirstForColumn() ? "1" : "0");
        int[] nArray = aggregateTableModel.getAggregatedColumnsInPivotFields();
        PivotField[] pivotFieldArray = aggregateTableModel.getPivotDataModel().getFields();
        StringBuffer stringBuffer = new StringBuffer(ATTRIBUTE_NAME);
        for (int n : nArray) {
            stringBuffer.append(", ").append(pivotFieldArray[n].getName());
        }
        element.setAttribute(ATTRIBUTE_AGGREGATE_COLUMNS, stringBuffer.toString());
        for (int i = 0; i < aggregateTableModel.getColumnCount(); ++i) {
            Element element2 = document.createElement(NODE_COLUMN);
            element.appendChild(element2);
            AggregateTablePersistenceUtils.writeColumnElement(document, aggregateTable, i, element2, save);
        }
        ISortableTableModel iSortableTableModel = (ISortableTableModel)TableModelWrapperUtils.getActualTableModel(aggregateTable.getModel(), ISortableTableModel.class);
        if (iSortableTableModel != null && (list = iSortableTableModel.getSortingColumns()) != null && list.size() > 0) {
            for (ISortableTableModel.SortItem sortItem : list) {
                Element element3 = document.createElement(NODE_SORTING);
                element.appendChild(element3);
                AggregateTablePersistenceUtils.writeSortingItemElement(document, sortItem, element3, save);
            }
        }
        if (save != null) {
            save.save(document, element, aggregateTable);
        }
    }

    private static void writeSortingItemElement(Document document, ISortableTableModel.SortItem sortItem, Element element, PersistenceUtilsCallback.Save save) {
        element.setAttribute(ATTRIBUTE_SORTING_COLUMN_INDEX, "" + sortItem.getColumn());
        element.setAttribute(ATTRIBUTE_ASCENDING, sortItem.isAscending() ? "1" : "0");
        if (save != null) {
            save.save(document, element, sortItem);
        }
    }

    private static void writeColumnElement(Document document, AggregateTable aggregateTable, int n, Element element, PersistenceUtilsCallback.Save save) {
        int n2;
        int n3 = aggregateTable.getAggregateTableModel().getActualModelColumnIndex(n);
        PivotField pivotField = aggregateTable.getAggregateTableModel().getPivotDataModel().getFields()[n3];
        TableColumn tableColumn = null;
        AggregateTablePane aggregateTablePane = AggregateTableUtils.getAggregateTablePane(aggregateTable);
        if (aggregateTablePane != null) {
            if (pivotField.getAreaType() == 0) {
                n2 = aggregateTablePane.getRowHeaderTable().convertColumnIndexToView(n);
                if (n2 >= 0) {
                    tableColumn = aggregateTablePane.getRowHeaderTable().getColumnModel().getColumn(n2);
                }
            } else {
                n2 = aggregateTablePane.getMainTable().convertColumnIndexToView(n);
                if (n2 >= 0) {
                    tableColumn = aggregateTablePane.getMainTable().getColumnModel().getColumn(n2);
                    n2 += aggregateTablePane.getRowHeaderTable().getColumnModel().getColumnCount();
                }
            }
        } else {
            n2 = aggregateTable.convertColumnIndexToView(n);
            if (n2 >= 0) {
                tableColumn = aggregateTable.getColumnModel().getColumn(n2);
            }
        }
        element.setAttribute(ATTRIBUTE_NAME, pivotField.getName());
        element.setAttribute(ATTRIBUTE_TITLE, pivotField.getTitle());
        element.setAttribute(ATTRIBUTE_COLUMN_INDEX, "" + n2);
        element.setAttribute(ATTRIBUTE_SUMMARY_TYPE, "" + pivotField.getSummaryType());
        element.setAttribute(ATTRIBUTE_GRAND_TOTAL_SUMMARY_TYPE, "" + pivotField.getGrandTotalSummaryType());
        element.setAttribute(ATTRIBUTE_WIDTH, tableColumn == null ? "-1" : "" + tableColumn.getWidth());
        element.setAttribute(ATTRIBUTE_MIN_WIDTH, tableColumn == null ? "-1" : "" + tableColumn.getMinWidth());
        element.setAttribute(ATTRIBUTE_MAX_WIDTH, tableColumn == null ? "-1" : "" + tableColumn.getMaxWidth());
        element.setAttribute(ATTRIBUTE_PREFERRED_WIDTH, tableColumn == null ? "-1" : "" + tableColumn.getPreferredWidth());
        element.setAttribute(ATTRIBUTE_CUSTOM_SUBTOTAL, PersistenceUtils.intArrayToString(pivotField.getCustomSubtotals()));
        element.setAttribute(ATTRIBUTE_SUBTOTAL_TYPE, "" + pivotField.getSubtotalType());
        if (save != null) {
            save.save(document, element, aggregateTable);
        }
    }

    public static void load(AggregateTable aggregateTable, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        AggregateTablePersistenceUtils.load(aggregateTable, PersistenceUtils.getDocument(inputStream));
    }

    public static void load(AggregateTable aggregateTable, String string) throws ParserConfigurationException, SAXException, IOException {
        AggregateTablePersistenceUtils.load(aggregateTable, PersistenceUtils.getDocument(string));
    }

    public static void load(AggregateTable aggregateTable, Document document) {
        AggregateTablePersistenceUtils.load(aggregateTable, document, null);
    }

    public static void load(AggregateTable aggregateTable, InputStream inputStream, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        AggregateTablePersistenceUtils.load(aggregateTable, PersistenceUtils.getDocument(inputStream), load);
    }

    public static void load(AggregateTable aggregateTable, String string, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        AggregateTablePersistenceUtils.load(aggregateTable, PersistenceUtils.getDocument(string), load);
    }

    public static void load(AggregateTable aggregateTable, Document document, PersistenceUtilsCallback.Load load) {
        Node node;
        int n;
        Object object;
        Node node2;
        if (aggregateTable.getDraggingHandler() != null) {
            aggregateTable.getColumnModel().removeColumnModelListener(aggregateTable.getDraggingHandler());
        }
        if ((node2 = document.getElementsByTagName("component").item(0)) == null) {
            throw new IllegalArgumentException(PivotResources.getResourceBundle(aggregateTable.getLocale()).getString("PivotTablePane.invalidLayoutFile"));
        }
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (!"version".equals(object.getNodeName())) continue;
            string = object.getNodeValue();
            break;
        }
        if (string != null) {
            aggregateTable.setVersion(string);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        object = new ArrayList();
        String[] stringArray = new String[]{""};
        AggregateTablePane aggregateTablePane = AggregateTableUtils.getAggregateTablePane(aggregateTable);
        boolean bl = false;
        NodeList nodeList = node2.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            node = nodeList.item(n);
            if (node instanceof Element && NODE_AGGREGATE_TABLE.equals(node.getNodeName()) && aggregateTablePane == null) {
                AggregateTablePersistenceUtils.readAggregateTableElement(aggregateTable, document, (Element)node, (List<Integer>)object, load);
                node2 = node;
                bl = true;
                break;
            }
            if (!(node instanceof Element) || !NODE_AGGREGATE_TABLE_PANE.equals(node.getNodeName()) || aggregateTablePane == null) continue;
            AggregateTablePersistenceUtils.readAggregateTableElement(aggregateTable, document, (Element)node, (List<Integer>)object, load);
            node2 = node;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        nodeList = node2.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            node = nodeList.item(n);
            if (!(node instanceof Element) || !NODE_COLUMN.equals(node.getNodeName())) continue;
            AggregateTablePersistenceUtils.readColumnElement(aggregateTable, document, (Element)node, hashMap, stringArray, load);
        }
        stringArray[0] = "" + hashMap.size() + '\t' + aggregateTable.getWidth() + '\t' + stringArray[0];
        int[] nArray = new int[object.size()];
        for (int i = 0; i < object.size(); ++i) {
            nArray[i] = (Integer)object.get(i);
        }
        aggregateTable.getAggregateTableModel().setAggregatedColumns(nArray);
        if (aggregateTablePane != null) {
            aggregateTable.getAggregateTableModel().aggregate();
        } else {
            aggregateTable.aggregate();
        }
        String[] stringArray2 = stringArray[0].split("\t");
        if (aggregateTablePane != null) {
            TableUtils.adjustColumnOrderAndWidth(aggregateTablePane, hashMap, null, stringArray2, hashMap.size(), true, false);
            aggregateTablePane.resizeRowHeaderTableToFit();
            TableUtils.clearColumnOrdersMemory(aggregateTablePane);
        } else {
            TableUtils.adjustColumnOrderAndWidth(aggregateTable, hashMap, null, stringArray2, hashMap.size(), true, false);
        }
        ArrayList<ISortableTableModel.SortItem> arrayList = new ArrayList<ISortableTableModel.SortItem>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!(node3 instanceof Element) || !NODE_SORTING.equals(node3.getNodeName())) continue;
            AggregateTablePersistenceUtils.readSortingElement(aggregateTable, document, (Element)node3, arrayList, load);
        }
        ISortableTableModel iSortableTableModel = (ISortableTableModel)TableModelWrapperUtils.getActualTableModel(aggregateTable.getModel(), ISortableTableModel.class);
        if (iSortableTableModel != null) {
            aggregateTable.configureSortableTableModel(aggregateTable.getAggregateTableModel());
            iSortableTableModel.setSortingColumns(arrayList);
        }
        if (aggregateTable.getDraggingHandler() != null) {
            aggregateTable.getColumnModel().addColumnModelListener(aggregateTable.getDraggingHandler());
        }
    }

    private static void readSortingElement(AggregateTable aggregateTable, Document document, Element element, List<ISortableTableModel.SortItem> list, PersistenceUtilsCallback.Load load) {
        ISortableTableModel iSortableTableModel = (ISortableTableModel)TableModelWrapperUtils.getActualTableModel(aggregateTable.getModel(), ISortableTableModel.class);
        if (iSortableTableModel == null) {
            return;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        String string2 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (ATTRIBUTE_SORTING_COLUMN_INDEX.equals(node.getNodeName())) {
                string = node.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_ASCENDING.equals(node.getNodeName())) continue;
            string2 = node.getNodeValue();
        }
        if (string != null && string2 != null) {
            ISortableTableModel.SortItem sortItem = new ISortableTableModel.SortItem(Integer.parseInt(string), "1".equals(string2));
            list.add(sortItem);
        }
        if (load != null) {
            load.load(document, element, list);
        }
    }

    private static void readAggregateTableElement(AggregateTable aggregateTable, Document document, Element element, List<Integer> list, PersistenceUtilsCallback.Load load) {
        Object[] objectArray;
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            objectArray = namedNodeMap.item(i);
            if (ATTRIBUTE_GRAND_TOTAL.equals(objectArray.getNodeName())) {
                string = objectArray.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST.equals(objectArray.getNodeName())) {
                string2 = objectArray.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_ROW.equals(objectArray.getNodeName())) {
                string3 = objectArray.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_DISPLAY_GRAND_TOTAL_FIRST_FOR_COLUMN.equals(objectArray.getNodeName())) {
                string4 = objectArray.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_AGGREGATE_COLUMNS.equals(objectArray.getNodeName())) continue;
            string5 = objectArray.getNodeValue();
        }
        IPivotDataModel iPivotDataModel = aggregateTable.getAggregateTableModel().getPivotDataModel();
        if (string5 != null) {
            if (string5.contains(ATTRIBUTE_NAME)) {
                objectArray = iPivotDataModel.getFields();
                String[] stringArray = string5.split(", ");
                for (int i = 1; i < stringArray.length; ++i) {
                    Object object;
                    int n;
                    for (n = 0; n < objectArray.length && !stringArray[i].equals(((Field)(object = objectArray[n])).getName()); ++n) {
                    }
                    if (n >= objectArray.length) continue;
                    list.add(n);
                }
            } else {
                for (Object object : objectArray = (Object[])PersistenceUtils.stringToIntArray(string5)) {
                    list.add((int)object);
                }
            }
        }
        if (iPivotDataModel != null) {
            iPivotDataModel.setShowGrandTotalForRow("1".equals(string));
            if (string2 != null) {
                iPivotDataModel.setDisplayGrandTotalFirst("1".equals(string2));
            }
            if (string3 != null) {
                iPivotDataModel.setDisplayGrandTotalFirstForRow("1".equals(string3));
            }
            if (string4 != null) {
                iPivotDataModel.setDisplayGrandTotalFirstForColumn("1".equals(string4));
            }
        }
        if (load != null) {
            load.load(document, element, aggregateTable);
        }
    }

    private static void readColumnElement(AggregateTable aggregateTable, Document document, Element element, Map<String, Integer> map, String[] stringArray, PersistenceUtilsCallback.Load load) {
        int n;
        NamedNodeMap namedNodeMap = element.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (ATTRIBUTE_NAME.equals(node.getNodeName())) {
                string = node.getNodeValue();
            }
            if (ATTRIBUTE_TITLE.equals(node.getNodeName())) {
                string2 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_COLUMN_INDEX.equals(node.getNodeName())) {
                string3 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_SUMMARY_TYPE.equals(node.getNodeName())) {
                string4 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_GRAND_TOTAL_SUMMARY_TYPE.equals(node.getNodeName())) {
                string5 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(node.getNodeName())) {
                string6 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_MIN_WIDTH.equals(node.getNodeName())) {
                string7 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_MAX_WIDTH.equals(node.getNodeName())) {
                string8 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_WIDTH.equals(node.getNodeName())) {
                string9 = node.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CUSTOM_SUBTOTAL.equals(node.getNodeName())) {
                string10 = node.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_SUBTOTAL_TYPE.equals(node.getNodeName())) continue;
            string11 = node.getNodeValue();
        }
        if (string == null) {
            return;
        }
        PivotField[] pivotFieldArray = aggregateTable.getAggregateTableModel().getPivotDataModel().getFields();
        for (n = 0; n < pivotFieldArray.length && !string.equals(pivotFieldArray[n].getName()); ++n) {
        }
        if (n >= pivotFieldArray.length) {
            return;
        }
        PivotField pivotField = pivotFieldArray[n];
        int n2 = AggregateTableUtils.getOuterModelIndex(aggregateTable, n);
        if (pivotField != null) {
            pivotField.setTitle(string2);
            if (string3 != null) {
                int n3 = Integer.parseInt(string3);
                map.put(string, n3);
            }
            if (string4 != null) {
                pivotField.setSummaryType(Integer.parseInt(string4));
            }
            if (string5 != null) {
                pivotField.setGrandTotalSummaryType(Integer.parseInt(string5));
            }
            if (string10 != null) {
                pivotField.setCustomSubtotals(PersistenceUtils.stringToIntArray(string10));
            }
            if (string11 != null) {
                pivotField.setSubtotalType(Integer.parseInt(string11));
            }
            stringArray[0] = stringArray[0] + string + '\t' + n2 + '\t' + string8 + '\t' + string7 + '\t' + string9 + '\t' + string6 + '\t';
        }
        if (load != null) {
            load.load(document, element, pivotField);
        }
    }

    public static String getVersion(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return AggregateTablePersistenceUtils.getVersion(PersistenceUtils.getDocument(inputStream));
    }

    public static String getVersion(String string) throws ParserConfigurationException, SAXException, IOException {
        return AggregateTablePersistenceUtils.getVersion(PersistenceUtils.getDocument(string));
    }

    public static String getVersion(Document document) {
        return PersistenceUtils.getVersion(document);
    }

    public static void isLayoutValid(AggregateTable aggregateTable, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException, IllegalArgumentException {
        AggregateTablePersistenceUtils.isLayoutValid(aggregateTable, PersistenceUtils.getDocument(inputStream));
    }

    public static void isLayoutValid(AggregateTable aggregateTable, String string) throws ParserConfigurationException, SAXException, IOException, IllegalArgumentException {
        AggregateTablePersistenceUtils.isLayoutValid(aggregateTable, PersistenceUtils.getDocument(string));
    }

    public static void isLayoutValid(AggregateTable aggregateTable, Document document) throws IllegalArgumentException {
        Node node = document.getElementsByTagName("component").item(0);
        if (node == null) {
            throw new IllegalArgumentException(PivotResources.getResourceBundle(aggregateTable.getLocale()).getString("PivotTablePane.invalidLayoutFile"));
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!"version".equals(node2.getNodeName())) continue;
            string = node2.getNodeValue();
            break;
        }
        if (string != null) {
            throw new IllegalArgumentException("There is no version information in the layout.");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!NODE_COLUMN.equals(node3.getNodeName())) continue;
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            String string2 = null;
            for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                Node node4 = namedNodeMap2.item(j);
                if (!ATTRIBUTE_NAME.equals(node4.getNodeName())) continue;
                string2 = node4.getNodeValue();
            }
            PivotField pivotField = aggregateTable.getAggregateTableModel().getPivotDataModel().getField(string2);
            if (pivotField != null) continue;
            throw new IllegalArgumentException("The layout has a field \"" + string2 + "\" which is no longer in the AggregateTable.");
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(32)) {
            Lm.showInvalidProductMessage(AggregateTablePersistenceUtils.class.getName(), 32);
        }
    }
}

